/*
 *  Name:    $Id: ProviderSelector.java,v 1.3 2010/01/27 16:01:10 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig.context;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

/**
 * Returns a specific JCA/JCE component from a configured security provider.
 * 
 * @author t724w (mru)
 * 
 */
public interface ProviderSelector {

	/**
	 * Returns a CertPathValidator
	 * 
	 * @return configured CertPathValidator
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchProviderException
	 */
	public CertPathValidator getCertPathValidator()
			throws NoSuchAlgorithmException, NoSuchProviderException;

	/**
	 * Returns a CertStore
	 * 
	 * @param certStoreParams
	 *            the parameters
	 * @return configured CertPathValidator
	 * @throws InvalidAlgorithmParameterException
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchProviderException
	 */
	public CertStore getCertStore(CertStoreParameters certStoreParams)
			throws InvalidAlgorithmParameterException,
			NoSuchAlgorithmException, NoSuchProviderException;

	/**
	 * Returns CertificateFactory
	 * 
	 * @return configured CertificateFactory
	 * @throws CertificateException
	 * @throws NoSuchProviderException
	 */
	public CertificateFactory getCertificateFactory()
			throws CertificateException, NoSuchProviderException;

}