/*
 *  Name:    $Id: ValidationResult.java,v 1.4 2010/03/02 16:01:39 t724w Exp $
 * 
 *  Copyright 2009 Bundesamt für Informatik und Telekommunikation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package ch.admin.bit.edec.dsig;

/**
 * Hold the status after a XML Signature Validation
 * 
 * @author t724w (mru)
 * 
 */
public interface ValidationResult {

	/**
	 * Returns if the signature is correct.
	 * 
	 * @return true if the signature is valid or false when the signature is
	 *         invalid.
	 */
	public boolean isValid();

	/**
	 * Returns a message
	 * 
	 * @return the message
	 */
	public String getMessage();

	/**
	 * Returns the exception when a error occurred during the validation process
	 * 
	 * @return the exception which was thrown during the validation process.
	 */
	public Throwable getException();

}