<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        xmlns:receipt="http://www.e-dec.ch/xml/schema/edecReceiptResponse/v3">
    
	<!--document language-->
	<xsl:variable name="lower">abcdefghijklmnopqrstuvwxyz</xsl:variable> 
	<xsl:variable name="upper">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
	<xsl:variable name="documentLanguage" select="//receipt:documentInformation/receipt:documentLanguage"/>
	<xsl:variable name="documentLanguageUpperCase" select="translate($documentLanguage,$lower,$upper)"/>
  	<xsl:variable name="documentType" select="//receipt:documentInformation/receipt:documentType"/>

	<!-- interne Daten -->
	<xsl:variable name="edecDomainsData" select="document('')/*/xsl:variable[@name='edecDomains']/domains" /> 
	<xsl:variable name="edecTariffMasterDataSchemaData" select="document('')/*/xsl:variable[@name='edecTariffMasterDataSchema']" /> 
	<xsl:variable name="languagePropertiesData" select="document('')/*/xsl:variable[@name='languageProperties']" /> 
	
	<!--Main Templates-->
	<xsl:output method="html" encoding="UTF-8"/> 
	<xsl:template match="/">
        <xsl:apply-templates select="//receipt:receiptRequestResponse/receipt:taxationDecisionExport"/>
		<xsl:apply-templates select="//receipt:receiptRequestResponse/receipt:taxationDecisionVAT"/>
		<xsl:apply-templates select="//receipt:receiptRequestResponse/receipt:taxationDecisionCustomsDuties"/>
		<xsl:apply-templates select="//receipt:receiptRequestResponse/receipt:refundVAT"/>
		<xsl:apply-templates select="//receipt:receiptRequestResponse/receipt:refundCustomsDuties"/>
    </xsl:template>
    
	<!-- taxationDecision (HTML Version for the 3 PDF Documents from receiptResponse)-->
	<xsl:template match="receipt:receiptRequestResponse/receipt:taxationDecisionExport" name="taxationDecisionExport"> <!-- VVE -->
		<xsl:call-template name="mainTemplate"/>
    </xsl:template>
    <xsl:template match="receipt:receiptRequestResponse/receipt:taxationDecisionVAT" name="taxationDecisionVAT"> <!-- VVM -->
		<xsl:call-template name="mainTemplate"/>
    </xsl:template>
    <xsl:template match="receipt:receiptRequestResponse/receipt:taxationDecisionCustomsDuties" name="taxationDecisionCustomsDuties"> <!-- VVZ -->
		<xsl:call-template name="mainTemplate"/>
    </xsl:template>
    <xsl:template match="receipt:receiptRequestResponse/receipt:refundVAT" name="refundVAT">
		<xsl:call-template name="mainTemplate"/>
    </xsl:template>
    <xsl:template match="receipt:receiptRequestResponse/receipt:refundCustomsDuties" name="refundCustomsDuties">
		<xsl:call-template name="mainTemplate"/>
    </xsl:template>
	
    <!-- Main Layout for all Documents  -->
    <xsl:template name="mainTemplate">
		<xsl:variable name="declarationType" select="receipt:declarationType"/>
		<xsl:variable name="correctionCode" select="receipt:correctionCode"/>
        <xsl:variable name="acceptanceDate" select="receipt:acceptanceDate"/>
        <xsl:variable name="acceptanceTime" select="receipt:acceptanceTime"/>
        <xsl:variable name="documentDate" select="receipt:documentInformation/receipt:documentDate"/>
        <xsl:variable name="documentTime" select="receipt:documentInformation/receipt:documentTime"/>
        <xsl:variable name="documentNumber" select="receipt:documentInformation/receipt:documentNumber"/>
        <xsl:variable name="accessCode" select="receipt:accessCode"/>
		
		<html content="text/html; charset=UTF-8" >
            <!-- HEAD -->
			<head>
				<xsl:call-template name="header_settings"/>
            </head>

			<!-- BODY -->
            <body>
				<!-- header images-->
                <table width="818" border="0">
					 <tr>   
						<td width="100%">
                            <xsl:call-template name="header"/>
                        </td>
                    </tr>
				 </table>

                 <table width="788" class="mainTable" border="0" cellspacing="0" cellpading="0">
					<!-- correction Code-->
                    <xsl:if test="$correctionCode = 0">
                        <tr>
                            <td scope="row">
                                <div align="left">
                                    <span class="subtitle">
                                        <xsl:call-template name="Translate">
                                            <xsl:with-param name="labelToTranslate" select="'annullation'"/>
                                        </xsl:call-template>
                                    </span>
                                </div>
                            </td>
                        </tr>
                    </xsl:if>

                    <!-- datum -->
					<tr>
                        <td>
                            <div align="left">
                                <table width="100%" class="content" border="0" cellspacing="0" cellpading="0">
                                    <!-- optional on refund -->
									<xsl:if test="$acceptanceDate">
										<tr>
	                                        <td width="30%">
												<span class="label">
													<xsl:call-template name="Translate">
														<xsl:with-param name="labelToTranslate" select="'annahmedatum'"/>
													</xsl:call-template>
												</span>
	                                        </td>
	                                        <td>
	                                            <xsl:value-of select="$acceptanceDate"/>
	                                            <xsl:text>, </xsl:text>
	                                            <xsl:value-of select="$acceptanceTime"/>
	                                        </td>
	                                    </tr>
									</xsl:if>
                                    <tr>
                                        <td width="30%">
											<span class="label">
												<xsl:call-template name="Translate">
													<xsl:with-param name="labelToTranslate" select="'ausstellungsdatum'"/>
												</xsl:call-template>
											</span>
                                        </td>
                                        <td>
                                            <xsl:value-of select="$documentDate"/>
                                            <xsl:text>, </xsl:text>
                                            <xsl:value-of select="$documentTime"/>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </td>
                    </tr>

					<!-- customsOffice-->
                    <tr>
                        <td>
							<br/>
                            <xsl:call-template name="customsOffice"/>
                        </td>
                    </tr>
				</table>
				<!-- TaxationDecision VAT and CustomsDuties-->
				<xsl:if test="$documentType='taxationDecisionVAT' or $documentType='taxationDecisionCustomsDuties' or $documentType='taxationDecisionExport'">
					<xsl:call-template name="taxationDecisionTemplate"/>
				</xsl:if>				

				<!-- refund VAT and CustomsDuties-->
				<xsl:if test="$documentType='refundVAT' or $documentType='refundCustomsDuties'">
					<xsl:call-template name="refundTemplate"/>
				</xsl:if>					
								
				<!-- legalAdvisory -->
				<xsl:if test="receipt:legalAdvisory or ($documentType!='refundVAT' and $documentType!='refundCustomsDuties')">
					<table width="788" border="0" cellpadding="0" cellspacing="0" class="content mainTable" style="border-top: 2px solid black;">
						<xsl:for-each select="receipt:legalAdvisory">
							<xsl:variable name="title" select="receipt:title"/>
							<xsl:variable name="text" select="receipt:text"/>
							<tr>
								<td class="label" style="padding-top:10px;">
									<b><xsl:value-of select="$title"/></b>
								</td>
							</tr>
							<tr>
								<td class="label">
									<xsl:value-of select="$text"/>
								</td>
							</tr>
						</xsl:for-each>
				
						<!-- documentNumber and accessCode -->
						<xsl:if test="$documentType!='refundVAT' and $documentType!='refundCustomsDuties'">
							<tr>
								<td style="padding-top:10px;">
									<span class="label">
										<b>
											<xsl:call-template name="Translate">
												<xsl:with-param name="labelToTranslate" select="'zollanmeldungsnummer'"/>
											</xsl:call-template>
										</b>
									</span>
									<xsl:value-of select="$documentNumber"/>
								</td>
							</tr>
							<tr>
								<td>
									<span class="label">
										<b>
											<xsl:call-template name="Translate">
												<xsl:with-param name="labelToTranslate" select="'zugangscode'"/>
											</xsl:call-template>
										</b>
									</span>						
									<xsl:value-of select="$accessCode"/>
								</td>
							</tr>
						</xsl:if>
					</table>
				</xsl:if>
            </body>
		</html>
    </xsl:template>

	<!-- Titel und CSS --> 
	<xsl:template name="header_settings">
		<script language="javascript">
			<![CDATA[  
			//found with a whole bunch of useful stuff at:
			//freebarcodefonts.dobsonsw.com
			function getBarcode(rawData) { var offset = 32; var highAscii = 18; var
			newCodeString = new Array(rawData.length + 3); newCodeString[0] =
			offset + highAscii + 104; var total = 104; for(var stringCounter = 0 ;
			stringCounter < rawData.length ; stringCounter++) { var
			character =
			rawData.substr(stringCounter, 1); var ASCIIValue =
			character.charCodeAt(0); var checkDigit = ((ASCIIValue - offset) *
			(stringCounter + 1)); total += checkDigit; newCodeString[stringCounter
			+ 1] = ASCIIValue; } var check = total % 103; var holder = 0; if(check
			+ offset >= 127) { holder = check + offset + highAscii; } else {
			holder = check + offset; } newCodeString[newCodeString.length - 2] =
			holder; holder = 106 + offset + highAscii;
			newCodeString[newCodeString.length - 1] = holder; for(var rCounter = 0
			; rCounter < newCodeString.length ; rCounter++) {
			if(newCodeString[rCounter] == 32) { newCodeString[rCounter] = 128; } }
			return getBarcodeText(newCodeString);
			}
			function getBarcodeText(codeString) { 
			var returnVal = "<p align=\"left\" style=\"font-size:17.0pt;mso-bidi-font-size:17.0pt;font-family:Code128bWinLarge\">";
			for(var counter = 0 ; counter < codeString.length ; counter++) {
			var intValue = codeString[counter]; returnVal += "&#" + parseInt(intValue); } returnVal += "</P>"; 
			return returnVal;
			}
			 ]]>
		</script>
        <title>
			<xsl:call-template name="getDocumentTitle"/>
        </title>
        <style type="text/css">
            <xsl:text>
			.title {font-family:Arial, Helvetica, sans-serif; font-size: 20px; font-style:bold}
			.subtitle {font-family:Arial, Helvetica, sans-serif; font-size: 38px; font-style:bold; color:red}
			.label {font-family:Arial, Helvetica, sans-serif;font-size: 13px; /*font-style:italic;*/ margin-right: 5px; padding-top: 3px;line-height:125%;}
			.content {font-family:Arial, Helvetica, sans-serif;font-size: 15px; line-height:125%;}
			.barcodeTop {font-family:Arial, Helvetica, sans-serif;font-size: 15px}
			.barcodeCenter {font-family:Arial, Helvetica, sans-serif;font-size: 40px}
			.barcodeBottom {font-family:Arial, Helvetica, sans-serif;font-size: 24px}
			.header {font-family:Arial, Helvetica, sans-serif;font-size: 8px;line-height:125%;}
			.mainTable {margin-left: 35px;}
			table.content td, table.content th{vertical-align:bottom; line-height:125%}
			table.withSpace td, table.withSpace th {padding-top:5px; border: 0px none; }
			table.noPadding td, table.noPadding th {padding:0px;}
			table.withBorder {border-collapse: collapse;}
			table.withBorder td, table.withBorder th {border: 1px solid black; padding:3px;}
			</xsl:text>
        </style>
	</xsl:template>

	<!-- Header / Logo und EZV -->
    <xsl:template name="header">
        <table width="100%" border="0" cellpadding="0" cellspacing="0">
            <tr>
				<td>
					<table border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td style="padding-right:10px;">
								<img src="https://www.ezv.admin.ch/ezv/en/_jcr_content/logo/image.imagespooler.png/1480534300772/logo.png" height="60px" alt="logo_switzerland"/>
							</td>
							<td valign="top" class="header">
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'eidgenoessisches_finanzdepartement_efd'"/>
								</xsl:call-template>
								<br/>
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'eidgenoessische_zollverwaltung_ezv'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<!-- barcode-->
				<td rowspan="2" align="right" valign="top">
					<xsl:call-template name="barcode"/>                        
				</td>
			</tr>
			<tr>
				<!-- document title-->	
				<td>
					<div class="mainTable" align="left">
						<b>
							<span class="title">
								<xsl:call-template name="getDocumentTitle"/>
							</span>
						</b>
					</div>
				</td>
				<td>
					<xsl:text> </xsl:text>
				</td>
			</tr>
        </table>
    </xsl:template>
	
	<!-- Barcode -->
	<xsl:template name="barcode">
		<xsl:variable name="documentNumber" select="receipt:documentInformation/receipt:documentNumber"/>
		<xsl:variable name="documentVersion" select="receipt:documentInformation/receipt:documentVersion"/>
		<xsl:variable name="declarationType" select="receipt:declarationType"/>
		<table border="0" cellpadding="0" cellspacing="0">
			<xsl:if test="$documentType!='refundVAT' and $documentType!='refundCustomsDuties'">
				<tr>
					<td class="content">
						<b>
							<xsl:if test="($documentType = 'taxationDecisionExport')">
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'export'"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="($documentType != 'taxationDecisionExport')">
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'import'"/>
								</xsl:call-template>
							</xsl:if>
						</b>
					</td>
					<td align="right" class="content">
						<b>
							<xsl:call-template name="getDomainText">
								<xsl:with-param name="domainName" select="'declarationType'"/>
								<xsl:with-param name="value" select="$declarationType"/>
							</xsl:call-template>
						</b>
					</td>
				</tr>
			</xsl:if>
		    <tr>
		        <td id="docNumberBarcode" colspan="2" align="right" style="white-space: nowrap">
		            <!--div align="left" class="barcodeBottom" style="font-size:16.0pt;mso-bidi-font-size:16.0pt;font-family:Code128bWinLarge">08CHEE000000121755.1</div-->
		        </td>
		    </tr>
			<tr>
		        <td align="right" colspan="2" class="content">
					<span id="docNumber" style="font-weight: bold;">
						<xsl:value-of select="$documentNumber"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="$documentVersion"/>
					</span>
					<script language="javascript">
						var number = document.getElementById("docNumber").innerHTML;
						document.getElementById("docNumberBarcode").innerHTML = getBarcode(number);
					</script>
		        </td>
		    </tr>
		</table>
	</xsl:template>

	<!-- Zollstelle -->
    <xsl:template name="customsOffice">
        <xsl:variable name="name" select="receipt:customsOffice/receipt:name"/>
        <xsl:variable name="street" select="receipt:customsOffice/receipt:street"/>
        <xsl:variable name="country" select="receipt:customsOffice/receipt:country"/>
        <xsl:variable name="postalCode" select="receipt:customsOffice/receipt:postalCode"/>
        <xsl:variable name="city" select="receipt:customsOffice/receipt:city"/>
        <xsl:variable name="addressSupplement1" select="receipt:customsOffice/receipt:addressSupplement1"/>
        <xsl:variable name="addressSupplement2" select="receipt:customsOffice/receipt:addressSupplement2"/>
        
		<table width="100%" class="label" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td>
					<xsl:value-of select="$name"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement1 and string-length($addressSupplement1)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement1"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$addressSupplement2 and string-length($addressSupplement2)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement2"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$street"/>
                </td>
            </tr>
            <tr>
                <td>
                    <xsl:if test="$country and string-length($country)>0">
                        <xsl:value-of select="$country"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="$postalCode"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$city"/>
                </td>
            </tr>
        </table>
    </xsl:template>
		
	<!-- Dokumenttypen: 'taxationDecisionVAT', 'taxationDecisionCustomsDuties' oder 'taxationDecisionExport' -->
	<xsl:template name="taxationDecisionTemplate">
		<table class="mainTable" width="788" border="0">
			<tr>
				<!-- Adressen -->
				<td width="55%" scope="row" align="left" valign="top" style="padding-top:8px;">
		            <!-- versender -->
					<xsl:if test="receipt:consignor">
						<br/>
		                <xsl:call-template name="consignor"/>
		            </xsl:if>
					<!-- Importeur -->
					<xsl:if test="receipt:importer">
						<br/>
		            	<xsl:call-template name="importer"/>
					</xsl:if>
					<!-- Empfaenger -->
		            <xsl:if test="receipt:consignee">
						<br/>
		            	<xsl:call-template name="consignee"/>
					</xsl:if>
					<!-- Zugelassener Empfaenger -->
		            <xsl:if test="receipt:authorizedConsignee">
						<br/>
		            	<xsl:call-template name="authorizedConsignee"/>
					</xsl:if>
					<!-- Deklarant -->
					<xsl:if test="receipt:declarant">
						<br/>
		            	<xsl:call-template name="spediteur"/>
					</xsl:if>
					<!-- transporteur -->
					<xsl:if test="receipt:carrier">
						<br/>
		            	<xsl:call-template name="carrier"/>
					</xsl:if>
				</td>				
		        <td valign="top">
					<br/>
					<!-- Frachtinformationen -->
		            <xsl:call-template name="headerInformationRight"/>
							
					<!-- gesammtbetrag MWST -->
					<xsl:variable name="vatTotalAmount" select="receipt:valuationSummary/receipt:VAT/receipt:totalAmount"/>
					<xsl:if test="$documentType = 'taxationDecisionVAT' and $vatTotalAmount and string-length($vatTotalAmount)>0">
						<br/>
						<table width="100%" class="content withBorder" border="0" cellspacing="0" cellpadding="0" >
							<tr>
								<td>
									<b>
										<xsl:call-template name="Translate">
											<xsl:with-param name="labelToTranslate" select="'gesamtbetrag_mwst'"/>
										</xsl:call-template>
									</b>
								</td>
								<td align="right" >
									<b>
										<xsl:value-of select="$vatTotalAmount"/>
									</b>
								</td>
							</tr>
						</table>
					</xsl:if>
		
					<!-- valuationSummary refundCustomsDuties -->	
					<xsl:if test="$documentType = 'taxationDecisionCustomsDuties'">
						<br/>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="content withBorder">
							<xsl:call-template name="valuationSummaryCustomDuties"/>
						</table>
					</xsl:if>	
		        </td>
		    </tr>
		</table>

		<!-- Goods Item -->
		<xsl:for-each select="receipt:goodsItem">
			<xsl:call-template name="goodsItem"/>
		</xsl:for-each>
	</xsl:template>
	
	<!-- versender -->
    <xsl:template name="consignor">
        <xsl:variable name="name" select="receipt:consignor/receipt:name"/>
        <xsl:variable name="street" select="receipt:consignor/receipt:street"/>
        <xsl:variable name="country" select="receipt:consignor/receipt:country"/>
        <xsl:variable name="postalCode" select="receipt:consignor/receipt:postalCode"/>
        <xsl:variable name="city" select="receipt:consignor/receipt:city"/>
        <xsl:variable name="addressSupplement1" select="receipt:consignor/receipt:addressSupplement1"/>
        <xsl:variable name="addressSupplement2" select="receipt:consignor/receipt:addressSupplement2"/>
        <xsl:variable name="addressSupplement3" select="receipt:consignor/receipt:addressSupplement3"/>
        <xsl:variable name="consignorReference" select="receipt:consignor/receipt:consignorReference"/>
        <xsl:variable name="traderIdentificationNumber" select="receipt:consignor/receipt:traderIdentificationNumber"/>
        <span class="label">
            <xsl:call-template name="Translate">
                <xsl:with-param name="labelToTranslate" select="'versender'"/>
            </xsl:call-template>
        </span>
        <table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <xsl:value-of select="$name"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement1 and string-length($addressSupplement1)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement1"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$addressSupplement2 and string-length($addressSupplement2)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement2"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$street"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement3 and string-length($addressSupplement3)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement3"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$country"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$postalCode"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$city"/>
                </td>
            </tr>
            <xsl:if test="$consignorReference and string-length($consignorReference)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$consignorReference"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$traderIdentificationNumber and string-length($traderIdentificationNumber)>0">
                <tr>
                    <td>
                        <span class="label">
                            <xsl:call-template name="Translate">
                                <xsl:with-param name="labelToTranslate" select="'tin_nr'"/>
                            </xsl:call-template>
                        </span>
                        <xsl:value-of select="$traderIdentificationNumber"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>
    
	<!-- importeur -->
	<xsl:template name="importer">
        <xsl:variable name="name" select="receipt:importer/receipt:name"/>
        <xsl:variable name="street" select="receipt:importer/receipt:street"/>
        <xsl:variable name="country" select="receipt:importer/receipt:country"/>
        <xsl:variable name="postalCode" select="receipt:importer/receipt:postalCode"/>
        <xsl:variable name="city" select="receipt:importer/receipt:city"/>
        <xsl:variable name="addressSupplement1" select="receipt:importer/receipt:addressSupplement1"/>
        <xsl:variable name="addressSupplement2" select="receipt:importer/receipt:addressSupplement2"/>
        <xsl:variable name="addressSupplement3" select="receipt:importer/receipt:addressSupplement3"/>
        <xsl:variable name="traderIdentificationNumber" select="receipt:importer/receipt:traderIdentificationNumber"/>
        <xsl:variable name="importerReference" select="receipt:importer/receipt:importerReference"/>
        <span class="label">
            <xsl:call-template name="Translate">
                <xsl:with-param name="labelToTranslate" select="'importeur'"/>
            </xsl:call-template>
        </span>
        <table width="100%" class="content" border="0" cellpading="0" cellspacing="0">
            <tr>
                <td>
                    <xsl:value-of select="$name"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement1 and string-length($addressSupplement1)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement1"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$addressSupplement2 and string-length($addressSupplement2)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement2"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$street"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement3 and string-length($addressSupplement3)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement3"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$country"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$postalCode"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$city"/>
                </td>
            </tr>
            <xsl:if test="$importerReference and string-length($importerReference)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$importerReference"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$traderIdentificationNumber and string-length($traderIdentificationNumber)>0">
                <tr>
                    <td>
                        <span class="label">
                            <xsl:call-template name="Translate">
                                <xsl:with-param name="labelToTranslate" select="'tin_nr'"/>
                            </xsl:call-template>
                        </span>
                        <xsl:value-of select="$traderIdentificationNumber"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>  
	
    <!-- empfaenger -->
    <xsl:template name="consignee">
        <xsl:variable name="name" select="receipt:consignee/receipt:name"/>
        <xsl:variable name="street" select="receipt:consignee/receipt:street"/>
        <xsl:variable name="country" select="receipt:consignee/receipt:country"/>
        <xsl:variable name="postalCode" select="receipt:consignee/receipt:postalCode"/>
        <xsl:variable name="city" select="receipt:consignee/receipt:city"/>
        <xsl:variable name="addressSupplement1" select="receipt:consignee/receipt:addressSupplement1"/>
        <xsl:variable name="addressSupplement2" select="receipt:consignee/receipt:addressSupplement2"/>
        <xsl:variable name="addressSupplement3" select="receipt:consignee/receipt:addressSupplement3"/>
        <xsl:variable name="consigneeReference" select="receipt:consignee/receipt:consigneeReference"/>
        <xsl:variable name="traderIdentificationNumber" select="receipt:consignee/receipt:traderIdentificationNumber"/>
        <span class="label">
            <xsl:call-template name="Translate">
                <xsl:with-param name="labelToTranslate" select="'empfaenger'"/>
            </xsl:call-template>
        </span>
        <table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <xsl:value-of select="$name"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement1 and string-length($addressSupplement1)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement1"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$addressSupplement2 and string-length($addressSupplement2)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement2"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$street"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement3 and string-length($addressSupplement3)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement3"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$country"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$postalCode"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$city"/>
                </td>
            </tr>
            <xsl:if test="$consigneeReference and string-length($consigneeReference)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$consigneeReference"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$traderIdentificationNumber and string-length($traderIdentificationNumber)>0">
                <tr>
                    <td>
                        <span class="label">
                            <xsl:call-template name="Translate">
                                <xsl:with-param name="labelToTranslate" select="'tin_nr'"/>
                            </xsl:call-template>
                        </span>
                        <xsl:value-of select="$traderIdentificationNumber"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>
	
	<!-- zugelassener empfaenger -->
    <xsl:template name="authorizedConsignee">
        <xsl:variable name="name" select="receipt:authorizedConsignee/receipt:name"/>
        <xsl:variable name="addressSupplement1" select="receipt:authorizedConsignee/receipt:addressSupplement1"/>
        <xsl:variable name="addressSupplement2" select="receipt:authorizedConsignee/receipt:addressSupplement2"/>
        <xsl:variable name="street" select="receipt:authorizedConsignee/receipt:street"/>
        <xsl:variable name="addressSupplement3" select="receipt:authorizedConsignee/receipt:addressSupplement3"/>
        <xsl:variable name="postalCode" select="receipt:authorizedConsignee/receipt:postalCode"/>
        <xsl:variable name="city" select="receipt:authorizedConsignee/receipt:city"/>
        <xsl:variable name="country" select="receipt:authorizedConsignee/receipt:country"/>
        <xsl:variable name="traderIdentificationNumber" select="receipt:authorizedConsignee/receipt:traderIdentificationNumber"/>
        <xsl:variable name="authorizedConsigneeReference" select="receipt:authorizedConsignee/receipt:authorizedConsigneeReference"/>
        <span class="label">
            <xsl:call-template name="Translate">
                <xsl:with-param name="labelToTranslate" select="'zugelassenerEmpfaenger'"/>
            </xsl:call-template>
        </span>
        <table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <xsl:value-of select="$name"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement1 and string-length($addressSupplement1)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement1"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$addressSupplement2 and string-length($addressSupplement2)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement2"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$street"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement3 and string-length($addressSupplement3)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement3"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$country"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$postalCode"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$city"/>
                </td>
            </tr>
            <xsl:if test="$authorizedConsigneeReference and string-length($authorizedConsigneeReference)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$authorizedConsigneeReference"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$traderIdentificationNumber and string-length($traderIdentificationNumber)>0">
                <tr>
                    <td>
                        <span class="label">
                            <xsl:call-template name="Translate">
                                <xsl:with-param name="labelToTranslate" select="'tin_nr'"/>
                            </xsl:call-template>
                        </span>
                    <xsl:value-of select="$traderIdentificationNumber"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>
	
	<!-- spediteur -->
    <xsl:template name="spediteur">
        <xsl:variable name="declarantNumber" select="receipt:declarant/receipt:declarantNumber"/>
        <xsl:variable name="name" select="receipt:declarant/receipt:name"/>
        <xsl:variable name="street" select="receipt:declarant/receipt:street"/>
        <xsl:variable name="country" select="receipt:declarant/receipt:country"/>
        <xsl:variable name="postalCode" select="receipt:declarant/receipt:postalCode"/>
        <xsl:variable name="city" select="receipt:declarant/receipt:city"/>
        <xsl:variable name="traderDeclarationNumber" select="receipt:traderDeclarationNumber"/>
        <xsl:variable name="traderReference" select="receipt:traderReference"/> <!--  Dossiernummer Spedi -->
        <span class="label">
            <xsl:call-template name="Translate">
                <xsl:with-param name="labelToTranslate" select="'spediteur'"/>
            </xsl:call-template>
        </span>
        <table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <xsl:value-of select="$name"/>
                </td>
            </tr>

			<!-- Deklarantennummer -->
            <xsl:if test="$traderDeclarationNumber and string-length($traderDeclarationNumber)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$declarantNumber"/>
                    </td>
                </tr>
            </xsl:if>

            <xsl:if test="$street and string-length($street)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$street"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:if test="$country and string-length($country)>0">
                        <xsl:value-of select="$country"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:if test="$postalCode and string-length($postalCode)>0">
                        <xsl:value-of select="$postalCode"/>
                    </xsl:if>
                    <xsl:if test="$city and string-length($city)>0">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="$city"/>
                    </xsl:if>
                </td>
            </tr>

			<!-- Zollanmeldungsnummer--> 
            <xsl:if test="$traderDeclarationNumber and string-length($traderDeclarationNumber)>0">
                <tr>
                    <td>
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'anm_nr'"/>
							</xsl:call-template>
						</span>
                        <xsl:value-of select="$traderDeclarationNumber"/>
                    </td>
                </tr>
            </xsl:if>
						
			<!-- Dossiernummer Spediteur -->
            <xsl:if test="$traderReference and string-length($traderReference)>0">
                <tr>
                    <td>
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'ref_nr'"/>
							</xsl:call-template>
						</span>
                        <xsl:value-of select="$traderReference"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>
    
	<!-- transporteur -->
    <xsl:template name="carrier">
        <xsl:variable name="name" select="receipt:carrier/receipt:name"/>
        <xsl:variable name="street" select="receipt:carrier/receipt:street"/>
        <xsl:variable name="country" select="receipt:carrier/receipt:country"/>
        <xsl:variable name="postalCode" select="receipt:carrier/receipt:postalCode"/>
        <xsl:variable name="city" select="receipt:carrier/receipt:city"/>
        <xsl:variable name="addressSupplement1" select="receipt:carrier/receipt:addressSupplement1"/>
        <xsl:variable name="addressSupplement2" select="receipt:carrier/receipt:addressSupplement2"/>
        <xsl:variable name="addressSupplement3" select="receipt:carrier/receipt:addressSupplement3"/>
        <xsl:variable name="traderIdentificationNumber" select="receipt:carrier/receipt:traderIdentificationNumber"/>
        <xsl:variable name="carrierReference" select="receipt:carrier/receipt:carrierReference"/>
        <span class="label">
            <xsl:call-template name="Translate">
                <xsl:with-param name="labelToTranslate" select="'transporteur'"/>
            </xsl:call-template>
        </span>
        <table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <xsl:value-of select="$name"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement1 and string-length($addressSupplement1)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement1"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$addressSupplement2 and string-length($addressSupplement2)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement2"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$street"/>
                </td>
            </tr>
            <xsl:if test="$addressSupplement3 and string-length($addressSupplement3)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$addressSupplement3"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>
                    <xsl:value-of select="$country"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$postalCode"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="$city"/>
                </td>
            </tr>

            <!-- TIN -->
            <xsl:if test="$traderIdentificationNumber and string-length($traderIdentificationNumber)>0">
                <tr>
                    <td>
                        <span class="label">
                            <xsl:call-template name="Translate">
                                <xsl:with-param name="labelToTranslate" select="'tin_nr'"/>
                            </xsl:call-template>
                        </span>
                        <xsl:value-of select="$traderIdentificationNumber"/>
                    </td>
                </tr>
            </xsl:if>

            <xsl:if test="$carrierReference and string-length($carrierReference)>0">
                <tr>
                    <td>
                        <xsl:value-of select="$carrierReference"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>
	
	<!-- frachtinformationen -->
    <xsl:template name="headerInformationRight">
        <xsl:variable name="bordereauNumber" select="receipt:bordereauNumber"/>
        <xsl:variable name="deliveryDestination" select="receipt:deliveryDestination"/>
        <xsl:variable name="dispatchCountry" select="receipt:dispatchCountry"/>        
		<xsl:variable name="dispatchCountryConfirmation" select="receipt:dispatchCountryConfirmation"/>  
        <xsl:variable name="numberOfGoodsItems" select="receipt:numberOfGoodsItems"/>
        <xsl:variable name="VATNumber" select="//receipt:VATNumber"/><!-- Import/Export different schema -->
		<xsl:variable name="VATSuffix" select="//receipt:VATSuffix"/><!-- Import/Export different schema -->
		<xsl:variable name="invoiceCurrencyType" select="receipt:invoiceCurrencyType"/>		
		<xsl:variable name="incoterms" select="receipt:incoterms"/>	
        <xsl:variable name="transportMode" select="receipt:transportMeans/receipt:transportMode"/>
		<xsl:variable name="transportationType" select="receipt:transportMeans/receipt:transportationType"/>
        <!-- Verkehrszweig -->
        <xsl:variable name="transportationCountry" select="receipt:transportMeans/receipt:transportationCountry"/>
        <xsl:variable name="transportationNumber" select="receipt:transportMeans/receipt:transportationNumber"/>
        <xsl:variable name="container" select="receipt:container"/>
        <xsl:variable name="previousDocument" select="receipt:previousDocument"/>
        <xsl:variable name="specialMention" select="receipt:specialMention"/>
        <xsl:variable name="reason" select="receipt:reason"/> 
		<xsl:variable name="declarationType" select="receipt:declarationType"/>
		<!-- Konto Zoll = customs account-->   	
		<xsl:variable name="customsAccount" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:customsAccount"/>		
        <xsl:variable name="accountNumberCustoms" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:customsAccount/receipt:accountNumber"/>
        <xsl:variable name="accountNameCustoms" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:customsAccount/receipt:accountName"/>
		<!-- Konto MWST = VAT account-->
		<xsl:variable name="VATAccount" select="//receipt:VATAccount"/><!-- Import/Export different schema -->
        <xsl:variable name="accountNumberVAT" select="$VATAccount/receipt:accountNumber"/>
        <xsl:variable name="accountNameVAT" select="$VATAccount/receipt:accountName"/>
		
		<table width="100%" class="content withSpace" border="0" cellpadding="0" cellspacing="0">
        	<xsl:if test="$bordereauNumber and string-length($bordereauNumber)>0">
				<tr>
				<td class="label">
                    <xsl:call-template name="Translate">
                        <xsl:with-param name="labelToTranslate" select="'bordereauNumber'"/>
                    </xsl:call-template>
                </td>
                    <td>
                        <xsl:value-of select="$bordereauNumber"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$deliveryDestination and string-length($deliveryDestination)>0">
                <tr>
                <td class="label">
                    <xsl:call-template name="Translate">
                        <xsl:with-param name="labelToTranslate" select="'bestimmungsland'"/>
                    </xsl:call-template>
                </td>
				<td>
                	<xsl:value-of select="$deliveryDestination"/>
                </td>
                </tr>
            </xsl:if>
            <xsl:if test="$dispatchCountry and string-length($dispatchCountry)>0">
                <tr>
                <td class="label">
                    <xsl:call-template name="Translate">
                        <xsl:with-param name="labelToTranslate" select="'erzeugungsland'"/>
                    </xsl:call-template>
                </td>
                    <td>
                        <xsl:value-of select="$dispatchCountry"/>
						<xsl:call-template name="checkConfirmation">
							<xsl:with-param name="value" select="$dispatchCountryConfirmation"/>
						</xsl:call-template>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td class="label">
                    <xsl:call-template name="Translate">
                        <xsl:with-param name="labelToTranslate" select="'positionen'"/>
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:value-of select="$numberOfGoodsItems"/>
                </td>
            </tr>
			
			<!-- Konto Zoll = customs account-->   	
            <xsl:if test="$customsAccount and string-length($customsAccount)>0">
                <tr>
                    <td class="label">
                        <xsl:call-template name="Translate">
                            <xsl:with-param name="labelToTranslate" select="'konto_zoll'"/>
                        </xsl:call-template>
                    </td>
                    <td>
                        <xsl:value-of select="$accountNumberCustoms"/>
						<xsl:text>-</xsl:text>
						<xsl:value-of select="$accountNameCustoms"/>

                    </td>
                </tr>
            </xsl:if>
			
			<!-- Konto MWST = VAT account-->
            <xsl:if test="$documentType!='taxationDecisionCustomsDuties' and $VATAccount and string-length($VATAccount)>0">
                <tr>
                    <td class="label">
                        <xsl:call-template name="Translate">
                            <xsl:with-param name="labelToTranslate" select="'konto_mwst'"/>
                        </xsl:call-template>
                    </td>
					<td>
			            <xsl:value-of select="$accountNumberVAT"/>
						<xsl:text>-</xsl:text>
						<xsl:value-of select="$accountNameVAT"/>
					</td>                
				</tr>
            </xsl:if>
			
			<!-- Mwst Nummer -->
			<xsl:if test="$documentType!='taxationDecisionCustomsDuties' and $VATNumber and string-length($VATNumber)>0">
                <tr>
                    <td class="label">
                        <xsl:call-template name="Translate">
                            <xsl:with-param name="labelToTranslate" select="'mwst_nr'"/>
                        </xsl:call-template>
                    </td>
                    <td>
                        <xsl:value-of select="$VATNumber"/> 
						<xsl:if test="$VATSuffix and ($VATSuffix = '1')">
							<xsl:text> </xsl:text>
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'vatsuffix'"/>
							</xsl:call-template>
						</xsl:if>
                    </td>
                </tr>
            </xsl:if>
			
			<!-- Rechnungswaehrung -->
			<xsl:if test="$documentType!='taxationDecisionCustomsDuties' and $invoiceCurrencyType and string-length($invoiceCurrencyType)>0">
                <tr>
                    <td class="label">
                        <xsl:call-template name="Translate">
                            <xsl:with-param name="labelToTranslate" select="'rechnungswaehrung'"/>
                        </xsl:call-template>
                    </td>
                    <td>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'invoiceCurrencyType'"/>
							<xsl:with-param name="value" select="$invoiceCurrencyType"/>
						</xsl:call-template>
                    </td>
                </tr>
            </xsl:if>
			
			<!-- Incoterms -->
			<xsl:if test="$incoterms and string-length($incoterms)>0">
                <tr>
                    <td class="label">
                        <xsl:call-template name="Translate">
                            <xsl:with-param name="labelToTranslate" select="'incoterms'"/>
                        </xsl:call-template>
                    </td>
                    <td>
                        <xsl:value-of select="$incoterms"/>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="$reason and string-length($reason)>0">
                <tr>
                    <td class="label">
                        <xsl:call-template name="Translate">
                            <xsl:with-param name="labelToTranslate" select="'reason'"/>
                        </xsl:call-template>
                    </td>
                    <td>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'reason'"/>
							<xsl:with-param name="value" select="$reason"/>
						</xsl:call-template>
                    </td>
                </tr>
            </xsl:if>
        </table>
		
		<!-- transport -->
		<br/>
		<span class="label">
			<xsl:call-template name="Translate">
				<xsl:with-param name="labelToTranslate" select="'transport'"/>
			</xsl:call-template>
        </span>
        <table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td>
					<xsl:if test="$transportMode and string-length($transportMode)>0">
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'transportMode'"/>
							<xsl:with-param name="value" select="$transportMode"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$transportationType and string-length($transportationType)>0">
						<xsl:text>, </xsl:text>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'transportationType'"/>
							<xsl:with-param name="value" select="$transportationType"/>
						</xsl:call-template>
					</xsl:if>
                    <xsl:if test="$transportationCountry and string-length($transportationCountry)>0">
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="$transportationCountry"/>
                    </xsl:if>
                    <xsl:if test="$transportationNumber and string-length($transportationNumber)>0">
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="$transportationNumber"/>
                    </xsl:if>
                </td>
            </tr>
		</table>
		
		<!-- container -->
		<xsl:if test="$container">
			<br/>
			<span class="label">
				<xsl:call-template name="Translate">
					<xsl:with-param name="labelToTranslate" select="'container'"/>
				</xsl:call-template>
			</span>
			<table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
                <xsl:for-each select="$container">
                    <tr>
                        <td>
                            <xsl:value-of select="receipt:containerNumber"/>
                        </td>
                    </tr>
                </xsl:for-each>
			</table>
		</xsl:if>
			
		<!-- Vorpapiere -->
		<xsl:if test="$previousDocument">
			<br/>
			<span class="label">
				<xsl:call-template name="Translate">
					<xsl:with-param name="labelToTranslate" select="'vorpapiere'"/>
				</xsl:call-template>
			</span>
			<table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
                <xsl:for-each select="$previousDocument">
                    <tr>
                        <td>
							<xsl:call-template name="getDomainText">
								<xsl:with-param name="domainName" select="'previousDocumentType'"/>
								<xsl:with-param name="value" select="receipt:previousDocumentType"/>
							</xsl:call-template>
                            <xsl:text>, </xsl:text>
                            <xsl:value-of select="receipt:previousDocumentReference"/>
                            <xsl:text>, </xsl:text>
                            <xsl:value-of select="receipt:additionalInformation"/>
                        </td>
                    </tr>
                </xsl:for-each>
			</table>
		</xsl:if>
		
		<!-- Besondere Vermerke -->
		<xsl:if test="$specialMention">		
			<br/>
			<span class="label">
				<xsl:call-template name="Translate">
					<xsl:with-param name="labelToTranslate" select="'besondere_vermerke'"/>
				</xsl:call-template>			
			</span>
			<table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
                <xsl:for-each select="$specialMention">
                    <tr>
                        <td>
                            <xsl:value-of select="receipt:text"/>
                        </td>
                    </tr>
                </xsl:for-each>
			</table>
		</xsl:if>
    </xsl:template>
	
	<!-- GoodsItems -->
    <xsl:template name="goodsItem">
        <xsl:variable name="customsItemNumber" select="receipt:customsItemNumber"/>
	    <xsl:variable name="description" select="receipt:description"/>
        <xsl:variable name="statisticalCode" select="receipt:statisticalCode"/>
        <xsl:variable name="commodityCode" select="receipt:commodityCode"/>
        <xsl:variable name="commodityCodeConfirmation" select="receipt:commodityCodeConfirmation"/>
        <xsl:variable name="customsClearanceType" select="receipt:statistic/receipt:customsClearanceType"/>
        <xsl:variable name="refund" select="receipt:refund"/>
        <xsl:variable name="refundType" select="receipt:refund/receipt:refundType"/>
 		<xsl:variable name="netMass" select="receipt:netMass"/> <!-- Eigenmasse -->
		<xsl:variable name="netMassConfirmation" select="receipt:netMassConfirmation"/>
    	<xsl:variable name="grossMass" select="receipt:grossMass"/> <!-- Rohmasse -->
		<xsl:variable name="grossMassConfirmation" select="receipt:grossMassConfirmation"/>
    	<xsl:variable name="statisticalValue" select="receipt:statistic/receipt:statisticalValue"/> <!-- Stat. Wert -->
		<xsl:variable name="statisticalValueConfirmation" select="receipt:statistic/receipt:statisticalValueConfirmation"/>
		<xsl:variable name="customsNetWeight" select="receipt:customsNetWeight"/> <!-- Zollnetogewicht -->
        <xsl:variable name="specialMention" select="receipt:specialMention"/>
        <xsl:variable name="additionalUnit" select="receipt:additionalUnit"/>
        <xsl:variable name="additionalUnitConfirmation" select="receipt:additionalUnitConfirmation"/>
        <xsl:variable name="VOCQuantity" select="receipt:refund/receipt:VOCQuantity"/>
        <xsl:variable name="packaging" select="receipt:packaging"/>
        <xsl:variable name="permit" select="receipt:permit"/>
        <xsl:variable name="producedDocument" select="receipt:producedDocument"/>
        <xsl:variable name="nonCustomsLaw" select="receipt:nonCustomsLaw"/>
        <xsl:variable name="nonCustomsLawObligation" select="receipt:nonCustomsLawObligation"/>
		<xsl:variable name="originPreference" select="receipt:origin/receipt:preference"/>
		<xsl:variable name="originPreferenceConfirmation" select="receipt:origin/receipt:preferenceConfirmation"/>
		<xsl:variable name="originCountry" select="receipt:origin/receipt:originCountry"/>
		<xsl:variable name="commercialGood" select="receipt:statistic/receipt:commercialGood"/>
		<xsl:variable name="permitObligation" select="receipt:permitObligation"/>
		<xsl:variable name="storageType" select="receipt:storageType"/>
		<xsl:variable name="direction" select="receipt:repairAndRefinement/receipt:direction"/>
		<xsl:variable name="processType" select="receipt:repairAndRefinement/receipt:processType"/>
		<xsl:variable name="refinementType" select="receipt:repairAndRefinement/receipt:refinementType"/>
		<xsl:variable name="billingType" select="receipt:repairAndRefinement/receipt:billingType"/>
		<xsl:variable name="repair" select="receipt:statistic/receipt:repair"/>
		<xsl:variable name="repairReason" select="receipt:repairAndRefinement/receipt:repairReason"/>
		
		<br/>
        <table width="788" border="0" class="content withSpace mainTable" cellpadding="0" cellspacing="0" style="border-top: 2px solid black;">
            <tr>
				<td width="47%" valign="top">
					<strong>
						<xsl:value-of select="receipt:customsItemNumber"/>
					</strong>
				</td>
                <td colspan="2">
                    <strong>
						<xsl:for-each select="$nonCustomsLaw">
							<xsl:if test="position() > 1">
								<xsl:text>, </xsl:text>
							</xsl:if>							
							<xsl:call-template name="getDomainText">
								<xsl:with-param name="domainName" select="'nonCustomsLawType'"/>
								<xsl:with-param name="value" select="receipt:nonCustomsLawType"/>
							</xsl:call-template>
						</xsl:for-each>
                    </strong>
                </td>
			</tr>
			<tr>
				<td colspan="3">
					<table width="100%" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td colspan="2">
								<strong>
									<xsl:value-of select="receipt:description"/>
								</strong>
							</td>
							<td width="30%" align="right" valign="top">
								<strong>
									<span>
										<xsl:value-of select="$commodityCode"/>
										<xsl:call-template name="checkConfirmation">
											<xsl:with-param name="value" select="$commodityCodeConfirmation"/>
										</xsl:call-template>
									</span>
									<xsl:if test="$statisticalCode">
										<span style="padding-left:50px;">
											<xsl:value-of select="$statisticalCode"/>
										</span>
									</xsl:if>
								</strong>
							</td>
						</tr>
					</table>
				</td>
            </tr>
			<xsl:if test="$customsClearanceType or $refund">
                <tr>
					<td>
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<xsl:if test="$commercialGood and ($commercialGood=1 or $commercialGood=2)">
									<td>
										<xsl:if test="$commercialGood = 1">
											<input type="checkbox" checked="checked" disabled="true"/> 
										</xsl:if>
										<xsl:if test="$commercialGood = 2">
											<input type="checkbox" disabled="true"/> 
										</xsl:if>
									</td>
									<td style="padding-right:20px; vertical-align:baseline;" valign="baseline">
										<span class="label">
											<xsl:call-template name="Translate">
												<xsl:with-param name="labelToTranslate" select="'handelswaren'"/>
											</xsl:call-template>
										</span>
									</td>
								</xsl:if>
								<xsl:if test="$originPreference and ($originPreference=1 or $originPreference=0) and ($documentType != 'taxationDecisionExport')">
									<td>
										<xsl:if test="$originPreference = 1">
											<input type="checkbox" checked="checked" disabled="true"/> 
										</xsl:if>
										<xsl:if test="$originPreference = 0">
											<input type="checkbox" disabled="true"/> 
										</xsl:if>
									</td>
									<td style="padding-right:20px; vertical-align:baseline;" valign="baseline">
										<span class="label" style="margin-right: 0px;">
											<xsl:call-template name="Translate">
												<xsl:with-param name="labelToTranslate" select="'praeferenz'"/>
											</xsl:call-template>
										</span>
										<xsl:call-template name="checkConfirmation">
											<xsl:with-param name="value" select="$originPreferenceConfirmation"/>
										</xsl:call-template>
									</td>
								</xsl:if>
								<xsl:if test="$originCountry">	
									<td style="padding-right:20px; vertical-align:baseline;" valign="baseline">
										<span class="label">
											<xsl:call-template name="Translate">
												<xsl:with-param name="labelToTranslate" select="'ursprungsland'"/>
											</xsl:call-template>
										</span>
										<xsl:value-of select="$originCountry"/>
									</td>
								</xsl:if>
							</tr>
						</table>
					</td>					
					<td colspan="2" style="vertical-align:baseline; padding-top: 10px;" valign="baseline">
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'veranlagungstyp'"/>
							</xsl:call-template>
						</span>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'customsClearanceType'"/>
							<xsl:with-param name="value" select="$customsClearanceType"/>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<!-- Veredelungsverkehr -->
			<xsl:if test="$repairReason or ($repair and $repair = 1)">
				<tr>
					<td colspan="2">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td style="vertical-align:baseline; padding-top: 0px; padding-right:25px; margin-top:2px;" valign="baseline">
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td style="vertical-align:baseline;" valign="baseline">
												<xsl:if test="$repair and ($repair=1 or $repair=0)">
													<xsl:if test="$repair = 1">
														<input style="margin-bottom:0px" type="checkbox" checked="checked" disabled="true"/> 
													</xsl:if>
													<xsl:if test="$repair = 0">
														<input type="checkbox" disabled="true"/> 
													</xsl:if>
												</xsl:if>
											</td>
											<td style="vertical-align:baseline;" valign="baseline">
												<span class="label" style="padding: 0px;">
													<xsl:call-template name="Translate">
														<xsl:with-param name="labelToTranslate" select="'ausbesserung'"/>
													</xsl:call-template>
												</span>
											</td>
										</tr>
									</table>
								</td>
								<td style="padding-top:6px;">
									<xsl:if test="$repairReason and string-length($repairReason)>0">
										<span class="label">
											<xsl:call-template name="Translate">
												<xsl:with-param name="labelToTranslate" select="'ausbesserungszweck'"/>
											</xsl:call-template>
										</span>
										<xsl:value-of select="$repairReason"/>
									</xsl:if>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:if>
			
			<!--- ValuationDetails -->
			<xsl:choose>
				<xsl:when test="$documentType = 'taxationDecisionVAT'">
					<tr>
						<td colspan="3">
							<xsl:call-template name="valuationDetailsTaxationDecisionVAT"/>
							<br/>
						</td>
					</tr>
				</xsl:when>
				<xsl:when test="$documentType = 'taxationDecisionCustomsDuties'">
					<tr>
						<xsl:call-template name="valuationDetailsTaxationDecisionCustomsDuties"/>
					</tr>
				</xsl:when>
				<!-- No details for Export -->
			</xsl:choose>

 			<!-- more GoodsItems -->           
            <tr>
                <td>
					<xsl:if test="$netMass">
	                    <span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'eigenmasse'"/>
							</xsl:call-template>
	                    </span>
	                    <xsl:value-of select="$netMass"/>
						<xsl:call-template name="checkConfirmation">
							<xsl:with-param name="value" select="$netMassConfirmation"/>
						</xsl:call-template>
	                </xsl:if>
                </td>
				<td>
			        <xsl:if test="$grossMass">
	                    <span class="label">
	                        <xsl:call-template name="Translate">
	                            <xsl:with-param name="labelToTranslate" select="'rohmasse'"/>
	                        </xsl:call-template>
	                    </span>
	                    <xsl:value-of select="$grossMass"/>
						<xsl:call-template name="checkConfirmation">
							<xsl:with-param name="value" select="$grossMassConfirmation"/>
						</xsl:call-template>
					</xsl:if>
                </td>
				<td>
			        <xsl:if test="$statisticalValue and ($documentType = 'taxationDecisionExport')">
	                    <span class="label">
	                        <xsl:call-template name="Translate">
	                            <xsl:with-param name="labelToTranslate" select="'statwert'"/>
	                        </xsl:call-template>
	                    </span>
	                    <xsl:value-of select="$statisticalValue"/>
						<xsl:call-template name="checkConfirmation">
							<xsl:with-param name="value" select="$statisticalValueConfirmation"/>
						</xsl:call-template>
					</xsl:if>
                </td>
            </tr>
			<tr>
				<td>
					<xsl:if test="$additionalUnit and string-length($additionalUnit)>0">
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'zusatzmenge'"/>
							</xsl:call-template>
						</span>
						<xsl:value-of select="$additionalUnit"/>
						<xsl:call-template name="checkConfirmation">
							<xsl:with-param name="value" select="$additionalUnitConfirmation"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<td colspan="2">
					<xsl:if test="$customsNetWeight>0">
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'nettogewicht'"/>
							</xsl:call-template>
						</span>
						<xsl:value-of select="$customsNetWeight"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td colspan ="2">
					<xsl:if test="$refundType and string-length($refundType)>0 ">
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'rueckerstattungstyp'"/>
							</xsl:call-template>
						</span>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'refundType'"/>
							<xsl:with-param name="value" select="$refundType"/>
						</xsl:call-template>
					</xsl:if>
                </td>
				<td valign="top">
				    <xsl:if test="$VOCQuantity and string-length($VOCQuantity)>0">
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'vocmenge'"/>
							</xsl:call-template>
						</span>
						<xsl:value-of select="$VOCQuantity"/>
					</xsl:if>
				</td>
			</tr>
			<xsl:if test="$storageType and string-length($storageType)>0">
				<tr>
					<td colspan="3">
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'lagercode'"/>
							</xsl:call-template>
						</span>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'storageType'"/>
							<xsl:with-param name="value" select="$storageType"/>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td>
					<span class="label">
						<xsl:call-template name="Translate">
							<xsl:with-param name="labelToTranslate" select="'bewilligungspflichtcode'"/>
						</xsl:call-template>
					</span>
					<xsl:call-template name="getDomainText">
						<xsl:with-param name="domainName" select="'permitObligation'"/>
						<xsl:with-param name="value" select="$permitObligation"/>
					</xsl:call-template>
				</td>
				<td colspann="2">
					<span class="label">
						<xsl:call-template name="Translate">
							<xsl:with-param name="labelToTranslate" select="'nze_pflichtcode'"/>
						</xsl:call-template>
					</span>				
					<xsl:call-template name="getDomainText">
						<xsl:with-param name="domainName" select="'nonCustomsLawObligation'"/>
						<xsl:with-param name="value" select="$nonCustomsLawObligation"/>
					</xsl:call-template>
				</td>
			</tr>
			<xsl:if test="$direction or $processType">	
				<tr>
					<td>
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'verkehrsrichtung'"/>
							</xsl:call-template>
						</span>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'direction'"/>
							<xsl:with-param name="value" select="$direction"/>
						</xsl:call-template>
					</td>
					<td colspan="2" >
						<xsl:if test="$processType">	
							<span class="label">
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'verfahren'"/>
								</xsl:call-template>
							</span>				
							<xsl:call-template name="getDomainText">
								<xsl:with-param name="domainName" select="'processType'"/>
								<xsl:with-param name="value" select="$processType"/>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="$refinementType or $billingType">	
				<tr>
					<td>
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'veredelungstyp'"/>
							</xsl:call-template>
						</span>
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'refinementType'"/>
							<xsl:with-param name="value" select="$refinementType"/>
						</xsl:call-template>
					</td>
					<td colspan="2">
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'abrechnung'"/>
							</xsl:call-template>
						</span>				
						<xsl:call-template name="getDomainText">
							<xsl:with-param name="domainName" select="'billingType'"/>
							<xsl:with-param name="value" select="$billingType"/>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>			
			<xsl:if test="$permit">
				<tr>
					<td colspan="3" valign="top" height="10px" ></td>
				</tr>
				<xsl:for-each select="$permit">
					<tr>
						<td colspan="3" valign="top">
							<span class="label">
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'bewilligungen'"/>
								</xsl:call-template>
							</span>
							<br/>
							<xsl:call-template name="getDomainText">
								<xsl:with-param name="domainName" select="'permitType'"/>
								<xsl:with-param name="value" select="receipt:permitType"/>
							</xsl:call-template>
							<xsl:text>, </xsl:text>
							<xsl:call-template name="getDomainText">
								<xsl:with-param name="domainName" select="'permitAuthority'"/>
								<xsl:with-param name="value" select="receipt:permitAuthority"/>
							</xsl:call-template>
							<xsl:text>, </xsl:text>
							<xsl:value-of select="receipt:permitNumber"/>
							<xsl:text>, </xsl:text>
							<xsl:value-of select="receipt:issueDate"/>
							<xsl:text>, </xsl:text>
							<xsl:call-template name="valueOfWithEmpty">
								<xsl:with-param name="value" select="receipt:additionalInformation"/>
							</xsl:call-template>
							
							<xsl:if test="receipt:permitItemDetails/receipt:permitItemDetail">
								<table width="100%" border="0" class="content noPadding" cellpadding="0" cellspacing="0" style="margin-left:20px;">
									<span class="label">
										<xsl:call-template name="Translate">
											<xsl:with-param name="labelToTranslate" select="'bewilligungsdetail_SchluesselWert'"/>
										</xsl:call-template>
									</span>
									<xsl:for-each select="receipt:permitItemDetails/receipt:permitItemDetail">	
										<tr>
											<td>
												<xsl:call-template name="getDomainText">
													<xsl:with-param name="domainName" select="'permitItemDetailName'"/>
													<xsl:with-param name="value" select="receipt:key"/>
												</xsl:call-template>								
												<xsl:text>: </xsl:text>
												<xsl:value-of select="receipt:value"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td colspan="3" valign="top" height="8px" ></td>
				</tr>
			</xsl:if>			
			
			<xsl:if test="$packaging or $producedDocument">			
				<tr>
					<td valign="top" style="padding-top:7px; vertical-align:top;">
						<xsl:if test="$packaging">
							<span class="label">
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'packstuecke'"/>
								</xsl:call-template>
							</span>
							<table width="100%" border="0" class="content noPadding" cellpadding="0" cellspacing="0">
								<xsl:for-each select="$packaging">
									<tr>
										<td>
											<xsl:call-template name="getDomainText">
												<xsl:with-param name="domainName" select="'packagingType'"/>
												<xsl:with-param name="value" select="./receipt:packagingType"/>
											</xsl:call-template>
											<xsl:text>, </xsl:text>
											<xsl:call-template name="valueOfWithEmpty">
												<xsl:with-param name="value" select="./receipt:quantity"/>
											</xsl:call-template>
											<xsl:text>, </xsl:text>
											<xsl:call-template name="valueOfWithEmpty">
												<xsl:with-param name="value" select="./receipt:packagingReferenceNumber"/>
											</xsl:call-template>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</xsl:if>
					</td>
					<td valign="top" colspan="2" style="padding-top:7px; vertical-align:top;">
						<xsl:if test="$producedDocument">
							<span class="label">
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'unterlagen'"/>
								</xsl:call-template>
							</span>
							<table width="100%" border="0" class="content noPadding" cellpadding="0" cellspacing="0">
								<xsl:for-each select="$producedDocument">
									<tr>
										<td>
											<xsl:call-template name="getDomainText">
												<xsl:with-param name="domainName" select="'documentType'"/>
												<xsl:with-param name="value" select="./receipt:documentType"/>
											</xsl:call-template>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="./receipt:documentReferenceNumber"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="./receipt:issueDate"/>
											<xsl:text>, </xsl:text>
											<xsl:call-template name="valueOfWithEmpty">
												<xsl:with-param name="value" select="./receipt:additionalInformation"/>
											</xsl:call-template>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</xsl:if>
					</td>
				</tr>
			</xsl:if>
			
			<!-- zusatzinformationen -->
			<xsl:if test="receipt:goodsItemDetails/receipt:goodsItemDetail">
                <tr>
                    <td colspan="3">
						<br/>
						<span class="label">
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'zusatzinformationen'"/>
							</xsl:call-template>
						</span>
						<table width="100%" border="0" class="content noPadding" cellpadding="0" cellspacing="0">
							
							<xsl:for-each select="receipt:goodsItemDetails/receipt:goodsItemDetail[position()mod 3=1]">
								<xsl:sort select="receipt:name" />
								<xsl:variable name="current-pos" select="(position()-1) * 3+1"/>
								<tr>
								<xsl:for-each select="../receipt:goodsItemDetail[position()&gt;=$current-pos and position() &lt; $current-pos+3]" >
									<xsl:sort select="receipt:name" />
									<td with="33%">
										<span class="label">
											<xsl:call-template name="getDomainText">
												<xsl:with-param name="domainName" select="'goodsItemDetailName'"/>
												<xsl:with-param name="value" select="receipt:name"/>
											</xsl:call-template>
											<xsl:text>:</xsl:text>
										</span>
										
										<xsl:variable name="domainName">
											<xsl:choose>												
												<xsl:when test="receipt:name = '1'"> <!-- Merkenschluessel -->
													<xsl:text>vehicleModelCode</xsl:text>
												</xsl:when>												
												<xsl:when test="receipt:name = '25'"> <!-- Tabaksorte -->
													<xsl:text>tobaccoType</xsl:text>
												</xsl:when>
												<xsl:when test="receipt:name = '27'"> <!-- Exportcode -->
													<xsl:text>ExportCode</xsl:text>
												</xsl:when>												
												<xsl:when test="receipt:name = '28'"> <!-- Freizonenverkehr -->
													<xsl:text>freeTradeZone</xsl:text>
												</xsl:when>												
												<xsl:when test="receipt:name = '29'"> <!-- Grenzzonenverkehr -->
													<xsl:text>borderZoneTraffic</xsl:text>
												</xsl:when>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$domainName and string-length($domainName)>0">
												<xsl:call-template name="getDomainText">
													<xsl:with-param name="domainName" select="$domainName"/>
													<xsl:with-param name="value" select="receipt:value"/>
												</xsl:call-template>	
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="receipt:value"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</xsl:for-each>
								</tr>           
							</xsl:for-each>      
						</table>
					</td>
				</tr>
			</xsl:if>
			
            <xsl:if test="$specialMention">
                <tr>
                    <td colspan="3">
                        <table width="100%" border="0" class="content" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
									<span class="label"> 
										<xsl:call-template name="Translate">
											<xsl:with-param name="labelToTranslate" select="'besondere_vermerke'"/>
										</xsl:call-template>
									</span>
                                </td>
                            </tr>
                            <xsl:for-each select="$specialMention/receipt:text">
                                <tr>
                                    <td>
                                        <xsl:value-of select="."/>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </table>
                    </td>
                </tr>
            </xsl:if>
        </table>
        <br/>
    </xsl:template>
	
	<!-- Table for Adresses and valuationSummary-->
	<xsl:template name="refundTemplate">
		<!-- konto mwst -->
		<xsl:variable name="VATAccount" select="receipt:valuationSummary/receipt:VAT/receipt:VATAccount"/>
        <xsl:variable name="accountNumberVAT" select="$VATAccount/receipt:accountNumber"/>
        <xsl:variable name="accountNameVAT" select="$VATAccount/receipt:accountName"/>   
		<!-- konto zoll -->
		<xsl:variable name="customsAccount" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:customsAccount"/>		
        <xsl:variable name="accountNumberCustoms" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:customsAccount/receipt:accountNumber"/>
        <xsl:variable name="accountNameCustoms" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:customsAccount/receipt:accountName"/>
		<xsl:variable name="VATSuffix" select="receipt:valuationSummary/receipt:VAT/receipt:VATSuffix"/><!-- Import/Export different schema -->
		<xsl:variable name="VATNumber" select="receipt:valuationSummary/receipt:VAT/receipt:VATNumber"/>
		<xsl:variable name="traderReference" select="receipt:traderReference"/>
		<xsl:variable name="correctionReason" select="receipt:correctionReason"/>
		<xsl:variable name="customsReference" select="receipt:customsReference"/>
		<xsl:variable name="bordereauNumber" select="receipt:bordereauNumber"/>
		<xsl:variable name="personInCharge" select="receipt:personInCharge"/>
		
		<br/>
		<table class="mainTable content" width="788" border="0">
			<tr>
				<td width="55%" scope="row" align="left" valign="top">
		            <!-- kunde (opt)-->
	                <xsl:call-template name="accountHolder"/>
					<!-- VATAccount -->
					<xsl:if test="$VATAccount" >
						<br/>
						<span class="label">
				            <xsl:call-template name="Translate">
				                <xsl:with-param name="labelToTranslate" select="'konto_mwst'"/>
				            </xsl:call-template>
				        </span><br/>
						<xsl:value-of select="$accountNumberVAT"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$accountNameVAT"/>
		            	<br/>
					</xsl:if>
					<!-- customsAccount -->
					<xsl:if test="$customsAccount">
		            	<br/>
						<span class="label">
				            <xsl:call-template name="Translate">
				                <xsl:with-param name="labelToTranslate" select="'konto_zoll'"/>
				            </xsl:call-template>
				        </span>
						<br/>
						<xsl:value-of select="$accountNumberCustoms"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$accountNameCustoms"/>
		            	<br/>
					</xsl:if>
					<!-- MWST-Nr = VATNumber (mand) -->
					<xsl:if test="$VATNumber">
		            	<br/>
				        <span class="label">
				            <xsl:call-template name="Translate">
				                <xsl:with-param name="labelToTranslate" select="'mwst_nr'"/>
				            </xsl:call-template>
				        </span>
						<br/>
						<xsl:value-of select="$VATNumber"/>
							<xsl:if test="$VATSuffix and ($VATSuffix = '1')">
							<xsl:text> </xsl:text>
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'vatsuffix'"/>
							</xsl:call-template>
						</xsl:if>
		            	<br/>
					</xsl:if>
				</td>
		        <td  valign="top">
					<table width="100%" class="content withSpace" border="0" cellpadding="0" cellspacing="0">
						<!-- sachbearbeiter (mand) -->
						<tr>
							<td>
								<span class="label">
									<xsl:call-template name="Translate">
										<xsl:with-param name="labelToTranslate" select="'sachbearbeiter'"/>
									</xsl:call-template>
								</span>
								<br/>
								<xsl:value-of select="$personInCharge"/>
							</td>
						</tr>
						
						<!-- borderau nummer (opt)-->
						<xsl:if test="$bordereauNumber and string-length($bordereauNumber)>0">
							<tr>
								<td>
									<span class="label">
										<xsl:call-template name="Translate">
											<xsl:with-param name="labelToTranslate" select="'bordereauNumber'"/>
										</xsl:call-template>
									</span>
									<br/>
									<xsl:value-of select="$bordereauNumber"/>
								</td>
							</tr>
						</xsl:if>

						<!-- Referenz Zoll (opt)-->
						<xsl:if test="$customsReference and string-length($customsReference)>0">
							<tr>
								<td>
									<span class="label">
										<xsl:call-template name="Translate">
											<xsl:with-param name="labelToTranslate" select="'referenz_zoll'"/>
										</xsl:call-template>
									</span>
									<br/>
									<xsl:value-of select="$customsReference"/>
								</td>
							</tr>
						</xsl:if>

						<!-- Dossiernummer Spediteur (opt)-->
						<xsl:if test="$traderReference and string-length($traderReference)>0">
							<tr>
								<td>
									<span class="label">
										<xsl:call-template name="Translate">
											<xsl:with-param name="labelToTranslate" select="'referenz_kunde'"/>
										</xsl:call-template>
									</span>
									<br/>
									<xsl:value-of select="$traderReference"/>
								</td>
							</tr>
						</xsl:if>

						<!-- Berichtigungsgrund (opt)-->
						<xsl:if test="$correctionReason and string-length($correctionReason)>0">
							<tr>
								<td>
									<span class="label">
										<xsl:call-template name="Translate">
											<xsl:with-param name="labelToTranslate" select="'berichtigungsgrund'"/>
										</xsl:call-template>
									</span>
									<br/>
									<xsl:call-template name="getDomainText">
										<xsl:with-param name="domainName" select="'correctionReason'"/>
										<xsl:with-param name="value" select="$correctionReason"/>
									</xsl:call-template>
								</td>
							</tr>
						</xsl:if>
					</table>
		        </td>
		    </tr>
		</table>
		<br/>
		
		<table width="788" border="0" cellpadding="0" cellspacing="0" class="content mainTable" style="border-top: 2px solid black;">
			<tr>
				<td>
					<br/>
					<table width="100%" border="0" cellpadding="0" cellspacing="0" class="withBorder content">
							<!-- valuationSummary refundVAT -->
							<xsl:if test="($documentType = 'refundVAT')">
								<xsl:call-template name="valuationSummaryRefundVAT"/>
							</xsl:if>
							<!-- valuationSummary refundCustomsDuties -->	
							<xsl:if test="($documentType = 'refundCustomsDuties')">
								<xsl:call-template name="valuationSummaryCustomDuties"/>
							</xsl:if>								
					</table>
				</td>
			</tr>
		</table>
		<br/>
	</xsl:template>
	
	<!-- kunde -->
	<xsl:template name="accountHolder">
		<xsl:variable name="accountHolder" select="receipt:accountHolder"/>
        <xsl:variable name="country" select="$accountHolder/receipt:country"/>
        <xsl:variable name="postalCode" select="$accountHolder/receipt:postalCode"/>
        <xsl:variable name="city" select="$accountHolder/receipt:city"/>
		<!-- (opt)-->
		<xsl:if test="$accountHolder and string-length($accountHolder)>0">
			<span class="label">
				<xsl:call-template name="Translate">
					<xsl:with-param name="labelToTranslate" select="'kunde'"/>
				</xsl:call-template>
			</span>
			<table width="100%" class="content" border="0" cellpadding="0" cellspacing="0">
				<xsl:for-each select="$accountHolder/receipt:addressLine">
					 <tr>
						<td>  
							<xsl:if test=". != concat($postalCode,' ',$city)">
								<xsl:value-of select="."/>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td>
						<xsl:value-of select="$country"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$postalCode"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$city"/>
					</td>
				</tr>
			</table>
		</xsl:if>
    </xsl:template>
	  
	<!-- Refund MWST Tabelle gross -->
	<xsl:template name="valuationSummaryRefundVAT">
		<xsl:variable name="totalAmount" select="receipt:valuationSummary/receipt:VAT/receipt:totalAmount"/>
	    <tr>
            <td class="label" align="center" width="80%">
                <xsl:call-template name="Translate">
                    <xsl:with-param name="labelToTranslate" select="'einnahmeart'"/>
                </xsl:call-template>
            </td>
            <td class="label" align="center">
                <xsl:call-template name="Translate">
                    <xsl:with-param name="labelToTranslate" select="'betrag'"/>
                </xsl:call-template>
            </td>
		</tr>
		<tr>
            <td align="left">
                <xsl:call-template name="Translate">
                    <xsl:with-param name="labelToTranslate" select="'vatsuffix'"/>
                </xsl:call-template>
            </td>
            <td align="right">
                <xsl:value-of select="$totalAmount"/>
            </td>
		</tr>
		<tr>
            <td align="left">
				<b>
					<xsl:call-template name="Translate">
						<xsl:with-param name="labelToTranslate" select="'nettorueckverguetung'"/>
					</xsl:call-template>
				</b>
			</td>
            <td align="right">
				<b>
					<xsl:value-of select="$totalAmount"/>
				</b>
            </td>
		</tr>
	</xsl:template>
	
	<!-- Tabelle Zolldeklarationuebersicht -->
	<xsl:template name="valuationSummaryCustomDuties">
		<xsl:variable name="detailAmount" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:detailAmount"/>
		<xsl:variable name="totalAmount" select="receipt:valuationSummary/receipt:dutyAndAdditionalTaxes/receipt:totalAmount"/>
		
		<tr>
            <td class="label" align="center">
                <xsl:call-template name="Translate">
                    <xsl:with-param name="labelToTranslate" select="'einnahmeart'"/>
                </xsl:call-template>
            </td>
            <td class="label" align="center" width="100px">
                <xsl:call-template name="Translate">
                    <xsl:with-param name="labelToTranslate" select="'betrag'"/>
                </xsl:call-template>
            </td>
		</tr>
		<xsl:for-each select="$detailAmount">
			<xsl:variable name="type" select="receipt:type"/>
			<tr>
	            <td align="left">
					<xsl:call-template name="getFeesOrAdditionalTaxes">
						<xsl:with-param name="value" select="$type"/>
					</xsl:call-template>
	            </td>
	            <td align="right">
	                <xsl:value-of select="receipt:amount"/>
	            </td>
			</tr>
		</xsl:for-each>		
		<tr>
            <td align="left"><b>
				<xsl:if test="($documentType = 'refundCustomsDuties')">
                	<xsl:call-template name="Translate">
                    	<xsl:with-param name="labelToTranslate" select="'nettorueckverguetung'"/>
                	</xsl:call-template>
				</xsl:if>
				<xsl:if test="($documentType = 'taxationDecisionCustomsDuties')">
                	<xsl:call-template name="Translate">
                    	<xsl:with-param name="labelToTranslate" select="'gesamtbetrag_ohne'"/>
                	</xsl:call-template>
				</xsl:if>
				</b>
            </td>
            <td align="right">
                <b><xsl:value-of select="$totalAmount"/></b>
            </td>
		</tr>
	</xsl:template>
	
	<!-- tabelle detail MWST-Berechnung -->
	<xsl:template name="valuationDetailsTaxationDecisionVAT">
		<xsl:variable name="amountNotCharged" select="receipt:valuationDetails/receipt:VAT/receipt:amountNotCharged"/>
		<xsl:variable name="boolen_amountNotCharged" select="$amountNotCharged and $amountNotCharged=1"/>
		<xsl:variable name="amount" select="receipt:valuationDetails/receipt:VAT/receipt:amount"/>
		<xsl:variable name="duties" select="receipt:valuationDetails/receipt:VAT/receipt:duties"/>
		<xsl:variable name="basisForAssessment" select="receipt:valuationDetails/receipt:VAT/receipt:basisForAssessment"/>
		<xsl:variable name="rate" select="receipt:valuationDetails/receipt:VAT/receipt:rate"/>
		<xsl:variable name="VATValue" select="receipt:valuationDetails/receipt:VAT/receipt:VATValue"/>
		<table width="100%" border="0" class="content withBorder" cellpading="0" cellspacing="0">
			<tr>
				<td style="border-top: none !important; border-left: none !important;"></td>
				 <td class="label" align="center">
					<xsl:call-template name="Translate">
						<xsl:with-param name="labelToTranslate" select="'betrag'"/>
					</xsl:call-template>
				</td>
				 <td class="label" align="center">
					<xsl:call-template name="Translate">
						<xsl:with-param name="labelToTranslate" select="'ansatz_prozent'"/>
					</xsl:call-template>
				</td>
				 <td class="label" align="center">
					<xsl:call-template name="Translate">
						<xsl:with-param name="labelToTranslate" select="'mwst'"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				 <td class="label">
					<xsl:call-template name="Translate">
						<xsl:with-param name="labelToTranslate" select="'mwst_wert'"/>
					</xsl:call-template>
				</td>
				<td align="right">
					<xsl:value-of select="$VATValue"/>
				</td>
				<td align="right" bgcolor="#C0C0C0">
					<xsl:text></xsl:text>
				</td>
				<td align="right" bgcolor="#C0C0C0">
					<xsl:text></xsl:text>
				</td>
			</tr>
			<tr>
				<td class="label">
					<xsl:call-template name="Translate">
						<xsl:with-param name="labelToTranslate" select="'abgaben'"/>
					</xsl:call-template>
				</td>
				<td align="right">
					<xsl:value-of select="$duties"/>
				</td>
				<td align="right" bgcolor="#C0C0C0">
					<xsl:text></xsl:text>
				</td>
				<td align="right" bgcolor="#C0C0C0">
					<xsl:text></xsl:text>
				</td>
			</tr>
			<tr>
				<td class="label">
					<xsl:call-template name="Translate">
						<xsl:with-param name="labelToTranslate" select="'bemessungsgrundlage'"/>
					</xsl:call-template>
				</td>
				<td align="right">
					<b><xsl:value-of select="$basisForAssessment"/></b>
				</td>
				<td align="right">
					<b>
						<xsl:value-of select="$rate"/>
					</b>
				</td>				
				<xsl:choose>
					<xsl:when test="$boolen_amountNotCharged">
						<td align="right" style="padding-top:0px !important;">
							<b>
								<xsl:value-of select="$amount"/>
							</b>
							<xsl:text> </xsl:text>
							<span class="label">
								<sup>a)</sup>
							</span>
						</td>
					</xsl:when>
					<xsl:otherwise>			
						<td align="right">
							<b>
								<xsl:value-of select="$amount"/>
							</b>
						</td>			
					</xsl:otherwise>	
				</xsl:choose>
			</tr>
			<xsl:if test="$boolen_amountNotCharged">
				<tr>
					<td colspan="4" align="right" style="border: none !important; padding-right:0px;">
						<span class="label" style="line-height:150%; margin-right:0px;">
							<sup>a)</sup>
							<xsl:text> </xsl:text>
							<xsl:call-template name="Translate">
								<xsl:with-param name="labelToTranslate" select="'betrag_wird_nicht_erhoben'"/>
							</xsl:call-template>
						</span>
						<br/>	
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- tabelle detail Zoll-Berechnung -->
	<xsl:template name="valuationDetailsTaxationDecisionCustomsDuties">
		<xsl:variable name="totalAmount" select="receipt:valuationDetails/receipt:dutyAndAdditionalTaxes/receipt:totalAmount"/>
		<xsl:variable name="amountNotCharged" select="receipt:valuationDetails/receipt:dutyAndAdditionalTaxes/receipt:amountNotCharged"/>
		<xsl:variable name="boolen_amountNotCharged" select="$amountNotCharged and $amountNotCharged=1"/>
		<td colspan="3">
			<table width="100%" border="0" class="content withBorder" cellpading="0" cellspacing="0">
				<tr>
	                <td class="label" align="center">
	                    <xsl:call-template name="Translate">
	                        <xsl:with-param name="labelToTranslate" select="'einnahmenart'"/>
	                    </xsl:call-template>
	                </td>
	                 <td class="label" align="center">
	                    <xsl:call-template name="Translate">
	                        <xsl:with-param name="labelToTranslate" select="'bemessungsgrundlage_zoll'"/>
	                    </xsl:call-template>
	                </td>
	                 <td class="label" align="center">
	                    <xsl:call-template name="Translate">
	                        <xsl:with-param name="labelToTranslate" select="'volumenprozent'"/>
	                    </xsl:call-template>
	                </td>
					 <td class="label" align="center">
	                    <xsl:call-template name="Translate">
	                        <xsl:with-param name="labelToTranslate" select="'ansatz'"/>
	                    </xsl:call-template>
	                </td>
					 <td class="label" align="center" width="100px">
	                    <xsl:call-template name="Translate">
	                        <xsl:with-param name="labelToTranslate" select="'betrag'"/>
	                    </xsl:call-template>
	                </td>
				</tr>

				<xsl:for-each select="receipt:valuationDetails/receipt:dutyAndAdditionalTaxes/receipt:detail">
					<xsl:variable name="type" select="receipt:type"/>
					<xsl:variable name="basisForAssessment" select="receipt:basisForAssessment"/>
					<xsl:variable name="rate" select="receipt:rate"/>
					<xsl:variable name="alcoholLevel" select="receipt:alcoholLevel"/>
					<xsl:variable name="amount" select="receipt:amount"/>
					<tr>
						<!-- Einnahmeart -->
		                <td align="left">
							<xsl:call-template name="getFeesOrAdditionalTaxes">
								<xsl:with-param name="value" select="$type"/>
							</xsl:call-template>
		                </td>
						<!-- optional -->
		                <td align="center">
		                    <xsl:value-of select="$basisForAssessment"/>
							<xsl:if test = "string-length($basisForAssessment) = 0">
								<xsl:text>-</xsl:text>
							</xsl:if>
		                </td>
						<!-- optional -->
		                <td align="right">
		                    <xsl:value-of select="$alcoholLevel"/>
		                </td>
						<!-- optional -->
		                <td align="right">
		                    <xsl:value-of select="$rate"/>
							<xsl:if test = "string-length($rate) = 0">
								<xsl:text>-</xsl:text>
							</xsl:if>
		                </td>
						<!-- optional -->
						<td align="right">
		                    <xsl:value-of select="$amount"/>
		                </td>
					</tr>
				</xsl:for-each>
				<tr>
	                <td colspan="4" style="border-bottom: none !important; border-left: none !important;"></td>
					<xsl:choose>
						<xsl:when test="$boolen_amountNotCharged">
							<td align="right" style="padding-top:0px !important;">
								<b>
									<xsl:value-of select="$totalAmount"/>
								</b>
								<xsl:text> </xsl:text>
								<span class="label">
									<sup>a)</sup>
								</span>
							</td>
						</xsl:when>
						<xsl:otherwise>			
							<td align="right">
								<b>
									<xsl:value-of select="$totalAmount"/>
								</b>
							</td>			
						</xsl:otherwise>	
					</xsl:choose>
				</tr>
				<xsl:if test="$boolen_amountNotCharged">
					<tr>
						<td colspan="5" align="right" style="border: none !important; padding-right:0px;">
							<span class="label" style="line-height:150%; margin-right:0px;">
								<sup>a)</sup>
								<xsl:text> </xsl:text>
								<xsl:call-template name="Translate">
									<xsl:with-param name="labelToTranslate" select="'betrag_wird_nicht_erhoben'"/>
								</xsl:call-template>
							</span>
							<br/>	
						</td>
					</tr>
				</xsl:if>
			</table>
		</td>
	</xsl:template>

	<!-- generiert den Dokumenttitel -->
    <xsl:template name="getDocumentTitle">
		<xsl:variable name="documentTitle" select="receipt:documentInformation/receipt:documentTitle"/>
		<xsl:value-of select="$documentTitle"/>
	</xsl:template>	
	
	<!-- falls confirmation==1, * -->
    <xsl:template name="checkConfirmation">
		<xsl:param name="value" select="/.."/>
		<xsl:if test="$value and string-length($value)>0 and $value=1">
			<xsl:text>*</xsl:text>
		</xsl:if>
	</xsl:template>	
	
	<!-- gibt bei leerstring etwas zurueck -->
    <xsl:template name="valueOfWithEmpty">
		<xsl:param name="value" select="/.."/>
		<xsl:choose>
			<xsl:when test="$value and string-length($value)>0">
				<xsl:value-of select="$value"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>---</xsl:text>
			</xsl:otherwise>	
		</xsl:choose>
	</xsl:template>	
			
	<!-- liest aus den edecDomains xml -->
    <xsl:template name="getDomainText">
		<xsl:param name="domainName" select="/.."/>
		<xsl:param name="value" select="/.."/>
		<xsl:variable name="domainText">
			<xsl:for-each select="$edecDomainsData/domain[@name=concat($domainName, '')]/entry[@value=normalize-space($value)]">
				<xsl:sort select="@validTo" order="descending" />
				<xsl:if test="position() = 1">
					<xsl:choose>
						<xsl:when test="$documentLanguageUpperCase = 'IT'">
							<xsl:value-of select="@meaningIt"/>
						</xsl:when>
						<xsl:when test="$documentLanguageUpperCase = 'FR'">
							<xsl:value-of select="@meaningFr"/>
						</xsl:when>
						<xsl:when test="$documentLanguageUpperCase = 'DE'">
							<xsl:value-of select="@meaningDe"/>
						</xsl:when>
					</xsl:choose>	
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$domainText and string-length($domainText)>0">
				<xsl:value-of select="$domainText"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat('[??? ',$value,' | ',$domainName,' ???]')"/>
			</xsl:otherwise>	
		</xsl:choose>
    </xsl:template>
	
	<!-- liest aus den edecTariffMasterDataSchema xml -->
    <xsl:template name="getFeesOrAdditionalTaxes">
		<xsl:param name="value" select="/.."/>
		<xsl:variable name="tariffText">
			<xsl:for-each select="$edecTariffMasterDataSchemaData/additionalTaxes/type[@value=normalize-space($value)] | $edecTariffMasterDataSchemaData/fees/type[@value=normalize-space($value)]">
				<xsl:if test="position() = 1">
					<xsl:choose>
						<xsl:when test="$documentLanguageUpperCase = 'IT'">
							<xsl:value-of select="@meaningIt"/>
						</xsl:when>
						<xsl:when test="$documentLanguageUpperCase = 'FR'">
							<xsl:value-of select="@meaningFr"/>
						</xsl:when>
						<xsl:when test="$documentLanguageUpperCase = 'DE'">
							<xsl:value-of select="@meaningDe"/>
						</xsl:when>
					</xsl:choose>	
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$tariffText and string-length($tariffText)>0">
				<xsl:value-of select="$tariffText"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>	
		</xsl:choose>
    </xsl:template>	
	
	<!-- Translations DE, FR, IT -->
    <xsl:template name="Translate">
		<xsl:param name="labelToTranslate" select="/.."/>
		<xsl:variable name="labelText">
			<xsl:choose>
				<xsl:when test="$documentLanguageUpperCase = 'IT'">
					<xsl:value-of select="$languagePropertiesData/entry[@key=normalize-space($labelToTranslate)]/@textIt"/>
				</xsl:when>
				<xsl:when test="$documentLanguageUpperCase = 'FR'">
					<xsl:value-of select="$languagePropertiesData/entry[@key=normalize-space($labelToTranslate)]/@textFr"/>
				</xsl:when>
				<xsl:when test="$documentLanguageUpperCase = 'DE'">
					<xsl:value-of select="$languagePropertiesData/entry[@key=normalize-space($labelToTranslate)]/@textDe"/>
				</xsl:when>
			</xsl:choose>	
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$labelText and string-length($labelText)>0">
				<xsl:value-of select="$labelText"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat('[??? ',$labelToTranslate,' ???]')"/>
			</xsl:otherwise>	
		</xsl:choose>
    </xsl:template>
	
	<!-- language properties -->
	<xsl:variable name="languageProperties">
		<entry key="betrag_wird_nicht_erhoben" textDe="Betrag wird nicht erhoben" textFr="Le montant n'est pas perçu." textIt="L'importo non sarà riscosso."/>
		<entry key="bewilligungen" textDe="Bewilligungen (Art, Stelle, Nummer, Datum, zusätzliche Angaben):" textFr="Permis (genre, office, numéro, date, données supplémentaires):" textIt="Permesso (genere, ufficio, numero, data, indicazioni supplementari):"/>
		<entry key="transport" textDe="Transport (Verkehrszweig, Typ, Land, Kennzeichen):" textFr="Transport (Mode, type, pays, immatriculation):" textIt="Trasporto (Modo, tipo, nazionalità, targa):"/>
		<entry key="ref_nr" textDe="Ref-Nr.:" textFr="Réf. No.:" textIt="Rif. N.:"/>
		<entry key="verkehrsrichtung" textDe="Verkehrsrichtung:" textFr="Direction du trafic:" textIt="Direzione del traffico:"/>
		<entry key="veredelungstyp" textDe="Veredelungstyp:" textFr="Type de perfectionnement:" textIt="Tipo di perfezionamento:"/>
		<entry key="abrechnung" textDe="Abrechnung:" textFr="Décompte:" textIt="Conteggio:"/>
		<entry key="abgaben" textDe="Abgaben gemäss separater Veranlagungsverfügung Zoll:" textFr="Redevances selon décision de taxation douane séparée:" textIt="Dati secondo la decisione d'imposizione dazio separata:"/>
		<entry key="bemessungsgrundlage" textDe="Bemessungsgrundlage MWST:" textFr="Base de calcul TVA" textIt="Base di calcolo per l'IVA"/>
		<entry key="einnahmenart" textDe="Einnahmenart:" textFr="Genre de perception" textIt="Genere di introiti:"/>
		<entry key="referenz_zoll" textDe="Referenz Zoll:" textFr="Référence douane:" textIt="Riferimento dogana:"/>
		<entry key="referenz_kunde" textDe="Referenz Kunde:" textFr="Référence client:" textIt="Riferimento cliente:"/>
		<entry key="anm_nr" textDe="Anmeld. Nr:" textFr="No de déclaration:" textIt="N. della dichiarazione:"/>
		<entry key="import" textDe="Import" textFr="Import" textIt="Importazione"/>
		<entry key="export" textDe="Export" textFr="Export" textIt="Esportazione"/>
		<entry key="bewilligungsdetail_SchluesselWert" textDe="Bewilligungsdetail (Schlüssel, Wert):" textFr="Détail du permis (Clé, Valeur):" textIt="Dettaglio del permesso (Chiave, Valore):"/>
		<entry key="vorpapiere" textDe="Vorpapiere (Art, Nummer, zusätzliche Angaben):" textFr="Documents précédents (Genre, Numéro, données supplémentaires):" textIt="Documenti precedenti (genere, numero, dati supplementari):"/>
		<entry key="handelswaren" textDe="Handelswaren" textFr="Marchandise commerciale" textIt="Merci commerciali"/>
		<entry key="ursprungsland" textDe="Ursprungsland:" textFr="Pays d'origine:" textIt="Paese d'origine:"/>
		<entry key="bewilligungspflichtcode" textDe="Bewilligungspflichtcode:" textFr="Code d'assujettissement au permis:" textIt="Codice assoggettamento permesso:"/>
		<entry key="nze_pflichtcode" textDe="NZE-Pflichtcode:" textFr="Code d'assujettissement ALAD:" textIt="Codice assoggettamento leggi accessorie:"/>
		<entry key="lagercode" textDe="Lagercode:" textFr="Code d'entreposage:" textIt="Codice deposito:"/>
		<entry key="zusatzinformationen" textDe="Zusatzinformationen:" textFr="Informations complémentaires:" textIt="Informazioni supplementari:"/>
		<entry key="zugangscode" textDe="Zugangscode:" textFr="Code d'accès:" textIt="Codice d'accesso:"/>
		<entry key="zollanmeldungsnummer" textDe="Zollanmeldungsnummer:" textFr="Numéro de déclaration en douane:" textIt="Numero della dichiarazione doganale:"/>
		<entry key="unterlagen" textDe="Unterlagen (Art, Nummer, Datum, zusätzliche Angaben):" textFr="Documents (genre, numéro, date, données supplémentaires):" textIt="Documenti (genere, numero, data, indicazioni supplementari):"/>
		<entry key="packstuecke" textDe="Packstücke (Art, Anzahl, Nummer):" textFr="Colis (genre, nombre, numéro):" textIt="Colli (genere, quantità, marche):"/>
		<entry key="vocmenge" textDe="VOC Menge:" textFr="Quantité COV:" textIt="Quantità COV:"/>
		<entry key="besondere_vermerke" textDe="Besondere Vermerke:" textFr="Mentions spéciales:" textIt="Menzioni speciali:"/>
		<entry key="eigenmasse" textDe="Eigenmasse:" textFr="Masse effective:" textIt="Massa netta:"/>
		<entry key="rohmasse" textDe="Rohmasse:" textFr="Masse brute:" textIt="Massa lorda:"/>
		<entry key="statwert" textDe="Stat. Wert:" textFr="Valeur stat.:" textIt="Valore statistico:"/>
		<entry key="rueckerstattungstyp" textDe="Rückerstattungstyp:" textFr="Genre de remboursement:" textIt="Tipo di restituzione:"/>
		<entry key="veranlagungstyp" textDe="Veranlagungstyp:" textFr="Genre de taxation:" textIt="Tipo d'imposizione:"/>
		<entry key="besondere_vermerke" textDe="Besondere Vermerke:" textFr="Mentions spéciales" textIt="Menzioni speciali:"/>
		<entry key="container" textDe="Container:" textFr="Conteneur:" textIt="Container:"/>
		<entry key="mwst_nr" textDe="MWST-Nr:" textFr="No TVA:" textIt="N. IVA.:"/>
		<entry key="rechnungswaehrung" textDe="Rechnungswährung:" textFr="monnaie de facturation:" textIt="moneta di fatturazione:"/>
		<entry key="incoterms" textDe="Incoterms:" textFr="Incoterms:" textIt="Incoterms:"/>
		<entry key="vatsuffix" textDe="MWST" textFr="TVA" textIt="IVA"/>
		<entry key="positionen" textDe="Positionen:" textFr="Positions:" textIt="Posizioni:"/>
		<entry key="transporteur" textDe="Transporteur:" textFr="Transporteur:" textIt="Trasportatore:"/>
		<entry key="spediteur" textDe="Spediteur:" textFr="Transitaire:" textIt="Spedizioniere:"/>
		<entry key="empfaenger" textDe="Empfänger:" textFr="Destinataire:" textIt="Destinatario:"/>
		<entry key="tin_nr" textDe="Sped-Nr./TIN/UID:" textFr="No de transitaire/TIN/IDE:" textIt="N. dello spedizioniere/TIN/IDI:"/>
		<entry key="versender" textDe="Versender:" textFr="Expéditeur:" textIt="Speditore:"/>
		<entry key="eidgenoessische_zollverwaltung_ezv" textDe="Eidgenössische Zollverwaltung EZV" textFr="Administration fédérale des douanes AFD" textIt="Amministrazione federale delle dogane AFD"/>
		<entry key="eidgenoessisches_finanzdepartement_efd" textDe="Eidgenössisches Finanzdepartement EFD" textFr="Département fédéral des finances DFF" textIt="Dipartimento federale delle finanze DFF"/>
		<entry key="ausstellungsdatum" textDe="Ausstellungsdatum:" textFr="Date d'établissement:" textIt="Data allestimento:"/>
		<entry key="annahmedatum" textDe="Annahmedatum:" textFr="Date d'acceptation:" textIt="Data accettazione:"/>
		<entry key="annullation" textDe="Annullation" textFr="Annulation" textIt="Annullamento"/>
		<entry key="verfahren" textDe="Verfahren:" textFr="Procédure:" textIt="Procedura"/>
		<entry key="importeur" textDe="Importeur:" textFr="Importateur:" textIt="Importatore"/>
		<entry key="bestimmungsland" textDe="Bestimmungsland:" textFr="Pays de destination:" textIt="Paese di destinazione:"/>
		<entry key="erzeugungsland" textDe="Versendungsland:" textFr="Pays de production:" textIt="Paese di produzione:"/>
		<entry key="reason" textDe="Grund provisorisch:" textFr="Motif provisoire:" textIt="Motivo per lo sdoganamento provvisorio:"/>
		<entry key="bordereauNumber" textDe="Bordereaunummer:" textFr="Numéro du bordereau:" textIt="N. della distinta"/>
		<entry key="konto_mwst" textDe="Konto MWST:" textFr="Compte TVA:" textIt="Conto IVA:"/>
		<entry key="konto_zoll" textDe="Konto Zoll:" textFr="Compte douane:" textIt="Conto doganale:"/>
		<entry key="mwst" textDe="MWST [CHF]" textFr="TVA [CHF]" textIt="IVA [CHF]"/>
		<entry key="bemessungsgrundlage_zoll" textDe="Bemessungsgrundlage:" textFr="Base de calcul:" textIt="Base di calcolo:"/>
		<entry key="ansatz_prozent" textDe="Ansatz [%]" textFr="Taux [%]" textIt="Aliquota [%]"/>
		<entry key="betrag" textDe="Betrag [CHF]" textFr="Montant [CHF]" textIt="Importo [CHF]"/>
		<entry key="mwst_wert" textDe="MWST Wert:" textFr="Valeur TVA:" textIt="Valore IVA:"/>
		<entry key="ansatz" textDe="Ansatz [CHF]" textFr="Taux [CHF]" textIt="Aliquota [CHF]"/>
		<entry key="volumenprozent" textDe="Vol-%" textFr="% vol" textIt="Vol-%"/>
		<entry key="gesamtbetrag_ohne" textDe="Gesamtbetrag:" textFr="Montant total:" textIt="Importo totale:"/>
		<entry key="nettogewicht" textDe="Nettogewicht:" textFr="Poids net:" textIt="Peso netto"/>
		<entry key="sachbearbeiter" textDe="SachbearbeiterIn:" textFr="Contact:" textIt="Affare trattato da:"/>
		<entry key="berichtigungsgrund" textDe="Berichtigungsgrund:" textFr="Motif de la rectification:" textIt="Motivo della rettifica:"/>
		<entry key="kunde" textDe="Kunde:" textFr="Client:" textIt="Cliente:"/>
		<entry key="einnahmeart" textDe="Einnahmeart" textFr="Genre de perception" textIt="Genere di introiti"/>
		<entry key="nettorueckverguetung" textDe="Nettorückerstattung" textFr="Remboursement net" textIt="Restituzione netta"/>
		<entry key="gesamtbetrag_mwst" textDe="Gesamtbetrag MWST [CHF]:" textFr="Montant total TVA [CHF]:" textIt="Importo totale IVA [CHF]:"/>
		<entry key="praeferenz" textDe="Präferenz" textFr="Préférence" textIt="Preferenza"/>
		<entry key="zusatzmenge" textDe="Zusatzmenge:" textFr="Quantité suppl.:" textIt="Quantità suppl.:"/>
		<entry key="zugelassenerEmpfaenger" textDe="Zugelassener Empfänger:" textFr="Destinataire agréé:" textIt="Destinatario autorizzato:"/>
		<entry key="ausbesserung" textDe="Ausbesserung" textFr="Réparation" textIt="Riparazione"/>
		<entry key="ausbesserungszweck" textDe="Art der Veredelung/Ausbesserung:" textFr="Genre de perfectionnement / réparation:" textIt="Tipo di perfezionamento/riparazione:"/>
	</xsl:variable> 
	
	<!-- daten von edecTariffMasterDataSchema_v_1_0.xml, nur die "type"'s von "additionalTaxes" und "fees" ohne deren "key"-Elementen -->
	<xsl:variable name="edecTariffMasterDataSchema">
		<additionalTaxes>
			<type value="280" meaningDe="Monopolgebühren" meaningFr="Droits de monopole" meaningIt="Tasse di monopolio" meaningEn="Monopoly duties" />
			<type value="290" meaningDe="Grenztierärztliche Untersuchung / Untersuchungsgebühr" meaningFr="Visite vétérinaire de frontière / taxe de visite" meaningIt="Visita veterinaria di confine / tassa di visita" meaningEn="Border veterinary inspection / inspection fee" />
			<type value="292" meaningDe="CITES Fauna-Gebühr (Artenschutz-Kontrolle)" meaningFr="Emoluments CITES Fauna (contrôle de la conservation des espèces)" meaningIt="Tassa CITES Fauna (controllo sulla conservazione delle specie)" meaningEn="CITES Fauna fee (verification of the conservation of species)" />
			<type value="450" meaningDe="Tabaksteuer" meaningFr="Impôt sur le tabac" meaningIt="Imposta sul tabacco" meaningEn="Tobacco tax" />
			<type value="460" meaningDe="Banderolensteuer" meaningFr="Impôt sur les banderoles" meaningIt="Imposta sulle fascette" meaningEn="Tax on banderoles" />
			<type value="465" meaningDe="SOTA-Gebühren" meaningFr="Redevances SOTA" meaningIt="Tasse SOTA" meaningEn="SOTA fees" />
			<type value="470" meaningDe="Tabakpräventionsfonds" meaningFr="Fonds de prévention du tabagisme" meaningIt="Fondo per la prevenzione del tabagismo" meaningEn="Tobacco prevention fund" />
			<type value="480" meaningDe="Biersteuer" meaningFr="Impôt sur la bière" meaningIt="Imposta sulla birra" meaningEn="Beer tax" />
			<type value="600" meaningDe="Mineralölsteuer auf Treibstoff Benzin" meaningFr="Impôts sur les huiles minérales grevant le carburant essence" meaningIt="Imposta sugli oli minerali gravante la benzina" meaningEn="Mineral oil tax on petroleum spirit used as power fuel" />
			<type value="601" meaningDe="Mineralölsteuer auf Treibstoff Diesel" meaningFr="Impôt sur les huiles minérales grevant le carburant Diesel" meaningIt="Imposta sugli oli minerali gravante il diesel" meaningEn="Mineral oil tax on diesel oil used as power fuel" />
			<type value="602" meaningDe="Mineralölsteuer auf Treibstoff Petrol" meaningFr="Impôt sur les huiles minérales grevant le carburant petrole" meaningIt="Imposta sugli oli minerali gravante il petrolio" meaningEn="Mineral oil tax on petroleum oil used as power fuel" />
			<type value="603" meaningDe="Mineralölsteuer auf anderen Treibstoffen" meaningFr="Impôt sur les huiles minérales grevant les autres carburants" meaningIt="Imposta sugli oli minerali gravante altri carburanti" meaningEn="Mineral oil tax on other power fuels" />
			<type value="605" meaningDe="Mineralölsteuer auf Treibstoff Flugbenzin" meaningFr="Impôts sur les huiles minérales grevant le carburant essence pour avions" meaningIt="Imposta sugli oli minerali gravante la benzina per aeromobili" meaningEn="Mineral oil tax on petroleum spirit used as power aviation fuel" />
			<type value="606" meaningDe="Mineralölsteuer auf Treibstoff Flugpetrol" meaningFr="Impôt sur les huiles minérales grevant le carburant petrole pour avions" meaningIt="Imposta sugli oli minerali gravante il petrolio per aeromobili" meaningEn="Mineral oil tax on petroleum oil used as power aviation fuel" />
			<type value="620" meaningDe="Mineralölsteuerzuschlag auf Treibstoff Benzin" meaningFr="Surtaxe sur les huiles minérales grevant le carburant essence" meaningIt="Supplemento d'imposta sugli oli minerali gravante la benzina" meaningEn="Mineral oil surtax on petroleum spirit used as power fuel" />
			<type value="621" meaningDe="Mineralölsteuerzuschlag auf Treibstoff Diesel" meaningFr="Surtaxe sur les huiles minérales grevant le carburant Diesel" meaningIt="Supplemento d'imposta sugli oli minerali gravante il diesel" meaningEn="Mineral oil surtax on diesel oil used as power fuel" />
			<type value="622" meaningDe="Mineralölsteuerzuschlag auf Treibstoff Petrol" meaningFr="Surtaxe sur les huiles minérales grevant le carburant pétrole" meaningIt="Supplemento d'imposta sugli oli minerali gravante il petrolio" meaningEn="Mineral oil surtax on petroleum oil used as power fuel" />
			<type value="623" meaningDe="Mineralölsteuerzuschlag auf anderen Treibstoffen" meaningFr="Surtaxe sur les huiles minérales grevant les autres carburants" meaningIt="Supplemento d'imposta sugli oli minerali gravante altri carburanti" meaningEn="Mineral oil surtax on other power fuels" />
			<type value="625" meaningDe="Mineralölsteuerzuschlag auf Treibstoff Flugbenzin" meaningFr="Surtaxe sur les huiles minérales grevant le carburant essence pour avions" meaningIt="Supplemento d'imposta sugli oli minerali gravante la benzina per aeromobili" meaningEn="Mineral oil surtax on petroleum spirit used as power aviation fuel" />
			<type value="626" meaningDe="Mineralölsteuerzuschlag auf Treibstoff Flugpetrol" meaningFr="Surtaxe sur les huiles minérales grevant le carburant pétrole pour avions" meaningIt="Supplemento d'imposta sugli oli minerali gravante il petrolio per aeromobili" meaningEn="Mineral oil surtax on petroleum oil used as power aviation fuel" />
			<type value="640" meaningDe="Mineralölsteuer auf Brennstoffen und anderen Mineralölprodukten" meaningFr="Impôt sur les huiles minérales grevant les combustibles et autres produits à base d'huiles minérales" meaningIt="Imposta sugli oli minerali gravante i combustibili e altri prodotti a base di oli minerali" meaningEn="Mineral oil tax on heating fuels and other mineral oil products" />
			<type value="660" meaningDe="Automobilsteuer" meaningFr="Impôt sur les automobiles" meaningIt="Imposta sugli autoveicoli" meaningEn="Motor vehicle tax" />
			<type value="700" meaningDe="Lenkungsabgabe auf flüchtigen organischen Verbindungen (VOC)" meaningFr="Taxe d'incitation sur les composés organiques volatils (COV)" meaningIt="Tassa d'incentivazione sui composti organici volatili (COV)" meaningEn="Incentive tax on volatile organic compounds" />
			<type value="740" meaningDe="CO2-Abgabe auf Heizöl" meaningFr="Taxe sur le CO2 sur l'huile de chauffage" meaningIt="Tassa sul CO2 sull'olio da riscaldamento" meaningEn="CO2 tax on heating oil" />
			<type value="741" meaningDe="CO2-Abgabe auf Erdgas" meaningFr="Taxe sur le CO2 sur le gaz naturel" meaningIt="Tassa sul CO2 sul gas naturale" meaningEn="CO2 tax on natural gas" />
			<type value="742" meaningDe="CO2-Abgabe auf anderen Mineralölen" meaningFr="Taxe sur le CO2 sur les autres huiles minérales" meaningIt="Tassa sul CO2 su altri oli minerali" meaningEn="CO2 tax on other mineral oils" />
			<type value="743" meaningDe="CO2-Abgabe auf Kohle/Petrolkoks" meaningFr="Taxe sur le CO2 sur le charbon/coke de pétrole" meaningIt="Tassa sul CO2 sul carbone/coke di petrolio" meaningEn="CO2 tax on coal/petroleum coke" />
			<type value="792" meaningDe="CITES Flora-Gebühr (Artenschutz-Kontrolle)" meaningFr="Emoluments CITES Flora (contrôle de la conservation des espèces)" meaningIt="Tassa CITES Flora (controllo sulla conservazione delle specie)" meaningEn="CITES Flora fee (verification of the conservation of species)" />
			<type value="970" meaningDe="Vorgezogene Entsorgungsgebühr für Getränkeverpackungen aus Glas" meaningFr="Taxe d'élimination anticipée sur les bouteilles en verre pour boissons" meaningIt="Tassa di smaltimento anticipata sugli imballaggi per bevande in vetro" meaningEn="Prepaid Disposal fee for glass beverage Containers" />
		</additionalTaxes>
		<fees>
			<type value="110" meaningDe="Zollabgaben" meaningFr="Droits de douane" meaningIt="Tribute doganali" />												
			<type value="150" meaningDe="Andere Gebühren" meaningFr="Autres taxes" meaningIt="Altre tasse" meaningEn="Other taxes" />												
			<type value="151" meaningDe="Edelmetallkontrollgebühren" meaningFr="Taxes du contrôle des métaux précieux" meaningIt="Tasse per il controllo dei metalli preziosi" meaningEn="Precious metals control fee" />												
			<type value="170" meaningDe="Erlös aus Verkäufen" meaningFr="Produit des ventes" meaningIt="Ricavo delle vendite" meaningEn="Sales income" />												
			<type value="180" meaningDe="Kostenrückerstattungen" meaningFr="Remboursement des frais" meaningIt="Rifusioni delle spese" meaningEn="Cost refund" />												
			<type value="200" meaningDe="31.34 Zollbussen" meaningFr="31.34 Amendes de douane" meaningIt="31.34 Multe doganali" meaningEn="31.34 Customs fines" />												
			<type value="201" meaningDe="31.34 Mehrwertsteuerbussen" meaningFr="31.34 Amendes de TVA" meaningIt="31.34 Multe concernenti l'IVA" meaningEn="31.34 Value added tax fines" />												
			<type value="205" meaningDe="31.35 Alkoholbussen" meaningFr="31.35 Amendes d'alcool" meaningIt="31.35 Multe concernenti l'alcole" meaningEn="31.35 Alcohol fines" />												
			<type value="210" meaningDe="31.36 Ordnungsbussen" meaningFr="31.36 Amendes d'ordre" meaningIt="31.36 Multe disciplinari" meaningEn="31.36 Disciplinary fines" />												
			<type value="215" meaningDe="31.37 SVA-Bussen" meaningFr="31.37 Amendes RPL" meaningIt="31.37 Multe TTP" meaningEn="31.37 Heavy vehicle fee fines" />												
			<type value="220" meaningDe="31.38 Vignetten-Bussen" meaningFr="31.38 Amendes vignettes" meaningIt="31.38 Multe concernenti i contrassegni" meaningEn="31.38 Vignette fines" />												
			<type value="250" meaningDe="Mieten" meaningFr="Locations" meaningIt="Affitti" meaningEn="Rents" />												
			<type value="260" meaningDe="Zinsen" meaningFr="Intérêts" meaningIt="Interessi" meaningEn="Interests" />												
			<type value="270" meaningDe="Sonstige Einnahmen" meaningFr="Autres recettes" meaningIt="Altri introiti" meaningEn="Other revenues" />												
			<type value="291" meaningDe="Kanzleigebühren Grenztierarzt" meaningFr="Emoluments de chancellerie pour le vétérinaire de frontière" meaningIt="Tasse di cancelleria per il veterinario di confine" meaningEn="Registry charges for the border veterinary officer" />												
			<type value="300" meaningDe="Ausnahmebewilligungsgebühren" meaningFr="Taxes d'autorisations exceptionnelles" meaningIt="Tasse per autorizzazioni straordinarie" meaningEn="Taxes for exceptional authorizations" />												
			<type value="305" meaningDe="Leistungsabhängige Schwerverkehrsabgabe" meaningFr="Redevance sur le trafic des poids lourds liée aux prestations" meaningIt="Tassa sul traffico pesante commisurata alle prestazioni" meaningEn="Distance-related heavy vehicle fee" />												
			<type value="306" meaningDe="Pauschale Schwerverkehrsabgabe" meaningFr="Redevance forfaitaire sur le trafic des poids lourds" meaningIt="Tassa forfetaria sul traffico pesante" meaningEn="Flat rate heavy vehicle fee" />												
			<type value="315" meaningDe="Nationalstrassenabgabe (Autobahnvignette)" meaningFr="Vignettes autoroutières" meaningIt="Tassa per l'utilizzazione delle strade nazionali (contrassegno autostradale)" meaningEn="Highway vignette" />												
			<type value="330" meaningDe="Grenzversicherungen" meaningFr="Assurance frontière" meaningIt="Assicurazioni di confine" meaningEn="Border insurance" />												
			<type value="400" meaningDe="Kassenüberschüsse" meaningFr="Excédents de caisse" meaningIt="Eccedenze di cassa" meaningEn="Cash surplus" />												
			<type value="405" meaningDe="Gefundenes Geld" meaningFr="Argent trouvé" meaningIt="Denaro trovato" meaningEn="Found money" />												
			<type value="410" meaningDe="Inventarerlös" meaningFr="Produit d'inventaire" meaningIt="Ricavo dell'inventario" meaningEn="Inventory income" />												
			<type value="415" meaningDe="Disziplinarstrafen" meaningFr="Peines disciplinaires" meaningIt="Pene disciplinari" meaningEn="Disciplinary penalties" />												
			<type value="420" meaningDe="Anonyme Geldsendungen" meaningFr="Versements anonymes" meaningIt="Versamenti anonimi di denaro" meaningEn="Anonymous payments" />												
			<type value="425" meaningDe="nicht zustellbare Hinterlagen" meaningFr="Dépôts non attribuables" meaningIt="Depositi non attribuibili" meaningEn="Non-attributable deposits" />												
			<type value="430" meaningDe="Prov. Übersiedlungsgut" meaningFr="Prov. Effets de déménagement" meaningIt="Prov. Masserizie di immigranti" meaningEn="E" />												
			<type value="455" meaningDe="Tabakzölle" meaningFr="Droits sur le tabac" meaningIt="Dazi sul tabacco" meaningEn="Customs duties on tobacco" />												
			<type value="500" meaningDe="Barhinterlagen Eingang" meaningFr="Dépôts en espèces" meaningIt="Entrata di depositi in contanti" meaningEn="Cash deposits" />												
			<type value="670" meaningDe="Gebühren im Ultra-System" meaningFr="Taxes dans le système Ultra" meaningIt="Tasse nel sistema Ultra" meaningEn="Taxes in ULTRA system" />												
			<type value="791" meaningDe="Pflanzenschutzgebühr" meaningFr="taxe phytosanitaire" meaningIt="tassa fitosanitaria" meaningEn="plant health tax" />												
			<type value="950" meaningDe="Total Bussenverteiler der Kreisdirektionen" meaningFr="Total de répartition des amendes des Directions d'arrondiissement" meaningIt="Totale delle multe delle direzioni di circondario" meaningEn="Total of fines imposed by District Directorates of Customs" />												
			<type value="956" meaningDe="Tierseuchengesetz-Bussen" meaningFr="Amendes épizooties" meaningIt="Multa sulle epizoozie" meaningEn="E" />												
			<type value="958" meaningDe="Bussen CITES/TSchG" meaningFr="Amendes CITES/LPA" meaningIt="Multe CITES/LPAn" meaningEn="E" />												
			<type value="980" meaningDe="Rückerstattungsgebühr" meaningFr="Taxes pour remboursement" meaningIt="Tassa di rimborso" meaningEn="Refund fee" />												
			<type value="991" meaningDe="Barhinterlagen Abt." meaningFr="Dépôts en espèces subdivisions" meaningIt="Depositi in contanti div." meaningEn="Cash deposits subdivisions" />												
			<type value="992" meaningDe="Barhinterlagen Ausgang" meaningFr="Sortie dépôts en espèces" meaningIt="Uscita depositi in contanti" meaningEn="Outgoing cash deposits" />												
			<type value="994" meaningDe="Rückerstattungen" meaningFr="Remboursements" meaningIt="Rimborsi" meaningEn="Refunds" />												
			<type value="995" meaningDe="Zollbegünstigungskontrollgebühr" meaningFr="Allègement douanier, taxe de contrôle" meaningIt="Tassa di controllo sulle agevolazioni doganali" meaningEn="Customs relief control tax" />												
		</fees>
	</xsl:variable>
	
	<!-- daten von edecDomains_1_0.xml, ohne domain-name="errorDescription" -->
	<xsl:variable name="edecDomains"> 
		<domains version="00261" created="2014-10-16T02:32:39" xsi:schemaLocation="http://www.e-dec.ch/xml/schema/edecReceiptResponse/v3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="http://www.ezv.admin.ch/pdf_linker.php?doc=edecDomainSchema_v_1_0">
			<domain name="billingType">
			<entry value="1" meaningDe="Nichterhebungsverfahren" meaningFr="Système de la suspension" meaningIt="Procedura di non riscossione" meaningEn="en_Nichterhebungsverfahren" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Rückerstattungsverfahren" meaningFr="Procédure de remboursement" meaningIt="Procedura di restituzione" meaningEn="en_Rückerstattungsverfahren" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="borderZoneTraffic">
			<entry value="60" meaningDe="Forstwirtschaftlicher Grenzzonenverkehr mit Frankreich" meaningFr="Trafic frontière d&apos;exploitation forestière avec la France" meaningIt="Traffico forestale di confine con la Francia" meaningEn="Forstwirtschaftlicher Grenzzonenverkehr mit Frankreich" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="63" meaningDe="Übriger Grenzzonenverkehr " meaningFr="Autre trafic dans la zone frontière" meaningIt="Altro traffico nella zona di confine" meaningEn="Übriger Grenzzonenverkehr " validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="67" meaningDe="Produkte des Grenzweidegangs" meaningFr="Produits du pacage frontalier" meaningIt="Prodotti del passaggio transfrontaliero di animali per il pascolo" meaningEn="Produkte des Grenzweidegangs" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="68" meaningDe="Marktverkehr" meaningFr="Trafic de marché" meaningIt="Traffico di mercato" meaningEn="Marktverkehr" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="centralisedSelectionCategory">
			<entry value="1" meaningDe="Regel unveränderbar und aktiv" meaningFr="Regel unveränderbar und aktiv" meaningIt="Regel unveränderbar und aktiv" meaningEn="Regel unveränderbar und aktiv" validFrom="2012-09-06" validTo="2012-11-09" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Regel unveränderbar und aktiv" meaningFr="Règle non modifiable et active" meaningIt="La regola è attiva e non modificabile" meaningEn="Regel unveränderbar und aktiv" validFrom="2012-11-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Regel veränderbar und aktiv" meaningFr="Règle modifiable et active" meaningIt="La regola è attiva e modificabile" meaningEn="Regel veränderbar und aktiv" validFrom="2012-11-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Regel veränderbar und aktiv" meaningFr="Regel veränderbar und aktiv" meaningIt="Regel veränderbar und aktiv" meaningEn="Regel veränderbar und aktiv" validFrom="2012-09-06" validTo="2012-11-09" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Regel veränderbar und nicht aktiv" meaningFr="Règle modifiable et inactive" meaningIt="La regola è inattiva e modificabile" meaningEn="Regel veränderbar und nicht aktiv" validFrom="2012-11-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Regel veränderbar und nicht aktiv" meaningFr="Regel veränderbar und nicht aktiv" meaningIt="Regel veränderbar und nicht aktiv" meaningEn="Regel veränderbar und nicht aktiv" validFrom="2012-09-06" validTo="2012-11-09" validForImport="true" validForExport="true" />
			</domain>
			<domain name="centralisedSelectionSaveMode">
			<entry value="1" meaningDe="neue Regel der Zollstelle zuweisen" meaningFr="Attribuer une nouvelle règle au bureau de douane" meaningIt="Attribuire la nuova regola all&apos;ufficio doganale" meaningEn="neue Regel der Zollstelle zuweisen" validFrom="2012-11-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="neue Regel der Zollstelle zuweisen" meaningFr="neue Regel der Zollstelle zuweisen" meaningIt="neue Regel der Zollstelle zuweisen" meaningEn="neue Regel der Zollstelle zuweisen" validFrom="2012-09-06" validTo="2012-11-09" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Regel bei Zollstelle überschreiben" meaningFr="Ecraser la règle pour le bureau de douane" meaningIt="Sovrascrivere la regola nell&apos;ufficio doganale" meaningEn="Regel bei Zollstelle überschreiben" validFrom="2012-11-10" validTo="2013-03-14" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Regel bei Zollstelle überschreiben" meaningFr="Remplacer la règle du bureau de douane " meaningIt="Sovrascrivere la regola nell&apos;ufficio doganale" meaningEn="Regel bei Zollstelle überschreiben" validFrom="2013-03-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Regel bei Zollstelle überschreiben" meaningFr="Regel bei Zollstelle überschreiben" meaningIt="Regel bei Zollstelle überschreiben" meaningEn="Regel bei Zollstelle überschreiben" validFrom="2012-09-06" validTo="2012-11-09" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Regel bei Zollstelle löschen" meaningFr="Supprimer la règle pour le bureau de douane" meaningIt="Cancellare la regola nell&apos;ufficio doganale" meaningEn="Regel bei Zollstelle löschen" validFrom="2012-11-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Regel bei Zollstelle löschen" meaningFr="Regel bei Zollstelle löschen" meaningIt="Regel bei Zollstelle löschen" meaningEn="Regel bei Zollstelle löschen" validFrom="2012-09-06" validTo="2012-11-09" validForImport="true" validForExport="true" />
			</domain>
			<domain name="clearanceLocation">
			<entry value="1" meaningDe="Zollstelle" meaningFr="Bureau de douane" meaningIt="Ufficio doganale" meaningEn="en_Zollstelle" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Domizil" meaningFr="Domicile" meaningIt="Domicilio" meaningEn="en_Domizil" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="nachträgliche Erfassung ED" meaningFr="saisie du DU a posteriori" meaningIt="rilevamento del DU a posteriori" meaningEn="en_nachträgliche Erfassung ED" validFrom="2005-01-01" validTo="2008-12-31" validForImport="true" validForExport="false" />
			<entry value="3" meaningDe="Erfassung ab Einheitsdokument" meaningFr="saisie du document uniqe" meaningIt="rilevamento del documento unico" meaningEn="en_Erfassung ab Einheitsdokument" validFrom="2009-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="4" meaningDe="d&apos;office Veranlagung an Zollstelle" meaningFr="taxation d&apos;office au bureau de douane" meaningIt="imposizione d&apos;ufficio all&apos;ufficio di servizio" meaningEn="en_d&apos;office Veranlagung an Zollstelle" validFrom="2005-01-01" validTo="2008-12-31" validForImport="true" validForExport="false" />
			<entry value="4" meaningDe="Veranlagung von Amtes wegen" meaningFr="taxation d&apos;office" meaningIt="imposizione d&apos;ufficio" meaningEn="en_Veranlagung von Amtes wegen" validFrom="2009-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="5" meaningDe="e-dec web" meaningFr="e-dec web" meaningIt="e-dec web" meaningEn="e-dec web" validFrom="2011-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="commercialGood">
			<entry value="1" meaningDe="Handelsware" meaningFr="Marchandise commerciale" meaningIt="Merce commerciale" meaningEn="en_Handelsware" validFrom="1999-09-08" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Nichthandelsware" meaningFr="Marchandise non commerciale" meaningIt="Merce non commerciale" meaningEn="en_Nichthandelsware" validFrom="1999-09-08" validTo="2070-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="confirmationCode">
			<entry value="0" meaningDe="Richtigcode nicht gesetzt" meaningFr="Code de confirmation non activé" meaningIt="Codice conferma non attivato" meaningEn="en_Richtigcode nicht gesetzt" validFrom="1999-09-08" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Richtigcode gesetzt" meaningFr="Code de confirmation activé" meaningIt="Codice conferma attivato" meaningEn="en_Richtigcode gesetzt" validFrom="1999-09-08" validTo="2070-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="correctionCode">
			<entry value="0" meaningDe="Annullation" meaningFr="Annulation" meaningIt="Annullamento" meaningEn="en_Annullation" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Erstübermittlung" meaningFr="Première transmission" meaningIt="Prima trasmissione" meaningEn="en_Erstübermittlung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Berichtigung" meaningFr="Rectification" meaningIt="Rettifica" meaningEn="en_Berichtigung" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Berichtigung" meaningFr="Correction" meaningIt="Correzione" meaningEn="en_Korrektur" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="erneute Anforderung von Rückmeldung und PDF" meaningFr="Nouvelle demande de réponse et PDF" meaningIt="Nuovo sollecito della risposta e di invio del PDF" meaningEn="en_erneute Anforderung von Rückmeldung und PDF" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="correctionReason">
			<entry value="1" meaningDe="Antrag vor Aufnahme der Kontrolltätigkeit" meaningFr="Demande avant le début du contrôle" meaningIt="Domanda prima dell&apos;inizio del controllo" meaningEn="en_Antrag vor Aufnahme der Kontrolltätigkeit" validFrom="2004-01-01" validTo="2007-05-30" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Antrag vor Aufnahme der Kontrolltätigkeit" meaningFr="Demande avant le début du contrôle" meaningIt="Richiesta presentata prima dell&apos;inizio dell&apos;attività di controllo" meaningEn="en_Antrag vor Aufnahme der Kontrolltätigkeit" validFrom="2007-05-31" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Formelle Überprüfung" meaningFr="Contrôle formel" meaningIt="Controllo formale" meaningEn="en_Formelle Überprüfung" validFrom="2007-05-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Belegrevision" meaningFr="Révison des documents" meaningIt="Controllo formale dei documenti" meaningEn="en_Belegrevision" validFrom="2004-01-01" validTo="2007-05-25" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Materielle Kontrolle" meaningFr="Contrôle matériel" meaningIt="Visita (controllo materiale)" meaningEn="en_Materielle Kontrolle" validFrom="2004-01-01" validTo="2007-05-25" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Beschau" meaningFr="Vérification" meaningIt="Visita delle merci" meaningEn="en_Beschau" validFrom="2007-05-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Kontrolle von Transport- und Verpackungsmitteln" meaningFr="Contrôle du matériel d&apos;emballage et des accessoires de transports " meaningIt="Controllo del materiale d&apos;imballagio e degli e accessori di trasporto" meaningEn="eng_Kontrolle von Transport- und Verpackungsmitteln" validFrom="2008-06-03" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Kontrolle von Transport- und Verpackungsmitteln" meaningFr="Contrôle du matériel d&apos;emballage et des accessoires de transports " meaningIt="Controllo del materiale d&apos;imballagio e degli e accessori di trasporto" meaningEn="eng_Kontrolle von Transport- und Verpackungsmitteln" validFrom="2004-01-01" validTo="2007-05-25" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Kontrolle von Transport- und Verpackungsmitteln" meaningFr="Contrôle du matériel d&apos;emballage et des accessoires de transports " meaningIt="Controllo del materiale d&apos;imballagio e degli e accessori di trasporto" meaningEn="eng_Kontrolle von Transport- und Verpackungsmitteln" validFrom="2007-05-26" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Kontrolle von Transport- und Verpackungsmitteln" meaningFr="Contrôle du matériel d&apos;emballage et des accessoires de transports " meaningIt="Controllo del materiale d&apos;imballaggio e degli accessori di trasporto" meaningEn="eng_Kontrolle von Transport- und Verpackungsmitteln" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Antrag nach Abschluss der Kontrolltätigkeit" meaningFr="Demande après la fin du contrôle" meaningIt="Richiesta dopo la fine del controllo" meaningEn="en_Antrag nach Abschluss der Kontrolltätigkeit" validFrom="2004-01-01" validTo="2007-05-30" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Antrag nach Abschluss der Kontrolltätigkeit" meaningFr="Demande après la fin du contrôle" meaningIt="Richiesta presentata al termine dell&apos;attività di controllo" meaningEn="en_Antrag nach Abschluss der Kontrolltätigkeit" validFrom="2007-05-31" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="Nachträgliche Kontrolle" meaningFr="Contrôle a posteriori" meaningIt="Controllo a posteriori" meaningEn="en_Nachträgliche Kontrolle" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="Umwandlung provisorische in definitive Einfuhrzollanmeldung" meaningFr="Transformation d&apos;une déclaration d&apos;importation provisoire en déclaration d&apos;importation définitive" meaningIt="Commutazione di una dichiarazione d&apos;importazione provvisoria in definitiva" meaningEn="en_Umwandlung provisorische in definitive Einfuhrzollanmeldung" validFrom="2007-05-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="7" meaningDe="Erledigung provisorische Einfuhrzollanmeldung" meaningFr="Liquidation de l&apos;annonce à l&apos;importation provisoire" meaningIt="Liquidazione della dichiarazione provvisoria" meaningEn="en_Erledigung provisorische Einfuhrzollanmeldung" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="false" />
			<entry value="8" meaningDe="Verwaltungsbeschwerde / Rückerstattungsgesuch" meaningFr="recours administratif / demande de remboursement" meaningIt="Ricorso amministrativo / domanda di restituzione" meaningEn="eng_Verwaltungsbeschwerde / Rückerstattungsgesuch" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Verwaltungsbeschwerde / Rückerstattungsgesuch" meaningFr="recours administratif / demande de remboursement" meaningIt="ricorso amministrativo / " meaningEn="eng_Verwaltungsbeschwerde / Rückerstattungsgesuch" validFrom="2008-06-03" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Verwaltungsbeschwerde / Rückerstattungsgesuch" meaningFr="recours administratif / demande de remboursement" meaningIt="ricorso amministrativo / " meaningEn="eng_Verwaltungsbeschwerde / Rückerstattungsgesuch" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Umbuchung / nicht abgabenrelevante Änderung" meaningFr="Transfert comptable / modification non déterminante pour la perception" meaningIt="Storno / modifica non rilevante per i tributi" meaningEn="en_Umbuchung / nicht abgabenrelevante Änderun" validFrom="2004-01-01" validTo="2007-05-30" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Umbuchung / nicht abgabenrelevante Änderung" meaningFr="Transfert comptable / modification non déterminante pour la perception" meaningIt="Storno / modifica senza incidenza sui tributi" meaningEn="en_Umbuchung / nicht abgabenrelevante Änderung" validFrom="2007-05-31" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="10" meaningDe="Fristerstreckung einer provisorischen Einfuhrzollanmeldung" meaningFr="Prorogation de délai pour une déclaration d&apos;importation provisoire" meaningIt="Proroga del termine per una dichiarazione d&apos;importazione provvisoria" meaningEn="en_Fristerstreckung einer provisorischen Einfuhrzollanmeldung" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Fristverlängerung einer provisorischen Einfuhrzollanmeldung" meaningFr="Prorogation de délai pour une déclaration d&apos;importation provisoire" meaningIt="Proroga del termine per una dichiarazione d&apos;importazione provvisoria" meaningEn="en_Fristverlängerung einer provisorischen Einfuhrzollanmeldung" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="Nachforderung gemäss ZS/KD" meaningFr="perception subséquente selon BD/DA" meaningIt="riscossione posticipata" meaningEn="eng_Nachforderung gemäss ZS/KD" validFrom="2004-01-01" validTo="2007-05-30" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="Nachforderung gemäss ZS/KD" meaningFr="perception subséquente selon BD/DA" meaningIt="riscossione posticipata" meaningEn="eng_Nachforderung gemäss ZS/KD" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="Nachforderung gemäss ZS/KD" meaningFr="perception subséquente selon BD/DA" meaningIt="riscossione posticipata" meaningEn="eng_Nachforderung gemäss ZS/KD" validFrom="2007-05-31" validTo="2008-06-02" validForImport="true" validForExport="false" />
			<entry value="12" meaningDe="Selbstanzeige nach Austellung der Veranlagungsverfügung" meaningFr="Dénonciation spontanée après établissement de la décision de taxation" meaningIt="Autodenuncia dopo l&apos;allestimento della decisione d&apos;imposizione" meaningEn="en_Selbstanzeige nach Austellung der Veranlagungsverfügung" validFrom="2004-01-01" validTo="2007-05-30" validForImport="true" validForExport="true" />
			<entry value="12" meaningDe="Selbstanzeige nach Ausstellung der Veranlagungsverfügung" meaningFr="Dénonciation spontanée après établissement de la décision de taxation" meaningIt="Autodenuncia dopo l&apos;emanazione della decisione d&apos;imposizione" meaningEn="en_Selbstanzeige nach Ausstellung der Veranlagungsverfügung" validFrom="2007-05-31" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="13" meaningDe="Abschluss Zolllagerverfahren &quot;Lager für Massengüter&quot;" meaningFr="Apurement du régime d&apos;entrepôt douanier &quot;entrepôt de marchandises de grande consommation&quot;" meaningIt="Appuramento del regime di deposito doganale &quot;deposito per merci di gran consumo&quot;" meaningEn="en_Abschluss Zolllagerverfahren &quot;Lager für Massengüter&quot;" validFrom="2007-05-26" validTo="2008-11-02" validForImport="true" validForExport="false" />
			<entry value="13" meaningDe="Abschluss Zolllagerverfahren &quot;Lager für Massengüter&quot;" meaningFr="Apurement du régime d&apos;entrepôt douanier &quot;entrepôt de marchandises de grande consommation&quot;" meaningIt=" Appuramento del regime di deposito doganale &quot;deposito per merci di gran consumo&quot;" meaningEn="en_Abschluss Zolllagerverfahren &quot;Lager für Massengüter&quot;" validFrom="2007-05-01" validTo="2007-05-25" validForImport="true" validForExport="false" />
			<entry value="13" meaningDe="Abschreibung ZLM &quot;Lager für Massengüter&quot;" meaningFr="Imputation DEM &quot;entrepôt de marchandises de grande consommation&quot;" meaningIt="Detrazione da una dichiarazione doganale per deposito di merci di gran cosomo" meaningEn="eng_13" validFrom="2008-11-02" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="14" meaningDe="Abschluss Zollagerverfahren &quot;Lager für Massengüter&quot;" meaningFr="Apurement du régime de l&apos;entrepôt douanier &quot;entrepôt de marchandises de grande consommation&quot;" meaningIt="Conclusione del regime di deposito doganale per merci di gran consumo" meaningEn="eng_14" validFrom="2008-11-02" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="15" meaningDe="E-dec web korrigiert am Zollstellenterminal" meaningFr="Correction effectuée dans e-dec web sur le terminal du bureau de douane" meaningIt="E-dec web effettua la correzione al terminale dell&apos;UD" meaningEn="E-dec web korrigiert am Zollstellenterminal" validFrom="2004-01-01" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="15" meaningDe="E-dec web korrigiert am Zollstellenterminal" meaningFr="Correction effectuée dans e-dec web sur le terminal du bureau de douane" meaningIt="Correzione E-dec web effettuata al terminale dell&apos;UD" meaningEn="E-dec web korrigiert am Zollstellenterminal" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="99" meaningDe="Andere" meaningFr="Autres" meaningIt="Altri" meaningEn="en_Andere" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="customsClearanceType">
			<entry value="1" meaningDe="Normalabfertigung" meaningFr="Dédouanement normal" meaningIt="Sdoganamento normale" meaningEn="en_Normalabfertigung" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Normalveranlagung" meaningFr="Taxation normal" meaningIt="Imposizione all&apos;aliquota normale" meaningEn="en_Normalveranlagung" validFrom="2008-06-03" validTo="2008-06-11" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Normalveranlagung" meaningFr="Taxation normal" meaningIt="Imposizione  normale" meaningEn="en_Normalveranlagung" validFrom="2008-06-12" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Veredelungsverkehr" meaningFr="trafic de perfectionnement" meaningIt="traffico di perfezionamento" meaningEn="eng_Veredelungsverkehr" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Veredelungsverkehr" meaningFr="trafic de perfectionnement" meaningIt="traffico di perfezionamento" meaningEn="eng_Veredelungsverkehr" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Ausbesserungsverkehr" meaningFr="Trafic de réparation" meaningIt="Traffico di riparazione" meaningEn="en_Reparaturverkehr" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Ausbesserungsverkehr" meaningFr="Trafic de réparation" meaningIt="Traffico di riparazione" meaningEn="en_Reparaturverkehr" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Rückwaren" meaningFr="marchandises en retour" meaningIt="merci di ritorno" meaningEn="eng_Rückwaren" validFrom="2011-08-08" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="4" meaningDe="Rückwaren" meaningFr="marchandises en retour" meaningIt="merci di ritorno" meaningEn="eng_Rückwaren" validFrom="2008-06-03" validTo="2011-07-01" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Rückwaren" meaningFr="marchandises en retour" meaningIt="merci di ritorno" meaningEn="eng_Rückwaren" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Rückwaren" meaningFr="marchandises en retour" meaningIt="merci di ritorno" meaningEn="eng_Rückwaren" validFrom="2011-07-02" validTo="2011-08-05" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Zollerleichterung" meaningFr="Allègement douanier" meaningIt="Agevolazione doganale" meaningEn="en_Zollerleichterung" validFrom="2010-04-09" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="5" meaningDe="Zollerleichterung" meaningFr="Allègement douanier" meaningIt="Agevolazione doganale" meaningEn="en_Zollerleichterung" validFrom="2004-01-01" validTo="2010-04-08" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="Tabak" meaningFr="Tabac" meaningIt="Tabacco" meaningEn="en_Tabak" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="Zollfreie Abfertigung gem. ZG" meaningFr="Dédouanement en franchise de droits de douane selon LD" meaningIt="Sdoganamento in franchigia da dazio secondo LD" meaningEn="en_Zollfreie Abfertigung gem. ZG" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="false" />
			<entry value="7" meaningDe="Zollfreie Veranlagung gem. ZG" meaningFr="Taxation en franchise de droits de douane selon LD" meaningIt="Imposizione in franchigia da dazio secondo LD" meaningEn="en_Zollfreie Veranlagung gem. ZG" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="8" meaningDe="Abgabenfreie Abfertigung" meaningFr="Dédouanement en franchise de redevances" meaningIt="Sdoganamento in franchigia da tributi Abfertigung" meaningEn="en_Abgabenfreie Abfertigung" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Abgabenfreie Veranlagung" meaningFr="Taxation en franchise de redevances" meaningIt="Sdoganamento in franchigia da tributi" meaningEn="en_Abgabenfreie Veranlagung" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Abgabenfreie Veranlagung" meaningFr="Taxation en franchise de redevances" meaningIt="Imposizione in franchigia da tributi Abfertigung" meaningEn="en_Abgabenfreie Veranlagung" validFrom="2008-06-03" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Sonderfälle" meaningFr="cas spéciaux ex SDI code de dédouanement 9" meaningIt="casi particolari" meaningEn="en_Sonderfälle" validFrom="2009-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="9" meaningDe="Sonderfälle ex ZIL Abfertigungscode 9" meaningFr="cas spéciaux ex SDI code de dédouanement 9" meaningIt="casi particolari ex SDI codice di sdoganamento 9" meaningEn="en_Sonderfälle ex ZIL Abfertigungscode 9" validFrom="2005-01-01" validTo="2008-12-31" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Rueckwaren gemaess Zollrecht" meaningFr="marchandises en retour selon le droit douanier" meaningIt="merci di ritorno secondo diritto doganale" meaningEn="Rueckwaren gemaess Zollrecht" validFrom="2010-02-19" validTo="2011-08-17" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Rueckwaren gemaess Zollrecht" meaningFr="marchandises en retour selon le droit douanier" meaningIt="merci di ritorno secondo diritto doganale" meaningEn="Rueckwaren gemaess Zollrecht" validFrom="2011-08-18" validTo="2011-08-22" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Rueckwaren gemaess Zollrecht" meaningFr="marchandises en retour selon le droit douanier" meaningIt="merci di ritorno secondo diritto doganale" meaningEn="Rueckwaren gemaess Zollrecht" validFrom="2011-08-24" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Rueckwaren gemaess Zollrecht" meaningFr="marchandises en retour selon le droit douanier" meaningIt="m. di ritorno secondo diritto doganale" meaningEn="Rueckwaren gemaess Zollrecht" validFrom="2011-08-23" validTo="2011-08-23" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="Rueckwaren gemaess Zoll-/MWST-Recht" meaningFr="marchandises en retour selon le droit douanier/TVA" meaningIt="m. di rit. secondo diritto doganale e LIVA" meaningEn="Rueckwaren gemaess Zoll-/MWST-Recht" validFrom="2011-08-23" validTo="2011-08-23" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="Rueckwaren gemaess Zoll-/MWST-Recht" meaningFr="marchandises en retour selon le droit douanier/TVA" meaningIt="merci di ritorno secondo diritto doganale e LIVA" meaningEn="Rueckwaren gemaess Zoll-/MWST-Recht" validFrom="2010-02-19" validTo="2011-08-17" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="Rueckwaren gemaess Zoll-/MWST-Recht" meaningFr="marchandises en retour selon le droit douanier/TVA" meaningIt="merci di ritorno secondo diritto doganale e LIVA" meaningEn="Rueckwaren gemaess Zoll-/MWST-Recht" validFrom="2011-08-18" validTo="2011-08-22" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="Rueckwaren gemaess Zoll-/MWST-Recht" meaningFr="marchandises en retour selon le droit douanier/TVA" meaningIt="merci di ritorno secondo diritto doganale e LIVA" meaningEn="Rueckwaren gemaess Zoll-/MWST-Recht" validFrom="2011-08-24" validTo="9999-12-31" validForImport="true" validForExport="false" />
			</domain>
			<domain name="declarationTime">
			<entry value="1" meaningDe="Stellung unter Zollkontrolle" meaningFr="Mise sous contrôle de douane" meaningIt="Messa sotto controllo" meaningEn="en_Stellung unter Zollkontrolle" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Gestellung" meaningFr="Présentation en douane" meaningIt="Presentazione in dogana" meaningEn="en_Gestellung" validFrom="2007-05-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Voranmeldung" meaningFr="déclaration préalable" meaningIt="Predichiarazione" meaningEn="en_Voranmeldung" validFrom="2007-05-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Vorausanmeldung" meaningFr="Annonce préalable" meaningIt="Predichiarazione" meaningEn="en_Vorausanmeldung" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Nachträgliche Anmeldung" meaningFr="Annonce a posteriori" meaningIt="Dichiarazione a posteriori" meaningEn="en_Nachträgliche Anmeldung" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Nachträgliche Anmeldung" meaningFr="Déclaration  a posteriori" meaningIt="Dichiarazione a posteriori" meaningEn="en_Nachträgliche Anmeldung" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Vorausanmeldung für Direktauslieferungen" meaningFr="Déclaration préalable pour livraisons directes" meaningIt="Predichiarazione per le forniture dirette" meaningEn="en_Vorausanmeldung für Direktauslieferungen" validFrom="2008-06-03" validTo="2012-04-18" validForImport="true" validForExport="false" />
			<entry value="4" meaningDe="Vorausanmeldung für Direktauslieferungen" meaningFr="Annonce préalable pour livraisons directes" meaningIt="Predichiarazione per le forniture dirette" meaningEn="en_Vorausanmeldung für Direktauslieferungen" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="false" />
			<entry value="5" meaningDe="Vorausanmeldung für Zu-/Beilad" meaningFr="annonce préalable chargement/déchargement" meaningIt="preannuncio per carico/scarico" meaningEn="eng_Vorausanmeldung für Zu-/Beilad" validFrom="2008-04-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="99" meaningDe="Andere" meaningFr="Autres" meaningIt="Altri" meaningEn="en_Andere" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="declarationType">
			<entry value="1" meaningDe="Definitiv" meaningFr="Déf." meaningIt="Def." meaningEn="en_Definitiv" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Provisorisch" meaningFr="Prov." meaningIt="Prov." meaningEn="en_Provisorisch" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="3" meaningDe="Andere Zwischenveranlagungen / Zwischenveranl." meaningFr="Autres taxations intérimaires / Tax. intéerim." meaningIt="Altri sdoganamenti intermedi" meaningEn="en_Andere Zwischenveranlagungen / Zwischenveranl." validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="3" meaningDe="Andere Zwischenabfertigung" meaningFr="Autres dédouanements intérimaires" meaningIt="Altri sdoganamenti intermedi" meaningEn="en_Andere Zwischenabfertigung" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="false" />
			<entry value="4" meaningDe="VEV" meaningFr="PSI" meaningIt="PSI" meaningEn="en_VEV" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="5" meaningDe="Periodische Sammelanmeldung" meaningFr="Annonce collective périodique" meaningIt="Dichiarazione collettiva periodica" meaningEn="en_Periodische Sammelanmeldung" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Periodische Sammelanmeldung" meaningFr="Déclaration collective périodique" meaningIt="Dichiarazione collettiva periodica" meaningEn="en_Periodische Sammelanmeldung" validFrom="2008-06-03" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="e-dec easy" meaningFr="e-dec easy" meaningIt="e-dec easy" meaningEn="e-dec easy" validFrom="2010-02-03" validTo="2010-02-04" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="easy" meaningFr="easy" meaningIt="easy" meaningEn="easy" validFrom="2010-06-14" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="99" meaningDe="Andere" meaningFr="Autres" meaningIt="Altri" meaningEn="en_Andere" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			</domain>
			<domain name="direction">
			<entry value="1" meaningDe="aktiv" meaningFr="Actif" meaningIt="Attivo" meaningEn="en_aktiv" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="passiv" meaningFr="Passif" meaningIt="Passivo" meaningEn="en_passiv" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="documentType">
			<entry value="C641" meaningDe="Dissostichus  Fangdokument Einfuhr" meaningFr="Dissostichus Certificat de capture importation" meaningIt="Dissostichus Documento di cattura importazione" meaningEn="Dissostichus catch document import" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C641" meaningDe="Dissostichus - Fangdokument, Einfuhr" meaningFr="Dissostichus - Certificat de capture, importation" meaningIt="Dissostichus - catch document import" meaningEn="en_Dissostichus - Fangdokument, Einfuhr" validFrom="2011-02-08" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="C656" meaningDe="Dissostichus - Fangdokument, Ausfuhr" meaningFr="Dissostichus - Certificat de capture, exportation" meaningIt="Dissostichus - Documento di cattura, esportazione" meaningEn="Dissostichus - Catch document export" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C673" meaningDe="Fangbescheinigung" meaningFr="Certificat de capture" meaningIt="Certificato di cattura" meaningEn="Catch certificate" validFrom="2010-05-08" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="AEO-Versender/Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Esportatore AEO" meaningEn="en_AEO-Versender/Ausführer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Zugelassener Wirtschaftsbeteiligter" meaningFr="fr_Zugelassener Wirtschaftsbeteiligter" meaningIt="it_Zugelassener Wirtschaftsbeteiligter" meaningEn="en_Zugelassener Wirtschaftsbeteiligter" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Versender / Ausführer" meaningFr="fr_Versender / Ausführer" meaningIt="it_Versender / Ausführer" meaningEn="en_Versender / Ausführer" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Versender / Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Consignor / exporter (AEO)" meaningEn="en_Versender / Ausführer" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="AEO-Versender/Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Consignor / exporter (AEO)" meaningEn="en_AEO-Versender/Ausführer" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="Empfänger" meaningFr="Destinataire (AEO)" meaningIt="Consignee (AEO certificate number)" meaningEn="en_Empfänger" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="Empfänger" meaningFr="fr_Empfänger" meaningIt="it_Empfänger" meaningEn="en_Empfänger" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="AEO-Empfänger" meaningFr="Destinataire (AEO)" meaningIt="Consignee (AEO certificate number)" meaningEn="en_AEO-Empfänger" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="AEO-Empfänger" meaningFr="Destinataire AEO" meaningIt="Destinatario AEO" meaningEn="en_AEO-Empfänger" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO Anmelder" meaningFr="Déclarant AEO" meaningIt="Dichiarante AEO" meaningEn="en_AEO Anmelder" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="Empfänger" meaningFr="fr_Empfänger" meaningIt="it_Empfänger" meaningEn="en_Empfänger" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="Deklarant" meaningFr="fr_Deklarant" meaningIt="it_Deklarant" meaningEn="en_Deklarant" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO-Anmelder (Deklarant)" meaningFr="Déclarant (AEO)" meaningIt="Declarant (AEO certificate number)" meaningEn="en_AEO-Anmelder (Deklarant)" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO-Anmelder" meaningFr="Déclarant (AEO)" meaningIt="Declarant (AEO certificate number)" meaningEn="en_AEO-Anmelder" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="AEO-Vertreter" meaningFr="Représentant (AEO)" meaningIt="Representative (AEO)" meaningEn="en_AEO-Vertreter" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Vertreter" meaningFr="Représentant (AEO)" meaningIt="Representative (AEO)" meaningEn="en_Vertreter" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Vertreter" meaningFr="fr_Vertreter" meaningIt="it_Vertreter" meaningEn="en_Vertreter" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Deklarant" meaningFr="fr_Deklarant" meaningIt="it_Deklarant" meaningEn="en_Deklarant" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="AEO Vertreter" meaningFr="Représentant AEO" meaningIt="Rappresentante AEO" meaningEn="en_AEO Vertreter" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="Hauptverpflichteter" meaningFr="Principal obligé (AEO)" meaningIt="Principal (AEO certificate number)" meaningEn="en_Hauptverpflichteter" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="HV Principal" meaningFr="fr_HV Principal" meaningIt="it_HV Principal" meaningEn="en_HV Principal" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="AEO Hauptverpflichteter" meaningFr="Principal obligé AEO" meaningIt="Obblig. principale AEO" meaningEn="en_AEO Hauptverpflichteter" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="Hauptverpflichteter" meaningFr="fr_Hauptverpflichteter" meaningIt="it_Hauptverpflichteter" meaningEn="en_Hauptverpflichteter" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="AEO-Hauptverpflichteter" meaningFr="Principal obligé (AEO)" meaningIt="Principal (AEO certificate number)" meaningEn="en_AEO-Hauptverpflichteter" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="AEO-Lagerinhaber" meaningFr="Entreposeur (AEO)" meaningIt="Warehousekeeper (AEO)" meaningEn="en_AEO-Lagerinhaber" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Transporteur" meaningFr="fr_Transporteur" meaningIt="it_Transporteur" meaningEn="en_Transporteur" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Lagerinhaber" meaningFr="fr_Lagerinhaber" meaningIt="it_Lagerinhaber" meaningEn="en_Lagerinhaber" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Lagerinhaber" meaningFr="Entreposeur (AEO)" meaningIt="Warehousekeeper (AEO)" meaningEn="en_Lagerinhaber" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="AEO Lagerinhaber" meaningFr="Entreposeur AEO" meaningIt="Depositario autorizzato AEO" meaningEn="en_AEO Lagerinhaber" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="Hauptverpflichteter" meaningFr="fr_Hauptverpflichteter" meaningIt="it_Hauptverpflichteter" meaningEn="en_Hauptverpflichteter" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="AEO-Beförderer" meaningFr="Autre opérateur économique autorisé (AEO)" meaningIt="Carrier (AEO certificate number)" meaningEn="en_AEO-Beförderer" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="andere zugelassene Wirtschaftsbeteiligte" meaningFr="Autre opérateur économique autorisé (AEO)" meaningIt="Carrier (AEO certificate number)" meaningEn="en_andere zugelassene Wirtschaftsbeteiligte" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="andere zugelassene Wirtschaftsbeteiligte" meaningFr="fr_andere zugelassene Wirtschaftsbeteiligte" meaningIt="it_andere zugelassene Wirtschaftsbeteiligte" meaningEn="en_andere zugelassene Wirtschaftsbeteiligte" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="AEO-Beförderer" meaningFr="Transporteur AEO" meaningIt="Trasportatore AEO" meaningEn="en_AEO-Beförderer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe=" And. Zugel. Wirtschaftsbeteiligte" meaningFr="Other authorised economic operator" meaningIt="Other authorised economic operator" meaningEn="en_ And. Zugel. Wirtschaftsbeteiligte" validFrom="2008-11-25" validTo="2011-02-01" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe="And. Zugel. Wirtschaftsbeteiligte" meaningFr="Other authorised economic operator" meaningIt="Other authorised economic operator" meaningEn="en_And. Zugel. Wirtschaftsbeteiligte" validFrom="2011-02-01" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe="And. Zugel. Wirtschaftsbeteiligte" meaningFr="autre opérateur économique agréé" meaningIt="Altro operatore economico autorizzato" meaningEn="en_And. Zugel. Wirtschaftsbeteiligte" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y031" meaningDe="ZWB Zert" meaningFr="AEO Zert" meaningIt="AEO Zert" meaningEn="AEO Zert" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y101" meaningDe="Einfuhrlizenz AGRIM" meaningFr="certificat d&apos;importation AGRIM" meaningIt="titolo d&apos;importazione AGRIM" meaningEn="import licence AGRIM" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y927" meaningDe="Verordnung (EG) Nr. 1005/2008" meaningFr="règlement (CE) n° 1005/2008 du Conseil" meaningIt="regolamento (CE) n. 1005/2008 del Consiglio" meaningEn="Regulation (EC) No. 1005/2008" validFrom="2011-01-28" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y927" meaningDe="Verordnung EG Nr. 1005/2008 des Rates" meaningFr="règlement CE Nr 1005/2008 du Conseil" meaningIt="regolamento CE Nr 1005/2008 del Consiglio" meaningEn="en_Verordnung EG Nr. 1005/2008 des Rates" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CLE" meaningDe="Referenznummer/Datum der Anschreibung in der Buchführung" meaningFr="ICM" meaningIt="ICM" meaningEn="Reference date of entry of the goods in the records" validFrom="2012-02-09" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers (Verwendungsverpflichtung)" meaningFr="Revers (Verwendungsverpflichtung)" meaningIt="Revers (Verwendungsverpflichtung)" meaningEn="Revers (Verwendungsverpflichtung)" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers (Verwendungsverpflichtung)" meaningFr="Revers(Forme de l&apos;engagement d&apos;emploi)" meaningIt="Revers(Forma dell&apos;impegno d&apos;impiego)" meaningEn="en_Revers (Verwendungsverpflichtung)" validFrom="2008-11-25" validTo="2011-11-08" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers Verwendungsverpflichtung" meaningFr="Revers Forme de l&apos;engagement d&apos;emploi" meaningIt="Revers impegno circa l&apos;uso" meaningEn="en_Revers Verwendungsverpflichtung" validFrom="2013-01-12" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers (Verwendungsverpflichtung)" meaningFr="Revers(Forme de lengagement demploi)" meaningIt="Revers(Forma dellimpegno dimpiego)" meaningEn="en_Revers (Verwendungsverpflichtung)" validFrom="2011-11-08" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers Verwendungsverpflichtung" meaningFr="Revers Forme de l&apos;engagement d&apos;emploi" meaningIt="Revers impegno circa luso" meaningEn="en_Revers Verwendungsverpflichtung" validFrom="2011-12-20" validTo="2013-01-12" validForImport="true" validForExport="true" />
			<entry value="T02" meaningDe="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningFr="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningIt="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningEn="Bewilligung als Ergänzung zu einem bestehenden Revers" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T02" meaningDe="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningFr="Permis en complément à un revers existant" meaningIt="Autorizzazione completamenta ad un revers esistente" meaningEn="en_Bewilligung als Ergänzung zu einem bestehenden Revers" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T02" meaningDe="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningFr="Permis en complément à un revers existant" meaningIt="Permesso complementare ad un revers esistente" meaningEn="en_Bewilligung als Ergänzung zu einem bestehenden Revers" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T03" meaningDe="Jahr der Ergänzungsbewilligung" meaningFr="Année du permis complémentaire" meaningIt="Anno del permesso complementare" meaningEn="en_Jahr der Ergänzungsbewilligung" validFrom="2008-11-25" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T03" meaningDe="Jahr der Ergänzungsbewilligung" meaningFr="Jahr der Ergänzungsbewilligung" meaningIt="Jahr der Ergänzungsbewilligung" meaningEn="Jahr der Ergänzungsbewilligung" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T04" meaningDe="Produkthauptgruppe" meaningFr="Groupe principal produit" meaningIt="Gruppo princ prodotto" meaningEn="en_Produkthauptgruppe" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T04" meaningDe="Produkthauptgruppe" meaningFr="Groupe principal produit" meaningIt="Gruppo princ. prodotto" meaningEn="en_Produkthauptgruppe" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T04" meaningDe="Produkthauptgruppe" meaningFr="Produkthauptgruppe" meaningIt="Produkthauptgruppe" meaningEn="Produkthauptgruppe" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T05" meaningDe="Produktuntergruppe" meaningFr="Produktuntergruppe" meaningIt="Produktuntergruppe" meaningEn="Produktuntergruppe" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T05" meaningDe="Produktuntergruppe" meaningFr="Sous-groupe produit" meaningIt="Sotto gruppo prodotto" meaningEn="en_Produktuntergruppe" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T05" meaningDe="Produktuntergruppe" meaningFr="Sous groupe produit" meaningIt="Sottogruppo di prodotti" meaningEn="en_Produktuntergruppe" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T06" meaningDe="Laufnummer" meaningFr="No courant" meaningIt="Numero progressivo" meaningEn="en_Laufnummer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T06" meaningDe="Laufnummer" meaningFr="No courant" meaningIt="N. corrente" meaningEn="en_Laufnummer" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T06" meaningDe="Laufnummer" meaningFr="Laufnummer" meaningIt="Laufnummer" meaningEn="Laufnummer" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T07" meaningDe="Ansatz" meaningFr="Taux" meaningIt="Aliquota" meaningEn="en_Ansatz" validFrom="2008-11-25" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T07" meaningDe="Ansatz" meaningFr="Ansatz" meaningIt="Ansatz" meaningEn="Ansatz" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T08" meaningDe="Besondere Masseinheit - Stück" meaningFr="Besondere Masseinheit - Stück" meaningIt="Besondere Masseinheit - Stück" meaningEn="Besondere Masseinheit - Stück" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T08" meaningDe="Besondere Masseinheit - Stück" meaningFr="Quantité spéciale - pièce" meaningIt="Quantità particolare - pezzo" meaningEn="en_Besondere Masseinheit - Stück" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T08" meaningDe="Besondere Masseinheit Stück" meaningFr="Quantité spéciale pièce" meaningIt="Quantità particolare pezzo" meaningEn="en_Besondere Masseinheit Stück" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T09" meaningDe="Zollauschlussgebiete" meaningFr="Enclave douanière" meaningIt="Enclave doganale" meaningEn="en_Zollauschlussgebiete" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T09" meaningDe="Zollauschlussgebiete" meaningFr="Enclave douanière" meaningIt="Terr.fuori linea dogana" meaningEn="en_Zollauschlussgebiete" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T09" meaningDe="Zollauschlussgebiete" meaningFr="Zollauschlussgebiete" meaningIt="Zollauschlussgebiete" meaningEn="Zollauschlussgebiete" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="zzz" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="other" validFrom="2004-11-05" validTo="2010-03-02" validForImport="true" validForExport="true" />
			<entry value="zzz" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="Other" validFrom="2010-03-05" validTo="2010-03-06" validForImport="true" validForExport="true" />
			<entry value="ZZZ" meaningDe="Sonstige" meaningFr="Autres" meaningIt="Altro" meaningEn="Other" validFrom="2009-09-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EU" meaningDe="Einheitspapier - Handel mit EFTA" meaningFr="Document Administratif Unique Echanges avec l&apos;AELE" meaningIt="Single Administrative Document- Trade with EFTA" meaningEn="Single Administrative Document- Trade with EFTA" validFrom="2012-06-22" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Konformitätsbescheinigung" meaningFr="Certificat de conformité" meaningIt="Certificato di conformità" meaningEn="Certificate of conformity" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Qualitätszeugnis" meaningFr="Certificat de qualité" meaningIt="Certificato di qualità" meaningEn="Certificate of quality" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="18" meaningDe="Warenverkehrsbescheinigung A.TR.1" meaningFr="Certificat ATR1" meaningIt="Certificato di circolazione A.TR.1" meaningEn="Movement certificate A.TR.1" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="Containerliste" meaningFr="Liste de conteneur" meaningIt="Elenco dei container" meaningEn="Container list" validFrom="2004-11-05" validTo="2013-10-09" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="Containerliste" meaningFr="Liste de conteneur" meaningIt="Elenco dei contenitori" meaningEn="Container list" validFrom="2013-10-09" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="271" meaningDe="Packliste" meaningFr="Liste de colisage" meaningIt="Distinta del carico" meaningEn="Packing list" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="325" meaningDe="Proformarechnung" meaningFr="Facture proforma" meaningIt="Fattura proforma" meaningEn="Proforma invoice" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="337" meaningDe="Summarische Anmeldung zur vorübergehenden Lagerung" meaningFr="déclaration sommaire de dépôt temporaire" meaningIt="dichiarazione sommaria per la custodia temporanea" meaningEn="Summary declaration for temporary storage" validFrom="2011-02-04" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="355" meaningDe="Summarische Voranmeldung" meaningFr="déclaration sommaire d&apos;entrée" meaningIt="Dichiarazione sommaria di ingresso" meaningEn="Entry summary declaration" validFrom="2011-02-04" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="380" meaningDe="Handelsrechnung" meaningFr="Facture commerciale" meaningIt="Fattura commerciale" meaningEn="Commercial invoice" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="703" meaningDe="Hausfrachtbrief" meaningFr="Récepissé" meaningIt="Lett.ra  vettura emessa da sped.re" meaningEn="House waybill" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="703" meaningDe="Hausfrachtbrief" meaningFr="Récepissé" meaningIt="Lettera di vettura casa" meaningEn="House waybill" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="704" meaningDe="Sammelkonnossement" meaningFr="Connaissement principal" meaningIt="Polizza di carico principale" meaningEn="Master bill of lading" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="705" meaningDe="Konnossement" meaningFr="Connaissement" meaningIt="Polizza di carico" meaningEn="Bill of lading" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement émis par un transitai" meaningIt="Polizza di carico emessa da sped.re" meaningEn="House bill of lading" validFrom="2009-04-30" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement maison interne" meaningIt="Polizza di carico emessa da sped.re" meaningEn="en_Hauskonnossement" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement maison/interne" meaningIt="Polizza di carico emessa da sped.re" meaningEn="House bill of lading" validFrom="2004-11-05" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="Frachtbrief CIM" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM consignment note rail" validFrom="2012-08-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief Rail" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM consignment note Rail" validFrom="2009-07-09" validTo="2009-08-12" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief Rail" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM-consignment note Rail" validFrom="2011-12-20" validTo="2012-08-21" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief ( Rail )" meaningFr="CIM-feuille de route ( Rail )" meaningIt="CIM-lettera di vettura ( Rail )" meaningEn="CIM consignment note (rail)" validFrom="2010-02-09" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="722" meaningDe="SMGS-Begleitliste" meaningFr="Feuille de route-SMGS" meaningIt="Doc. accompagnamento-SMGS" meaningEn="Road list-SMGS" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="722" meaningDe="SMGS Begleitliste" meaningFr="Feuille de route SMGS" meaningIt="Doc. accompagnamento SMGS" meaningEn="Road list SMGS" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="730" meaningDe="LKW-Frachtbrief" meaningFr="Document d&apos;expédition par route" meaningIt="Lettera di vettura stradale" meaningEn="Road consignment note" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="740" meaningDe="Luftfrachtbrief" meaningFr="Lettre de transport aérien" meaningIt="Lettera di vettura aerea" meaningEn="Air waybill" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="741" meaningDe="Master-Luftfrachtbrief" meaningFr="Lettre de transport aérien principale" meaningIt="Lettera di vettura aerea principale" meaningEn="Master air waybill" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="750" meaningDe="Paketkarte Despatch note" meaningFr="Bulletin d&apos;expédition colis postaux" meaningIt="Bollettino spedizione pacchi postali" meaningEn="Despatch note post parcels" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="750" meaningDe="Paketkarte (Despatch note)" meaningFr="Bulletin d&apos;expédition (colis postaux)" meaningIt="Bollettino spedizione (pacchi postali)" meaningEn="Despatch note (post parcels)" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="760" meaningDe="Kombiniertes Transportdokument" meaningFr="Doc. transp. multimodal/combiné" meaningIt="Doc.trasporto multimodale/combinato" meaningEn="Multimodal/combined transport doc." validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Manifeste de cargaison" meaningIt="Manifesto cargo" meaningEn="Cargo manifest" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Manifeste" meaningIt="Manifesto di carico" meaningEn="Cargo manifest" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereau" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2004-11-05" validTo="2011-02-01" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereaux" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2011-02-01" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereau" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="820" meaningDe="T-Versandschein" meaningFr="Document d&apos;expédition modèle T" meaningIt="Documento di spedizione modello T" meaningEn="Despatch note model T" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="821" meaningDe="T1-Versandschein" meaningFr="Document d&apos;expédition modèle T1" meaningIt="Documento di spedizione modello T1" meaningEn="Despatch note model T1" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="822" meaningDe="T2-Versandschein" meaningFr="Document d&apos;expédition modèle T2" meaningIt="Documento di spedizione modello T2" meaningEn="Despatch note model T2" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="823" meaningDe="T5 Kontrollexemplar" meaningFr="Document de contrôle T5" meaningIt="Documento di controllo T5" meaningEn="Control document T5" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="825" meaningDe="T2L-Versandnachweis" meaningFr="Document d&apos;expédition modèle T2L" meaningIt="Documento di spedizione modello T2L" meaningEn="Despatch note model T2L" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="830" meaningDe="Ausfuhrdeklaration" meaningFr="Déclaration d&apos;exportation" meaningIt="Dichiarazione di esportazione" meaningEn="Goods declaration for exportation" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="851" meaningDe="Pflanzenschutzzeugnis" meaningFr="Certificat phytosanitaire" meaningIt="Certificato fitosanitario" meaningEn="Phytosanitary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="852" meaningDe="Genusstauglichkeitszeugnis" meaningFr="Certificat sanitaire" meaningIt="Certificato sanitario" meaningEn="Sanitary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="853" meaningDe="Tierärztliches Gesundheitszeugnis" meaningFr="Certificat vétérinaire" meaningIt="Certificato veterinario" meaningEn="Veterinary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="861" meaningDe="Ursprungszeugnis" meaningFr="Certificat d&apos;origine" meaningIt="Certificato d&apos;origine" meaningEn="Certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="862" meaningDe="Ursprungserklärung" meaningFr="Déclaration d&apos;origine" meaningIt="Dichiarazione di origine" meaningEn="Declaration of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="864" meaningDe="Präferenz-Ursprungsnachweis" meaningFr="Certificat d&apos;origine préference" meaningIt="Certificato di origine preferenziale" meaningEn="Preference certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="865" meaningDe="APS-Ursprungszeugnis" meaningFr="Certificat d&apos;origine formulaire SGP" meaningIt="Certificato di origine form. APS" meaningEn="Certificate of origin form GSP" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="900" meaningDe="Beilagen zur Identitätssicherung" meaningFr="Annexes servant à garantir identité" meaningIt="Allegati per garantire identità" meaningEn="en_Beilagen zur Identitätssicherung" validFrom="2014-02-04" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="900" meaningDe="Beilagen zur Identitätssicherung" meaningFr="fr_Beilagen zur Identitätssicherung" meaningIt="it_Beilagen zur Identitätssicherung" meaningEn="en_Beilagen zur Identitätssicherung" validFrom="2013-12-02" validTo="2014-02-04" validForImport="true" validForExport="true" />
			<entry value="911" meaningDe="Einfuhrlizenz" meaningFr="Licence d&apos;importation" meaningIt="Licenza di importazione" meaningEn="Import licence" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="933" meaningDe="Frachtanmeldung Ankunft" meaningFr="Déclaration de chargement arrivée" meaningIt="Dichiarazione del carico arrivo" meaningEn="Cargo declaration arrival" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="933" meaningDe="Frachtanmeldung (Ankunft)" meaningFr="Déclaration de chargement (arrivée)" meaningIt="Dichiarazione del carico (arrivo)" meaningEn="Cargo declaration (arrival)" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="941" meaningDe="Ausfuhrgenehmigung für Embargowaren" meaningFr="Permit d&apos;export pr march. sous embargo" meaningIt="Autorizzazione per merci sotto embargo" meaningEn="Embargo permit" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="951" meaningDe="TIF-Dokument" meaningFr="Formulaire TIF" meaningIt="Modulo TIF" meaningEn="TIF form" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet-TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="TIR carnet" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="TIR Carnet" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="954" meaningDe="EUR.1 Warenverkehrsbescheinigung" meaningFr="EUR 1 certificat d&apos;origine" meaningIt="Certificato di origine EUR 1" meaningEn="EUR 1 certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="Carnet ATA" meaningFr="Carnet ATA" meaningIt="Carnet ATA" meaningEn="ATA Carnet" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="Carnet ATA" meaningFr="Carnet ATA" meaningIt="Carnet ATA" meaningEn="ATA carnet" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS rail test movement" meaningFr="NCTS rail test movement" meaningIt="NCTS rail test movement" meaningEn="NCTS rail test movement" validFrom="2009-08-08" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS Eisenbahn Test-Verfahren" meaningFr="NCTS rail test movement" meaningIt="NCTS rail test movement" meaningEn="NCTS rail test movement" validFrom="2013-10-12" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS Rail Test" meaningFr="NCTS Rail Test" meaningIt="NCTS Rail Test" meaningEn="NCTS rail test movement" validFrom="2011-12-20" validTo="2013-10-12" validForImport="true" validForExport="true" />
			<entry value="720A" meaningDe="NCTS Rail Verfahren" meaningFr="NCTS procédure Rail" meaningIt="NCTS procedura Rail" meaningEn="NCTS rail movement" validFrom="2009-04-30" validTo="2009-07-09" validForImport="true" validForExport="true" />
			<entry value="720A" meaningDe="NCTS Rail Test" meaningFr="NCTS Rail test" meaningIt="NCTS Rail Test" meaningEn="NCTS Rail Test" validFrom="2009-08-05" validTo="2009-08-08" validForImport="true" validForExport="true" />
			</domain>
			<domain name="ExportCode">
			<entry value="10" meaningDe="Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningFr="fr_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningIt="it_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningEn="en_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" validFrom="2010-04-09" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="10" meaningDe="Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningFr="Exportation à partir de la mise à la consommation (soumis à l&apos;impôt)" meaningIt="Esportazione da libera pratica (tassato)" meaningEn="en_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" validFrom="2011-12-15" validTo="2012-10-12" validForImport="false" validForExport="true" />
			<entry value="10" meaningDe="Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningFr="Exportation à partir de la mise à la consommation (soumis à impôt)" meaningIt="Esportazione da libera pratica (tassato)" meaningEn="en_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" validFrom="2012-10-13" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="10" meaningDe="Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningFr="fr_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningIt="it_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" meaningEn="en_Ausfuhr ab steuerrechtlich freiem Verkehr (versteuert)" validFrom="2004-01-01" validTo="2010-04-08" validForImport="true" validForExport="true" />
			<entry value="11" meaningDe="Ausfuhr ab ZL mit BS, normal" meaningFr="Exportation ED avec bulletin de déliverance (normal)" meaningIt="Esportazione da DA con BS (normale)" meaningEn="en_Ausfuhr ab ZL mit BS, normal" validFrom="2012-10-13" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="11" meaningDe="Ausfuhr ab ZL mit BS, normal" meaningFr="fr_Ausfuhr ab ZL mit BS, normal" meaningIt="it_Ausfuhr ab ZL mit BS, normal" meaningEn="en_Ausfuhr ab ZL mit BS, normal" validFrom="2010-04-09" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="11" meaningDe="Ausfuhr ab ZL mit BS, normal" meaningFr="fr_Ausfuhr ab ZL mit BS, normal" meaningIt="it_Ausfuhr ab ZL mit BS, normal" meaningEn="en_Ausfuhr ab ZL mit BS, normal" validFrom="2004-01-01" validTo="2010-04-08" validForImport="true" validForExport="true" />
			<entry value="11" meaningDe="Ausfuhr ab ZL mit BS, normal" meaningFr="Exportation d&apos;ED avec bulletin de délivrance (normal)" meaningIt="Esportazione da DA con BS (normale)" meaningEn="en_Ausfuhr ab ZL mit BS, normal" validFrom="2011-12-15" validTo="2012-10-12" validForImport="false" validForExport="true" />
			<entry value="12" meaningDe="Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningFr="fr_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningIt="it_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningEn="en_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" validFrom="2004-01-01" validTo="2010-04-08" validForImport="true" validForExport="true" />
			<entry value="12" meaningDe="Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningFr="Exportation ED avec bulletin de déliverance pour chargement sur Rheinhäfen" meaningIt="Esportazione da DA con BS per caricamento (Rheinhäfen)" meaningEn="en_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" validFrom="2012-10-13" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="12" meaningDe="Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningFr="fr_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningIt="it_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningEn="en_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" validFrom="2010-04-09" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="12" meaningDe="Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" meaningFr="Exportation d&apos;ED avec bulletin de délivrance pour chargement sur Rheinhäfen" meaningIt="Esportazione da DA con BS per caricamento (Rheinhäfen)" meaningEn="en_Ausfuhr ab ZL mit BS zur Bunkerung Rheinhäfen" validFrom="2011-12-15" validTo="2012-10-12" validForImport="false" validForExport="true" />
			<entry value="13" meaningDe="Ausfuhr ab ZL mit BS nach Samnaun" meaningFr="Exportation de ED avec bulletin de délivrance sur Samnaun" meaningIt="Esportazione da DA con BS su Samnaun" meaningEn="en_Ausfuhr ab ZL mit BS nach Samnaun" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="13" meaningDe="Ausfuhr ab ZL mit BS nach Samnaun" meaningFr="fr_Ausfuhr ab ZL mit BS nach Samnaun" meaningIt="it_Ausfuhr ab ZL mit BS nach Samnaun" meaningEn="en_Ausfuhr ab ZL mit BS nach Samnaun" validFrom="2010-04-09" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="13" meaningDe="Ausfuhr ab ZL mit BS nach Samnaun" meaningFr="fr_Ausfuhr ab ZL mit BS nach Samnaun" meaningIt="it_Ausfuhr ab ZL mit BS nach Samnaun" meaningEn="en_Ausfuhr ab ZL mit BS nach Samnaun" validFrom="2004-01-01" validTo="2010-04-08" validForImport="true" validForExport="true" />
			<entry value="14" meaningDe="Ausfuhr ab ZL mit BS, andere" meaningFr="Exportation ED avec bulletin de délivrance, autre" meaningIt="Esportazione da DA con BS, altre" meaningEn="en_Ausfuhr ab ZL mit BS, andere" validFrom="2012-10-13" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="14" meaningDe="Ausfuhr ab ZL mit BS, andere" meaningFr="fr_Ausfuhr ab ZL mit BS, andere" meaningIt="it_Ausfuhr ab ZL mit BS, andere" meaningEn="en_Ausfuhr ab ZL mit BS, andere" validFrom="2004-01-01" validTo="2010-04-08" validForImport="true" validForExport="true" />
			<entry value="14" meaningDe="Ausfuhr ab ZL mit BS, andere" meaningFr="Exportation d&apos;ED avec bulletin de délivrance, autre" meaningIt="Esportazione da DA con BS, altre" meaningEn="en_Ausfuhr ab ZL mit BS, andere" validFrom="2011-12-15" validTo="2012-10-12" validForImport="false" validForExport="true" />
			<entry value="14" meaningDe="Ausfuhr ab ZL mit BS, andere" meaningFr="fr_Ausfuhr ab ZL mit BS, andere" meaningIt="it_Ausfuhr ab ZL mit BS, andere" meaningEn="en_Ausfuhr ab ZL mit BS, andere" validFrom="2010-04-09" validTo="2011-12-14" validForImport="false" validForExport="true" />
			</domain>
			<domain name="freeTradeZone">
			<entry value="61" meaningDe="Hochsavoyen" meaningFr="Haute-Savoie" meaningIt="Alta Savoia" meaningEn="eng_61 Hochsavoyen" validFrom="2011-05-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="62" meaningDe="Landschaft Gex" meaningFr="Pays de Gex" meaningIt="Paese di Gex" meaningEn="eng_62 Landschaft Gex" validFrom="2011-05-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="66" meaningDe="Samnaun" meaningFr="Samnaun" meaningIt="Samnaun" meaningEn="Samnaun" validFrom="2012-03-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="goodsItemDetailName">
			<entry value="1" meaningDe="Markenschlüssel" meaningFr="La clé de marque" meaningIt="Chiave di marca" meaningEn="en_Markenschlüssel" validFrom="2004-01-01" validTo="2999-01-01" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Fahrgestellnummer" meaningFr="Le numéro de châssis" meaningIt="Numero di telaio" meaningEn="en_Fahrgestellnummer" validFrom="2004-01-01" validTo="2999-01-01" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Stammnummer" meaningFr="Le numéro matricule" meaningIt="Numero di matricola" meaningEn="en_Stammnummer" validFrom="2004-01-01" validTo="2999-01-01" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Stickstoff (N)" meaningFr="Azote (N)" meaningIt="Azoto (N)" meaningEn="en_Stickstoff (N)" validFrom="2008-07-15" validTo="2008-07-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Stickstoff (N)" meaningFr="Azote (N)" meaningIt="Azoto (N)" meaningEn="en_Stickstoff (N)" validFrom="2004-01-01" validTo="2008-07-14" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Phosphor (P)" meaningFr="Phosphore (P)" meaningIt="Fosforo (P)" meaningEn="en_Phosphor (P)" validFrom="2004-01-01" validTo="2008-07-14" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Phosphor (P)" meaningFr="Phosphore (P)" meaningIt="Fosforo (P)" meaningEn="en_Phosphor (P)" validFrom="2008-07-15" validTo="2008-07-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="Kalium (K)" meaningFr="Potassium (K)" meaningIt="Potassio (K)" meaningEn="en_Kalium (K)" validFrom="2008-07-15" validTo="2008-07-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="Kalium (K)" meaningFr="Potassium (K)" meaningIt="Potassio (K)" meaningEn="en_Kalium (K)" validFrom="2004-01-01" validTo="2008-07-14" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="Produkthauptgruppe" meaningFr="Groupe principal de produit" meaningIt="Gruppo principale di prodotti" meaningEn="en_Produkthauptgruppe" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Produktuntergruppe" meaningFr="Sous-groupe de produit" meaningIt="Sottogruppo di prodotti" meaningEn="en_Produktuntergruppe" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Bezeichnung" meaningFr="Désignation" meaningIt="Designazione" meaningEn="en_Bezeichnung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="10" meaningDe="Laufnummer" meaningFr="Numéro d&apos;ordre" meaningIt="Numero progressivo" meaningEn="en_Laufnummer" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="11" meaningDe="Packung zu" meaningFr="Emballage à" meaningIt="Pacco da" meaningEn="en_Packung zu" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="12" meaningDe="Anzahl Sortimente" meaningFr="Nombre d&apos;assortiments" meaningIt="Quantità di assortimenti" meaningEn="en_Anzahl Sortimente" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="13" meaningDe="Filter/Mundstueck" meaningFr="Filtre/bec" meaningIt="Filtro/bocchino" meaningEn="en_Filter/Mundstueck" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="14" meaningDe="Menthol" meaningFr="Menthol" meaningIt="Mentolo" meaningEn="en_Menthol" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="15" meaningDe="Tabakersatz" meaningFr="Succédané de tabac" meaningIt="Succedanei del tabacco" meaningEn="en_Tabakersatz" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="16" meaningDe="Slim" meaningFr="Slim" meaningIt="Slim" meaningEn="en_Slim" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="17" meaningDe="Laengenabgrenzung" meaningFr="Limite de longueur" meaningIt="Limite secondo la lunghezza" meaningEn="en_Laengenabgrenzung" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="18" meaningDe="Kopfzigarrentyp" meaningFr="Genre de cigares à bouts tournés" meaningIt="Tipo di sigari Avana" meaningEn="en_Kopfzigarrentyp" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="19" meaningDe="Anzahl in Verpackung" meaningFr="Nombre de pièces dans l&apos;emballage" meaningIt="Quantità per imballaggio" meaningEn="en_Anzahl in Verpackung" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="20" meaningDe="Verpackungstyp" meaningFr="Genre d&apos;emballage" meaningIt="Tipo di imballaggio" meaningEn="en_Verpackungstyp" validFrom="2004-01-01" validTo="2012-03-29" validForImport="true" validForExport="true" />
			<entry value="21" meaningDe="Filter/Mundstueck separat versteuern?" meaningFr="Imposer séparément filtre/bec?" meaningIt="Tassazione separata per filtro e bocchino?" meaningEn="en_Filter/Mundstueck separat versteuern?" validFrom="2004-01-01" validTo="2013-04-01" validForImport="true" validForExport="true" />
			<entry value="22" meaningDe="Gewicht Tabak" meaningFr="Poids tabac" meaningIt="Peso del tabacco" meaningEn="en_Gewicht Tabak" validFrom="2004-01-01" validTo="2013-04-01" validForImport="true" validForExport="true" />
			<entry value="23" meaningDe="Gewicht Filter/Mundstueck" meaningFr="Poids filtre/bec" meaningIt="Peso del filtro/bocchino" meaningEn="en_Gewicht Filter/Mundstueck" validFrom="2004-01-01" validTo="2013-04-01" validForImport="true" validForExport="true" />
			<entry value="24" meaningDe="Kleinhandelspreis" meaningFr="Prix de détail" meaningIt="Prezzo al dettaglio" meaningEn="en_Kleinhandelspreis" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="25" meaningDe="Tabaksorte" meaningFr="Sorte de tabac" meaningIt="Tipo del tabacco" meaningEn="en_Tabaksorte" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="26" meaningDe="Lager Nr." meaningFr="entrepôt No." meaningIt="Deposito No." meaningEn="en_Lager Nr." validFrom="2009-05-29" validTo="2999-12-31" validForImport="false" validForExport="true" />
			<entry value="27" meaningDe="Export Code" meaningFr="fr_Export_Code" meaningIt="it_Export_Code" meaningEn="en_Export_Code" validFrom="2004-01-01" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="27" meaningDe="Export Code" meaningFr="Code export" meaningIt="Codice d&apos;esportazione" meaningEn="en_Export_Code" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="28" meaningDe="Freizonenverkehr" meaningFr="Trafic zones franches" meaningIt="Traffico zone franche" meaningEn="eng_Freizonenverkehr" validFrom="2011-10-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="28" meaningDe="Freizonenverkehr" meaningFr="Trafic zones franches" meaningIt="Traffico zone franche" meaningEn="eng_Freizonenverkehr" validFrom="2011-03-29" validTo="2011-10-04" validForImport="true" validForExport="true" />
			<entry value="29" meaningDe="Grenzzonenverkehr" meaningFr="Trafic frontière" meaningIt="Traffico di confine" meaningEn="en_Grenzzonenverkehr" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="incoterms">
			<entry value="CFR" meaningDe="(CFR) Kosten und Fracht" meaningFr="(CFR) coût et fret" meaningIt="(CFR) costo e nolo" meaningEn="CFR" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CFR" meaningDe="Kosten und Fracht" meaningFr="coût et fret" meaningIt="costo e nolo" meaningEn="CFR" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="CIF" meaningDe="Kosten, Versicherung, Fracht" meaningFr="coût, assurance et fret" meaningIt="costo, assicurazione e nolo" meaningEn="CIF" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="CIF" meaningDe="(CIF) Kosten, Versicherung, Fracht" meaningFr="(CIF) coût, assurance et fret" meaningIt="(CIF) costo, assicurazione e nolo" meaningEn="CIF" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CIP" meaningDe="frachtfrei versichert" meaningFr="port payé, assurance comprise, jusqu&apos;à" meaningIt="trasporto e assicurazione pagati fino a" meaningEn="CIP" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="CIP" meaningDe="(CIP) frachtfrei versichert" meaningFr="(CIP) port payé, assurance comprise, jusqu&apos;à" meaningIt="(CIP) trasporto e assicurazione pagati fino a" meaningEn="CIP" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CPT" meaningDe="frachtfrei" meaningFr="port payé jusqu&apos;à" meaningIt="trasporto pagato fino a" meaningEn="CPT" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="CPT" meaningDe="(CPT) frachtfrei" meaningFr="(CPT) port payé jusqu&apos;à" meaningIt="(CPT) trasporto pagato fino a" meaningEn="CPT" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DAF" meaningDe="(DAF) geliefert Grenze" meaningFr="(DAF) rendu frontière" meaningIt="(DAF) reso frontiera" meaningEn="DAF" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DAF" meaningDe="geliefert Grenze" meaningFr="rendu frontière" meaningIt="reso frontiera" meaningEn="DAF" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="DAP" meaningDe="geliefert am - (Ort)" meaningFr="livré au lieu choisi - (lieu)" meaningIt="consegnato a - (luogo)" meaningEn="delivered at place - (place)" validFrom="2011-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="DAP" meaningDe="(DAP) geliefert am - (Ort)" meaningFr="(DAP) livré au lieu choisi - (lieu)" meaningIt="(DAP) consegnato a - (luogo)" meaningEn="(DAP) delivered at place - (place)" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DAT" meaningDe="geliefert am Terminal - (....)" meaningFr="livré au terminal - (....)" meaningIt="consegnata in terminal - (....)" meaningEn="delivered at terminal - (....)" validFrom="2011-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="DAT" meaningDe="(DAT) geliefert am Terminal - (....)" meaningFr="(DAT) livré au terminal - (....)" meaningIt="(DAT) consegnata in terminal - (....)" meaningEn="(DAT) delivered at terminal - (....)" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DDP" meaningDe="geliefert verzollt" meaningFr="rendu droits acquittés" meaningIt="reso sdoganato" meaningEn="DDP" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="DDP" meaningDe="(DDP) geliefert verzollt" meaningFr="(DDP) rendu droits acquittés" meaningIt="(DDP) reso sdoganato" meaningEn="DDP" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DDU" meaningDe="geliefert unverzollt" meaningFr="rendu droits non acquittés" meaningIt="reso non sdoganato" meaningEn="DDU" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="DDU" meaningDe="(DDU) geliefert unverzollt" meaningFr="(DDU) rendu droits non acquittés" meaningIt="(DDU) reso non sdoganato" meaningEn="DDU" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DEQ" meaningDe="geliefert ab Kai" meaningFr="rendu à quai" meaningIt="reso banchina" meaningEn="DEQ" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="DEQ" meaningDe="(DEQ) geliefert ab Kai" meaningFr="(DEQ) rendu à quai" meaningIt="(DEQ) reso banchina" meaningEn="DEQ" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DES" meaningDe="geliefert ab Schiff" meaningFr="rendu ex ship" meaningIt="reso ex ship" meaningEn="DES" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="DES" meaningDe="(DES) geliefert ab Schiff" meaningFr="(DES) rendu ex ship" meaningIt="(DES) reso ex ship" meaningEn="DES" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EXW" meaningDe="(EXW) ab Werk" meaningFr="(EXW) à l&apos;usine" meaningIt="(EXW) franco fabbrica" meaningEn="EXW" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EXW" meaningDe="ab Werk" meaningFr="à l&apos;usine" meaningIt="franco fabbrica" meaningEn="EXW" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="FAS" meaningDe="(FAS) frei Längsseite Schiff" meaningFr="(FAS) franco le long du navire" meaningIt="(FAS) franco lungo bordo" meaningEn="FAS" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FAS" meaningDe="frei Längsseite Schiff" meaningFr="franco le long du navire" meaningIt="franco lungo bordo" meaningEn="FAS" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="FCA" meaningDe="frei Frachtführer" meaningFr="franco transporteur" meaningIt="franco vettore" meaningEn="FCA" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			<entry value="FCA" meaningDe="(FCA) frei Frachtführer" meaningFr="(FCA) franco transporteur" meaningIt="(FCA) franco vettore" meaningEn="FCA" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FOB" meaningDe="(FOB) frei an Bord" meaningFr="(FOB) franco bord" meaningIt="(FOB) franco a bordo" meaningEn="FOB" validFrom="2011-07-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FOB" meaningDe="frei an Bord" meaningFr="franco bord" meaningIt="franco a bordo" meaningEn="FOB" validFrom="2004-01-01" validTo="2011-07-20" validForImport="true" validForExport="true" />
			</domain>
			<domain name="initiator">
			<entry value="0" meaningDe="Zollpersonal" meaningFr="Personnel douanier" meaningIt="Personale doganale" meaningEn="en_Zollpersonal" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Kunde" meaningFr="Client" meaningIt="Partner" meaningEn="en_Kunde" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="injunctionType">
			<entry value="0" meaningDe="Ohne Zusatzbeleg" meaningFr="Sans justificatif supplémentaire" meaningIt="senza giustivicativo supplementare" meaningEn="en_Ohne Zusatzbeleg" validFrom="2007-05-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Zusatzveranlagungsverfügung Zoll" meaningFr="décisions de taxation douane supplémentaire" meaningIt="decisione di tassazione del dazio supplementare" meaningEn="en_Zusatzveranlagungsverfügung Zoll" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Zusatzveranlagungsverfügung (Ausfuhrbeiträge)" meaningFr="Décision de taxation supplémentaire (contributions à l&apos;exportation)" meaningIt="Decisione d&apos;imposizione supplementare (contributi all&apos;esportazione) " meaningEn="en_Zusatzveranlagungsverfügung (Ausfuhrbeiträge)" validFrom="2007-05-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="invoiceCurrencyType">
			<entry value="1" meaningDe="Schweizer Franken (CHF)" meaningFr="Franc Suisse (CHF)" meaningIt="Franco Svizzero (CHF)" meaningEn="Swiss Franc (CHF)" validFrom="2011-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Schweizer Franken (CHF)" meaningFr="Franc Suisse (CHF)" meaningIt="Franco Svizzero (CHF)" meaningEn="Swiss Franc (CHF)" validFrom="2004-01-01" validTo="2011-01-01" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Euro (EUR)" meaningFr="Euro (EUR)" meaningIt="Euro (EUR)" meaningEn="Euro (EUR)" validFrom="2004-01-01" validTo="2011-01-01" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Euro (EUR)" meaningFr="Euro (EUR)" meaningIt="Euro (EUR)" meaningEn="Euro (EUR)" validFrom="2011-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Andere von EU (GBP,DKK usw)" meaningFr="Autres monnaies UE (GBP,DKK usw)" meaningIt="oltre valuta del&apos;UE (GBP,DKK usw)" meaningEn="Other currency of EU (GBP,DKK usw)" validFrom="2004-01-01" validTo="2011-01-01" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="andere Währungen der EU (GBP,DKK usw.)" meaningFr="autre monnaies UE (GBP,DKK etc.)" meaningIt="altre monete dell&apos;UE (GBP,DKK etc.)" meaningEn="other currencies of the EU (GBP,DKK ecc.)" validFrom="2011-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="US-Dollar (USD)" meaningFr="Dollar USA (USD)" meaningIt="Dollaro USA (USD)" meaningEn="US Dollar (USD)" validFrom="2011-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="US-Dollar (USD)" meaningFr="Dollar USA (USD)" meaningIt="Dollaro USA (USD)" meaningEn="US Dollar (USD)" validFrom="2004-01-01" validTo="2011-01-01" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Andere" meaningFr="Autres" meaningIt="Oltre" meaningEn="Other" validFrom="2011-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Andere" meaningFr="Autres" meaningIt="Oltre" meaningEn="Other" validFrom="2004-01-01" validTo="2011-01-01" validForImport="true" validForExport="true" />
			</domain>
			<domain name="Kontrollgrund.Kontrollgrund">
			<entry value="110" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="eng_Andere" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="111" meaningDe="auf Wunsch ZA (Beilad/Ablad)" meaningFr="selon le vux du bureau (chargement/déchargement)" meaningIt="Su richiesta ID (concarico/scarico)" meaningEn="eng_auf Wunsch ZA (Beilad/Ablad)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="112" meaningDe="ex Ladungskontrolle" meaningFr="ex Contrôle de chargement" meaningIt="da controllo carico" meaningEn="eng_ex Ladungskontrolle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="113" meaningDe="Kontrolle VOC" meaningFr="Contrôle COV" meaningIt="controllo COV" meaningEn="eng_Kontrolle VOC" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="114" meaningDe="LA/LV" meaningFr="MP / CP" meaningIt="Mandato/Convenzione prestazioni" meaningEn="eng_LA/LV" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="115" meaningDe="MOBS" meaningFr="Scanner mobile" meaningIt="Scanner mobile" meaningEn="eng_MOBS" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="115" meaningDe="MOBS" meaningFr="Scanner mobile" meaningIt="MOBS" meaningEn="eng_MOBS" validFrom="2006-01-01" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="116" meaningDe="periodisch" meaningFr="périodique" meaningIt="periodico" meaningEn="eng_periodisch" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="117" meaningDe="RA ZI" meaningFr="AR ID" meaningIt="AR ID" meaningEn="eng_RA ZI" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="118" meaningDe="RA OZD" meaningFr="AR DGD" meaningIt="AR DGD" meaningEn="eng_RA OZD" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="119" meaningDe="Revisionsplanung" meaningFr="Plan de vérification" meaningIt="Pianificazione visite" meaningEn="eng_Revisionsplanung" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="120" meaningDe="spontan" meaningFr="Spontanné" meaningIt="spontaneo" meaningEn="eng_spontan" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="121" meaningDe="Weisungen KD/OZD" meaningFr="Ordres DA / DGD" meaningIt="Direttive DGD/DC" meaningEn="eng_Weisungen KD/OZD" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="290" meaningDe="Inventarkontrolle" meaningFr="Contrôle Inventaire" meaningIt="Controllo Inventario" meaningEn="eng_Inventarkontrolle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="291" meaningDe="Bestandeskontrolle" meaningFr="Contrôle de stock" meaningIt="Controllo della scorte" meaningEn="eng_Bestandeskontrolle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="292" meaningDe="Verlaufskontrolle" meaningFr="Contrôle du déroulement" meaningIt="Controllo percorso" meaningEn="eng_Verlaufskontrollle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="293" meaningDe="Sicherheitskontrolle" meaningFr="Contrôle de sécurité" meaningIt="Controllo di sicurezza" meaningEn="eng_Sicherheitskontrolle" validFrom="2011-03-29" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="language">
			<entry value="de" meaningDe="Deutsch" meaningFr="Allemand" meaningIt="Tedesco" meaningEn="German" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="en" meaningDe="Englisch" meaningFr="Anglais" meaningIt="Inglese" meaningEn="English" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="fr" meaningDe="Französisch" meaningFr="Français" meaningIt="Francese" meaningEn="French" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="it" meaningDe="Italienisch" meaningFr="Italien" meaningIt="Italiano" meaningEn="Italian" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="Massnahmen.Art">
			<entry value="127" meaningDe="31.48 Feststellungsprotokoll LSVA" meaningFr="31.48 Procès-verbal de constat RPLP" meaningIt="31.48 - PV constatazione TTPCP" meaningEn="eng_31.48 Feststellungsprotokoll LSVA" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="128" meaningDe="31.49 Tatbestandsprotokoll" meaningFr="31.49 Procès-Verbal" meaningIt="31.49 - PV contravvenzione - Altre leggi" meaningEn="eng_31.49 Tatbestandsprotokoll" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="129" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="eng_Andere" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="130" meaningDe="andere Zollkontrolle" meaningFr="Autre contrôle douanier" meaningIt="Altro controllo doganale" meaningEn="eng_andere Zollkontrolle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="131" meaningDe="Annulation der Deklaration" meaningFr="Annulation de déclaration" meaningIt="Annullamento dichiarazione" meaningEn="eng_Annulation der Deklaration" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="132" meaningDe="Anzeige" meaningFr="Annonce" meaningIt="Denuncia" meaningEn="eng_Anzeige" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="133" meaningDe="Beschau" meaningFr="Vérification" meaningIt="Visita doganale" meaningEn="eng_Beschau" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="134" meaningDe="Beschlagnahme" meaningFr="Séquestre" meaningIt="Sequestro" meaningEn="eng_Beschlagnahme" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="135" meaningDe="Korrektur ohne Strafverfahren" meaningFr="Correction sans procédure pénale" meaningIt="Correzione senza PP" meaningEn="eng_Korrektur ohne Strafverfahren" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="136" meaningDe="Lebensmittel Rapport (ohne Muster)" meaningFr="Rapport CDA (sans échantillon)" meaningIt="Rapporto RDA (senza campione)" meaningEn="eng_Lebensmittel Rapport (ohne Muster)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="137" meaningDe="Markenname" meaningFr="Marque" meaningIt="marca" meaningEn="eng_Markenname" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="138" meaningDe="Meldung D60 Geistiges Eigentum" meaningFr="Annonce propriété intellectuelle D 60" meaningIt="Annuncio D.60 - Proprietà intellettuale" meaningEn="eng_Meldung D60 Geistiges Eigentum" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="139" meaningDe="Meldung D60 Swissmedic" meaningFr="Annonce Swissmedic D 60" meaningIt="Annuncio D.60 - Swissmedic" meaningEn="eng_Meldung D60 Swissmedic" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="140" meaningDe="Meldung RA Team OZD" meaningFr="Annonce AR team DGD" meaningIt="Notifica Team AR DGD" meaningEn="eng_Meldung RA Team OZD" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="141" meaningDe="Muster CTK" meaningFr="Echantillion contrôle chimico technique" meaningIt="Campione DGD - Sez. C+T" meaningEn="eng_Muster CTK" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="142" meaningDe="Muster KD" meaningFr="Echantillon à DA" meaningIt="Campione DC" meaningEn="eng_Muster KD" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="143" meaningDe="Muster LMK (inkl. Rapport)" meaningFr="Echantillon denrées alimentaires (y compris rapport)" meaningIt="Campione RDA (incl. Rapporto)" meaningEn="eng_Muster LMK (inkl. Rapport)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="144" meaningDe="Muster OZD" meaningFr="Echantillon à DGD" meaningIt="Campione DGD - Altro" meaningEn="eng_Muster OZD" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="145" meaningDe="Nachbezug" meaningFr="Perception subséquente" meaningIt="Riscossione posticipata" meaningEn="eng_Nachbezug" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="146" meaningDe="Nachkontrolle" meaningFr="Contrôle ultérieur" meaningIt="Controllo posticipato" meaningEn="eng_Nachkontrolle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="147" meaningDe="Ordnungsbusse (31.36)" meaningFr="Amende d&apos;ordre (31.36)" meaningIt="31.36 - PP abbreviata - IPO" meaningEn="eng_Ordnungsbusse (31.36)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="148" meaningDe="Polizeikontrolle" meaningFr="Contrôle de police" meaningIt="Controllo di polizia" meaningEn="eng_Polizeikontrolle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="149" meaningDe="Rückerstattung" meaningFr="Remboursement" meaningIt="Rimborso" meaningEn="eng_Rückerstattung" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="150" meaningDe="Sendung/Fz zurückweisen" meaningFr="Envoi/vhc à refouler" meaningIt="Veicolo/invio respinto" meaningEn="eng_Sendung/Fz zurückweisen" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="151" meaningDe="Strafverfahren abgekürzt - Art (31.34/31.35)" meaningFr="MRPS - Genre (31.34 /35)" meaningIt="31.34/31.35 - PP abbreviata" meaningEn="eng_Strafverfahren abgekürzt - Art (31.34/31.35)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="152" meaningDe="Strafverfahren abgekürzt - Art (31.37, LSVA)" meaningFr="MRPS - Genre (31.37 RPLP)" meaningIt="31.37 - PP abbreviata TTPCP" meaningEn="eng_Strafverfahren abgekürzt - Art (31.37, LSVA)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="153" meaningDe="Strafverfahren ordentlich (31.30)" meaningFr="Procès-verbal final (31.30)" meaningIt="31.30 - PP ordinaria" meaningEn="eng_Strafverfahren ordentlich (31.30)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="154" meaningDe="Überweisung an Polizei" meaningFr="Transmission à la police" meaningIt="Consegna alla polizia" meaningEn="eng_Überweisung an Polizei" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="155" meaningDe="Ursprungskontrolle (19.75)" meaningFr="Contrôle d&apos;origine (19.75)" meaningIt="Controllo origine (19.75)" meaningEn="eng_Ursprungskontrolle (19.75)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="156" meaningDe="Verwarnung" meaningFr="Avertissement" meaningIt="Ammonimento" meaningEn="eng_Verwarnung" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="157" meaningDe="Weitergehende Abklärungen" meaningFr="Eclairsissement complémentaire" meaningIt="Riscossione posticipata" meaningEn="eng_Weitergehende Abklärungen" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="268" meaningDe="Ladungskontrolle" meaningFr="Contrôle de chargement" meaningIt="Controllo carico" meaningEn="eng_Ladungskontrolle" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="288" meaningDe="Umlad/Ablad" meaningFr="Transbordement / Déchargement" meaningIt="Trasbordo / Scaricare" meaningEn="eng_Umlad/Ablad" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="methodOfPayment">
			<entry value="A" meaningDe="Barebezahlung" meaningFr="Paiement cash" meaningIt="Pagamento in contanti" meaningEn="Payment in cash" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="A" meaningDe="Barzahlung" meaningFr="Paiement cash" meaningIt="Pagamento in contanti" meaningEn="Payment in cash" validFrom="2011-10-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="A" meaningDe="Barebezahlung" meaningFr="Paiement cash" meaningIt="Pagamento in contanti" meaningEn="Payment in cash" validFrom="2011-01-02" validTo="2011-10-05" validForImport="true" validForExport="true" />
			<entry value="B" meaningDe="Kreditkarte" meaningFr="Paiement par carte de crédit" meaningIt="Pagamento con carta di credito" meaningEn="Payment by credit card" validFrom="2011-01-02" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C" meaningDe="Check" meaningFr="Paiement par chèque" meaningIt="Pagamento con asegno" meaningEn="Payment by cheque" validFrom="2011-01-02" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="C" meaningDe="Check" meaningFr="Paiement par chèque" meaningIt="Pagamento con assegno" meaningEn="Payment by cheque" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="D" meaningDe="Andere" meaningFr="Autre" meaningIt="Altri" meaningEn="Other" validFrom="2011-01-02" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="H" meaningDe="Elektronischer Zahlungsverkehr" meaningFr="Transfert électronique de crédit" meaningIt="Trasferimento elettronico del credito" meaningEn="Electronic credit transfer" validFrom="2011-01-02" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y" meaningDe="Kontoinhaber entspricht Beförderer" meaningFr="Titulaire du compte auprès du transporteur" meaningIt="Titolare del conto presso il vettore" meaningEn="Account holder with carrier" validFrom="2014-03-28" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y" meaningDe="Kontoinhaber beim Beförderer" meaningFr="Titulaire de compte avec le transporteur" meaningIt="Titolare del conto presso il vettore" meaningEn="Account holder with carrier" validFrom="2011-12-20" validTo="2014-03-28" validForImport="true" validForExport="true" />
			<entry value="Y" meaningDe="Kontoinhaber beim Beförderer" meaningFr="Titulaire de compte avec le transporteur" meaningIt="Il vettore e intestatario del conto" meaningEn="Account holder with carrier" validFrom="2011-01-02" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Z" meaningDe="Keine Vorauszahlung" meaningFr="Pas de prépaiement" meaningIt="Nessun pagamento anticipato" meaningEn="Not pre-paid" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Z" meaningDe="Keine Vorauszahlung" meaningFr="Pas de prépaiement" meaningIt="Nessun pagamento in anticipo" meaningEn="Not pre-paid" validFrom="2011-01-02" validTo="2011-12-20" validForImport="true" validForExport="true" />
			</domain>
			<domain name="nonCustomsLawObligation">
			<entry value="0" meaningDe="0 NZE nein" meaningFr="0 ALAD non" meaningIt="0 DNND no" meaningEn="en_0 NZE nein" validFrom="2000-11-22" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="1 NZE ja" meaningFr="1 ALAD oui" meaningIt="1 DNND sì" meaningEn="en_1 NZE ja" validFrom="2000-11-22" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="2 NZE nein" meaningFr="2 ALAD non" meaningIt="2 DNND no" meaningEn="en_2 NZE nein" validFrom="2000-11-22" validTo="2070-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="nonCustomsLawType">
			<entry value="26" meaningDe="Kulturgut" meaningFr="Bien culturel" meaningIt="Bene culturale" meaningEn="Cultural property" validFrom="2008-05-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="30" meaningDe="PIC" meaningFr="PIC" meaningIt="PIC" meaningEn="PIC" validFrom="2005-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="44" meaningDe="Radioaktive Stoffe" meaningFr="Matières radioactives" meaningIt="Materiali radioattivi" meaningEn="Radioactive substances" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="66" meaningDe="Abfälle (gelbes Kontrollverfahren)" meaningFr="Déchets (procédure de contrôle orange)" meaningIt="Rifiuti (procedura di controllo ambra)" meaningEn="Waste (amber control procedure)" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="67" meaningDe="Abfälle (grünes Kontrollverfahren)" meaningFr="Déchets (procédure de contrôle verte)" meaningIt="Rifiuti (procedura di controllo verde)" meaningEn="Waste (green control procedure)" validFrom="2014-07-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="68" meaningDe="Elektr.-Schrott" meaningFr="Débris électriques électroniques" meaningIt="Rottame elettrico" meaningEn="Electric waste/scrap" validFrom="1999-10-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="69" meaningDe="Altholz" meaningFr="Bois usagé" meaningIt="Legno vecchio" meaningEn="Used wood" validFrom="1999-10-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="100" meaningDe="Fleisch/ Fleischwaren (Veterinärrecht)" meaningFr="Viandes/ produits carnés (Législation vétérinaire)" meaningIt="Carne/ prodotti carnei (Legislazione veterinaria)" meaningEn="Meat/ meat preparations (Veterinary Legislation)" validFrom="1988-01-01" validTo="2014-07-31" validForImport="true" validForExport="true" />
			<entry value="110" meaningDe="Alkohol" meaningFr="f" meaningIt="i" meaningEn="e" validFrom="1988-01-01" validTo="1999-09-30" validForImport="true" validForExport="true" />
			<entry value="190" meaningDe="Veterinärrecht und CITES Fauna" meaningFr="Législation vétérinaire et CITES Fauna" meaningIt="Legislazione veterinaria e CITES Fauna" meaningEn="Veterinary Legislation and CITES Fauna" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="200" meaningDe="Artenschutz (Veterinärrecht)" meaningFr="Conservation des espèces (Législation vétérinaire)" meaningIt="Protezione delle specie (Legislazione veterinaria)" meaningEn="Species conservation (Veterinary Legislation)" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="201" meaningDe="CITES Flora" meaningFr="CITES Flora" meaningIt="CITES Flora" meaningEn="CITES Flora" validFrom="2004-02-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="210" meaningDe="Edelmetallkontrolle" meaningFr="Contrôle des métaux précieux" meaningIt="Controllo dei metalli preziosi" meaningEn="Precious Metals Control" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="220" meaningDe="Salzregal" meaningFr="Régale des sels" meaningIt="Regalia del sale" meaningEn="Salt monopoly" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="270" meaningDe="Pflanzenschutz" meaningFr="Protection des végétaux" meaningIt="Protezione dei vegetali" meaningEn="Plant protection" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="packagingType">
			<entry value="AA" meaningDe="Massengutbehälter, mittelgross, sta" meaningFr="Grand récipient pour vrac, en plast" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, rigid " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="AA" meaningDe="Massengutbehälter, mittelgross, starrer Kunststoff" meaningFr="Grand récipient pour vrac, en plastique rigide" meaningIt="Contenitore di grandi dimensioni per rinfuse, di plastica rigida" meaningEn="Intermediate bulk container, rigid plastic" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AB" meaningDe="Behältnis, Holzfaser" meaningFr="Réceptacle en carton" meaningIt="Recipiente di cartone" meaningEn="Receptacle, fibre" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AC" meaningDe="Behältnis, Papier" meaningFr="Réceptacle en papier" meaningIt="Recipiente di carta" meaningEn="Receptacle, paper" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AD" meaningDe="Behältnis, Holz" meaningFr="Réceptacle en bois" meaningIt="Recipiente di legno" meaningEn="Receptacle, wooden" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AE" meaningDe="Aerosol" meaningFr="Aérosol" meaningIt="Aerosol" meaningEn="Aerosol" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AF" meaningDe="Palette, modular, Manschette 80 cm " meaningFr="Palette modulaire, rehausses de dim" meaningIt="Paletta modulare, con piedini di 80" meaningEn="Pallet, modular, collars 80cms * 60" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="AF" meaningDe="Palette, modular, Manschette 80 cm x 60 cm" meaningFr="Palette modulaire, rehausses de dimensions 80 x 60 cm" meaningIt="Paletta modulare, con piedini di 80 x 60 cm" meaningEn="Pallet, modular, collars 80cms * 60cms" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AG" meaningDe="Palette, eingeschweisst" meaningFr="Palette, housse thermorétractable" meaningIt="Paletta con rivestimento termoretra" meaningEn="Pallet, shrinkwrapped" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="AG" meaningDe="Palette, eingeschweisst" meaningFr="Palette, housse thermorétractable" meaningIt="Paletta con rivestimento termoretrattile" meaningEn="Pallet, shrinkwrapped" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AH" meaningDe="Palette, 100 cm x 110 cm" meaningFr="Palette, 100 x 110 cm" meaningIt="Paletta 100 x 110 cm" meaningEn="Paleete, 100cms * 110cms" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AI" meaningDe="Halbschale" meaningFr="Blister double coque" meaningIt="Cestello con coperchio a cerniera (" meaningEn="Clamshell" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="AI" meaningDe="Halbschale" meaningFr="Blister double coque" meaningIt="Cestello con coperchio a cerniera (&quot;clamshell&quot;)" meaningEn="Clamshell" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AJ" meaningDe="Kegel" meaningFr="Cornet" meaningIt="Cono" meaningEn="Cone" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AL" meaningDe="Ball" meaningFr="Bille" meaningIt="Palla" meaningEn="Ball" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AM" meaningDe="Ampulle, ungeschützt" meaningFr="Ampoule, non protégée" meaningIt="Ampolla, non protetta" meaningEn="Ampoule, non protected" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AP" meaningDe="Ampulle, geschützt" meaningFr="Ampoule, protégée" meaningIt="Ampolla, protetta" meaningEn="Ampoule, protected" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AT" meaningDe="Zerstäuber" meaningFr="Atomiseur" meaningIt="Atomizzatore" meaningEn="Atomizer" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="AV" meaningDe="Kapsel/Patrone" meaningFr="Capsule" meaningIt="Capsula" meaningEn="Capsule" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BA" meaningDe="Fass" meaningFr="Tonneau" meaningIt="Barile" meaningEn="Barrel" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BB" meaningDe="Spule" meaningFr="Bobine" meaningIt="Bobina" meaningEn="Bobbin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BC" meaningDe="Flaschenkasten, -gestell" meaningFr="Bouteilles en rack" meaningIt="Cassetta, rastrelliera per bottiglie" meaningEn="Bottlecrate, bottlerack" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BD" meaningDe="Brett" meaningFr="Plateau" meaningIt="Tavola" meaningEn="Board" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BE" meaningDe="Bündel" meaningFr="Paquet" meaningIt="Fascio" meaningEn="Bundle" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BF" meaningDe="Ballon, nicht geschützt" meaningFr="Ballon, non protégé" meaningIt="Pallone, non protetto" meaningEn="Balloon, non protected" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BG" meaningDe="Beutel, Tüte" meaningFr="Sac" meaningIt="Borsa, sacco" meaningEn="Bag" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BH" meaningDe="Bund" meaningFr="Botte, ballot" meaningIt="Fascio" meaningEn="Bunch" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BI" meaningDe="Behälter" meaningFr="Casier" meaningIt="Recipiente" meaningEn="Bin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BJ" meaningDe="Eimer" meaningFr="Seau" meaningIt="Secchio" meaningEn="Bucket" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BK" meaningDe="Korb" meaningFr="Panier" meaningIt="Canestro" meaningEn="Basket" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BL" meaningDe="Ballen, gepresst" meaningFr="Balle, compressée" meaningIt="Balla, compressa" meaningEn="Bale, compressed" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BM" meaningDe="Schale" meaningFr="Cuvette" meaningIt="Vaschetta" meaningEn="Basin" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BN" meaningDe="Ballen, nicht gepresst" meaningFr="Balle, non compressée" meaningIt="Balla, non compressa" meaningEn="Bale, non compressed" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BO" meaningDe="Flasche, ungeschützt, zylindrisch" meaningFr="Bouteille, non protégée, cylindrique" meaningIt="Bottiglia, non protetta, cilindrica" meaningEn="Bottle, non protected, cylindrical" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BP" meaningDe="Ballon, geschützt" meaningFr="Ballon, protégé" meaningIt="Pallone, protetto" meaningEn="Balloon, protected" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BQ" meaningDe="Flasche, geschützt, zylindrisch" meaningFr="Bouteille, protégée, cylindrique" meaningIt="Bottiglia, cilindrica, protetta" meaningEn="Bottle, protected cylindrical" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BR" meaningDe="Stab" meaningFr="Barre" meaningIt="Barra" meaningEn="Bar" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BS" meaningDe="Flasche, ungeschützt, bauchig" meaningFr="Bouteille, non protégée, renflée" meaningIt="Bottiglia, non protetta, convessa" meaningEn="Bottle, non protected, bulbous" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BT" meaningDe="Ballen" meaningFr="Balle, ballot" meaningIt="Balle" meaningEn="bolt" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BU" meaningDe="Kolben" meaningFr="Tonneau" meaningIt="Barile" meaningEn="Butt" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BV" meaningDe="Flasche, geschützt, bauchig" meaningFr="Bouteille, protégée, renflée" meaningIt="Bottiglia, convessa, protetta" meaningEn="Bottle, protected bulbous" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BW" meaningDe="Kasten, für Flüssigkeiten" meaningFr="Caisse pour liquides" meaningIt="Cassa (&quot;box&quot;) per liquidi" meaningEn="Box, for liquids" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BX" meaningDe="Schachtel" meaningFr="Boîte" meaningIt="Scatola" meaningEn="Box" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BY" meaningDe="Bretter, im Bund" meaningFr="Plateau, en paquet/botte" meaningIt="Pannello, in pacchi/mazzi/fasci" meaningEn="Board, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="BZ" meaningDe="Stäbe, im Bund" meaningFr="Barre,  en paquet/botte" meaningIt="Barre, in pacchi/mazzi/fasci" meaningEn="Bars, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="B4" meaningDe="Gurt" meaningFr="Courroie" meaningIt="Cintura" meaningEn="Belt" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CA" meaningDe="Dose, rechteckig" meaningFr="Boîte, rectangulaire" meaningIt="Barattolo, rettangolare" meaningEn="Can, rectangular" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CB" meaningDe="Harrasse, Bierkasten" meaningFr="Caisse de bière" meaningIt="Cassa della birra" meaningEn="Beer crate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CC" meaningDe="Milchkanne" meaningFr="Bidon" meaningIt="Zangola" meaningEn="Churn" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CD" meaningDe="Kanne, mit Henkel und Ausguss" meaningFr="Bidon avec anse et bec verseur" meaningIt="Bidone con manico e beccuccio" meaningEn="Can, with handle and spout" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CE" meaningDe="Weidenkorb" meaningFr="Panier de pêche" meaningIt="Paniere" meaningEn="Creel" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CF" meaningDe="Truhe" meaningFr="Coffre" meaningIt="Cofanetto" meaningEn="Coffer" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CG" meaningDe="Käfig" meaningFr="Cage" meaningIt="Gabbia" meaningEn="Cage" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CH" meaningDe="Kiste" meaningFr="Caisse" meaningIt="Cassa" meaningEn="Chest" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CI" meaningDe="Kanister" meaningFr="Boîte" meaningIt="Bidone" meaningEn="Canister" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CJ" meaningDe="Sarg" meaningFr="Cercueil" meaningIt="Bara" meaningEn="Coffin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CK" meaningDe="Fass, hölzern" meaningFr="Tonneau" meaningIt="Botte" meaningEn="Cask" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CL" meaningDe="Spule" meaningFr="Bobine" meaningIt="Bobina" meaningEn="Coil" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CM" meaningDe="Trägerpappe" meaningFr="Carte (&quot;card&quot;)" meaningIt="Cartoncino (&quot;card&quot;)" meaningEn="Card" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CN" meaningDe="Container, nicht anders als Beförde" meaningFr="Conteneur, sans autre précisions qu" meaningIt="Contenitore senza altra precisione" meaningEn="Container, not otherwise specified " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="CN" meaningDe="Container, nicht anders als Beförderungsausrüstung angegeben" meaningFr="Conteneur, sans autre précisions qu&apos;équipement de transport" meaningIt="Contenitore senza altra precisione" meaningEn="Container, not otherwise specified as transport equipment" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CO" meaningDe="Korbflasche, ungeschützt" meaningFr="Bonbonne, protégée" meaningIt="Fiasco, non protetto" meaningEn="Carboy, non protected" validFrom="2004-11-05" validTo="2006-06-21" validForImport="true" validForExport="true" />
			<entry value="CO" meaningDe="Korbflasche, ungeschützt" meaningFr="Bonbonne non protégée" meaningIt="Fiasco, non protetto" meaningEn="Carboy, non protected" validFrom="2006-06-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CP" meaningDe="Korbflasche, geschützt" meaningFr="Bonbonne protégée" meaningIt="Fiasco, protetto" meaningEn="Carboy, protected" validFrom="2006-06-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CP" meaningDe="Korbflasche, geschützt" meaningFr="Bonbonne, non protégée" meaningIt="Fiasco, protetto" meaningEn="Carboy, protected" validFrom="2004-11-05" validTo="2006-06-21" validForImport="true" validForExport="true" />
			<entry value="CQ" meaningDe="Patrone" meaningFr="Cartouche" meaningIt="Cartuccia" meaningEn="Cartridge" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CR" meaningDe="Lattenkiste" meaningFr="Caisse" meaningIt="Cassetta" meaningEn="Crate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CS" meaningDe="Kasten / Kästchen" meaningFr="Caisse" meaningIt="Cassa/cassetta" meaningEn="Case" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CT" meaningDe="Karton" meaningFr="Carton" meaningIt="Cartone" meaningEn="Carton" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CU" meaningDe="Becher" meaningFr="Coupe" meaningIt="Coppa" meaningEn="Cup" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CV" meaningDe="Hülle, Deckel, Überzug" meaningFr="Housse, couvercle" meaningIt="Involucro, coperchio, fodera" meaningEn="Cover" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CW" meaningDe="Käfig, Rolle" meaningFr="Roll" meaningIt="Roll" meaningEn="Cage, roll" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CX" meaningDe="Dose, zylindrisch" meaningFr="Boîte, cylindrique" meaningIt="Barattolo, cilindrico" meaningEn="Can, cylindrical" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CY" meaningDe="Zylinder" meaningFr="Cylindre" meaningIt="Cilindro" meaningEn="Cylinder" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CZ" meaningDe="Segeltuch" meaningFr="Toile" meaningIt="Telone" meaningEn="Canvas" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DA" meaningDe="Kiste, mehrlagig, Kunststoff" meaningFr="Casier en plastique, à plusieurs ni" meaningIt="Cassetta (&quot;crate&quot;) in plastica mult" meaningEn="Crate, multiple layer, plastic" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DA" meaningDe="Kiste, mehrlagig, Kunststoff" meaningFr="Casier en plastique, à plusieurs niveaux" meaningIt="Cassetta (&quot;crate&quot;) in plastica multistrato" meaningEn="Crate, multiple layer, plastic" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DB" meaningDe="Kiste, mehrlagig, Holz" meaningFr="Casier en bois, à plusieurs niveaux" meaningIt="Cassetta (&quot;crate&quot;) di legno multist" meaningEn="Crate, multiple layer, wooden" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DB" meaningDe="Kiste, mehrlagig, Holz" meaningFr="Casier en bois, à plusieurs niveaux" meaningIt="Cassetta (&quot;crate&quot;) di legno multistrato" meaningEn="Crate, multiple layer, wooden" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DC" meaningDe="Kiste, mehrlagig, Karton" meaningFr="Caisse en carton, à plusieurs nivea" meaningIt="Cassa (&quot;crate&quot;) di cartone multistr" meaningEn="Crate, multiple layer, cardboard" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DC" meaningDe="Kiste, mehrlagig, Karton" meaningFr="Caisse en carton, à plusieurs niveaux" meaningIt="Cassa (&quot;crate&quot;) di cartone multistrato" meaningEn="Crate, multiple layer, cardboard" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DG" meaningDe="Käfig, Commonwealth Handling Equipm" meaningFr="Cage CHEP (Commonwealth Handling Eq" meaningIt="Gabbia Eurobox CHEP (Commonwealth H" meaningEn="Cage, Commonwealth Handling Equipme" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DG" meaningDe="Käfig, Commonwealth Handling Equipment Pool (CHEP)" meaningFr="Cage CHEP (Commonwealth Handling Equipment Pool" meaningIt="Gabbia Eurobox CHEP (Commonwealth Handling Equipment Pool)" meaningEn="Cage, Commonwealth Handling Equipment Pool (CHEP)" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DH" meaningDe="Kasten, Commonwealth Handling Equip" meaningFr="Caisse CHEP (Commonwealth Handling " meaningIt="Cassetta Eurobox CHEP (Commonwealth" meaningEn="Box, Commonwealth Handling Equipmen" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DH" meaningDe="Kasten, Commonwealth Handling Equipment (CHEP), Eurobox" meaningFr="Caisse CHEP (Commonwealth Handling Equipment Pool) Eurobox" meaningIt="Cassetta Eurobox CHEP (Commonwealth Handling Equipment Pool)" meaningEn="Box, Commonwealth Handling Equipment Pool (CHEP), Eurobox" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DI" meaningDe="Fass, Trommel, Eisen" meaningFr="Fût en fer" meaningIt="Fusto di ferro" meaningEn="Drum, iron" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DJ" meaningDe="Glasballon, ungeschützt" meaningFr="Bonbonne, non protégée" meaningIt="Damigiana, non protetta" meaningEn="Demijohn, non protected" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DK" meaningDe="Kiste, Massengut, Karton" meaningFr="Carton pour vrac" meaningIt="Cartone per rinfuse" meaningEn="Crate, bulk, cardboard" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DL" meaningDe="Kiste, Massengut, Kunststoff" meaningFr="Casier en plastique pour vrac" meaningIt="Cassetta (&quot;crate&quot;) in plastico per " meaningEn="Crate, bulk, plastic" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DL" meaningDe="Kiste, Massengut, Kunststoff" meaningFr="Casier en plastique pour vrac" meaningIt="Cassetta (&quot;crate&quot;) in plastico per rinfuse" meaningEn="Crate, bulk, plastic" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DM" meaningDe="Kiste, Massengut, Holz" meaningFr="Casier en bois pour vrac" meaningIt="Cassetta (&quot;crate&quot;) di legno per rin" meaningEn="Crate, bulk, wooden" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DM" meaningDe="Kiste, Massengut, Holz" meaningFr="Casier en bois pour vrac" meaningIt="Cassetta (&quot;crate&quot;) di legno per rinfuse" meaningEn="Crate, bulk, wooden" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DN" meaningDe="Spender" meaningFr="Générateur aérosol" meaningIt="Generatore aerosol" meaningEn="Dispenser" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DP" meaningDe="Glasballon, geschützt" meaningFr="Bonbonne, protégée" meaningIt="Damigiana, protetta" meaningEn="Demijohn, protected" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DR" meaningDe="Trommel, Fass" meaningFr="Bidon" meaningIt="Tamburo, bidone" meaningEn="Drum" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DS" meaningDe="Tray-Packung, einlagig, ohne Deckel" meaningFr="Plateau en plastique, un niveau, sa" meaningIt="Cassetta (&quot;tray&quot;) di plastica, mono" meaningEn="Tray, one layer no cover, plastic" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DS" meaningDe="Tray-Packung, einlagig, ohne Deckel, Kunststoff" meaningFr="Plateau en plastique, un niveau, sans couvercle" meaningIt="Cassetta (&quot;tray&quot;) di plastica, monostrato, senza coperchio" meaningEn="Tray, one layer no cover, plastic" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DT" meaningDe="Tray-Packung, einlagig, ohne Deckel" meaningFr="Plateau en bois, un niveau, sans co" meaningIt="Cassetta (&quot;tray&quot;) di legno, monostr" meaningEn="Tray, one layer no cover, wooden" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DT" meaningDe="Tray-Packung, einlagig, ohne Deckel, Holz" meaningFr="Plateau en bois, un niveau, sans couvercle" meaningIt="Cassetta (&quot;tray&quot;) di legno, monostrato, senza coperchio" meaningEn="Tray, one layer no cover, wooden" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DU" meaningDe="Tray-Packung, einlagig, ohne Deckel" meaningFr="Plateau en polystyrène, un niveau, " meaningIt="Cassetta (&quot;tray&quot;) di polistirolo, m" meaningEn="Tray. one layer no cover, polystyre" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DU" meaningDe="Tray-Packung, einlagig, ohne Deckel, Styropor" meaningFr="Plateau en polystyrène, un niveau, sans couvercle" meaningIt="Cassetta (&quot;tray&quot;) di polistirolo, monostrato, senza coperchio" meaningEn="Tray. one layer no cover, polystyrene" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DV" meaningDe="Tray-Packung, einlagig, ohne Deckel" meaningFr="Plateau en carton, un niveau, sans " meaningIt="Cassetta (&quot;tray&quot;) di cartone, monos" meaningEn="Tray, one layer no cover, cardboard" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DV" meaningDe="Tray-Packung, einlagig, ohne Deckel, Karton" meaningFr="Plateau en carton, un niveau, sans couvercle" meaningIt="Cassetta (&quot;tray&quot;) di cartone, monostrato, senza coperchio" meaningEn="Tray, one layer no cover, cardboard" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DW" meaningDe="Tray-Packung, zweilagig, ohne Decke" meaningFr="Plateau en plastique, deux niveau, " meaningIt="Cassetta (&quot;tray&quot;) di plastica, dopp" meaningEn="Tray, two layers no cover, plastic " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DW" meaningDe="Tray-Packung, zweilagig, ohne Deckel, Kunststoff" meaningFr="Plateau en plastique, deux niveau, sans couvercle" meaningIt="Cassetta (&quot;tray&quot;) di plastica, doppio stratio, senza coperchio" meaningEn="Tray, two layers no cover, plastic tray" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DX" meaningDe="Tray-Packung, zweilagig, ohne Decke" meaningFr="Plateau en bois, deux niveaux, sans" meaningIt="Cassetta (&quot;tray&quot;) di legno, doppio " meaningEn="Tray, two layers no cover, wooden" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DX" meaningDe="Tray-Packung, zweilagig, ohne Deckel, Holz" meaningFr="Plateau en bois, deux niveaux, sans couvercle" meaningIt="Cassetta (&quot;tray&quot;) di legno, doppio strato, senza coperchio" meaningEn="Tray, two layers no cover, wooden" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DY" meaningDe="Tray-Packung, zweilagig, ohne Decke" meaningFr="Plateau en carton, deux niveau, san" meaningIt="Cassetta (&quot;tray&quot;) di cartone, doppi" meaningEn="Tray, two layers no cover, cardboar" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="DY" meaningDe="Tray-Packung, zweilagig, ohne Deckel, Karton" meaningFr="Plateau en carton, deux niveau, sans couvercle" meaningIt="Cassetta (&quot;tray&quot;) di cartone, doppio strato, senza coperchio" meaningEn="Tray, two layers no cover, cardboard" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EC" meaningDe="Beutel, Kunststoff" meaningFr="Sac plastique" meaningIt="Sacco di plastica" meaningEn="Bag, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ED" meaningDe="Kiste, mit Palette" meaningFr="Caisse palette" meaningIt="Cassa-paletta" meaningEn="Case, with pallet base" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EE" meaningDe="Kiste, mit Palette, Holz" meaningFr="Caisse palette en bois" meaningIt="Cassa-paletta di legno" meaningEn="Case, with pallet base, wooden" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EF" meaningDe="Kiste, mit Palette, Karton" meaningFr="Caisse pallette en carton" meaningIt="Cassa-paletta di cartone" meaningEn="Case, with pallet base, cardboard" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EG" meaningDe="Kiste, mit Palette, Kunststoff" meaningFr="Caisse palette en plastique" meaningIt="Cassa-paletta in plastica" meaningEn="Case, with pallet base, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EH" meaningDe="Kiste, mit Palette, Metall" meaningFr="Caisse palette en métal" meaningIt="Cassa-paletta di metallo" meaningEn="Case, with pallet base, metal" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EI" meaningDe="Kiste, isothermisch" meaningFr="Bac isotherme" meaningIt="Contenitore isotermico" meaningEn="Case, isothermic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EN" meaningDe="Umschlag" meaningFr="Enveloppe" meaningIt="Busta" meaningEn="Envelope" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FB" meaningDe="Flexibag" meaningFr="Flexibag" meaningIt="Contenitore flessibile" meaningEn="Flexibag" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FC" meaningDe="Früchtekorb" meaningFr="Caisse de fruits" meaningIt="Cassa da frutta" meaningEn="Fruit crate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FD" meaningDe="Kiste, verstärkt" meaningFr="Caisse renforcée" meaningIt="Cassa con telaio" meaningEn="Framed crate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FE" meaningDe="Flexitank" meaningFr="Flexitank" meaningIt="Serbatoio flessibile" meaningEn="Flexitank" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FI" meaningDe="Fass, Hohlmass ca. 40 Liter" meaningFr="Bidon, cont. env. 40 L" meaningIt="Bidone, cont. ca. 40 litri" meaningEn="Firkin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FL" meaningDe="Glaskolben" meaningFr="Flasque" meaningIt="Boccetta" meaningEn="Flask" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FO" meaningDe="Feldkiste" meaningFr="Cantine" meaningIt="Armadietto" meaningEn="Footlocker" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FP" meaningDe="Filmpack" meaningFr="Boîte de films" meaningIt="Pellicola" meaningEn="Filmpack" validFrom="2004-11-05" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="FP" meaningDe="Filmpack" meaningFr="Filmpack" meaningIt="Pellicola plastica (&quot;filmpack&quot;)" meaningEn="Filmpack" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FR" meaningDe="Rahmen" meaningFr="Cadre" meaningIt="Intelaiatura" meaningEn="Frame" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FT" meaningDe="Lebensmittelbehälter" meaningFr="Barquette pour aliments (foodtainer" meaningIt="Vaschetta per alimenti (&quot;foodtainer" meaningEn="Foodtainer" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="FT" meaningDe="Lebensmittelbehälter" meaningFr="Barquette pour aliments (foodtainer)" meaningIt="Vaschetta per alimenti (&quot;foodtainer&quot;)" meaningEn="Foodtainer" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FW" meaningDe="Magazinwagen" meaningFr="Carte à plat" meaningIt="Carrello piatto" meaningEn="Cart, flatbed" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="FX" meaningDe="Beutel, flexibel" meaningFr="Sac, contenant souple" meaningIt="Contenitore flessibile a sacco" meaningEn="Bag, flexible container" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="GB" meaningDe="Gasflasche" meaningFr="Bouteille de gaz" meaningIt="Bombola di gas" meaningEn="Gas bottle" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="GI" meaningDe="Balken" meaningFr="Poutre" meaningIt="Trave" meaningEn="Girder" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="GL" meaningDe="Container, Gallone" meaningFr="Conteneur, gallon" meaningIt="Contenitore gallone" meaningEn="Container, gallon" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="GR" meaningDe="Behältnis, Glas" meaningFr="Réceptacle en verre" meaningIt="Recipiente di vetro" meaningEn="Receptacle, glass" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="GU" meaningDe="Tray, mit waagerecht gestapelten flachen Artikeln" meaningFr="Plateau contenant des articles empilés à plat" meaningIt="Casetta traycontenente articoli piatti impilati orizzontalmente" meaningEn="Tray, containing horizontally stacked flat items" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="GY" meaningDe="Sack, Jute" meaningFr="Sac de jute toile gunny bag" meaningIt="Sacco di tela" meaningEn="Bag, gunny" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="GZ" meaningDe="Balken, im Bund" meaningFr="Poutres, groupées" meaningIt="Travi, in pacchi/mazzi/fasci" meaningEn="Girders, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="HA" meaningDe="Korb, mit Henkel, Kunststoff" meaningFr="Corbeille avec anse, en plastique" meaningIt="Cesto di plastica con manico" meaningEn="Basket, with handle, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="HB" meaningDe="Korb, mit Henkel, Holz" meaningFr="Corbeille avec anse, en bois" meaningIt="Cesto di legno con manico" meaningEn="Basket, with handle, wooden" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="HC" meaningDe="Korb, mit Henkel, Karton" meaningFr="Corbeille avec anse, en carton" meaningIt="Cesto di cartone con manico" meaningEn="Basket, with handle, cardboard" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="HG" meaningDe="Fass, Hohlmass ca. 240 Liter" meaningFr="Bidon, cont. env. 240 L" meaningIt="Botte, cont. ca. 240 litri" meaningEn="Hogshead" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="HN" meaningDe="Haken" meaningFr="Crochet" meaningIt="Attaccapanni" meaningEn="Hanger" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="HR" meaningDe="Deckelkorb" meaningFr="Bourriche" meaningIt="Canestro" meaningEn="Hamper" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IA" meaningDe="Packung, Display, Holz" meaningFr="Emballage de présentation, en bois" meaningIt="Imballaggio di presentazione di leg" meaningEn="Package, display. wooden" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="IA" meaningDe="Packung, Display, Holz" meaningFr="Emballage de présentation, en bois" meaningIt="Imballaggio di presentazione di legno" meaningEn="Package, display. wooden" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IB" meaningDe="Kiste, Display, Karton" meaningFr="Emballage de présentation, en carto" meaningIt="Imballaggio di presentazione di car" meaningEn="Package, display, cardboard" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="IB" meaningDe="Kiste, Display, Karton" meaningFr="Emballage de présentation, en carton" meaningIt="Imballaggio di presentazione di cartone" meaningEn="Package, display, cardboard" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IC" meaningDe="Packung, Display, Kunststoff" meaningFr="Emballage de présentation, en plast" meaningIt="Imballaggio di presentazione di pla" meaningEn="Package, display. plastic" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="IC" meaningDe="Packung, Display, Kunststoff" meaningFr="Emballage de présentation, en plastique" meaningIt="Imballaggio di presentazione di plastica" meaningEn="Package, display. plastic" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ID" meaningDe="Packung, Display, Metall" meaningFr="Emballage de présentation, en métal" meaningIt="Imballaggio di presentazione di met" meaningEn="Package, display, metal" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ID" meaningDe="Packung, Display, Metall" meaningFr="Emballage de présentation, en métal" meaningIt="Imballaggio di presentazione di metallo" meaningEn="Package, display, metal" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IE" meaningDe="Packung, Präsentation" meaningFr="Emballage à fenêtre" meaningIt="Imballaggio con finestra" meaningEn="Package, show" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IF" meaningDe="Packung, Schlauch" meaningFr="Emballage tubulaire" meaningIt="Imballaggio tubolare" meaningEn="Package, flow" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IG" meaningDe="Packung, Papierumhüllung" meaningFr="Emballage, enrobé dans du papier" meaningIt="Imballaggio con rivestimento di car" meaningEn="Package, paper, wrapped" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="IG" meaningDe="Packung, Papierumhüllung" meaningFr="Emballage, enrobé dans du papier" meaningIt="Imballaggio con rivestimento di carta" meaningEn="Package, paper, wrapped" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IH" meaningDe="Fass, Trommel, Kunststoff" meaningFr="Fût en plastique" meaningIt="Fusto di plastica" meaningEn="drum, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IK" meaningDe="Packung, Karton, mit Greiflöchern f" meaningFr="Emballage en carton, avec trous de " meaningIt="Imballaggio di cartone con fori di " meaningEn="Package, cardboard, with bottle gri" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="IK" meaningDe="Packung, Karton, mit Greiflöchern für Flaschen" meaningFr="Emballage en carton, avec trous de préhension" meaningIt="Imballaggio di cartone con fori di presa" meaningEn="Package, cardboard, with bottle grip-holes" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IL" meaningDe="Tray, starr, mit Deckel stapelbar" meaningFr="Plateau rigide, empilable, à couvercle" meaningIt="Cassetta tray rigida con coperchio, impilabile" meaningEn="Tray, rigid, lidded stackable" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IN" meaningDe="Barren" meaningFr="Lingot" meaningIt="Lingotto" meaningEn="Ingot" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IZ" meaningDe="Barren, im Bund" meaningFr="Lingots, groupés" meaningIt="Lingotti, in pacchi/mazzi/fasci" meaningEn="Ingots, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="JB" meaningDe="Bigbag" meaningFr="Sac jumbo" meaningIt="Sacco di dimensioni molto grandi" meaningEn="Bag, jumbo" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="JC" meaningDe="Kanister, rechteckig" meaningFr="Jerrican, rectangulaire" meaningIt="Tanica, rettangolare" meaningEn="Jerrican, rectangular" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="JG" meaningDe="Krug" meaningFr="Pot" meaningIt="Brocca" meaningEn="Jug" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="JR" meaningDe="Einmachglas" meaningFr="Jarre" meaningIt="Vaso per conserve" meaningEn="Jar" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="JT" meaningDe="Jutesack" meaningFr="Sac de jute" meaningIt="Sacco di iuta" meaningEn="Jutebag" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="JY" meaningDe="Pott" meaningFr="Jerrican, cylindrique" meaningIt="Tanica, cilindrica" meaningEn="Jerrican, cylindrical" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="KG" meaningDe="Fass (Keg)" meaningFr="Tonnelet" meaningIt="Barilotto" meaningEn="Keg" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="KI" meaningDe="Satz" meaningFr="Boîte à outils" meaningIt="Kit" meaningEn="Kit" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="LE" meaningDe="Gepäck" meaningFr="Bagage" meaningIt="Bagaglio" meaningEn="Luggage" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="LG" meaningDe="Stamm" meaningFr="Tronc" meaningIt="Tronco" meaningEn="Log" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="LT" meaningDe="Los" meaningFr="Lot" meaningIt="Lotto" meaningEn="Lot" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="LU" meaningDe="Obst Gemüsekiste" meaningFr="Case en bois" meaningIt="Cassetta" meaningEn="Lug" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="LV" meaningDe="Umzugskasten" meaningFr="Cadre (&quot;liftvan&quot;)" meaningIt="Cassone (&quot;liftvan&quot;)" meaningEn="Liftvan" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="LZ" meaningDe="Stämme, im Bund" meaningFr="Troncs, groupés" meaningIt="Tronchi, in pacchi/mazzi/fasci" meaningEn="Logs, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MA" meaningDe="Kiste, Metall" meaningFr="Casier en métal" meaningIt="Cassetta crate metallica" meaningEn="Crate, metal" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MB" meaningDe="Mehrlagiger Beutel/Tüte" meaningFr="Cornet, sachet, multicouche" meaningIt="Sacchetto a più pareti" meaningEn="Multiply bag" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MC" meaningDe="Milchkasten" meaningFr="Boîte de lait" meaningIt="Cassetta del latte" meaningEn="Milk crate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ME" meaningDe="Container, Metall" meaningFr="Conteneur métallique" meaningIt="Contenitore metallico" meaningEn="Container, metal" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MR" meaningDe="Behältnis, Metall" meaningFr="récipient, métal" meaningIt="recipiente, metallo" meaningEn="Receptacle, metal" validFrom="2005-09-21" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="MR" meaningDe="Behältnis, Metall" meaningFr="Réceptacle en métal" meaningIt="Recipiente di metallo" meaningEn="Receptacle, metal" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MS" meaningDe="Mehrlagiger Papiersack" meaningFr="Sac multicouche" meaningIt="Sacco a più strati" meaningEn="Multiwall sack" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MT" meaningDe="Matte" meaningFr="Tapis" meaningIt="Stuoia" meaningEn="Mat" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MW" meaningDe="Behältnis, eingeschweisst in Kunsts" meaningFr="Réceptacle, enrobage en plastique" meaningIt="Recipiente con rivestimento di plas" meaningEn="Receptacle, plastic wrapped" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="MW" meaningDe="Behältnis, eingeschweisst in Kunststoff" meaningFr="Réceptacle, enrobage en plastique" meaningIt="Recipiente con rivestimento di plastica" meaningEn="Receptacle, plastic wrapped" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MX" meaningDe="Streichholzschachtel" meaningFr="Boîte d&apos;allumette" meaningIt="Scatola di fiammiferi" meaningEn="Match box" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NA" meaningDe="Nicht verfügbar Nicht verfügbar Nicht verfügbar Nicht verfügbar Nicht verfügbar Nicht verfügbar Nicht verfügbar Nicht verfügbar Nicht v 140" meaningFr="Sans objet                                                                                                                               140" meaningIt="Senza oggetto                                                                                                                            140" meaningEn="Not available" validFrom="2007-06-05" validTo="2007-12-21" validForImport="true" validForExport="true" />
			<entry value="NA" meaningDe="Nicht verfügbar" meaningFr="Sans objet                                                                                                                               140" meaningIt="Senza oggetto                                                                                                                            140" meaningEn="Not available" validFrom="2007-12-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NA" meaningDe="Nicht verfügbar" meaningFr="Sans objet" meaningIt="Senza oggetto" meaningEn="Not available" validFrom="2005-07-01" validTo="2007-06-04" validForImport="true" validForExport="true" />
			<entry value="NE" meaningDe="Nicht verpackt" meaningFr="Non emballé" meaningIt="Non imballato" meaningEn="Unpacked or unpackaged" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NF" meaningDe="Nicht verpackt oder nicht abgepackt, eine Einheit" meaningFr="Non emballé ni conditioné, une seule unité" meaningIt="Merce disimballata o non imbalatta in un&apos;unica unità" meaningEn="Unpacked or unpacked, single units" validFrom="2005-12-03" validTo="2006-07-11" validForImport="true" validForExport="true" />
			<entry value="NF" meaningDe="Nicht verpackt oder nicht abgepackt" meaningFr="Non emballé ni conditioné, une seule unité" meaningIt="Merce disimballata o non imbalatta in un&apos;unica unità" meaningEn="Unpacked or unpacked, single units" validFrom="2006-07-12" validTo="2007-06-04" validForImport="true" validForExport="true" />
			<entry value="NF" meaningDe="Nicht verpackt oder nicht abgepackt" meaningFr="Non emballé ni conditioné, une seul" meaningIt="Merce disimballata o non imbalatta " meaningEn="Unpacked or unpacked, single units" validFrom="2005-07-01" validTo="2005-12-02" validForImport="true" validForExport="true" />
			<entry value="NF" meaningDe="Nicht verpackt oder nicht abgepackt, eine Einheit" meaningFr="Non emballé ni conditioné, une seule unité" meaningIt="Merce disimballata o non imbalatta in un&apos;unica unità" meaningEn="Unpacked or unpacked, single units" validFrom="2007-06-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NG" meaningDe="Nicht verpackt oder nicht abgepackt" meaningFr="Non emballé ni conditionné, plusieu" meaningIt="Merce disimbalatta o non imbalatta " meaningEn="Unpacked or unpacked, multiple unit" validFrom="2005-07-01" validTo="2005-12-02" validForImport="true" validForExport="true" />
			<entry value="NG" meaningDe="Nicht verpackt oder nicht abgepackt, mehrere Einheiten" meaningFr="Non emballé ni conditionné, plusieurs unités" meaningIt="Merce disimbalatta o non imbalatta in varie unità" meaningEn="Unpacked or unpacked, multiple unit" validFrom="2005-12-03" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="NG" meaningDe="Nicht verpackt oder nicht abgepackt, mehrere Einheiten" meaningFr="Non emballé ni conditionné, plusieurs unités" meaningIt="Merce disimbalatta o non imbalatta in varie unità" meaningEn="Unpacked or unpacked, multiple units" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NS" meaningDe="Schachtel" meaningFr="Boîte" meaningIt="Scatola" meaningEn="Nest" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NT" meaningDe="Netz" meaningFr="Filet" meaningIt="Rete" meaningEn="Net" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NU" meaningDe="Netz, schlauchförmig, Kunststoff" meaningFr="Filet tubulaire, en plastique" meaningIt="Rete tubolare di plastica" meaningEn="Net, tube, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="NV" meaningDe="Netz, schlauchförmig, Textil" meaningFr="Filet tubulaire, en textile" meaningIt="Rete tubolare di materiale tessile" meaningEn="Net, tube, textile" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OA" meaningDe="Palette CHEP 40 cm x 60 cm" meaningFr="Palette CHEP Pool 40 x 60 cm" meaningIt="Paletta, CHEP 40 cm x 60 cm" meaningEn="Pallet, CHEP 40 cm x 60 cm" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OB" meaningDe="Palette, CHEP 80 cm x 120 cm" meaningFr="Palette CHEP 80 x 120 cm" meaningIt="Paletta, CHEP 80 cm x 120 cm" meaningEn="Pallet, CHEP 80 cm x 120 cm" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OC" meaningDe="Palette CHEP 100 cm x 120 cm" meaningFr="Pallet CHEP 100 cm x 120 cm" meaningIt="Pallet CHEP 100 cm x 120 cm" meaningEn="Pallet CHEP 100 cm x 120 cm" validFrom="2013-01-19" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OD" meaningDe="Palette, AS 4068-1993" meaningFr="Palette, AS 4068-1993" meaningIt="Paletta, AS 4068-1993" meaningEn="Palette, AS 4068-1993" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OE" meaningDe="Pallet, ISO T11" meaningFr="Pallet, ISO T11" meaningIt="Pallet, ISO T11" meaningEn="Pallet, ISO T11" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OF" meaningDe="Plattform, Gewicht oder Abmessungen nicht angegeben" meaningFr="Plate-forme, poids et dimension non spécifiés" meaningIt="Piattaforma di peso o dimensioni non specificate" meaningEn="Platform, unspecified weight or dimension" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OK" meaningDe="Block" meaningFr="Bloc" meaningIt="Blocco" meaningEn="Block" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OT" meaningDe="Oktabin" meaningFr="Octabin" meaningIt="Octabin" meaningEn="Octabin" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="OU" meaningDe="Container, Aussen" meaningFr="Conteneur extérieur" meaningIt="Contenitore esterno" meaningEn="Container, outer" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PA" meaningDe="Päckchen" meaningFr="Paquet" meaningIt="Pacchetto" meaningEn="Packet" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PB" meaningDe="Boxpalette" meaningFr="Palette box" meaningIt="Palette box" meaningEn="Pallet, box" validFrom="2005-07-12" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="PB" meaningDe="Boxpalette" meaningFr="Palette box" meaningIt="Palette box" meaningEn="en_Boxpalette" validFrom="2005-07-09" validTo="2005-07-12" validForImport="true" validForExport="true" />
			<entry value="PB" meaningDe="Boxpalette" meaningFr="Palette-caisse (&quot;pallet box&quot;)" meaningIt="Paletta scatola (&quot;pallet box&quot;)" meaningEn="Pallet, box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PC" meaningDe="Paket" meaningFr="Colis" meaningIt="Pacco" meaningEn="Parcel" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PD" meaningDe="Palette, modular, Manschette 80 cm " meaningFr="Palette modulaire, rehausses de dim" meaningIt="Paletta modulare, con piedini, di 8" meaningEn="Pallet, modular, collars 80cms * 10" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="PD" meaningDe="Palette, modular, Manschette 80 cm x 100 cm" meaningFr="Palette modulaire, rehausses de dimensions 80 x 100 cm" meaningIt="Paletta modulare, con piedini, di 80 x 100 cm" meaningEn="Pallet, modular, collars 80cms * 100cms" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PE" meaningDe="Palette, modular, Manschette 80 cm " meaningFr="Palette modulaire, rehausses de dim" meaningIt="Paletta modulare, con piedini, di 8" meaningEn="Pallet, modular, collars 80 cms * 1" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="PE" meaningDe="Palette, modular, Manschette 80 cm x 120 cm" meaningFr="Palette modulaire, rehausses de dimensions 80 x 120 cm" meaningIt="Paletta modulare, con piedini, di 80 x 120 cm" meaningEn="Pallet, modular, collars 80 cms * 120cms" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PF" meaningDe="Tiertransportbox" meaningFr="Parc (&quot;pen&quot;)" meaningIt="Gabbia (&quot;pen&quot;)" meaningEn="Pen" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PG" meaningDe="Platte" meaningFr="Assiette" meaningIt="Lastra" meaningEn="Plate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PH" meaningDe="Henkelkrug" meaningFr="Cruche" meaningIt="Brocca" meaningEn="Pitcher" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PI" meaningDe="Rohr" meaningFr="Tuyau" meaningIt="Tubo" meaningEn="Pipe" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PJ" meaningDe="Körbchen" meaningFr="Flein" meaningIt="Cestello tondo" meaningEn="Punnet" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PK" meaningDe="Packung/Packstück" meaningFr="Paquet" meaningIt="Imballaggio" meaningEn="Package" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PL" meaningDe="Kübel" meaningFr="Seau" meaningIt="Secchio" meaningEn="Pail" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PN" meaningDe="Bohle" meaningFr="Planche" meaningIt="Tavola" meaningEn="Plank" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PO" meaningDe="Beutel, Tasche" meaningFr="Sachet, cornet" meaningIt="Astuccio" meaningEn="Pouch" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PP" meaningDe="Stück" meaningFr="Pièce" meaningIt="Pezzo" meaningEn="Piece" validFrom="2013-01-09" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PR" meaningDe="Behältnis, Kunststoff" meaningFr="Réceptacle en plastique" meaningIt="Recipiente di plastica" meaningEn="Receptacle, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PT" meaningDe="Topf" meaningFr="Pot" meaningIt="Vaso" meaningEn="Pot" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PU" meaningDe="Trog, Tablett, Mulde, Schale" meaningFr="Plateau" meaningIt="Vassoio, bacinella" meaningEn="Tray/Tray pack" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PV" meaningDe="Rohre, im Bündel/Bund (&quot;Pipes, in b" meaningFr="Tuyaux en ballot, botte, faisceau" meaningIt="Condotti (&quot;pipe&quot;) in pacchi/mazzi/f" meaningEn="Pipes, in bundle/bunch/truss" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="PV" meaningDe="Rohre, im Bündel/Bund (&quot;Pipes, in bundle/bunch/truss&quot;)" meaningFr="Tuyaux en ballot, botte, faisceau" meaningIt="Condotti (&quot;pipe&quot;) in pacchi/mazzi/fasci" meaningEn="Pipes, in bundle/bunch/truss" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PX" meaningDe="Palette" meaningFr="Palette" meaningIt="Paletta" meaningEn="Pallet" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PY" meaningDe="Platten, im Bund" meaningFr="Assiettes, groupées" meaningIt="Lastre, in pacchi/mazzi/fasci" meaningEn="Plates, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="PZ" meaningDe="Bohlen, im Bund" meaningFr="Tuyaux/planches, groupés" meaningIt="Tubi, in pacchi/mazzi/fasci" meaningEn="Pipes/Planks, in bundle/bunch/truss" validFrom="2004-11-05" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="PZ" meaningDe="Bohlen, im Bündel/Bund" meaningFr="Planches (&quot;planks&quot;) en ballot, botte, faisceau" meaningIt="Tavole (&quot;plank&quot;), in pacchi/mazzi/fasci" meaningEn="Planks, in bundle/bunch/truss" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="P2" meaningDe="Pfanne" meaningFr="Cuvette pan" meaningIt="Bacinella pan" meaningEn="Pan" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QA" meaningDe="Fass, Trommel, Stahl, nicht abnehmb" meaningFr="Fût en acier, à dessus non amovible" meaningIt="Fusto di acciaio con coperchio non " meaningEn="Drum, steel, non-removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QA" meaningDe="Fass, Trommel, Stahl, nicht abnehmbares Oberteil" meaningFr="Fût en acier, à dessus non amovible" meaningIt="Fusto di acciaio con coperchio non amovibile" meaningEn="Drum, steel, non-removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QB" meaningDe="Fass, Trommel, Stahl, abnehmbares O" meaningFr="Fût en acier, à dessus amovible" meaningIt="Fusto di acciaio con coperchio amov" meaningEn="Drum, steel, removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QB" meaningDe="Fass, Trommel, Stahl, abnehmbares Oberteil" meaningFr="Fût en acier, à dessus amovible" meaningIt="Fusto di acciaio con coperchio amovibile" meaningEn="Drum, steel, removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QC" meaningDe="Fass, Trommel, Aluminium, nicht abn" meaningFr="Fût en aluminium. à dessus non amov" meaningIt="Fusto di alluminio con coperchio no" meaningEn="Drum, aluminium, non-removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QC" meaningDe="Fass, Trommel, Aluminium, nicht abnehmbares Oberteil" meaningFr="Fût en aluminium. à dessus non amovible" meaningIt="Fusto di alluminio con coperchio non amovibile" meaningEn="Drum, aluminium, non-removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QD" meaningDe="Fass, Trommel, Aluminium, abnehmbar" meaningFr="Fût en aluminium, à dessus amovible" meaningIt="Fusto di alluminio con coperchio am" meaningEn="Drum, aluminium, removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QD" meaningDe="Fass, Trommel, Aluminium, abnehmbares Oberteil" meaningFr="Fût en aluminium, à dessus amovible" meaningIt="Fusto di alluminio con coperchio amovibile" meaningEn="Drum, aluminium, removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QF" meaningDe="Fass, Trommel, Kunststoff, nicht ab" meaningFr="Fût en plastique, à dessus non amov" meaningIt="Fusto di plastica con coperchio non" meaningEn="Drum, plastic, non-removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QF" meaningDe="Fass, Trommel, Kunststoff, nicht abnehmbares Oberteil" meaningFr="Fût en plastique, à dessus non amovible" meaningIt="Fusto di plastica con coperchio non amovibile" meaningEn="Drum, plastic, non-removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QG" meaningDe="Fass, Trommel, Kunststoff, abnehmba" meaningFr="Fût en plastique, à dessus amovible" meaningIt="Fusto di plastica con coperchio amo" meaningEn="Drum, plastic. removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QG" meaningDe="Fass, Trommel, Kunststoff, abnehmbares Oberteil" meaningFr="Fût en plastique, à dessus amovible" meaningIt="Fusto di plastica con coperchio amovibile" meaningEn="Drum, plastic. removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QH" meaningDe="Fass, Holz, Spundart" meaningFr="Tonneau en bois, à bonde" meaningIt="Botte (&quot;barrel&quot;) di legno con foro " meaningEn="Barrel, wooden, bung type" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QH" meaningDe="Fass, Holz, Spundart" meaningFr="Tonneau en bois, à bonde" meaningIt="Botte (&quot;barrel&quot;) di legno con foro di riempimento" meaningEn="Barrel, wooden, bung type" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QJ" meaningDe="Fass, Holz, abnehmbares Oberteil" meaningFr="Tonneau en bois, à dessus amovible" meaningIt="Botte (&quot;barrel&quot;) di legno con coper" meaningEn="Barrel, wooden, removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QJ" meaningDe="Fass, Holz, abnehmbares Oberteil" meaningFr="Tonneau en bois, à dessus amovible" meaningIt="Botte (&quot;barrel&quot;) di legno con coperchio amovibile" meaningEn="Barrel, wooden, removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QK" meaningDe="Kanister, Stahl, nicht abnehmbares " meaningFr="Jerricane en acier, à dessus non am" meaningIt="Tanica di acciaio con coperchio non" meaningEn="Jerrycan, steel, non-removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QK" meaningDe="Kanister, Stahl, nicht abnehmbares Oberteil" meaningFr="Jerricane en acier, à dessus non amovible" meaningIt="Tanica di acciaio con coperchio non amovibile" meaningEn="Jerrycan, steel, non-removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QL" meaningDe="Kanister, Stahl abnehmbares Obertei" meaningFr="Jerricane en acier, à dessus amovib" meaningIt="Tanica di acciaio con coperchio amo" meaningEn="Jerrycan, removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QL" meaningDe="Kanister, Stahl abnehmbares Oberteil" meaningFr="Jerricane en acier, à dessus amovible" meaningIt="Tanica di acciaio con coperchio amovibile" meaningEn="Jerrycan, removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QM" meaningDe="Kanister, Kunststoff, nicht abnehmb" meaningFr="Jerricane en plastique, à dessus no" meaningIt="Tanica di plastica con coperchio no" meaningEn="Jerrycan, plastic, non-removable he" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QM" meaningDe="Kanister, Kunststoff, nicht abnehmbares Oberteil" meaningFr="Jerricane en plastique, à dessus non amovible" meaningIt="Tanica di plastica con coperchio non amovibile" meaningEn="Jerrycan, plastic, non-removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QN" meaningDe="Kanister, Kunststoff, abnehmbares O" meaningFr="Jerricane en plastique, à dessus am" meaningIt="Tanica di plastica con coperchio am" meaningEn="Jerrycan, plastic, removable head" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QN" meaningDe="Kanister, Kunststoff, abnehmbares Oberteil" meaningFr="Jerricane en plastique, à dessus amovible" meaningIt="Tanica di plastica con coperchio amovibile" meaningEn="Jerrycan, plastic, removable head" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QP" meaningDe="Kasten, Holz, Naturholz, gewöhnlich" meaningFr="Caisse en bois naturel, ordinaire" meaningIt="Cassa (&quot;box&quot;) di legno naturale, or" meaningEn="Box, wooden, natural wood, ordinary" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QP" meaningDe="Kasten, Holz, Naturholz, gewöhnliches" meaningFr="Caisse en bois naturel, ordinaire" meaningIt="Cassa (&quot;box&quot;) di legno naturale, ordinaria" meaningEn="Box, wooden, natural wood, ordinary" validFrom="2006-01-10" validTo="2013-01-19" validForImport="true" validForExport="true" />
			<entry value="QP" meaningDe="Kasten, Holz, Naturholz, gewöhnliches" meaningFr="Caisse en bois naturel, ordinaire" meaningIt="Cassa di legno naturale, ordinaria" meaningEn="Box, wooden, natural wood, ordinary" validFrom="2013-01-19" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QQ" meaningDe="Kasten, Holz, Naturholz, mit undurc" meaningFr="Caisse en bois naturel, à panneaux " meaningIt="Cassa (&quot;box&quot;) di legno naturale a p" meaningEn="Box, wooden, natural wood, with sif" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QQ" meaningDe="Kasten, Holz, Naturholz, mit undurchlässigen Wänden" meaningFr="Caisse en bois naturel, à panneaux étanches aux pulvérulents" meaningIt="Cassa (&quot;box&quot;) di legno naturale a pannelli stagni alle polveri" meaningEn="Box, wooden, natural wood, with sift proof walls" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QR" meaningDe="Kasten, Kunststoff, ausdehnungsfähi" meaningFr="Caisse en plastique expansé" meaningIt="Cassa (&quot;box&quot;) in materiale plastico" meaningEn="Box, plastic, expanded" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="QR" meaningDe="Kasten, Kunststoff, ausdehnungsfähig" meaningFr="Caisse en plastique expansé" meaningIt="Cassa (&quot;box&quot;) in materiale plastico espanso" meaningEn="Box, plastic, expanded" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="QS" meaningDe="Kasten, Kunststoff, fest" meaningFr="Caisse en plastique rigide" meaningIt="Cassa (&quot;box&quot;) in plastica rigida" meaningEn="Box, plastic, solid" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RD" meaningDe="Stab, Stange" meaningFr="Baguette" meaningIt="Vergella" meaningEn="Rod" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RG" meaningDe="Ring" meaningFr="Anneau" meaningIt="Anello" meaningEn="Ring" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RJ" meaningDe="Gestell, Garderobenstange" meaningFr="Penderie mobile" meaningIt="Rastrelliera, attaccapanni" meaningEn="Rack, clothing hanger" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RK" meaningDe="Gestell" meaningFr="Rayonnage (&quot;rack&quot;)" meaningIt="Scaffalatura (&quot;rack&quot;)" meaningEn="Rack" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RL" meaningDe="Haspel, Spule" meaningFr="Bobine" meaningIt="Bobina" meaningEn="Reel" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RO" meaningDe="Rolle" meaningFr="Rouleau" meaningIt="Rotolo" meaningEn="Roll" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RT" meaningDe="Rotnetz" meaningFr="Filet rouge" meaningIt="Rete rossa" meaningEn="Rednet" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="RZ" meaningDe="Stäbe, Stangen, im Bund" meaningFr="Baguettes, groupées" meaningIt="Vergella, in pacchi/mazzi/fasci" meaningEn="Rods, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SA" meaningDe="Sack" meaningFr="Sac" meaningIt="Sacco" meaningEn="Sack" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SB" meaningDe="Platte (&quot;Slab&quot;)" meaningFr="Feuille calandrée" meaningIt="Lastra (&quot;slab&quot;)" meaningEn="Slab" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SC" meaningDe="Steige" meaningFr="Caisse plate" meaningIt="Cassa bassa" meaningEn="Shallow crate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SD" meaningDe="Spindel" meaningFr="Fuseau" meaningIt="Asta" meaningEn="Spindle" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SE" meaningDe="Seekiste" meaningFr="Caisse maritime" meaningIt="Cassapanca di tipo marino" meaningEn="Sea-chest" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SH" meaningDe="Beutel, klein" meaningFr="Sachet, petit" meaningIt="Sacchetto" meaningEn="Sachet" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SI" meaningDe="Transporthilfe" meaningFr="Luge (&quot;skid&quot;)" meaningIt="Skid" meaningEn="Skid" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SK" meaningDe="Verschlag" meaningFr="Caisse ajourée" meaningIt="Contenitore a telaio" meaningEn="Skeleton case" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SL" meaningDe="Kufenbrett" meaningFr="Intercalaire" meaningIt="Intercalare" meaningEn="Slipsheet" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SM" meaningDe="Blech" meaningFr="Tôle" meaningIt="Lamierino" meaningEn="Sheetmetal" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SO" meaningDe="Bandspule" meaningFr="Dévidoir (&quot;spool&quot;)" meaningIt="Bobina (&quot;spool&quot;)" meaningEn="0" validFrom="2005-07-01" validTo="2012-05-02" validForImport="true" validForExport="true" />
			<entry value="SO" meaningDe="Bandspule" meaningFr="Dévidoir" meaningIt="Bobina" meaningEn="Spool" validFrom="2012-05-02" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SP" meaningDe="Tafel, Bogen, Platte, eingeschweiss" meaningFr="Feuille, enrobage en plastique" meaningIt="Foglio, rivestimento di plastica" meaningEn="Sheet, plastic wrapping" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="SP" meaningDe="Tafel, Bogen, Platte, eingeschweisst in Kunststoff" meaningFr="Feuille, enrobage en plastique" meaningIt="Foglio, rivestimento di plastica" meaningEn="Sheet, plastic wrapping" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SS" meaningDe="Kiste, Stahl" meaningFr="Bac en acier" meaningIt="Contenitore (&quot;case&quot;) di acciaio" meaningEn="Case. steel" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ST" meaningDe="Tafel, Bögen, Platen, im Bund" meaningFr="Feuille" meaningIt="Foglio" meaningEn="Sheet" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SU" meaningDe="Handkoffer" meaningFr="Valise" meaningIt="Valigia" meaningEn="Suitcase" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SV" meaningDe="Hülle, Stahl" meaningFr="Enveloppe en acier" meaningIt="Involucare di acciaio" meaningEn="Envelope, steel" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SW" meaningDe="Schrumpfverpackt" meaningFr="Enveloppé serré" meaningIt="Pellicola di plastica" meaningEn="Shrinkwrapped" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SX" meaningDe="Garnitur" meaningFr="Assortiment (&quot;Set&quot;)" meaningIt="Assortimento (&quot;set&quot;)" meaningEn="Set" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SY" meaningDe="Hülse" meaningFr="Manchon" meaningIt="it_Hülse" meaningEn="Sleeve" validFrom="2005-07-01" validTo="2012-05-02" validForImport="true" validForExport="true" />
			<entry value="SY" meaningDe="Hülse" meaningFr="Fourreau" meaningIt="Boccolla" meaningEn="Sleeve" validFrom="2012-05-02" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="SZ" meaningDe="Blätter, im Bund" meaningFr="Feuilles, groupées" meaningIt="Fogli, in pacchi/mazzi/fasci" meaningEn="Sheets, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TB" meaningDe="Bottich, Wanne, Kübel, Zuber" meaningFr="Cuve" meaningIt="Mastello, vasca" meaningEn="Tub" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TC" meaningDe="Teekiste" meaningFr="Ballot de thé" meaningIt="Cassa da tè" meaningEn="Tea-chest" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TD" meaningDe="Tube" meaningFr="Tube" meaningIt="Tubo, flessibile" meaningEn="Tube, collapsible/Collapsible tube" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TE" meaningDe="Reifen" meaningFr="Pneumatique" meaningIt="Pneumatico" meaningEn="Tyre" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TG" meaningDe="Tankbehälter, allgemein" meaningFr="Conteneur-citerne, générique" meaningIt="Contenitore serbatoio generico" meaningEn="Tank container, generic" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TI" meaningDe="Stufe, Etage" meaningFr="Feuillette" meaningIt="Barilotto (&quot;tierce&quot;)" meaningEn="Tierce" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TK" meaningDe="Tank, rechteckig" meaningFr="Réservoir rectangulaire" meaningIt="Serbatoio, rettangolare" meaningEn="Tank, rectangular" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TL" meaningDe="Bottich, mit Deckel" meaningFr="Baquet avec couvercle" meaningIt="Cassone con coperchio" meaningEn="Tub, with lid" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TN" meaningDe="Konservendose" meaningFr="Boîte de conserve" meaningIt="Barattolo di latta" meaningEn="Tin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TO" meaningDe="Tonne" meaningFr="Tonneau" meaningIt="Botte di grande capacità" meaningEn="Tun" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TR" meaningDe="Koffer" meaningFr="Malle" meaningIt="Baule" meaningEn="Trunk" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TS" meaningDe="Bündel" meaningFr="Botte" meaningIt="Fascio" meaningEn="Truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TT" meaningDe="Beutel, Tragetasche" meaningFr="Sac de manutention" meaningIt="Sacco da trasporto" meaningEn="Bag, tote" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TU" meaningDe="Rohr" meaningFr="Tube" meaningIt="Tubo" meaningEn="Tube" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TV" meaningDe="Tube, mit Düse" meaningFr="Tube à embout" meaningIt="Tubo a imbuto" meaningEn="Tube, with nozzle" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TW" meaningDe="Palette, Triwall" meaningFr="Palette en carton ondulé lourd" meaningIt="Paletta triwall" meaningEn="Pallet triwall" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TY" meaningDe="Tank, zylindrisch" meaningFr="Réservoir cylindrique" meaningIt="Serbatoio, cilindrico" meaningEn="Tank, cylindrical" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="TZ" meaningDe="Rohre, im Bund" meaningFr="Tubes, groupés" meaningIt="Tubi, in pacchi/mazzi/fasci" meaningEn="Tube, in bundle/bunch/truss" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T1" meaningDe="Tablett" meaningFr="Tablette" meaningIt="Tavoletta" meaningEn="Tablet" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="UC" meaningDe="Ohne Käfig" meaningFr="Libre (animal)" meaningIt="Libero (animale)" meaningEn="Uncaged" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="UN" meaningDe="Einheit" meaningFr="Unité" meaningIt="Unità" meaningEn="Unit" validFrom="2013-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VA" meaningDe="Fass" meaningFr="Cuve" meaningIt="Tino" meaningEn="Vat" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VG" meaningDe="Massengut, Gas" meaningFr="Gaz, en gros" meaningIt="Gas alla rinfusa (1031mbar e 15°C)" meaningEn="Bulk, gas (at 1031mbar and 15°C)" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VI" meaningDe="Glasröhrchen" meaningFr="Tube de verre" meaningIt="Fiala" meaningEn="Vial" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VK" meaningDe="Vanpack" meaningFr="&quot;Vanpack&quot;" meaningIt="&quot;Vanpack&quot;" meaningEn="Vat" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VL" meaningDe="Massengut, flüssig" meaningFr="Liquide, en gros" meaningIt="Liquidi alla rinfusa" meaningEn="Bulk, liquid" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VN" meaningDe="Fahrzeug" meaningFr="Véhicule" meaningIt="Veicolo" meaningEn="Vehicle" validFrom="2013-01-23" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VN" meaningDe="Fahrzeug" meaningFr="Véhicule" meaningIt="Veicolo" meaningEn="Bulk, liquid" validFrom="2013-01-22" validTo="2013-01-23" validForImport="true" validForExport="true" />
			<entry value="VO" meaningDe="Massengut, fest, Knollen" meaningFr="Grosses particules solides, en vrac" meaningIt="Particelle rinfusa,solide,grandi" meaningEn="Bulk, solid, large part. (&quot;nodul.&quot;)" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VP" meaningDe="Vakuumverpackt" meaningFr="Conditionné sous vide" meaningIt="Sotto vuoto" meaningEn="Vacuum-packed" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VQ" meaningDe="Massengut, Flüssiggas" meaningFr="Gaz liquéfié, en gros" meaningIt="Gas liq. rinfusa(temp./press.anorm)" meaningEn="Bulk, liquefied gas at abnormal T/P" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VR" meaningDe="Massengut, fest, Körner" meaningFr="Granulés, en vrac" meaningIt="Particelle rinfusa,solide,granulari" meaningEn="Bulk, solid, gran. part. (&quot;grains&quot;)" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VS" meaningDe="Schrott" meaningFr="Ferraille" meaningIt="Rottame" meaningEn="Scrap" validFrom="2012-12-07" validTo="2013-10-23" validForImport="true" validForExport="true" />
			<entry value="VS" meaningDe="Schrott" meaningFr="Ferraille" meaningIt="Rottame" meaningEn="Scrap" validFrom="2013-11-29" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="VS" meaningDe="Schrott" meaningFr="Ferraille" meaningIt="Rottame" meaningEn="Scrap." validFrom="2013-10-23" validTo="2013-11-29" validForImport="true" validForExport="true" />
			<entry value="VY" meaningDe="Massengut, fest, in Pulverform" meaningFr="Fines particules en vrac" meaningIt="Particelle alla rinfusa,solide,fini" meaningEn="Bulk, solid, fine part. (&quot;powders&quot;)" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WA" meaningDe="Massengutbehälter, mittelgross" meaningFr="Grand récipient pour vrac" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WA" meaningDe="Massengutbehälter, mittelgross" meaningFr="Grand récipient pour vrac" meaningIt="Contenitore di grandi dimensioni per rinfuse" meaningEn="Intermediate bulk container" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WB" meaningDe="Korbflasche" meaningFr="Bouteille en osier" meaningIt="Bottiglia impagliata (fiasco)" meaningEn="Wickerbottle" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WC" meaningDe="Massengutbehälter, mittelgross, Sta" meaningFr="Grand récipient pour vrac, en acier" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, steel" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WC" meaningDe="Massengutbehälter, mittelgross, Stahl" meaningFr="Grand récipient pour vrac, en acier" meaningIt="Contenitore di grandi dimensioni per rinfuse, di acciaio" meaningEn="Intermediate bulk container, steel" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WD" meaningDe="Massengutbehälter, mittelgross, Alu" meaningFr="Grand récipient pour vrac, en alumi" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, alumin" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WD" meaningDe="Massengutbehälter, mittelgross, Aluminium" meaningFr="Grand récipient pour vrac, en aluminium" meaningIt="Contenitore di grandi dimensioni per rinfuse, di alluminio" meaningEn="Intermediate bulk container, aluminium" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WF" meaningDe="Massengutbehälter, mittelgross, Met" meaningFr="Grand récipient pour vrac, métalliq" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, metal" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WF" meaningDe="Massengutbehälter, mittelgross, Metall" meaningFr="Grand récipient pour vrac, métallique" meaningIt="Contenitore di grandi dimensioni per rinfuse, di metallo" meaningEn="Intermediate bulk container, metal" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WG" meaningDe="Massengutbehälter, mittelgross, sta" meaningFr="Grand récipient pour vrac, en acier" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, steel," validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WG" meaningDe="Massengutbehälter, mittelgross, stahl, beaufschlagt mit mehr als 10 kp" meaningFr="Grand récipient pour vrac, en acier, avec remplissage ou vidange sous" meaningIt="Contenitore di grandi dimensioni per rinfuse, di acciaio, con riempime" meaningEn="Intermediate bulk container, steel, pressurised &gt; 10 kpa" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WH" meaningDe="Massengutbehälter, mittelgross, Alu" meaningFr="Grand récipient pour vrac, en alumi" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, alumin" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WH" meaningDe="Massengutbehälter, mittelgross, Aluminium, beaufschlagt mit mehr als 1" meaningFr="Grand récipient pour vrac, en aluminium, avec remplissage ou vidange s" meaningIt="Contenitore di grandi dimensioni per rinfuse, di alluminio, con riempi" meaningEn="Intermediate bulk container, aluminium, pressurised &gt; 10 kpa" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WJ" meaningDe="Massengutbehälter, mittelgross, Met" meaningFr="Grand récipient pour vrac, métalliq" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, metal," validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WJ" meaningDe="Massengutbehälter, mittelgross, Metall, beaufschlagt mit &gt; 10 kpa" meaningFr="Grand récipient pour vrac, métallique, pour remplissage ou vidange sou" meaningIt="Contenitore di grandi dimensioni per rinfuse, di metallo, per riempime" meaningEn="Intermediate bulk container, metal, pressure 10 kpa" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WK" meaningDe="Massengutbehälter, mittelgross, Sta" meaningFr="Grand récipient pour vrac liquide, " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, steel," validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WK" meaningDe="Massengutbehälter, mittelgross, Stahl, Flüssigkeit" meaningFr="Grand récipient pour vrac liquide, en acier" meaningIt="Contenitore di grandi dimensioni per liquidi alla rinfusa, di acciaio" meaningEn="Intermediate bulk container, steel, liquid" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WL" meaningDe="Massengutbehälter, mittelgross, Alu" meaningFr="Grand récipient pour vrac liquide, " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, alumin" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WL" meaningDe="Massengutbehälter, mittelgross, Aluminium, Flüssigkeit" meaningFr="Grand récipient pour vrac liquide, en aluminium" meaningIt="Contenitore di grandi dimensioni per liquidi alla rinfusa, di allumini" meaningEn="Intermediate bulk container, aluminium, liquid" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WM" meaningDe="Massengutbehälter, mittelgross, Met" meaningFr="Grand récipient pour vrac liquide, " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, metal," validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WM" meaningDe="Massengutbehälter, mittelgross, Metall, Flüssigkeit" meaningFr="Grand récipient pour vrac liquide, métallique" meaningIt="Contenitore di grandi dimensioni per liquidi alla rinfusa, di metallo" meaningEn="Intermediate bulk container, metal, liquid" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WN" meaningDe="Massengutbehälter, mittelgross, gew" meaningFr="Grand récipient pour vrac, en tissu" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, woven " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WN" meaningDe="Massengutbehälter, mittelgross, gewebter Kunststoff, ohne Umhüllung" meaningFr="Grand récipient pour vrac, en tissu de plastique, sans revêtement inté" meaningIt="Contenitore di grandi dimensioni per rinfuse, di plastica, senza rives" meaningEn="Intermediate bulk container, woven plastic, without caot/liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WP" meaningDe="Massengutbehälter, mittelgross, gew" meaningFr="Grand récipient pour vrac, en tissu" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, woven " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WP" meaningDe="Massengutbehälter, mittelgross, gewebter Kunststoff, beschichtet" meaningFr="Grand récipient pour vrac, en tissu de plastique, avec revêtement inté" meaningIt="Contenitore di grandi dimensioni per rinfuse, di tessuto plastico, con" meaningEn="Intermediate bulk container, woven plastic, coated" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WQ" meaningDe="Massengutbehälter, mittelgross, gew" meaningFr="Grand récipient pour vrac, en tissu" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, woven " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WQ" meaningDe="Massengutbehälter, mittelgross, gewebter Kunststoff, mit Umhüllung" meaningFr="Grand récipient pour vrac, en tissu de plastique, avec doublure" meaningIt="Contenitore di grandi dimensioni per rinfuse, di tessuto plastico, con" meaningEn="Intermediate bulk container, woven plastic, with liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WR" meaningDe="Massengutbehälter, mittelgross, gew" meaningFr="Grand récipient pour vrac, en tissu" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, woven " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WR" meaningDe="Massengutbehälter, mittelgross, gewebter Kunststoff, beschichtet, mit" meaningFr="Grand récipient pour vrac, en tissu de plastique, avec revêtement inté" meaningIt="Contenitore di grandi dimensioni per rinfuse, di plastica, con rivesti" meaningEn="Intermediate bulk container, woven plastic, coated and liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WS" meaningDe="Massengutbehälter, mittelgross. Kun" meaningFr="Grand récipient pour vrac, en film " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, plasti" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WS" meaningDe="Massengutbehälter, mittelgross. Kunststofffolie" meaningFr="Grand récipient pour vrac, en film de plastique" meaningIt="Contenitore di grandi dimensioni per rinfuse, in film di plastica" meaningEn="Intermediate bulk container, plastic film" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WT" meaningDe="Massengutbehälter, mittelgross, Tex" meaningFr="Grand récipient pour vrac, en texti" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, textil" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WT" meaningDe="Massengutbehälter, mittelgross, Textil, mit äusserer Umhüllung" meaningFr="Grand récipient pour vrac, en textile sans revêtement intérieur ni do" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materia tessile, senz" meaningEn="Intermediate bulk container, textile with out coat/liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WU" meaningDe="Massengutbehälter, mittelgross, Nat" meaningFr="Grand récipient pour vrac, en bois " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, natura" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WU" meaningDe="Massengutbehälter, mittelgross, Naturholz, mit Auskleidung" meaningFr="Grand récipient pour vrac, en bois naturel, avec doublure" meaningIt="Contenitore di grandi dimensioni per rinfuse di legno naturale, con ri" meaningEn="Intermediate bulk container, natural wood, with inner line" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WV" meaningDe="Massengutbehälter, mittelgross, Tex" meaningFr="Grand récipient pour vrac, en texti" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, textil" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WV" meaningDe="Massengutbehälter, mittelgross, Textil, beschichtet" meaningFr="Grand récipient pour vrac, en textile, avec revêtement intérieur" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materia tessile, con" meaningEn="Intermediate bulk container, textile, coated" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WW" meaningDe="Massengutbehälter, mittelgross, Tex" meaningFr="Grand récipient pour vrac, en texti" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, textil" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WW" meaningDe="Massengutbehälter, mittelgross, Textil, mit Umhüllung" meaningFr="Grand récipient pour vrac, en textile, avec doublure" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materia tessile, con" meaningEn="Intermediate bulk container, textile, with liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WX" meaningDe="Massengutbehälter, mittelgross, Tex" meaningFr="Grand récipient pour vrac, en texti" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, textil" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WX" meaningDe="Massengutbehälter, mittelgross, Textil, beschichtet und Umhüllung" meaningFr="Grand récipient pour vrac, en textile, avec revêtement intérieur et do" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materia tessile, con" meaningEn="Intermediate bulk container, textile, coated and liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WY" meaningDe="Massengutbehälter, mittelgross, Spe" meaningFr="Grand récipient pour vrac, en contr" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, plywoo" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WY" meaningDe="Massengutbehälter, mittelgross, Sperrholz, mit Auskleidung" meaningFr="Grand récipient pour vrac, en contre-plaqué, avec doublure" meaningIt="Contenitore di grandi dimensioni per rinfuse, di legno compensato, con" meaningEn="Intermediate bulk container, plywood, with inner liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="WZ" meaningDe="Massengutbehälter, mittelgross, wie" meaningFr="Grand récipient pour vrac, en bois " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, recons" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="WZ" meaningDe="Massengutbehälter, mittelgross, wiederverwertetes Holz mit Auskleidung" meaningFr="Grand récipient pour vrac, en bois reconstitué, avec doublure" meaningIt="Contenitore di grandi dimensioni per rinfuse, di legno ricostituito," meaningEn="Intermediate bulk container, reconstituted wood, with inner liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XA" meaningDe="Beutel, gewebter Kunststoff, ohne I" meaningFr="Sac en tissu de plastique, sans rev" meaningIt="Sacco di tessuto do materia plastic" meaningEn="Bag, woven plastic, without inner c" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="XA" meaningDe="Beutel, gewebter Kunststoff, ohne Innenfutter/Auskleidung" meaningFr="Sac en tissu de plastique, sans revêtmement intérieur ni doublure" meaningIt="Sacco di tessuto do materia plastica, senza fodera o rivestimento inte" meaningEn="Bag, woven plastic, without inner coat/liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XB" meaningDe="Beutel, gewebter Kunststoff, undurc" meaningFr="Sac en tissu de plastique étanche a" meaningIt="Sacco di tessuto di materia plastic" meaningEn="Bag, woven plastic, sift proof" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="XB" meaningDe="Beutel, gewebter Kunststoff, undurchlässig" meaningFr="Sac en tissu de plastique étanche aux pulvérulents" meaningIt="Sacco di tessuto di materia plastica, stagno alle polveri" meaningEn="Bag, woven plastic, sift proof" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XC" meaningDe="Beutel, gewebter Kunststoff, wasser" meaningFr="Sac en tissu de plastique, résistan" meaningIt="Sacco di tessuto di materia, resist" meaningEn="Bag, woven, plastic, water resistan" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="XC" meaningDe="Beutel, gewebter Kunststoff, wasserresistent" meaningFr="Sac en tissu de plastique, résistant à l&apos;eau" meaningIt="Sacco di tessuto di materia, resistente all&apos;aqua" meaningEn="Bag, woven, plastic, water resistant" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XD" meaningDe="Beutel, Kunststofffilm" meaningFr="Sac en film de plastique" meaningIt="Sacco in film di plastica" meaningEn="Bag, plastics film" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XF" meaningDe="Beutel, Textil, ohne Innenfutter/Au" meaningFr="Sace en textile, sans revêtement in" meaningIt="Sacco di materia tessile, senza fod" meaningEn="Bag, textile, without inner coat/li" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="XF" meaningDe="Beutel, Textil, ohne Innenfutter/Auskleidung" meaningFr="Sace en textile, sans revêtement intérieur ni doublure" meaningIt="Sacco di materia tessile, senza fodera o rivestimento interno" meaningEn="Bag, textile, without inner coat/liner" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XG" meaningDe="Beutel, Textil, undurchlässig" meaningFr="Sac en textile, étanche aux pulvéru" meaningIt="Sacco di materia tessile stagno all" meaningEn="Bag, textile, sift proof" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="XG" meaningDe="Beutel, Textil, undurchlässig" meaningFr="Sac en textile, étanche aux pulvérulents" meaningIt="Sacco di materia tessile stagno alle polveri" meaningEn="Bag, textile, sift proof" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XH" meaningDe="Beutel, Textil, wasserresistent" meaningFr="Sace en textile, résistant à l&apos;eau" meaningIt="Sacco di materia tessile resistente" meaningEn="Bag, textile, water resistant" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="XH" meaningDe="Beutel, Textil, wasserresistent" meaningFr="Sace en textile, résistant à l&apos;eau" meaningIt="Sacco di materia tessile resistente all0aqua" meaningEn="Bag, textile, water resistant" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XJ" meaningDe="Beutel, Papier, mehrlagig" meaningFr="Sac en papier multiplis" meaningIt="Sacco di carta multifoglio" meaningEn="Bag, paper, multi-wall" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="XK" meaningDe="Beutel, Papier, mehrwandig, wasserr" meaningFr="Sac en papier mulitplis, résistant " meaningIt="Sacco di carta multifoglio, resiste" meaningEn="Bag, paper, multi-wall, water resis" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="XK" meaningDe="Beutel, Papier, mehrwandig, wasserresistent" meaningFr="Sac en papier mulitplis, résistant à l&apos;eau" meaningIt="Sacco di carta multifoglio, resistente all&apos;aqua" meaningEn="Bag, paper, multi-wall, water resistant" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YA" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YA" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Stahltrommel" meaningFr="Emballage composite, récipient en plastique avec fût extérieure en aci" meaningIt="Imballaggio composito, recipiente di plastica con fusto esterno di acc" meaningEn="Composite packaging, plastic receptacle in steel drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YB" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YB" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Stahlkiste" meaningFr="Emballage composite, récipient en plastique avec caisse extérieure en" meaningIt="Imballaggio composito, recipiente di plastica con cassa esterna di acc" meaningEn="Composite packaging, plastic receptacle in steel crate box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YC" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YC" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Aluminiumtrommel" meaningFr="Emballage composite, récipient en plastique avec fût extérieure en alu" meaningIt="Imballaggio composito, recipiente di plastica con fusto esterno di all" meaningEn="Composite packaging, plastic receptacle in aluminium drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YD" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YD" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Aluminiumkiste" meaningFr="Emballage composite, récipient en plastique avec caisse extérieure en" meaningIt="Imballaggio composito, recipiente di plastica con cassa esterna di all" meaningEn="Composite packaging, plastic receptacle in aluminium crate" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YF" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YF" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Holzkiste" meaningFr="Emballage composite, récipient en plastique avec caisse extérieure en" meaningIt="Imballaggio composito, recipiente di plastica con cassa esterna di leg" meaningEn="Composite packaging, plastic receptacle in wooden box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YG" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YG" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Sperrholztrommel" meaningFr="Emballage composite, récipient en plastique avec fût extérieure en con" meaningIt="Imballaggio composito, recipiente di plastica con fusto esterno di all" meaningEn="Composite packaging, plastic receptacle in plywood drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YH" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YH" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Sperrholzkiste" meaningFr="Emballage composite, récipient en plastique avec caisse extérieure en" meaningIt="Imballaggio composito, recipiente di plastica con cassa esterna di leg" meaningEn="Composite packaging, plastic receptacle in plywood box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YJ" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YJ" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Holzfasertrommel" meaningFr="Emballage composite, récipient en plastique avec fût extérieure en car" meaningIt="Imballaggio composito, recipiente di plastica con fusto esterno di car" meaningEn="Composite packaging, plastic receptacle in fibre drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YK" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YK" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Holzfaserkiste" meaningFr="Emballage composite, récipient en plastique avec caisse extérieure en" meaningIt="Imballaggio composito, recipiente di plastica con cassa esterna di car" meaningEn="Composite packaging, plastic receptacle in fibreboard box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YL" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YL" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in Kunststofftrommel" meaningFr="Emballage composite, récipient en plastiue avec fût extérieure en plas" meaningIt="Imballaggio composito, recipiente di plastica con fusto esterno di pla" meaningEn="Composite packaging, plastic receptacle in plastic drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YM" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YM" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter in fester Kunststoffki" meaningFr="Emballage composite, récipient en plastique avec caisse extérieure en" meaningIt="Imballaggio composito, recipiente di plastica con cassa esterna di pla" meaningEn="Composite packaging, plastic receptacle in solid plastic box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YN" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito recipiente di" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YN" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in Stahltrommel" meaningFr="Emballage composite, récipient en verre avec fût extérieure en acier" meaningIt="Imballaggio composito recipiente di vetro con fusto esterno di acciaio" meaningEn="Composite packaging, glass receptacle in steel drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YP" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito recipiente di" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YP" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in Stahlkiste" meaningFr="Emballage composite, récipient en verre avec caisse extérieure en acie" meaningIt="Imballaggio composito recipiente di vetro con cassa esterna di acciaio" meaningEn="Composite packaging, glass receptacle in steel crate box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YQ" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YQ" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in Aluminiumtrommel" meaningFr="Emballage composite, récipient en verre avec flût extérieure en alumin" meaningIt="Imballaggio composito, recipiente di vetro con fusto esterno di allumi" meaningEn="Composite packaging, glass receptacle in aluminium drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YR" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YR" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in Aluminiumkiste" meaningFr="Emballage composite, récipient en verre avec caisse extérieure en alum" meaningIt="Imballaggio composito, recipiente di vetro con cassa esterna di allumi" meaningEn="Composite packaging, glass receptacle in aluminium crate" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YS" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YS" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in Holzkiste" meaningFr="Emballage composite, récipient en verre avec caisse extérieure en bois" meaningIt="Imballaggio composito, recipiente di vetro con cassa esterna di legno" meaningEn="Composite packaging, glass receptacle in wooden box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YT" meaningDe="Zusammengesetzte Verpackung, Galsbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YT" meaningDe="Zusammengesetzte Verpackung, Galsbehälter in Sperrholzkiste" meaningFr="Emballage composite, récipient en verre avec fût extérieure en contrép" meaningIt="Imballaggio composito, recipiente di vetro con fusto esterno di legno" meaningEn="Composite packaging, glass receptacle in plywood drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YV" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YV" meaningDe="Zusammengesetzte Verpackung, Glasbehälter im Weidenkorb" meaningFr="Emballage composite, récipient en verre avec panier extérieure en osie" meaningIt="Imballaggio composito, recipiente di vetro con paniere esterno di vimi" meaningEn="Composite packaging, glass receptacle in wickerwork hamper" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YW" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito recipiente di" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YW" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in Holzfasertrommel" meaningFr="Emballage composite, récipient en verre avec fût extérieure en carton" meaningIt="Imballaggio composito recipiente di vetro con fusto esterno di cartone" meaningEn="Composite packaging, glass receptacle in fibre drum" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YX" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito recipiente di" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YX" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in Holzfaserkiste" meaningFr="Emballage composite, récipient en verre avec caisse extérieure en cart" meaningIt="Imballaggio composito recipiente di vetro con cassa esterna di cartone" meaningEn="Composite packaging, glass receptacle in fibreboard box" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YY" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YY" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in dehnungsfähigem Kunststof" meaningFr="Emballage composite, récipient en verre avec emballage extérieure en p" meaningIt="Imballaggio composito, recipiente di vetro con imballaggio esterno di" meaningEn="Composite packaging, glass receptacle in expandable plastic pack" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="YZ" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="YZ" meaningDe="Zusammengesetzte Verpackung, Glasbehälter in festem Kunststoffgebinde" meaningFr="Emballage composite, récipient en verre avec emballage extérieure en p" meaningIt="Imballaggio composito, recipiente di vetro con imballaggio esterno di" meaningEn="Composite packaging, glass receptacle in solid plastic pack" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZA" meaningDe="Massengutbehälter, mittelgross, Pap" meaningFr="Grand récipient pour vrac, en papie" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, paper," validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZA" meaningDe="Massengutbehälter, mittelgross, Papier, mehrlagig" meaningFr="Grand récipient pour vrac, en papier multiplis" meaningIt="Contenitore di grandi dimensioni per rinfuse, di carta multifoglio" meaningEn="Intermediate bulk container, paper, multi-wall" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZB" meaningDe="Beutel, gross" meaningFr="Sac de grande taille" meaningIt="Sacco di grandi dimensioni" meaningEn="Bag, large" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZC" meaningDe="Massengutbehälter, mittelgross, Pap" meaningFr="Grand récipient pour vrac, en papie" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, paper," validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZC" meaningDe="Massengutbehälter, mittelgross, Papier, mehrlagig, wasserresistent" meaningFr="Grand récipient pour vrac, en papier multiplis, résistant à l&apos;eau" meaningIt="Contenitore di grandi dimensioni per rinfuse, di carta multifoglio, re" meaningEn="Intermediate bulk container, paper, multi-wall, water resistant" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZD" meaningDe="Massengutbehälter mittelgross starr" meaningFr="Grand récipient pour vrac solide, e" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, rigid " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZD" meaningDe="Massengutbehälter mittelgross starrer Kunststoff statische Struktur Fe" meaningFr="Grand récipient pour vrac solide, en plastique rigide, avec équipement" meaningIt="Contenitore di grandi dimensioni per merce solida alla rinfusa, di pla" meaningEn="Intermediate bulk container, rigid plastic, with structural equipment," validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZF" meaningDe="Massengutbehälter mittelgross starr" meaningFr="Grand récipient pour vrac solide, e" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, rigid " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZF" meaningDe="Massengutbehälter mittelgross starrer Kunststoff frei stehend Feststof" meaningFr="Grand récipient pour vrac solide, en plastique rigide, autoportant" meaningIt="Contenitore di grandi dimensioni per merce solida alla rinfusa, di pla" meaningEn="Intermediate bulk container, rigid plastic, freestanding, solids" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZG" meaningDe="Massengutbehälter starrer Kunststof" meaningFr="Grand récipient pour vrac, en plast" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, rigid " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZG" meaningDe="Massengutbehälter starrer Kunststoff statische Struktur mit Druck beau" meaningFr="Grand récipient pour vrac, en plastique rigide, avec équipement de str" meaningIt="Contenitore di grandi dimensioni per rinfuse, di plastica rigida, con" meaningEn="Intermediate bulk container, rigid plastic, with structural equipment," validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZH" meaningDe="Massengutbehälter mittelgross starr" meaningFr="Grand récipient pour vrac, en plast" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, rigid " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZH" meaningDe="Massengutbehälter mittelgross starrer Kunststoff frei stehend mit Druc" meaningFr="Grand récipient pour vrac, en plastique rigide, autopartant, pour remp" meaningIt="Contenitore di grandi dimensioni per rinfuse, di plastica rigida, auto" meaningEn="Intermediate bulk container, rigid plastic, freestanding pressurised" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZJ" meaningDe="Massengutbehälter mittelgross starr" meaningFr="Grand récipient pour vrac liquide, " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, rigid " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZJ" meaningDe="Massengutbehälter mittelgross starrer Kunststoff statische Struktur Fl" meaningFr="Grand récipient pour vrac liquide, en plastique rigide, avec équipemen" meaningIt="Contenitore di grandi dimensioni per liquidi alla rinfusa, di plastica" meaningEn="Intermediate bulk container, rigid plastic, with structural equipment," validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZK" meaningDe="Massengutbehälter mittelgross starr" meaningFr="Grand récipient pour vrac liquide, " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, rigid " validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZK" meaningDe="Massengutbehälter mittelgross starrer Kunststoff frei stehend Flüssigk" meaningFr="Grand récipient pour vrac liquide, en plastique rigide, autoportant" meaningIt="Contenitore di grandi dimensioni per liquidi alla rinfusa, di plastica" meaningEn="Intermediate bulk container, rigid plastic, freestanding, liquids" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZL" meaningDe="Massengutbehälter, mittelgross, Ver" meaningFr="Grand récipient pour vrac solide, e" meaningIt="Contenitore di grandi dimensioni oe" meaningEn="Intermediate bulk container, compos" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZL" meaningDe="Massengutbehälter, mittelgross, Verbundmaterial, starrer Kunststoff, F" meaningFr="Grand récipient pour vrac solide, en matériaux composite, avec récipie" meaningIt="Contenitore di grandi dimensioni oer merce solida alla rinfusa, in mat" meaningEn="Intermediate bulk container, composite, rigid plastic, solids" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZM" meaningDe="Massengutbehälter, mittelgross, Ver" meaningFr="Grand récipient pour vrac solide, e" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, compos" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZM" meaningDe="Massengutbehälter, mittelgross, Verbundmaterial, flexibler Kunststoff," meaningFr="Grand récipient pour vrac solide, en matériaux composite, avec récipie" meaningIt="Contenitore di grandi dimensioni per merce solida alla rinfusa, in mat" meaningEn="Intermediate bulk container, composite, flexible plastic, solids" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZN" meaningDe="Massengutbehälter, mittelgross, Ver" meaningFr="Grand récipient pour vrac, en matér" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, compos" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZN" meaningDe="Massengutbehälter, mittelgross, Verbundmaterial, starrer Kunststoff, m" meaningFr="Grand récipient pour vrac, en matériaux composite, avec récipient inté" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materiale composito," meaningEn="Intermediate bulk container, composite, rigid plastic, pressurised" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZP" meaningDe="Massengutbehälter, mittelgross, Ver" meaningFr="Grand récipient pour vrac, en matér" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, compos" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZP" meaningDe="Massengutbehälter, mittelgross, Verbundmaterial, flexibler Kunststoff," meaningFr="Grand récipient pour vrac, en matéraiux composite, avec récipient inté" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materiale composito," meaningEn="Intermediate bulk container, composite, flexible palstic, pressurised" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZQ" meaningDe="Massengutbehälter, mittelgross, Ver" meaningFr="Grand récipient pour vrac liquide, " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, compos" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZQ" meaningDe="Massengutbehälter, mittelgross, Verbundmaterial, starrer Kunststoff, F" meaningFr="Grand récipient pour vrac liquide, en matériaux composite, avec récipi" meaningIt="Contenitore di grandi dimensioni per liquidi alla rinfusa, con recipie" meaningEn="Intermediate bulk container, composite, rigid plastic, liquids" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZR" meaningDe="Massengutbehälter, mittelgross, Ver" meaningFr="Grand récipient pour vrac liquide, " meaningIt="Contenitori di grandi dimensioni pe" meaningEn="Intermediate bulk container, compos" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZR" meaningDe="Massengutbehälter, mittelgross, Verbundmaterial, flexibler Kunststoff," meaningFr="Grand récipient pour vrac liquide, en matériaux composite, avec récipi" meaningIt="Contenitori di grandi dimensioni per liquidi alla rinfusa, di material" meaningEn="Intermediate bulk container, composite, flexible palstic, liquids" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZS" meaningDe="Massengutbehälter, mittelgross, Ver" meaningFr="grand récipient pour vrac, en matér" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, compos" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZS" meaningDe="Massengutbehälter, mittelgross, Verbundmaterial" meaningFr="grand récipient pour vrac, en matériaux composites" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materiali compositi" meaningEn="Intermediate bulk container, composite" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZT" meaningDe="Massengutbehälter, mittelgross, Hol" meaningFr="Grand récipient pour vrac, en panne" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, fibreb" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZT" meaningDe="Massengutbehälter, mittelgross, Holzfaser" meaningFr="Grand récipient pour vrac, en panneaux de fibres" meaningIt="Contenitore di grandi dimensioni perrinfuse, in pannelli di fibra" meaningEn="Intermediate bulk container, fibreboard" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZU" meaningDe="Massengutbehälter, mittelgross, fle" meaningFr="Grand récipient pour vrac, souple" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, flexib" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZU" meaningDe="Massengutbehälter, mittelgross, flexibel" meaningFr="Grand récipient pour vrac, souple" meaningIt="Contenitore di grandi dimensioni per rinfuse, di materiale morbido" meaningEn="Intermediate bulk container, flexible" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZV" meaningDe="Massengutbehälter, mittelgross, Met" meaningFr="Grand récipient pour vrac, en métal" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, metal," validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZV" meaningDe="Massengutbehälter, mittelgross, Metall, kein Stahl" meaningFr="Grand récipient pour vrac, en métal autre que l&apos;acier" meaningIt="Contenitore di grandi dimensioni per rinfuse, di metallo diverso dall&apos;" meaningEn="Intermediate bulk container, metal, other than steel" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZW" meaningDe="Massengutbehälter, mittelgross, Nat" meaningFr="Grand récipient pour vrac, en bois " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, natura" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZW" meaningDe="Massengutbehälter, mittelgross, Naturholz" meaningFr="Grand récipient pour vrac, en bois naturel" meaningIt="Contenitore di grandi dimensioni per rinfuse, di legno naturale" meaningEn="Intermediate bulk container, natural wood" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZX" meaningDe="Massengutbehälter, mittelgross, Spe" meaningFr="Grand récipient pour vrac, en contr" meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, plywoo" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZX" meaningDe="Massengutbehälter, mittelgross, Sperrholz" meaningFr="Grand récipient pour vrac, en contre-plaqué" meaningIt="Contenitore di grandi dimensioni per rinfuse, di legno compensato" meaningEn="Intermediate bulk container, plywood" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZY" meaningDe="Massengutbehälter, mittelgross, wie" meaningFr="Grand récipient pour vrac, en bois " meaningIt="Contenitore di grandi dimensioni pe" meaningEn="Intermediate bulk container, recons" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="ZY" meaningDe="Massengutbehälter, mittelgross, wiederverwertetes Holz" meaningFr="Grand récipient pour vrac, en bois reconstitué" meaningIt="Contenitore di grandi dimensioni perrinfuse, di legno ricostituito" meaningEn="Intermediate bulk container, reconstituted wood" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="ZZ" meaningDe="Einzelabpackung" meaningFr="Définition commune" meaningIt="Definizione comune" meaningEn="Mutually defined" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1A" meaningDe="Fass, Trommel, Stahl" meaningFr="Fût en acier" meaningIt="Fusto di acciaio" meaningEn="Drum, steel" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1B" meaningDe="Fass, Trommel, Aluminium" meaningFr="Fût en aluminium" meaningIt="Fusto di alluminio" meaningEn="Drum, aluminium" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1D" meaningDe="Fass, Trommel, Sperrholz" meaningFr="Fût en contré-plaqué" meaningIt="Fusto di legno compensato" meaningEn="Drum, plywood" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1F" meaningDe="Container flexibel" meaningFr="Conteneur souple" meaningIt="Contenitore flessibile" meaningEn="Container flexible" validFrom="2013-01-09" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1G" meaningDe="Fass, Trommel, Holzfaser" meaningFr="Fût en carton" meaningIt="Fusto di cartone" meaningEn="Drum, fibre" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1W" meaningDe="Fass, Trommel, Holz" meaningFr="Fût en bois" meaningIt="Fusto di legno" meaningEn="Drum, wooden" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2C" meaningDe="Fass, Holz" meaningFr="Tonneau en bois" meaningIt="Botte (&quot;barrel&quot;) di legno" meaningEn="Barrel, wooden" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3A" meaningDe="Kanister, Stahl" meaningFr="Jerricane en acier" meaningIt="Tanica di acciaio" meaningEn="Jerrycan, steel" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3H" meaningDe="Kanister, Kunststoff" meaningFr="Jerricane en plastique" meaningIt="Tanica di plastica" meaningEn="Jerrycan, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4A" meaningDe="Kasten, Stahl" meaningFr="Caisse en acier" meaningIt="Cassa (&quot;box&quot;) di acciaio" meaningEn="Box, steel" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4B" meaningDe="Kasten, Aluminium" meaningFr="Caisse en aluminium" meaningIt="Cassa (&quot;box&quot;) di alluminio" meaningEn="Box, aluminium" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4C" meaningDe="Kasten, Naturholz" meaningFr="Caisse en bois naturel" meaningIt="Cassa (&quot;box&quot;) di legno naturale" meaningEn="Box, natural wood" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4D" meaningDe="Kasten, Sperrholz" meaningFr="Caisse en contreplaqué" meaningIt="Cassa (&quot;box&quot;) di legno compensato" meaningEn="Box, plywood" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4F" meaningDe="Kasten, wiederverwendbares Holz" meaningFr="Caisse en bois reconstitué" meaningIt="Cassa (&quot;box&quot;) di legno ricostituito" meaningEn="Box, reconstituted wood" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4G" meaningDe="Kasten, Holzfaserplatten" meaningFr="Caisse en panneaux de fibres" meaningIt="Cassa (&quot;box&quot;) in pannelli di fibra" meaningEn="Box, fibreboard" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4H" meaningDe="Kasten, Kunststoff" meaningFr="Caisse en plastique" meaningIt="Cassa (&quot;box&quot;) in plastica" meaningEn="Box, plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="43" meaningDe="Beutel, Massengut" meaningFr="Grand récipient pour vrac souple (&quot;" meaningIt="Contenitore di grandi dimensioni fl" meaningEn="Bag, super bulk" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="43" meaningDe="Beutel, Massengut" meaningFr="Grand récipient pour vrac souple (&quot;big bag&quot;)" meaningIt="Contenitore di grandi dimensioni flessibile per rinfuse, (&quot;big bag&quot;)" meaningEn="Bag, super bulk" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="44" meaningDe="Beutel, Polybag" meaningFr="Sac de polyéthylène polybag" meaningIt="Sacco polybag" meaningEn="Bag, polybag" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="5H" meaningDe="Beutel, gewebter Kunststoff" meaningFr="Sac en tissu de plastique" meaningIt="Sacco di tessuto di plastica" meaningEn="Bag, woven plastic" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="5L" meaningDe="Beutel, Textil" meaningFr="Sac en textile" meaningIt="Sacco di materia tessile" meaningEn="Bag, textile" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="5M" meaningDe="Beutel, Papier" meaningFr="Sac en papier" meaningIt="Sacco di carta" meaningEn="Bag, paper" validFrom="2005-07-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="6H" meaningDe="Zusammengesetzte Verpackung, Kunsts" meaningFr="Emballage composite, récipient en p" meaningIt="Imballagio composito, recipiente di" meaningEn="Composite packaging, plastic recept" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="6H" meaningDe="Zusammengesetzte Verpackung, Kunststoffbehälter" meaningFr="Emballage composite, récipient en plastique" meaningIt="Imballagio composito, recipiente di plastica" meaningEn="Composite packaging, plastic receptacle" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="6P" meaningDe="Zusammengesetzte Verpackung, Glasbe" meaningFr="Emballage composite, récipient en v" meaningIt="Imballaggio composito, recipiente d" meaningEn="Composite packaging, glass receptac" validFrom="2005-07-01" validTo="2006-01-09" validForImport="true" validForExport="true" />
			<entry value="6P" meaningDe="Zusammengesetzte Verpackung, Glasbehälter" meaningFr="Emballage composite, récipient en verre" meaningIt="Imballaggio composito, recipiente di vetro" meaningEn="Composite packaging, glass receptacle" validFrom="2006-01-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="7A" meaningDe="Kiste Case car" meaningFr="Caisse, voiture case car" meaningIt="Contenitore di legno" meaningEn="Case car" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="7B" meaningDe="Kiste, Holz" meaningFr="Caisse en bois" meaningIt="Contenitore case di legno" meaningEn="Case, wooden" validFrom="2013-04-30" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="8A" meaningDe="Palette Holz" meaningFr="Caisse voiture case car" meaningIt="Paletta di legno" meaningEn="Pallet wooden" validFrom="2013-01-19" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="8B" meaningDe="Steige, Holz" meaningFr="Casier en bois" meaningIt="Cassetta di legno" meaningEn="Crate, wooden" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="8C" meaningDe="Bündel, Holz" meaningFr="Ballot, en bois" meaningIt="Pacco di legno" meaningEn="Bundle, wooden" validFrom="2013-01-22" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="permitAuthority">
			<entry value="1" meaningDe="BLW - Bundesamt für Landwirtschaft" meaningFr="OFG - Office fédéral de l&apos;agriculture" meaningIt="UFA - Ufficio federale dell&apos;agricoltura" meaningEn="FOAG - Federal Office for Agriculture" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="EAV - Eidg. Alkoholverwaltung" meaningFr="RFA - Régie fédérale des alcools" meaningIt="RFA - Regia federale degli alcoli" meaningEn="SAB - Swiss Alcohol Board" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="BWIP - Staatssekretariat für Wirtschaft (SECO)" meaningFr="BWIP - Secrétariat d&apos;Etat à l&apos;économie (SECO)" meaningIt="BWIP - Segreteria di Stato dell&apos;economia (SECO)" meaningEn="BWIP - State Secretariat for Economic Affairs (SECO)" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="BWKM - Staatssekretariat für Wirtschaft (SECO)" meaningFr="BWKM - Secrétariat d&apos;Etat à l&apos;économie (SECO)" meaningIt="BWKM - Segreteria di Stato dell&apos;economia (SECO)" meaningEn="BWKM - State Secretariat for Economic Affairs (SECO)" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="BAG - Bundesamt für Gesundheit" meaningFr="OSP - Office fédéral de la santé publique" meaningIt="USP - Ufficio federale della sanità pubblica" meaningEn="SFOPH - Swiss Federal Office of Public Health" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="BAFU - Bundesamt für Umwelt" meaningFr="BAFU - Office fédéral de l&apos;environnement" meaningIt="BAFU - Ufficio federale dell&apos;ambiente" meaningEn="BAFU - Federal Office for the Environment" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="ZSP - Bundesamt für Polizei" meaningFr="OCEP - Office fédéral de la police" meaningIt="UCEP - Ufficio federale di polizia" meaningEn="COP - Federal Office of Police" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Ca - Carbura, Schweizerische Pflichtlagerorganisation für flüssige Treib- und Brennstoffe" meaningFr="Ca - Carbura, Organisation suisse de stockage obligatoire pour carburants et combustibles liquides" meaningIt="Ca - Carbura, Organizzazione svizzera di scorte obbligatorie per carburanti e combustibili liquidi" meaningEn="Ca - Carbura, Swiss Organisation for Stockholding of Liquid Fuels" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="SBV - Schweizerischer Bierbrauerverein" meaningFr="f - f" meaningIt="i - i" meaningEn="e - e" validFrom="1988-01-01" validTo="2000-06-30" validForImport="true" validForExport="true" />
			<entry value="10" meaningDe="TSA - Treuhandstelle der Schweizerischen Antibiotika-Importeure" meaningFr="f - f" meaningIt="TSA - Treuhandstelle der Schweizerischen Antibiotika-Importeure" meaningEn="e - e" validFrom="1988-01-01" validTo="2004-03-31" validForImport="true" validForExport="true" />
			<entry value="11" meaningDe="BLV - Bundesamt für Lebensmittelsicherheit und Veterinärwesen" meaningFr="OSAV - Office fédéral de la sécurité alimentaire et des affaires vétérinaires" meaningIt="USAV - Ufficio federale della sicurezza alimentare e di veterinaria" meaningEn="FSVO - Federal Food Safety and Veterinary Office" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="12" meaningDe="TSD - Treuhandstelle der Schweizerischen Dünger-Pflichtlagerhalter" meaningFr="OSE - Office fiduciaire des détenteurs suisses de stocks obligatoires d&apos;engrais" meaningIt="USC - Ufficio fiduciario dei depositari svizzeri di scorte obbligatorie di concimi" meaningEn="FSF - Fiduciary office of the Swiss holders of compulsory stocks of fertilizers" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="13" meaningDe="TSG - Treuhandstelle der Schweizerischen Getreidepflichtlagerhalter" meaningFr="f - f" meaningIt="i - i" meaningEn="e - e" validFrom="1988-01-01" validTo="2003-12-31" validForImport="true" validForExport="true" />
			<entry value="14" meaningDe="TSL - Treuhandstelle der Schweizerischen Lebensmittelimporteure" meaningFr="f - f" meaningIt="i - i" meaningEn="e - e" validFrom="1988-01-01" validTo="2003-12-31" validForImport="true" validForExport="true" />
			<entry value="15" meaningDe="TSS - Treuhandstelle der Schweizerischen Fabrikanten und Importeure von Seifen und Waschmitteln" meaningFr="OFIFS - Office fiduciaire des fabricants et Importateurs Suisses de savons et produits de lessive" meaningIt="UFIFS - Ufficio fiduciario dei fabbricanti e importatori Svizzeri di saponi e detersivi" meaningEn="e - e" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="16" meaningDe="VSS - Verband Schweizerischer Schmierölimporteure" meaningFr="f - f" meaningIt="i - i" meaningEn="e - e" validFrom="1988-01-01" validTo="2002-12-31" validForImport="true" validForExport="true" />
			<entry value="17" meaningDe="BFE - Bundesamt für Energie" meaningFr="OFE - Office fédéral de l&apos;énergie" meaningIt="UFE - Ufficio federale dell&apos;energia" meaningEn="FOE - Federal Office for Energy" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="18" meaningDe="ZSW - Bundesamt für Polizei" meaningFr="OCA - Office fédéral de la police" meaningIt="UCA - Ufficio federale di polizia" meaningEn="COW - Federal Office of Police" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="19" meaningDe="HI - Schweizerisches Heilmittelinstitut" meaningFr="f - f" meaningIt="i - i" meaningEn="e - e" validFrom="2002-01-01" validTo="2002-03-31" validForImport="true" validForExport="true" />
			<entry value="20" meaningDe="SM - Swissmedic/Schweizerisches Heilmittelinstitut" meaningFr="SM - Swissmedic/Institut suisse des produits thérapeutiques" meaningIt="SM - Swissmedic/Istituto svizzero per gli agenti terapeutici" meaningEn="SM - Swissmedic/Swiss Agency for therapeutic products" validFrom="2002-04-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="21" meaningDe="STB - Oberzolldirektion, Sektion Tabak-  und Bierbesteuerung" meaningFr="STB - Direction générale des douanes, Section Imposition du tabac et de la bière" meaningIt="STB - Direzione generale delle dogane, Sezione Imposizione del tabacco e della birra" meaningEn="STB - Directorate General of Customs, Section for Tobacco and Beer Taxation" validFrom="2003-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="22" meaningDe="rs - réservesuisse" meaningFr="rs - réservesuisse" meaningIt="rs - réservesuisse" meaningEn="rs - réservesuisse" validFrom="2004-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="23" meaningDe="BAK - Bundesamt für Kultur" meaningFr="OFC - Office fédéral de la culture" meaningIt="UFC - Ufficio federale della cultura" meaningEn="FOC - Federal Office of Culture" validFrom="2005-06-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="24" meaningDe="IVI - Institut für Viruskrankheiten und Immunprophylaxe" meaningFr="IVI - Institut de virologie et d&apos;Immunoprophylaxie" meaningIt="IVI - Istituto di virologia e d&apos;immunoprofilassi" meaningEn="IVI - Institute of virology and immunoprophylaxis" validFrom="2007-10-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="80" meaningDe="ESTV - Eidg. Steuerverwaltung" meaningFr="AFC - Administration fédérale des contributions" meaningIt="AFC - Amministrazione federale delle contribuzioni" meaningEn="FTA - Federal Tax Administration" validFrom="2004-08-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="96" meaningDe="EZV Minöst - Eidg. Zollverwaltung: Minöst" meaningFr="AFD IMPMIN - Administration fédérale des douanes: IMPMIN" meaningIt="AFD IOM - Amministrazione federale delle dogane: IOM" meaningEn="FCA MOT - Federal Customs Administration: MOT" validFrom="2004-08-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="97" meaningDe="EZV VOC - Eidg. Zollverwaltung: VOC" meaningFr="AFD COV - Administration fédérale des douanes: COV" meaningIt="AFD COV - Amministrazione federale delle dogane: COV" meaningEn="FCA COV - Federal Customs Administration: COV" validFrom="2004-08-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="98" meaningDe="EZV andere - Eidg. Zollverwaltung: Andere" meaningFr="AFD autres - Administration fédérale des douanes: Autres" meaningIt="AFD altri - Amministrazione federale delle dogane: Altri" meaningEn="FCA other - Federal Customs Administration: Other" validFrom="2004-08-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="99" meaningDe="andere - andere" meaningFr="autres - autres" meaningIt="altri - altri" meaningEn="other - other" validFrom="2004-08-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="permitItemDetailName">
			<entry value="1" meaningDe="Positionsnummer der Bewilligung" meaningFr="Numéro de position du permis" meaningIt="Numero  della posizione del permesso" meaningEn="Positionsnummer der Bewilligung" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Anzahl vorhandene Einheiten gem. Bewilligung" meaningFr="Nombre d&apos;unités disponibles selon le permis" meaningIt="Numero delle unità disponibili secondo il permesso" meaningEn="Anzahl vorhandene Einheiten gem. Bewilligung" validFrom="2012-09-06" validTo="2014-07-24" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Abzuschreibende Menge (Einheit gem. Bew.)" meaningFr="Quantité à décharger (Nombre d&apos;unités selon le permis)" meaningIt="Quantità da scaricare (Numero delle unità secondo il permesso)" meaningEn="Abzuschreibende Menge (Einheit gem. Bew.)" validFrom="2014-07-25" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Warenart gem. CITES" meaningFr="Genre de marchandises selon la CITES" meaningIt="Tipo di merci secondo la CITES" meaningEn="Warenart gem. CITES" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Wissenschaftliche Bezeichnung gem. CITES" meaningFr="Désignation scientifique selon la CITES" meaningIt="Designazione scientifica secondo la CITES" meaningEn="Wissenschaftliche Bezeichnung gem. CITES" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="permitObligation">
			<entry value="0" meaningDe="nicht bewilligungspflichtig" meaningFr="Non assujetti au permis" meaningIt="Non soggetto all&apos;obbligo del permesso" meaningEn="en_nicht bewilligungspflichtig" validFrom="1999-09-08" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="bewilligungspflichtig" meaningFr="Assujetti au permis" meaningIt="Permesso obbligatorio" meaningEn="en_bewilligungspflichtig" validFrom="1999-09-08" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="bewilligungsfrei gemäss Deklarant" meaningFr="exempt de permis selon déclarant" meaningIt="esente da permesso secondo dichiarante" meaningEn="en_bewilligungsfrei gemäss Deklarant" validFrom="2000-11-22" validTo="2070-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="permitType">
			<entry value="1" meaningDe="Einzelbewilligung" meaningFr="Autorisation unique" meaningIt="Permesso singolo" meaningEn="en_Einzelbewilligung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Generaleinfuhrbewilligung" meaningFr="Autorisation générale d&apos;importation" meaningIt="Permesso generale d&apos;importazione" meaningEn="en_Generaleinfuhrbewilligung" validFrom="2004-01-01" validTo="2009-11-02" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Generalbewilligung" meaningFr="Autorisation generale" meaningIt="Permesso generale" meaningEn="en_Generalbewilligung" validFrom="2009-11-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Generallizenz" meaningFr="License générale" meaningIt="Licenza generale" meaningEn="en_Generallizenz" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Revers Tabak" meaningFr="Revers Tabac" meaningIt="Revers tabacco" meaningEn="en_Revers Tabak" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="5" meaningDe="Verwendungsverpflichtung" meaningFr="Engagement d&apos;emploi" meaningIt="Impegno circa l&apos;uso" meaningEn="en_Verwendungsverpflichtung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="Verpflichtung" meaningFr="Engagement" meaningIt="Impegno" meaningEn="en_Verpflichtung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="Bewilligung zur periodischen Steueranmeldung" meaningFr="Autorisation pour déclaration fiscale périodique" meaningIt="Autorizzazione per la dichiarazione fiscale periodica" meaningEn="en_Bewilligung zur periodischen Steueranmeldung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="(beso) Verpflichtung Minöst" meaningFr="Déclaration (particulière) Impmin" meaningIt="Impegno (particolare) per l&apos;imposta sugli oli minerali" meaningEn="en_(beso) Verpflichtung Minöst" validFrom="2004-01-01" validTo="2011-08-23" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Verpflichtung Minöst" meaningFr="Déclaration Impmin" meaningIt="Impegno per l&apos;imposta sugli oli minerali" meaningEn="en_Verpflichtung Minöst" validFrom="2011-08-24" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Nachweis Bio-Treibstoff" meaningFr="Numéro de preuve pour biocarburant" meaningIt="giustificativo carburante bio" meaningEn="en_Nachweis Bio-Treibstoff" validFrom="2008-10-09" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Nachweis Bio-Treibstoff" meaningFr="justificatif carburant bio" meaningIt="giustificativo carburante bio" meaningEn="en_Nachweis Bio-Treibstoff" validFrom="2008-04-01" validTo="2008-10-08" validForImport="true" validForExport="true" />
			<entry value="10" meaningDe="Vorausfestsetzungsbescheinigung" meaningFr="Certificat de préfixation" meaningIt="Certificato di prefissazione" meaningEn="eng_Vorausfestsetzungsbescheinigung" validFrom="2010-11-30" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="10" meaningDe="Vorausfestsetzungsbescheinigung" meaningFr="fra_10" meaningIt="ita_10" meaningEn="eng_10" validFrom="2008-11-02" validTo="2010-11-29" validForImport="false" validForExport="true" />
			<entry value="10" meaningDe="Vorausfestsetzungsbescheinigung" meaningFr="Certificat de préfixation" meaningIt="Certificato di predeterminazione" meaningEn="eng_Vorausfestsetzungsbescheinigung" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="11" meaningDe="eEinzelbewilligung" meaningFr="Autorisation unique électronique" meaningIt="Permesso singolo elettronico" meaningEn="eEinzelbewilligung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="12" meaningDe="eGeneralbewilligung" meaningFr="Autorisation général électronique" meaningIt="Permesso generale elettronico" meaningEn="eGeneralbewilligung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="99" meaningDe="Andere" meaningFr="Autres" meaningIt="Altri" meaningEn="en_Andere" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="positionType">
			<entry value="1" meaningDe="Ware, Lohn, Fracht" meaningFr="marchandise, salaire, port " meaningIt="merce, salario, nolo " meaningEn="en_Ware, Lohn, Fracht" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Neumaterial" meaningFr="Matériel neuf" meaningIt="Materiale nuovo" meaningEn="en_Neumaterial" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Ware, Lohn, Neumaterial, Fracht" meaningFr="Marchandise, salaire, matériel neuf, port" meaningIt="Merce, salario, materiale nuovo, nolo" meaningEn="en_Ware, Lohn, Neumaterial, Fracht" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="postalShipmentType">
			<entry value="1" meaningDe="Briefpostverkehr" meaningFr="trafic de la poste aux lettres" meaningIt="traffico della posta - lettere" meaningEn="en_Briefpostverkehr" validFrom="2007-06-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Paketpostverkehr" meaningFr="trafic des colis postaux" meaningIt="traffico della posta - pacchi" meaningEn="Paketpostverkehr" validFrom="2007-06-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="previousDocumentType">
			<entry value="OZLNR" meaningDe="OZL Nummer" meaningFr="Numéro EDO" meaningIt="Numero DDA" meaningEn="en_OZL Nummer" validFrom="2013-08-13" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="T2ATA" meaningDe="T2-ATA" meaningFr="T2-ATA" meaningIt="T2-ATA" meaningEn="en_T2-ATA" validFrom="1999-12-06" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="T2CIM" meaningDe="T2-CIM/TR" meaningFr="T2-CIM/TR" meaningIt="T2-CIM/TR" meaningEn="en_T2-CIM/TR" validFrom="1999-12-06" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="T2TIR" meaningDe="T2-TIR" meaningFr="T2-TIR" meaningIt="T2-TIR" meaningEn="en_T2-TIR" validFrom="1999-12-06" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="BAMU" meaningDe="Bandveranlagung Mülligen Urdorf" meaningFr="Taxation au tapis roulant Mülligen Urdorf" meaningIt="Imposizione al nastro trasportatore Mülligen Urdorf" meaningEn="Bandveranlagung Mülligen Urdorf" validFrom="2014-02-23" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="C641" meaningDe="Dissostichus  Fangdokument Einfuhr" meaningFr="Dissostichus Certificat de capture importation" meaningIt="Dissostichus Documento di cattura importazione" meaningEn="Dissostichus catch document import" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C641" meaningDe="Dissostichus - Fangdokument, Einfuhr" meaningFr="Dissostichus - Certificat de capture, importation" meaningIt="Dissostichus - catch document import" meaningEn="en_Dissostichus - Fangdokument, Einfuhr" validFrom="2011-02-08" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="C641" meaningDe="Dissostichus - Fangdokument, Einfuhr" meaningFr="Dissostichus - Certificat de capture, importation" meaningIt="Dissostichus - catch document import" meaningEn="en_Dissostichus - Fangdokument, Einfuhr" validFrom="2011-02-07" validTo="2011-02-08" validForImport="true" validForExport="true" />
			<entry value="C656" meaningDe="Dissostichus - Fangdokument, Ausfuhr" meaningFr="Dissostichus - Certificat de capture, exportation" meaningIt="Dissostichus - Documento di cattura, esportazione" meaningEn="Dissostichus - Catch document export" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C673" meaningDe="Fangbescheinigung" meaningFr="Certificat de capture" meaningIt="Certificato di cattura" meaningEn="Catch certificate" validFrom="2010-05-08" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="DONR" meaningDe="Dossiernummer" meaningFr="Numéro du dossier" meaningIt="Numero di dossier" meaningEn="en_Dossiernummer" validFrom="2013-08-13" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="T2LF" meaningDe="T2LF" meaningFr="T2LF" meaningIt="T2LF" meaningEn="en_T2LF" validFrom="1999-12-06" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="T2SM" meaningDe="T2SM" meaningFr="T2SM" meaningIt="T2SM" meaningEn="en_T2SM" validFrom="2009-07-09" validTo="2011-05-09" validForImport="true" validForExport="true" />
			<entry value="T2SM" meaningDe="T2SM" meaningFr="T2SM" meaningIt="T2SM" meaningEn="en_T2SM" validFrom="2011-05-09" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="WAZS" meaningDe="Warenausweis Zollstelle" meaningFr="Détail des marchandises office de douane" meaningIt="Distinta delle merci Ufficio" meaningEn="en_Warenausweis Zollstelle" validFrom="2014-03-12" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="AEO-Versender/Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Esportatore AEO" meaningEn="en_AEO-Versender/Ausführer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="AEO-Versender/Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Consignor / exporter (AEO)" meaningEn="en_AEO-Versender/Ausführer" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Versender / Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Consignor / exporter (AEO)" meaningEn="en_Versender / Ausführer" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Zugelassener Wirtschaftsbeteiligter" meaningFr="fr_Zugelassener Wirtschaftsbeteiligter" meaningIt="it_Zugelassener Wirtschaftsbeteiligter" meaningEn="en_Zugelassener Wirtschaftsbeteiligter" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Versender / Ausführer" meaningFr="fr_Versender / Ausführer" meaningIt="it_Versender / Ausführer" meaningEn="en_Versender / Ausführer" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="AEO-Empfänger" meaningFr="Destinataire AEO" meaningIt="Destinatario AEO" meaningEn="en_AEO-Empfänger" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="AEO-Empfänger" meaningFr="Destinataire (AEO)" meaningIt="Consignee (AEO certificate number)" meaningEn="en_AEO-Empfänger" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="Empfänger" meaningFr="fr_Empfänger" meaningIt="it_Empfänger" meaningEn="en_Empfänger" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="Empfänger" meaningFr="Destinataire (AEO)" meaningIt="Consignee (AEO certificate number)" meaningEn="en_Empfänger" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO Anmelder" meaningFr="Déclarant AEO" meaningIt="Dichiarante AEO" meaningEn="en_AEO Anmelder" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO-Anmelder (Deklarant)" meaningFr="Déclarant (AEO)" meaningIt="Declarant (AEO certificate number)" meaningEn="en_AEO-Anmelder (Deklarant)" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO-Anmelder" meaningFr="Déclarant (AEO)" meaningIt="Declarant (AEO certificate number)" meaningEn="en_AEO-Anmelder" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="Empfänger" meaningFr="fr_Empfänger" meaningIt="it_Empfänger" meaningEn="en_Empfänger" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="Deklarant" meaningFr="fr_Deklarant" meaningIt="it_Deklarant" meaningEn="en_Deklarant" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="AEO Vertreter" meaningFr="Représentant AEO" meaningIt="Rappresentante AEO" meaningEn="en_AEO Vertreter" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="AEO-Vertreter" meaningFr="Représentant (AEO)" meaningIt="Representative (AEO)" meaningEn="en_AEO-Vertreter" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Vertreter" meaningFr="Représentant (AEO)" meaningIt="Representative (AEO)" meaningEn="en_Vertreter" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Vertreter" meaningFr="fr_Vertreter" meaningIt="it_Vertreter" meaningEn="en_Vertreter" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Deklarant" meaningFr="fr_Deklarant" meaningIt="it_Deklarant" meaningEn="en_Deklarant" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="Hauptverpflichteter" meaningFr="Principal obligé (AEO)" meaningIt="Principal (AEO certificate number)" meaningEn="en_Hauptverpflichteter" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="AEO-Hauptverpflichteter" meaningFr="Principal obligé (AEO)" meaningIt="Principal (AEO certificate number)" meaningEn="en_AEO-Hauptverpflichteter" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="HV Principal" meaningFr="fr_HV Principal" meaningIt="it_HV Principal" meaningEn="en_HV Principal" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="Hauptverpflichteter" meaningFr="fr_Hauptverpflichteter" meaningIt="it_Hauptverpflichteter" meaningEn="en_Hauptverpflichteter" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="AEO Hauptverpflichteter" meaningFr="Principal obligé AEO" meaningIt="Obblig. principale AEO" meaningEn="en_AEO Hauptverpflichteter" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="AEO Lagerinhaber" meaningFr="Entreposeur AEO" meaningIt="Depositario autorizzato AEO" meaningEn="en_AEO Lagerinhaber" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Transporteur" meaningFr="fr_Transporteur" meaningIt="it_Transporteur" meaningEn="en_Transporteur" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="AEO-Lagerinhaber" meaningFr="Entreposeur (AEO)" meaningIt="Warehousekeeper (AEO)" meaningEn="en_AEO-Lagerinhaber" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Lagerinhaber" meaningFr="fr_Lagerinhaber" meaningIt="it_Lagerinhaber" meaningEn="en_Lagerinhaber" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Lagerinhaber" meaningFr="Entreposeur (AEO)" meaningIt="Warehousekeeper (AEO)" meaningEn="en_Lagerinhaber" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="AEO-Beförderer" meaningFr="Transporteur AEO" meaningIt="Trasportatore AEO" meaningEn="en_AEO-Beförderer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="andere zugelassene Wirtschaftsbeteiligte" meaningFr="fr_andere zugelassene Wirtschaftsbeteiligte" meaningIt="it_andere zugelassene Wirtschaftsbeteiligte" meaningEn="en_andere zugelassene Wirtschaftsbeteiligte" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="andere zugelassene Wirtschaftsbeteiligte" meaningFr="Autre opérateur économique autorisé (AEO)" meaningIt="Carrier (AEO certificate number)" meaningEn="en_andere zugelassene Wirtschaftsbeteiligte" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="Hauptverpflichteter" meaningFr="fr_Hauptverpflichteter" meaningIt="it_Hauptverpflichteter" meaningEn="en_Hauptverpflichteter" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="AEO-Beförderer" meaningFr="Autre opérateur économique autorisé (AEO)" meaningIt="Carrier (AEO certificate number)" meaningEn="en_AEO-Beförderer" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe=" And. Zugel. Wirtschaftsbeteiligte" meaningFr="Other authorised economic operator" meaningIt="Other authorised economic operator" meaningEn="en_ And. Zugel. Wirtschaftsbeteiligte" validFrom="2008-11-25" validTo="2011-02-01" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe="And. Zugel. Wirtschaftsbeteiligte" meaningFr="autre opérateur économique agréé" meaningIt="Altro operatore economico autorizzato" meaningEn="en_And. Zugel. Wirtschaftsbeteiligte" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe="And. Zugel. Wirtschaftsbeteiligte" meaningFr="Other authorised economic operator" meaningIt="Other authorised economic operator" meaningEn="en_And. Zugel. Wirtschaftsbeteiligte" validFrom="2011-02-01" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y031" meaningDe="ZWB Zert" meaningFr="AEO Zert" meaningIt="AEO Zert" meaningEn="AEO Zert" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y101" meaningDe="Einfuhrlizenz AGRIM" meaningFr="certificat d&apos;importation AGRIM" meaningIt="titolo d&apos;importazione AGRIM" meaningEn="import licence AGRIM" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y927" meaningDe="Verordnung EG Nr. 1005/2008 des Rates" meaningFr="règlement CE Nr 1005/2008 du Conseil" meaningIt="regolamento CE Nr 1005/2008 del Consiglio" meaningEn="en_Verordnung EG Nr. 1005/2008 des Rates" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y927" meaningDe="Verordnung (EG) Nr. 1005/2008" meaningFr="règlement (CE) n° 1005/2008 du Conseil" meaningIt="regolamento (CE) n. 1005/2008 del Consiglio" meaningEn="Regulation (EC) No. 1005/2008" validFrom="2011-01-28" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="AAM" meaningDe="Ankunftsanmeldung NCTS" meaningFr="Annonce d&apos;arrivée NCTS" meaningIt="Annuncio d&apos;arrivo NCTS" meaningEn="en_Ankunftsanmeldung NCTS" validFrom="2013-01-15" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="CLE" meaningDe="Referenznummer/Datum der Anschreibung in der Buchführung" meaningFr="ICM" meaningIt="ICM" meaningEn="Reference date of entry of the goods in the records" validFrom="2012-02-09" validTo="2012-02-17" validForImport="true" validForExport="true" />
			<entry value="CLE" meaningDe="ICM" meaningFr="ICM" meaningIt="ICM" meaningEn="en_ICM" validFrom="2012-02-08" validTo="2012-02-09" validForImport="true" validForExport="true" />
			<entry value="CLE" meaningDe="ICM" meaningFr="ICM" meaningIt="ICM" meaningEn="en_ICM" validFrom="2012-02-17" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="ENS" meaningDe="ENS" meaningFr="ENS" meaningIt="ENS" meaningEn="ENS" validFrom="2011-02-02" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="iFB" meaningDe="internationaler Frachtbrief" meaningFr="Lettre de voiture internationale" meaningIt="Lettera di vettura internazionale" meaningEn="en_internationaler Frachtbrief" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="IF3" meaningDe="Auskunftsblatt INF 3" meaningFr="INF3" meaningIt="INF3" meaningEn="en_Auskunftsblatt INF 3" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="IF8" meaningDe="Auskunftsblatt INF 8" meaningFr="INF8" meaningIt="INF8" meaningEn="en_Auskunftsblatt INF 8" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="ipv" meaningDe="Import Postverkehr" meaningFr="fr_Import Postverkehr" meaningIt="it_Import Postverkehr" meaningEn="en_Import Postverkehr" validFrom="2007-05-01" validTo="2007-05-14" validForImport="true" validForExport="true" />
			<entry value="IPV" meaningDe="Identifikation Postverkehr" meaningFr="identifcation trafic postal" meaningIt="identificazione traffico postale" meaningEn="en_Identifikation Postverkeh" validFrom="2007-05-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MNS" meaningDe="Manifest - vereinfachtes Verfahren" meaningFr="Manifeste, procédure simplifiée" meaningIt="Cargo manifest - simplified procedure" meaningEn="en_Manifest - vereinfachtes Verfahren" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="MRN" meaningDe="MRN-Versandbezugsnummer" meaningFr="Numéro de référence du mouvement MRN" meaningIt="Numero di riferimento MRN" meaningEn="eng_MRN-Versandbezugsnummer" validFrom="2012-02-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="MRN" meaningDe="MRN-Versandbezugsnummer" meaningFr="fra_MRN-Versandbezugsnummer" meaningIt="ita_MRN-Versandbezugsnummer" meaningEn="eng_MRN-Versandbezugsnummer" validFrom="2004-01-01" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="MRN" meaningDe="MRN-Versandbezugsnummer" meaningFr="fra_MRN-Versandbezugsnummer" meaningIt="Numero di spedizione MRN" meaningEn="eng_MRN-Versandbezugsnummer" validFrom="2011-12-15" validTo="2012-02-14" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers Verwendungsverpflichtung" meaningFr="Revers Forme de l&apos;engagement d&apos;emploi" meaningIt="Revers impegno circa l&apos;uso" meaningEn="en_Revers Verwendungsverpflichtung" validFrom="2013-01-12" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers Verwendungsverpflichtung" meaningFr="Revers Forme de l&apos;engagement d&apos;emploi" meaningIt="Revers impegno circa luso" meaningEn="en_Revers Verwendungsverpflichtung" validFrom="2011-12-20" validTo="2013-01-12" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers (Verwendungsverpflichtung)" meaningFr="Revers(Forme de l&apos;engagement d&apos;emploi)" meaningIt="Revers(Forma dell&apos;impegno d&apos;impiego)" meaningEn="en_Revers (Verwendungsverpflichtung)" validFrom="2008-11-25" validTo="2011-11-08" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers (Verwendungsverpflichtung)" meaningFr="Revers (Verwendungsverpflichtung)" meaningIt="Revers (Verwendungsverpflichtung)" meaningEn="Revers (Verwendungsverpflichtung)" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T01" meaningDe="Revers (Verwendungsverpflichtung)" meaningFr="Revers(Forme de lengagement demploi)" meaningIt="Revers(Forma dellimpegno dimpiego)" meaningEn="en_Revers (Verwendungsverpflichtung)" validFrom="2011-11-08" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T02" meaningDe="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningFr="Permis en complément à un revers existant" meaningIt="Autorizzazione completamenta ad un revers esistente" meaningEn="en_Bewilligung als Ergänzung zu einem bestehenden Revers" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T02" meaningDe="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningFr="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningIt="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningEn="Bewilligung als Ergänzung zu einem bestehenden Revers" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T02" meaningDe="Bewilligung als Ergänzung zu einem bestehenden Revers" meaningFr="Permis en complément à un revers existant" meaningIt="Permesso complementare ad un revers esistente" meaningEn="en_Bewilligung als Ergänzung zu einem bestehenden Revers" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T03" meaningDe="Jahr der Ergänzungsbewilligung" meaningFr="Jahr der Ergänzungsbewilligung" meaningIt="Jahr der Ergänzungsbewilligung" meaningEn="Jahr der Ergänzungsbewilligung" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T03" meaningDe="Jahr der Ergänzungsbewilligung" meaningFr="Année du permis complémentaire" meaningIt="Anno del permesso complementare" meaningEn="en_Jahr der Ergänzungsbewilligung" validFrom="2008-11-25" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T04" meaningDe="Produkthauptgruppe" meaningFr="Groupe principal produit" meaningIt="Gruppo princ prodotto" meaningEn="en_Produkthauptgruppe" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T04" meaningDe="Produkthauptgruppe" meaningFr="Groupe principal produit" meaningIt="Gruppo princ. prodotto" meaningEn="en_Produkthauptgruppe" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T04" meaningDe="Produkthauptgruppe" meaningFr="Produkthauptgruppe" meaningIt="Produkthauptgruppe" meaningEn="Produkthauptgruppe" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T05" meaningDe="Produktuntergruppe" meaningFr="Sous-groupe produit" meaningIt="Sotto gruppo prodotto" meaningEn="en_Produktuntergruppe" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T05" meaningDe="Produktuntergruppe" meaningFr="Sous groupe produit" meaningIt="Sottogruppo di prodotti" meaningEn="en_Produktuntergruppe" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T05" meaningDe="Produktuntergruppe" meaningFr="Produktuntergruppe" meaningIt="Produktuntergruppe" meaningEn="Produktuntergruppe" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T06" meaningDe="Laufnummer" meaningFr="No courant" meaningIt="Numero progressivo" meaningEn="en_Laufnummer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T06" meaningDe="Laufnummer" meaningFr="Laufnummer" meaningIt="Laufnummer" meaningEn="Laufnummer" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T06" meaningDe="Laufnummer" meaningFr="No courant" meaningIt="N. corrente" meaningEn="en_Laufnummer" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T07" meaningDe="Ansatz" meaningFr="Ansatz" meaningIt="Ansatz" meaningEn="Ansatz" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T07" meaningDe="Ansatz" meaningFr="Taux" meaningIt="Aliquota" meaningEn="en_Ansatz" validFrom="2008-11-25" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T08" meaningDe="Besondere Masseinheit - Stück" meaningFr="Besondere Masseinheit - Stück" meaningIt="Besondere Masseinheit - Stück" meaningEn="Besondere Masseinheit - Stück" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T08" meaningDe="Besondere Masseinheit Stück" meaningFr="Quantité spéciale pièce" meaningIt="Quantità particolare pezzo" meaningEn="en_Besondere Masseinheit Stück" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T08" meaningDe="Besondere Masseinheit - Stück" meaningFr="Quantité spéciale - pièce" meaningIt="Quantità particolare - pezzo" meaningEn="en_Besondere Masseinheit - Stück" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T09" meaningDe="Zollauschlussgebiete" meaningFr="Enclave douanière" meaningIt="Enclave doganale" meaningEn="en_Zollauschlussgebiete" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="T09" meaningDe="Zollauschlussgebiete" meaningFr="Enclave douanière" meaningIt="Terr.fuori linea dogana" meaningEn="en_Zollauschlussgebiete" validFrom="2008-11-25" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="T09" meaningDe="Zollauschlussgebiete" meaningFr="Zollauschlussgebiete" meaningIt="Zollauschlussgebiete" meaningEn="Zollauschlussgebiete" validFrom="2006-09-22" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="T2F" meaningDe="T2F (exkl. MWST)" meaningFr="T2F  (sauf TVA)" meaningIt="T2F (solo IVA)" meaningEn="en_T2F (exkl. MWST)" validFrom="1999-12-06" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="T2L" meaningDe="T2L-Nachweis" meaningFr="Document T2L" meaningIt="Documento T2L" meaningEn="en_T2L-Nachweis" validFrom="1999-12-06" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="UWA" meaningDe="Ueberfuhr WA" meaningFr="DM de substitution" meaningIt="DM di sostituzione" meaningEn="en_Ueberfuhr WA" validFrom="2013-01-15" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="VAM" meaningDe="Verkehrsanmeldung" meaningFr="Annonce du trafic" meaningIt="Notifica del traffico" meaningEn="en_Verkehrsanmeldung" validFrom="2013-01-18" validTo="2013-01-25" validForImport="true" validForExport="true" />
			<entry value="VAM" meaningDe="Verkehrsanmeldung" meaningFr="Annonce du trafic" meaningIt="Notifica del traffico" meaningEn="en_Verkehrsanmeldung" validFrom="2013-01-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="VAM" meaningDe="Verkehrsanmeldung" meaningFr="Annonce du trafic" meaningIt="Notifica del traffico" meaningEn="en_Verkehrsanmeldung" validFrom="2012-12-19" validTo="2013-01-18" validForImport="true" validForExport="true" />
			<entry value="zzz" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="Other" validFrom="2010-03-05" validTo="2010-03-06" validForImport="true" validForExport="true" />
			<entry value="zzz" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="other" validFrom="2004-11-05" validTo="2010-03-02" validForImport="true" validForExport="true" />
			<entry value="ZZZ" meaningDe="Sonstige" meaningFr="Autres" meaningIt="Altro" meaningEn="en_Sonstige" validFrom="2011-08-03" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="ZZZ" meaningDe="Sonstige" meaningFr="Autre" meaningIt="Altro" meaningEn="en_Sonstige" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="ZZZ" meaningDe="Sonstige" meaningFr="Autres" meaningIt="Altro" meaningEn="Other" validFrom="2009-09-01" validTo="2011-08-03" validForImport="true" validForExport="true" />
			<entry value="CO" meaningDe="Einheitspapier - Gemeinschaftswaren" meaningFr="DAU Marchandises communautaires" meaningIt="SAD merce comunitaria soggetta a misure specifiche" meaningEn="en_Einheitspapier - Gemeinschaftswaren" validFrom="2011-02-07" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="CO" meaningDe="Einheitspapier - Gemeinschaftswaren" meaningFr="DAU Marchandises communautaires" meaningIt="SAD - Community goods subject to specific measures" meaningEn="en_Einheitspapier - Gemeinschaftswaren" validFrom="2009-01-01" validTo="2011-02-07" validForImport="true" validForExport="true" />
			<entry value="EU" meaningDe="Einheitspapier - Handel mit EFTA" meaningFr="Document Administratif Unique Echanges avec l&apos;AELE" meaningIt="Single Administrative Document- Trade with EFTA" meaningEn="Single Administrative Document- Trade with EFTA" validFrom="2012-06-22" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="EU" meaningDe="Einheitspapier - Handel mit EFTA" meaningFr="Document Administratif Unique  Echanges avec l&apos;AELE" meaningIt="Documento unico per gli scambi con AELS" meaningEn="en_Einheitspapier - Handel mit EFTA" validFrom="2011-02-07" validTo="2012-06-22" validForImport="true" validForExport="true" />
			<entry value="EU" meaningDe="Einheitspapier - Handel mit EFTA" meaningFr="Document Administratif Unique  Echanges avec l&apos;AELE" meaningIt="Single Administrative Document- Trade with EFTA" meaningEn="en_Einheitspapier - Handel mit EFTA" validFrom="2009-01-01" validTo="2011-02-07" validForImport="true" validForExport="true" />
			<entry value="EX" meaningDe="Einheitspapier - Handel mit anderen als EU und EFTA (EX)" meaningFr="Document Administratif Unique Echanges autres qu&apos;avec l&apos;UE ou l&apos;AELE (EX)" meaningIt="Documento unico per scambi con altri che UE e AELS (EX)" meaningEn="en_Einheitspapier - Handel mit anderen als EU und EFTA (EX)" validFrom="2011-02-07" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="EX" meaningDe="Einheitspapier - Handel mit anderen als EU und EFTA" meaningFr="Document Administratif Unique Echanges autres qu&apos;avec l&apos;UE ou l&apos;AELE" meaningIt="Single Administrative Document- Trade with other than EU and EFTA" meaningEn="en_Einheitspapier - Handel mit anderen als EU und EFTA" validFrom="2009-01-01" validTo="2011-02-07" validForImport="true" validForExport="true" />
			<entry value="IM" meaningDe="Einheitspapier - Handel mit anderen als EU und EFTA" meaningFr="Document Administratif Unique Echanges autres qu&apos;avec l&apos;UE ou l&apos;AELE" meaningIt="Single Administrative Document- Trade with other than EU and EFTA" meaningEn="en_Einheitspapier - Handel mit anderen als EU und EFTA" validFrom="2009-01-01" validTo="2011-02-07" validForImport="true" validForExport="true" />
			<entry value="IM" meaningDe="Einheitspapier - Handel mit anderen als EU und EFTA (IM)" meaningFr="Document Administratif Unique Echanges autres qu&apos;avec l&apos;UE ou l&apos;AELE (IM)" meaningIt="Documento unico  per scambi con altri che UE e AELS (IM)" meaningEn="en_Einheitspapier - Handel mit anderen als EU und EFTA (IM)" validFrom="2011-02-07" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="LZ" meaningDe="Laufzettel" meaningFr="Fiche d&apos;accompagnement" meaningIt="Scheda di circolazione" meaningEn="en_Laufzettel" validFrom="2013-01-04" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="LZ" meaningDe="Laufzettel" meaningFr="Détail des marchandises" meaningIt="Distinta delle merci" meaningEn="en_Laufzettel" validFrom="2004-01-01" validTo="2013-01-03" validForImport="true" validForExport="true" />
			<entry value="T1" meaningDe="T1" meaningFr="T1" meaningIt="T1" meaningEn="en_T1" validFrom="2009-06-09" validTo="2009-06-09" validForImport="true" validForExport="true" />
			<entry value="T2" meaningDe="T2" meaningFr="T2" meaningIt="T2" meaningEn="en_T2" validFrom="1999-12-08" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="WA" meaningDe="Warenausweis" meaningFr="Fiche d&apos;accompagnement" meaningIt="Scheda di circolazione" meaningEn="en_Warenausweis" validFrom="2004-01-01" validTo="2013-01-03" validForImport="true" validForExport="true" />
			<entry value="WA" meaningDe="Warenausweis" meaningFr="Détail des marchandises" meaningIt="Distinta delle merci" meaningEn="en_Warenausweis" validFrom="2013-01-04" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Konformitätsbescheinigung" meaningFr="Certificat de conformité" meaningIt="Certificato di conformità" meaningEn="Certificate of conformity" validFrom="2004-11-05" validTo="2011-08-22" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Konformitätsbescheinigung" meaningFr="Certificat de conformité" meaningIt="Certificato di conformità" meaningEn="en_Konformitätsbescheinigung" validFrom="2011-08-22" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Qualitätszeugnis" meaningFr="Certificat de qualité" meaningIt="Certificato di qualità" meaningEn="Certificate of quality" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="18" meaningDe="Warenverkehrsbescheinigung A.TR.1" meaningFr="Certificat ATR1" meaningIt="Certificato di circolazione A.TR.1" meaningEn="Movement certificate A.TR.1" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="Containerliste" meaningFr="Liste de conteneur" meaningIt="Elenco dei container" meaningEn="Container list" validFrom="2004-11-05" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="Containerliste" meaningFr="Container list" meaningIt="Container list" meaningEn="en_Containerliste" validFrom="2012-07-25" validTo="2013-10-09" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="Containerliste" meaningFr="Liste de conteneur" meaningIt="Elenco dei contenitori" meaningEn="Container list" validFrom="2013-10-09" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="270" meaningDe="Ladeliste" meaningFr="Loading list delivery note" meaningIt="Loading list delivery note" meaningEn="en_Ladeliste" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="271" meaningDe="Packliste" meaningFr="Packing list" meaningIt="Packing list" meaningEn="en_Packliste" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="271" meaningDe="Packliste" meaningFr="Liste de colisage" meaningIt="Distinta del carico" meaningEn="Packing list" validFrom="2004-11-05" validTo="2011-08-03" validForImport="true" validForExport="true" />
			<entry value="271" meaningDe="Packliste" meaningFr="Liste de colisage" meaningIt="Distinta del carico" meaningEn="en_Packliste" validFrom="2011-08-03" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="325" meaningDe="Proformarechnung" meaningFr="Facture proforma" meaningIt="Fattura proforma" meaningEn="en_Proformarechnung" validFrom="2011-08-03" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="325" meaningDe="Proformarechnung" meaningFr="Proforma invoice" meaningIt="Proforma invoice" meaningEn="en_Proformarechnung" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="325" meaningDe="Proformarechnung" meaningFr="Facture proforma" meaningIt="Fattura proforma" meaningEn="Proforma invoice" validFrom="2004-11-05" validTo="2011-08-03" validForImport="true" validForExport="true" />
			<entry value="337" meaningDe="Summarische Anmeldung zur vorübergehenden Lagerung" meaningFr="déclaration sommaire de dépôt temporaire" meaningIt="dichiarazione sommaria per la custodia temporanea" meaningEn="en_Summarische Anmeldung zur vorübergehenden Lagerung" validFrom="2011-05-09" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="337" meaningDe="Summarische Anmeldung zur vorübergehenden Lagerung" meaningFr="déclaration sommaire de dépôt temporaire" meaningIt="dichiarazione sommaria per la custodia temporanea" meaningEn="Summary declaration for temporary storage" validFrom="2011-02-04" validTo="2011-02-10" validForImport="true" validForExport="true" />
			<entry value="337" meaningDe="Summarische Anmeldung zur vorübergehenden Lagerung" meaningFr="déclaration sommaire de dépôt temporaire" meaningIt="dichiarazione sommaria per la custodia temporanea" meaningEn="en_Summarische Anmeldung zur vorübergehenden Lagerung" validFrom="2011-02-10" validTo="2011-05-09" validForImport="true" validForExport="true" />
			<entry value="355" meaningDe="Summarische Voranmeldung" meaningFr="déclaration sommaire d&apos;entrée" meaningIt="Dichiarazione sommaria di ingresso" meaningEn="en_Summarische Voranmeldung" validFrom="2011-02-07" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="355" meaningDe="Summarische Voranmeldung" meaningFr="déclaration sommaire d&apos;entrée" meaningIt="Dichiarazione sommaria di ingresso" meaningEn="Entry summary declaration" validFrom="2011-02-04" validTo="2011-02-07" validForImport="true" validForExport="true" />
			<entry value="380" meaningDe="Handelsrechnung" meaningFr="Facture commerciale" meaningIt="Fattura commerciale" meaningEn="Commercial invoice" validFrom="2004-11-05" validTo="2011-05-09" validForImport="true" validForExport="true" />
			<entry value="380" meaningDe="Handelsrechnung" meaningFr="Facture commerciale" meaningIt="Fattura commerciale" meaningEn="en_Handelsrechnung" validFrom="2011-05-09" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="703" meaningDe="Hausfrachtbrief" meaningFr="Récepissé" meaningIt="Lett.ra  vettura emessa da sped.re" meaningEn="House waybill" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="703" meaningDe="Hausfrachtbrief" meaningFr="Récepissé" meaningIt="Lettera di vettura casa" meaningEn="House waybill" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="704" meaningDe="Sammelkonnossement" meaningFr="Connaissement principal" meaningIt="Polizza di carico principale" meaningEn="Master bill of lading" validFrom="2004-11-05" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="704" meaningDe="Sammelkonossement" meaningFr="Master bill of lading" meaningIt="Master bill of lading" meaningEn="en_Sammelkonossement" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="705" meaningDe="Konnossement" meaningFr="Connaissement" meaningIt="Polizza di carico" meaningEn="Bill of lading" validFrom="2004-11-05" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="705" meaningDe="Konnossement" meaningFr="Bill of lading" meaningIt="Bill of lading" meaningEn="en_Konnossement" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement émis par un transitai" meaningIt="Polizza di carico emessa da sped.re" meaningEn="House bill of lading" validFrom="2009-04-30" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement maison interne" meaningIt="Polizza di carico emessa da sped.re" meaningEn="en_Hauskonnossement" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement maison/interne" meaningIt="Polizza di carico emessa da sped.re" meaningEn="House bill of lading" validFrom="2004-11-05" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief ( Rail )" meaningFr="CIM-feuille de route ( Rail )" meaningIt="CIM-lettera di vettura ( Rail )" meaningEn="CIM consignment note (rail)" validFrom="2010-02-09" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief Rail" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM-consignment note Rail" validFrom="2011-12-20" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="Frachtbrief CIM" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM consignment note rail" validFrom="2012-08-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief Rail" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM consignment note Rail" validFrom="2009-07-09" validTo="2009-08-12" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="Frachtbrief CIM" meaningFr="CIM consignment note rail" meaningIt="CIM consignment note rail" meaningEn="en_Frachtbrief CIM" validFrom="2012-07-25" validTo="2012-08-21" validForImport="true" validForExport="true" />
			<entry value="722" meaningDe="SMGS-Begleitliste" meaningFr="Feuille de route-SMGS" meaningIt="Doc. accompagnamento-SMGS" meaningEn="Road list-SMGS" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="722" meaningDe="SMGS-Begleitliste" meaningFr="Road list SMGS" meaningIt="Road list SMGS" meaningEn="en_SMGS-Begleitliste" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="722" meaningDe="SMGS Begleitliste" meaningFr="Feuille de route SMGS" meaningIt="Doc. accompagnamento SMGS" meaningEn="Road list SMGS" validFrom="2011-12-20" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="730" meaningDe="LKW-Frachtbrief" meaningFr="Road consignment note" meaningIt="Road consignment note" meaningEn="en_LKW-Frachtbrief" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="730" meaningDe="LKW-Frachtbrief" meaningFr="Document d&apos;expédition par route" meaningIt="Lettera di vettura stradale" meaningEn="Road consignment note" validFrom="2004-11-05" validTo="2011-08-03" validForImport="true" validForExport="true" />
			<entry value="730" meaningDe="LKW-Frachtbrief" meaningFr="Lettre de voiture transport routier" meaningIt="Lettera di vettura stradale" meaningEn="en_LKW-Frachtbrief" validFrom="2011-08-03" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="740" meaningDe="Luftfrachtbrief" meaningFr="Master air waybill" meaningIt="Master air waybill" meaningEn="en_Luftfrachtbrief" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="740" meaningDe="Luftfrachtbrief" meaningFr="Lettre de transport aérien" meaningIt="Lettera di vettura aerea" meaningEn="Air waybill" validFrom="2004-11-05" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="741" meaningDe="Master-Luftfrachtbrief" meaningFr="Lettre de transport aérien principale" meaningIt="Lettera di vettura aerea principale" meaningEn="Master air waybill" validFrom="2004-11-05" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="741" meaningDe="Luftfrachtbrief ausgestellt von der Fluggesellschaft" meaningFr="Master air waybill" meaningIt="Master air waybill" meaningEn="en_Luftfrachtbrief ausgestellt von der Fluggesellschaft" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="750" meaningDe="Paketkarte Despatch note" meaningFr="Bulletin d&apos;expédition colis postaux" meaningIt="Bollettino spedizione pacchi postali" meaningEn="Despatch note post parcels" validFrom="2011-12-20" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="750" meaningDe="Paketkarte Postpakete" meaningFr="Despatch note post parcels" meaningIt="Despatch note post parcels" meaningEn="en_Paketkarte Postpakete" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="750" meaningDe="Paketkarte (Despatch note)" meaningFr="Bulletin d&apos;expédition (colis postaux)" meaningIt="Bollettino spedizione (pacchi postali)" meaningEn="Despatch note (post parcels)" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="760" meaningDe="Kombiniertes Transportdokument" meaningFr="Doc. transp. multimodal/combiné" meaningIt="Doc.trasporto multimodale/combinato" meaningEn="Multimodal/combined transport doc." validFrom="2004-11-05" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="760" meaningDe="Multimodales kombiniertes Transportdokument" meaningFr="Multimodal combined transport document" meaningIt="Multimodal combined transport document" meaningEn="en_Multimodales kombiniertes Transportdokument" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Manifeste de cargaison" meaningIt="Manifesto cargo" meaningEn="Cargo manifest" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Manifeste de cargaison" meaningIt="Manifesto cargo" meaningEn="en_Frachtmanifest" validFrom="2011-12-19" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Cargo manifest" meaningIt="Cargo manifest" meaningEn="en_Frachtmanifest" validFrom="2011-08-02" validTo="2011-12-19" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Manifeste" meaningIt="Manifesto di carico" meaningEn="Cargo manifest" validFrom="2004-11-05" validTo="2011-08-02" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereaux" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2011-02-01" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereau" meaningIt="Bordereau" meaningEn="en_Ladungsverzeichnis" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereau" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2011-12-20" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereau" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2004-11-05" validTo="2011-02-01" validForImport="true" validForExport="true" />
			<entry value="820" meaningDe="Gemeinschaftliche Versandanmeldung - gemischte Sendungen (T)" meaningFr="Community transit Declaration - Mixed consignments (T)" meaningIt="Community transit Declaration - Mixed consignments (T)" meaningEn="en_Gemeinschaftliche Versandanmeldung - gemischte Sendungen (T)" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="820" meaningDe="T-Versandschein" meaningFr="Document d&apos;expédition modèle T" meaningIt="Documento di spedizione modello T" meaningEn="Despatch note model T" validFrom="2004-11-05" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="821" meaningDe="Versandanmeldung T1" meaningFr="Document d&apos;expédition modèle T1" meaningIt="Documento di spedizione modello T1" meaningEn="en_Versandanmeldung T1" validFrom="2011-05-09" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="821" meaningDe="T1-Versandschein" meaningFr="Document d&apos;expédition modèle T1" meaningIt="Documento di spedizione modello T1" meaningEn="Despatch note model T1" validFrom="2004-11-05" validTo="2011-05-09" validForImport="true" validForExport="true" />
			<entry value="822" meaningDe="Internal Community transit Declaration (T2)" meaningFr="Internal Community transit Declaration (T2)" meaningIt="Internal Community transit Declaration (T2)" meaningEn="en_Internal Community transit Declaration (T2)" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="822" meaningDe="T2-Versandschein" meaningFr="Document d&apos;expédition modèle T2" meaningIt="Documento di spedizione modello T2" meaningEn="en_T2-Versandschein" validFrom="2012-06-21" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="822" meaningDe="T2-Versandschein" meaningFr="Document d&apos;expédition modèle T2" meaningIt="Documento di spedizione modello T2" meaningEn="Despatch note model T2" validFrom="2004-11-05" validTo="2012-06-21" validForImport="true" validForExport="true" />
			<entry value="823" meaningDe="T5 Kontrollexemplar" meaningFr="Document de contrôle T5" meaningIt="Documento di controllo T5" meaningEn="en_T5 Kontrollexemplar" validFrom="2012-06-21" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="823" meaningDe="T5 Kontrollexemplar" meaningFr="Document de contrôle T5" meaningIt="Documento di controllo T5" meaningEn="Control document T5" validFrom="2004-11-05" validTo="2012-06-21" validForImport="true" validForExport="true" />
			<entry value="823" meaningDe="Kontrollexemplar T5" meaningFr="Control copy T5" meaningIt="Control copy T5" meaningEn="en_Kontrollexemplar T5" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="825" meaningDe="T2L-Versandnachweis" meaningFr="Document d&apos;expédition modèle T2L" meaningIt="Documento di spedizione modello T2L" meaningEn="Despatch note model T2L" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="830" meaningDe="Ausfuhrdeklaration" meaningFr="Déclaration d&apos;exportation" meaningIt="Dichiarazione di esportazione" meaningEn="Goods declaration for exportation" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="851" meaningDe="Pflanzenschutzzeugnis" meaningFr="Certificat phytosanitaire" meaningIt="Certificato fitosanitario" meaningEn="Phytosanitary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="852" meaningDe="Genusstauglichkeitszeugnis" meaningFr="Certificat sanitaire" meaningIt="Certificato sanitario" meaningEn="Sanitary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="853" meaningDe="Tierärztliches Gesundheitszeugnis" meaningFr="Certificat vétérinaire" meaningIt="Certificato veterinario" meaningEn="Veterinary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="861" meaningDe="Ursprungszeugnis" meaningFr="Certificat d&apos;origine" meaningIt="Certificato d&apos;origine" meaningEn="Certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="862" meaningDe="Ursprungserklärung" meaningFr="Déclaration d&apos;origine" meaningIt="Dichiarazione di origine" meaningEn="Declaration of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="864" meaningDe="Präferenz-Ursprungsnachweis" meaningFr="Certificat d&apos;origine préference" meaningIt="Certificato di origine preferenziale" meaningEn="Preference certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="865" meaningDe="APS-Ursprungszeugnis" meaningFr="Certificat d&apos;origine formulaire SGP" meaningIt="Certificato di origine form. APS" meaningEn="Certificate of origin form GSP" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="900" meaningDe="Beilagen zur Identitätssicherung" meaningFr="fr_Beilagen zur Identitätssicherung" meaningIt="it_Beilagen zur Identitätssicherung" meaningEn="en_Beilagen zur Identitätssicherung" validFrom="2013-12-02" validTo="2014-02-04" validForImport="true" validForExport="true" />
			<entry value="900" meaningDe="Beilagen zur Identitätssicherung" meaningFr="Annexes servant à garantir identité" meaningIt="Allegati per garantire identità" meaningEn="en_Beilagen zur Identitätssicherung" validFrom="2014-02-04" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="911" meaningDe="Einfuhrlizenz" meaningFr="Licence d&apos;importation" meaningIt="Licenza di importazione" meaningEn="Import licence" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="933" meaningDe="Frachtanmeldung Ankunft" meaningFr="Déclaration de chargement arrivée" meaningIt="Dichiarazione del carico arrivo" meaningEn="Cargo declaration arrival" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="933" meaningDe="Frachtanmeldung (Ankunft)" meaningFr="Déclaration de chargement (arrivée)" meaningIt="Dichiarazione del carico (arrivo)" meaningEn="Cargo declaration (arrival)" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="941" meaningDe="Ausfuhrgenehmigung für Embargowaren" meaningFr="Permit d&apos;export pr march. sous embargo" meaningIt="Autorizzazione per merci sotto embargo" meaningEn="Embargo permit" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="951" meaningDe="TIF-Dokument" meaningFr="Formulaire TIF" meaningIt="Modulo TIF" meaningEn="TIF form" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="en_Carnet TIR" validFrom="2012-06-21" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="TIR Carnet" validFrom="2011-12-20" validTo="2012-06-21" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet-TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="TIR carnet" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="en_Carnet TIR" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="954" meaningDe="EUR.1 Warenverkehrsbescheinigung" meaningFr="EUR 1 certificat d&apos;origine" meaningIt="Certificato di origine EUR 1" meaningEn="en_EUR.1 Warenverkehrsbescheinigung" validFrom="2012-06-21" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="954" meaningDe="EUR.1 Warenverkehrsbescheinigung" meaningFr="EUR 1 certificat d&apos;origine" meaningIt="Certificato di origine EUR 1" meaningEn="EUR 1 certificate of origin" validFrom="2004-11-05" validTo="2012-06-21" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="Carnet ATA" meaningFr="Carnet ATA" meaningIt="Carnet ATA" meaningEn="en_Carnet ATA" validFrom="2012-07-25" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="Carnet ATA" meaningFr="Carnet ATA" meaningIt="Carnet ATA" meaningEn="ATA carnet" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="Carnet ATA" meaningFr="Carnet ATA" meaningIt="Carnet ATA" meaningEn="ATA Carnet" validFrom="2011-12-20" validTo="2012-07-25" validForImport="true" validForExport="true" />
			<entry value="1151" meaningDe="11.51 nationaler Geleitschein, verbürgt" meaningFr="11.51 acquit-à-caution national, garanti" meaningIt="11.51 bolletta di cauzione nazionale, garantita" meaningEn="11.51 nationaler Geleitschein, verbürgt" validFrom="2012-10-28" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="1152" meaningDe="11.52 nationaler Geleitschein, hinterlegt" meaningFr="11.52 acquit-à-caution national, déposé" meaningIt="11.52 bolletta di cauzione nazionale, depositata" meaningEn="11.52 nationaler Geleitschein, hinterlegt" validFrom="2012-10-28" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="1161" meaningDe="11.61 Vormerkschein / Transitschein" meaningFr="11.61 Certificat de prise en note / bulletin de transit" meaningIt="11.61 Certificato d&apos;annotazione / bollettino di transito" meaningEn="11.61 Vormerkschein / Transitschein" validFrom="2012-10-28" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="1525" meaningDe="15.25 Vormerkschein für Strassenfahrzeuge und Schiffe" meaningFr="15.25 Certificat de prise en note pour véhicules et embarcations" meaningIt="15.25 Certificato d&apos;annotazione per veicoli stradali e imbarcazioni" meaningEn="15.25 Vormerkschein für Strassenfahrzeuge und Schiffe" validFrom="2012-10-28" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="1530" meaningDe="15.30" meaningFr="15.30" meaningIt="15.30" meaningEn="en_15.30" validFrom="2013-01-18" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="1540" meaningDe="15.40" meaningFr="15.40" meaningIt="15.40" meaningEn="en_15.40" validFrom="2013-01-18" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="3131" meaningDe="31.31" meaningFr="31.31" meaningIt="31.31" meaningEn="en_31.31" validFrom="2014-03-12" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="3149" meaningDe="31.49" meaningFr="31.49" meaningIt="31.49" meaningEn="en_31.49" validFrom="2014-03-12" validTo="2070-12-31" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS rail test movement" meaningFr="NCTS rail test movement" meaningIt="NCTS rail test movement" meaningEn="NCTS rail test movement" validFrom="2009-08-08" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS Eisenbahn Test-Verfahren" meaningFr="NCTS rail test movement" meaningIt="NCTS rail test movement" meaningEn="NCTS rail test movement" validFrom="2013-10-12" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS Rail Test" meaningFr="NCTS Rail Test" meaningIt="NCTS Rail Test" meaningEn="en_NCTS Rail Test" validFrom="2011-12-20" validTo="2013-10-12" validForImport="true" validForExport="true" />
			<entry value="720A" meaningDe="NCTS Rail Verfahren" meaningFr="NCTS procédure Rail" meaningIt="NCTS procedura Rail" meaningEn="NCTS rail movement" validFrom="2009-04-30" validTo="2009-07-09" validForImport="true" validForExport="true" />
			<entry value="720A" meaningDe="NCTS Rail Test" meaningFr="NCTS Rail test" meaningIt="NCTS Rail Test" meaningEn="NCTS Rail Test" validFrom="2009-08-05" validTo="2009-08-08" validForImport="true" validForExport="true" />
			</domain>
			<domain name="procedureType">
			<entry value="1" meaningDe="reduziert zollfrei" meaningFr="réduit / en franchise de droits" meaningIt="ridotto in franchigia di dazio" meaningEn="en_reduziert zollfrei" validFrom="2007-06-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="reduziert zollzahlend" meaningFr="réduit / passible de droits" meaningIt="ridotto assoggettato a dazio" meaningEn="en_reduziert zollzahlend" validFrom="2007-06-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="standard" meaningFr="fr_standard" meaningIt="it_standard" meaningEn="en_standard" validFrom="2007-06-03" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="standard" meaningFr="standard" meaningIt="standard" meaningEn="en_standard" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="processType">
			<entry value="1" meaningDe="Ordentliches Verfahren" meaningFr="Procédure ordinaire" meaningIt="Procedura ordinaria" meaningEn="en_Ordentliches Verfahren" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Ordentliches Verfahren" meaningFr="Procédure ordinaire" meaningIt="Procedura ordinaria" meaningEn="en_Ordentliches Verfahren" validFrom="2007-05-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="vereinfachtes Verfahren" meaningFr="Procédure simplifiée" meaningIt="Procedura semplificata" meaningEn="en_vereinfachtes Verfahren" validFrom="2007-05-01" validTo="2007-05-09" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Vereinfachtes Verfahren" meaningFr="Procédure simplifiée" meaningIt="Procedura semplificata" meaningEn="en_vereinfachtes Verfahren" validFrom="2007-05-10" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Vereinfachtes Verfahren" meaningFr="Procédure simplifiée" meaningIt="Procedura semplificata" meaningEn="en_vereinfachtes Verfahren" validFrom="2004-01-01" validTo="2007-05-09" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Besonderes Verfahren" meaningFr="Procédure spéciale" meaningIt="Procedura speciale" meaningEn="eng_Besonderes Verfahren" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="3" meaningDe="Besonderes Verfahren" meaningFr="Procédure spéciale" meaningIt="Procédura speciale" meaningEn="eng_Besonderes Verfahren" validFrom="2008-04-01" validTo="2011-12-14" validForImport="false" validForExport="true" />
			</domain>
			<domain name="ProducedDocuments">
			<entry value="C641" meaningDe="Dissostichus - Fangdokument, Einfuhr" meaningFr="Dissostichus - Certificat de capture, importation" meaningIt="Dissostichus - catch document import" meaningEn="en_Dissostichus - Fangdokument, Einfuhr" validFrom="2011-02-08" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="C641" meaningDe="Dissostichus  Fangdokument Einfuhr" meaningFr="Dissostichus Certificat de capture importation" meaningIt="Dissostichus Documento di cattura importazione" meaningEn="Dissostichus catch document import" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C656" meaningDe="Dissostichus - Fangdokument, Ausfuhr" meaningFr="Dissostichus - Certificat de capture, exportation" meaningIt="Dissostichus - Documento di cattura, esportazione" meaningEn="Dissostichus - Catch document export" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C673" meaningDe="Fangbescheinigung" meaningFr="Certificat de capture" meaningIt="Certificato di cattura" meaningEn="Catch certificate" validFrom="2010-05-08" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Versender / Ausführer" meaningFr="fr_Versender / Ausführer" meaningIt="it_Versender / Ausführer" meaningEn="en_Versender / Ausführer" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Versender / Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Consignor / exporter (AEO)" meaningEn="en_Versender / Ausführer" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="AEO-Versender/Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Consignor / exporter (AEO)" meaningEn="en_AEO-Versender/Ausführer" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="Zugelassener Wirtschaftsbeteiligter" meaningFr="fr_Zugelassener Wirtschaftsbeteiligter" meaningIt="it_Zugelassener Wirtschaftsbeteiligter" meaningEn="en_Zugelassener Wirtschaftsbeteiligter" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y022" meaningDe="AEO-Versender/Ausführer" meaningFr="Opérateur économique agréé" meaningIt="Esportatore AEO" meaningEn="en_AEO-Versender/Ausführer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="AEO-Empfänger" meaningFr="Destinataire (AEO)" meaningIt="Consignee (AEO certificate number)" meaningEn="en_AEO-Empfänger" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="Empfänger" meaningFr="Destinataire (AEO)" meaningIt="Consignee (AEO certificate number)" meaningEn="en_Empfänger" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="Empfänger" meaningFr="fr_Empfänger" meaningIt="it_Empfänger" meaningEn="en_Empfänger" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y023" meaningDe="AEO-Empfänger" meaningFr="Destinataire AEO" meaningIt="Destinatario AEO" meaningEn="en_AEO-Empfänger" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO-Anmelder (Deklarant)" meaningFr="Déclarant (AEO)" meaningIt="Declarant (AEO certificate number)" meaningEn="en_AEO-Anmelder (Deklarant)" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="Empfänger" meaningFr="fr_Empfänger" meaningIt="it_Empfänger" meaningEn="en_Empfänger" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO-Anmelder" meaningFr="Déclarant (AEO)" meaningIt="Declarant (AEO certificate number)" meaningEn="en_AEO-Anmelder" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="Deklarant" meaningFr="fr_Deklarant" meaningIt="it_Deklarant" meaningEn="en_Deklarant" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y024" meaningDe="AEO Anmelder" meaningFr="Déclarant AEO" meaningIt="Dichiarante AEO" meaningEn="en_AEO Anmelder" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="AEO-Vertreter" meaningFr="Représentant (AEO)" meaningIt="Representative (AEO)" meaningEn="en_AEO-Vertreter" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Deklarant" meaningFr="fr_Deklarant" meaningIt="it_Deklarant" meaningEn="en_Deklarant" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="AEO Vertreter" meaningFr="Représentant AEO" meaningIt="Rappresentante AEO" meaningEn="en_AEO Vertreter" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Vertreter" meaningFr="fr_Vertreter" meaningIt="it_Vertreter" meaningEn="en_Vertreter" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y025" meaningDe="Vertreter" meaningFr="Représentant (AEO)" meaningIt="Representative (AEO)" meaningEn="en_Vertreter" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="AEO Hauptverpflichteter" meaningFr="Principal obligé AEO" meaningIt="Obblig. principale AEO" meaningEn="en_AEO Hauptverpflichteter" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="AEO-Hauptverpflichteter" meaningFr="Principal obligé (AEO)" meaningIt="Principal (AEO certificate number)" meaningEn="en_AEO-Hauptverpflichteter" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="Hauptverpflichteter" meaningFr="fr_Hauptverpflichteter" meaningIt="it_Hauptverpflichteter" meaningEn="en_Hauptverpflichteter" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="HV Principal" meaningFr="fr_HV Principal" meaningIt="it_HV Principal" meaningEn="en_HV Principal" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y026" meaningDe="Hauptverpflichteter" meaningFr="Principal obligé (AEO)" meaningIt="Principal (AEO certificate number)" meaningEn="en_Hauptverpflichteter" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="AEO-Lagerinhaber" meaningFr="Entreposeur (AEO)" meaningIt="Warehousekeeper (AEO)" meaningEn="en_AEO-Lagerinhaber" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Transporteur" meaningFr="fr_Transporteur" meaningIt="it_Transporteur" meaningEn="en_Transporteur" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Lagerinhaber" meaningFr="fr_Lagerinhaber" meaningIt="it_Lagerinhaber" meaningEn="en_Lagerinhaber" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="Lagerinhaber" meaningFr="Entreposeur (AEO)" meaningIt="Warehousekeeper (AEO)" meaningEn="en_Lagerinhaber" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y027" meaningDe="AEO Lagerinhaber" meaningFr="Entreposeur AEO" meaningIt="Depositario autorizzato AEO" meaningEn="en_AEO Lagerinhaber" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="AEO-Beförderer" meaningFr="Autre opérateur économique autorisé (AEO)" meaningIt="Carrier (AEO certificate number)" meaningEn="en_AEO-Beförderer" validFrom="2009-04-30" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="AEO-Beförderer" meaningFr="Transporteur AEO" meaningIt="Trasportatore AEO" meaningEn="en_AEO-Beförderer" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="Hauptverpflichteter" meaningFr="fr_Hauptverpflichteter" meaningIt="it_Hauptverpflichteter" meaningEn="en_Hauptverpflichteter" validFrom="2008-07-13" validTo="2008-09-27" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="andere zugelassene Wirtschaftsbeteiligte" meaningFr="Autre opérateur économique autorisé (AEO)" meaningIt="Carrier (AEO certificate number)" meaningEn="en_andere zugelassene Wirtschaftsbeteiligte" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="Y028" meaningDe="andere zugelassene Wirtschaftsbeteiligte" meaningFr="fr_andere zugelassene Wirtschaftsbeteiligte" meaningIt="it_andere zugelassene Wirtschaftsbeteiligte" meaningEn="en_andere zugelassene Wirtschaftsbeteiligte" validFrom="2008-09-28" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe=" And. Zugel. Wirtschaftsbeteiligte" meaningFr="Other authorised economic operator" meaningIt="Other authorised economic operator" meaningEn="en_ And. Zugel. Wirtschaftsbeteiligte" validFrom="2008-11-25" validTo="2011-02-01" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe="And. Zugel. Wirtschaftsbeteiligte" meaningFr="autre opérateur économique agréé" meaningIt="Altro operatore economico autorizzato" meaningEn="en_And. Zugel. Wirtschaftsbeteiligte" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y029" meaningDe="And. Zugel. Wirtschaftsbeteiligte" meaningFr="Other authorised economic operator" meaningIt="Other authorised economic operator" meaningEn="en_And. Zugel. Wirtschaftsbeteiligte" validFrom="2011-02-01" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y031" meaningDe="ZWB Zert" meaningFr="AEO Zert" meaningIt="AEO Zert" meaningEn="AEO Zert" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y101" meaningDe="Einfuhrlizenz AGRIM" meaningFr="certificat d&apos;importation AGRIM" meaningIt="titolo d&apos;importazione AGRIM" meaningEn="import licence AGRIM" validFrom="2012-07-26" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="Y927" meaningDe="Verordnung (EG) Nr. 1005/2008" meaningFr="règlement (CE) n° 1005/2008 du Conseil" meaningIt="regolamento (CE) n. 1005/2008 del Consiglio" meaningEn="Regulation (EC) No. 1005/2008" validFrom="2011-01-28" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="Y927" meaningDe="Verordnung EG Nr. 1005/2008 des Rates" meaningFr="règlement CE Nr 1005/2008 du Conseil" meaningIt="regolamento CE Nr 1005/2008 del Consiglio" meaningEn="en_Verordnung EG Nr. 1005/2008 des Rates" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="CLE" meaningDe="Referenznummer/Datum der Anschreibung in der Buchführung" meaningFr="ICM" meaningIt="ICM" meaningEn="Reference date of entry of the goods in the records" validFrom="2012-02-09" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="zzz" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="Other" validFrom="2010-03-05" validTo="2010-03-06" validForImport="true" validForExport="true" />
			<entry value="zzz" meaningDe="Andere" meaningFr="Autre" meaningIt="Altro" meaningEn="other" validFrom="2004-11-05" validTo="2010-03-02" validForImport="true" validForExport="true" />
			<entry value="ZZZ" meaningDe="Sonstige" meaningFr="Autres" meaningIt="Altro" meaningEn="Other" validFrom="2009-09-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="EU" meaningDe="Einheitspapier - Handel mit EFTA" meaningFr="Document Administratif Unique Echanges avec l&apos;AELE" meaningIt="Single Administrative Document- Trade with EFTA" meaningEn="Single Administrative Document- Trade with EFTA" validFrom="2012-06-22" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Konformitätsbescheinigung" meaningFr="Certificat de conformité" meaningIt="Certificato di conformità" meaningEn="Certificate of conformity" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Qualitätszeugnis" meaningFr="Certificat de qualité" meaningIt="Certificato di qualità" meaningEn="Certificate of quality" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="18" meaningDe="Warenverkehrsbescheinigung A.TR.1" meaningFr="Certificat ATR1" meaningIt="Certificato di circolazione A.TR.1" meaningEn="Movement certificate A.TR.1" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="Containerliste" meaningFr="Liste de conteneur" meaningIt="Elenco dei contenitori" meaningEn="Container list" validFrom="2013-10-09" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="Containerliste" meaningFr="Liste de conteneur" meaningIt="Elenco dei container" meaningEn="Container list" validFrom="2004-11-05" validTo="2013-10-09" validForImport="true" validForExport="true" />
			<entry value="271" meaningDe="Packliste" meaningFr="Liste de colisage" meaningIt="Distinta del carico" meaningEn="Packing list" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="325" meaningDe="Proformarechnung" meaningFr="Facture proforma" meaningIt="Fattura proforma" meaningEn="Proforma invoice" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="337" meaningDe="Summarische Anmeldung zur vorübergehenden Lagerung" meaningFr="déclaration sommaire de dépôt temporaire" meaningIt="dichiarazione sommaria per la custodia temporanea" meaningEn="Summary declaration for temporary storage" validFrom="2011-02-04" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="355" meaningDe="Summarische Voranmeldung" meaningFr="déclaration sommaire d&apos;entrée" meaningIt="Dichiarazione sommaria di ingresso" meaningEn="Entry summary declaration" validFrom="2011-02-04" validTo="2012-07-26" validForImport="true" validForExport="true" />
			<entry value="380" meaningDe="Handelsrechnung" meaningFr="Facture commerciale" meaningIt="Fattura commerciale" meaningEn="Commercial invoice" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="703" meaningDe="Hausfrachtbrief" meaningFr="Récepissé" meaningIt="Lett.ra  vettura emessa da sped.re" meaningEn="House waybill" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="703" meaningDe="Hausfrachtbrief" meaningFr="Récepissé" meaningIt="Lettera di vettura casa" meaningEn="House waybill" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="704" meaningDe="Sammelkonnossement" meaningFr="Connaissement principal" meaningIt="Polizza di carico principale" meaningEn="Master bill of lading" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="705" meaningDe="Konnossement" meaningFr="Connaissement" meaningIt="Polizza di carico" meaningEn="Bill of lading" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement maison interne" meaningIt="Polizza di carico emessa da sped.re" meaningEn="en_Hauskonnossement" validFrom="2008-11-25" validTo="2009-04-30" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement maison/interne" meaningIt="Polizza di carico emessa da sped.re" meaningEn="House bill of lading" validFrom="2004-11-05" validTo="2008-11-25" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="Hauskonnossement" meaningFr="Connaissement émis par un transitai" meaningIt="Polizza di carico emessa da sped.re" meaningEn="House bill of lading" validFrom="2009-04-30" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="Frachtbrief CIM" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM consignment note rail" validFrom="2012-08-21" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief Rail" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM consignment note Rail" validFrom="2009-07-09" validTo="2009-08-12" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief ( Rail )" meaningFr="CIM-feuille de route ( Rail )" meaningIt="CIM-lettera di vettura ( Rail )" meaningEn="CIM consignment note (rail)" validFrom="2010-02-09" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="CIM-Frachtbrief Rail" meaningFr="CIM-feuille de route Rail" meaningIt="CIM-lettera di vettura Rail" meaningEn="CIM-consignment note Rail" validFrom="2011-12-20" validTo="2012-08-21" validForImport="true" validForExport="true" />
			<entry value="722" meaningDe="SMGS Begleitliste" meaningFr="Feuille de route SMGS" meaningIt="Doc. accompagnamento SMGS" meaningEn="Road list SMGS" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="722" meaningDe="SMGS-Begleitliste" meaningFr="Feuille de route-SMGS" meaningIt="Doc. accompagnamento-SMGS" meaningEn="Road list-SMGS" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="730" meaningDe="LKW-Frachtbrief" meaningFr="Document d&apos;expédition par route" meaningIt="Lettera di vettura stradale" meaningEn="Road consignment note" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="740" meaningDe="Luftfrachtbrief" meaningFr="Lettre de transport aérien" meaningIt="Lettera di vettura aerea" meaningEn="Air waybill" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="741" meaningDe="Master-Luftfrachtbrief" meaningFr="Lettre de transport aérien principale" meaningIt="Lettera di vettura aerea principale" meaningEn="Master air waybill" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="750" meaningDe="Paketkarte (Despatch note)" meaningFr="Bulletin d&apos;expédition (colis postaux)" meaningIt="Bollettino spedizione (pacchi postali)" meaningEn="Despatch note (post parcels)" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="750" meaningDe="Paketkarte Despatch note" meaningFr="Bulletin d&apos;expédition colis postaux" meaningIt="Bollettino spedizione pacchi postali" meaningEn="Despatch note post parcels" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="760" meaningDe="Kombiniertes Transportdokument" meaningFr="Doc. transp. multimodal/combiné" meaningIt="Doc.trasporto multimodale/combinato" meaningEn="Multimodal/combined transport doc." validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Manifeste de cargaison" meaningIt="Manifesto cargo" meaningEn="Cargo manifest" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="Frachtmanifest" meaningFr="Manifeste" meaningIt="Manifesto di carico" meaningEn="Cargo manifest" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereau" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2004-11-05" validTo="2011-02-01" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereau" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="Ladungsverzeichnis" meaningFr="Bordereaux" meaningIt="Bordereau" meaningEn="Bordereau" validFrom="2011-02-01" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="820" meaningDe="T-Versandschein" meaningFr="Document d&apos;expédition modèle T" meaningIt="Documento di spedizione modello T" meaningEn="Despatch note model T" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="821" meaningDe="T1-Versandschein" meaningFr="Document d&apos;expédition modèle T1" meaningIt="Documento di spedizione modello T1" meaningEn="Despatch note model T1" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="822" meaningDe="T2-Versandschein" meaningFr="Document d&apos;expédition modèle T2" meaningIt="Documento di spedizione modello T2" meaningEn="Despatch note model T2" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="823" meaningDe="T5 Kontrollexemplar" meaningFr="Document de contrôle T5" meaningIt="Documento di controllo T5" meaningEn="Control document T5" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="825" meaningDe="T2L-Versandnachweis" meaningFr="Document d&apos;expédition modèle T2L" meaningIt="Documento di spedizione modello T2L" meaningEn="Despatch note model T2L" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="830" meaningDe="Ausfuhrdeklaration" meaningFr="Déclaration d&apos;exportation" meaningIt="Dichiarazione di esportazione" meaningEn="Goods declaration for exportation" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="851" meaningDe="Pflanzenschutzzeugnis" meaningFr="Certificat phytosanitaire" meaningIt="Certificato fitosanitario" meaningEn="Phytosanitary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="852" meaningDe="Genusstauglichkeitszeugnis" meaningFr="Certificat sanitaire" meaningIt="Certificato sanitario" meaningEn="Sanitary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="853" meaningDe="Tierärztliches Gesundheitszeugnis" meaningFr="Certificat vétérinaire" meaningIt="Certificato veterinario" meaningEn="Veterinary certificate" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="861" meaningDe="Ursprungszeugnis" meaningFr="Certificat d&apos;origine" meaningIt="Certificato d&apos;origine" meaningEn="Certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="862" meaningDe="Ursprungserklärung" meaningFr="Déclaration d&apos;origine" meaningIt="Dichiarazione di origine" meaningEn="Declaration of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="864" meaningDe="Präferenz-Ursprungsnachweis" meaningFr="Certificat d&apos;origine préference" meaningIt="Certificato di origine preferenziale" meaningEn="Preference certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="865" meaningDe="APS-Ursprungszeugnis" meaningFr="Certificat d&apos;origine formulaire SGP" meaningIt="Certificato di origine form. APS" meaningEn="Certificate of origin form GSP" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="900" meaningDe="Beilagen zur Identitätssicherung" meaningFr="fr_Beilagen zur Identitätssicherung" meaningIt="it_Beilagen zur Identitätssicherung" meaningEn="en_Beilagen zur Identitätssicherung" validFrom="2013-12-02" validTo="2014-02-04" validForImport="true" validForExport="true" />
			<entry value="900" meaningDe="Beilagen zur Identitätssicherung" meaningFr="Annexes servant à garantir identité" meaningIt="Allegati per garantire identità" meaningEn="en_Beilagen zur Identitätssicherung" validFrom="2014-02-04" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="911" meaningDe="Einfuhrlizenz" meaningFr="Licence d&apos;importation" meaningIt="Licenza di importazione" meaningEn="Import licence" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="933" meaningDe="Frachtanmeldung (Ankunft)" meaningFr="Déclaration de chargement (arrivée)" meaningIt="Dichiarazione del carico (arrivo)" meaningEn="Cargo declaration (arrival)" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="933" meaningDe="Frachtanmeldung Ankunft" meaningFr="Déclaration de chargement arrivée" meaningIt="Dichiarazione del carico arrivo" meaningEn="Cargo declaration arrival" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="941" meaningDe="Ausfuhrgenehmigung für Embargowaren" meaningFr="Permit d&apos;export pr march. sous embargo" meaningIt="Autorizzazione per merci sotto embargo" meaningEn="Embargo permit" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="951" meaningDe="TIF-Dokument" meaningFr="Formulaire TIF" meaningIt="Modulo TIF" meaningEn="TIF form" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet-TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="TIR carnet" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="Carnet TIR" meaningFr="Carnet TIR" meaningIt="Carnet TIR" meaningEn="TIR Carnet" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="954" meaningDe="EUR.1 Warenverkehrsbescheinigung" meaningFr="EUR 1 certificat d&apos;origine" meaningIt="Certificato di origine EUR 1" meaningEn="EUR 1 certificate of origin" validFrom="2004-11-05" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="Carnet ATA" meaningFr="Carnet ATA" meaningIt="Carnet ATA" meaningEn="ATA Carnet" validFrom="2011-12-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="Carnet ATA" meaningFr="Carnet ATA" meaningIt="Carnet ATA" meaningEn="ATA carnet" validFrom="2004-11-05" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS Rail Test" meaningFr="NCTS Rail Test" meaningIt="NCTS Rail Test" meaningEn="NCTS rail test movement" validFrom="2011-12-20" validTo="2013-10-12" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS rail test movement" meaningFr="NCTS rail test movement" meaningIt="NCTS rail test movement" meaningEn="NCTS rail test movement" validFrom="2009-08-08" validTo="2011-12-20" validForImport="true" validForExport="true" />
			<entry value="720a" meaningDe="NCTS Eisenbahn Test-Verfahren" meaningFr="NCTS rail test movement" meaningIt="NCTS rail test movement" meaningEn="NCTS rail test movement" validFrom="2013-10-12" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="720A" meaningDe="NCTS Rail Test" meaningFr="NCTS Rail test" meaningIt="NCTS Rail Test" meaningEn="NCTS Rail Test" validFrom="2009-08-05" validTo="2009-08-08" validForImport="true" validForExport="true" />
			<entry value="720A" meaningDe="NCTS Rail Verfahren" meaningFr="NCTS procédure Rail" meaningIt="NCTS procedura Rail" meaningEn="NCTS rail movement" validFrom="2009-04-30" validTo="2009-07-09" validForImport="true" validForExport="true" />
			</domain>
			<domain name="reason">
			<entry value="1" meaningDe="Ursprungsnachweis für Länder der EU" meaningFr="Preuve d&apos;origine pour les pays de l&apos;UE" meaningIt="Prova d&apos;origine per un paese dell&apos;UE" meaningEn="en_Ursprungsnachweis für Länder der EU" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="2" meaningDe="Ursprungsnachweis für Länder der EFTA" meaningFr="Preuve d&apos;origine pour les pays de l&apos;AELE" meaningIt="Prova d&apos;origine per un paese dell&apos;AELS" meaningEn="en_Ursprungsnachweis für Länder der EFTA" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="3" meaningDe="Ursprungsnachweis für Länder der aFHA" meaningFr="Preuve d&apos;origine pour les pays de l&apos;aALE" meaningIt="Prova d&apos;origine per un paese degli aALS" meaningEn="en_Ursprungsnachweis für Länder der aFHA" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="4" meaningDe="Ursprungsnachweis für Entwicklungsländer" meaningFr="Preuve d&apos;origine pour les pays en voie de développement" meaningIt="Prova d&apos;origine per paesi in via di sviluppo" meaningEn="en_Ursprungsnachweis für Entwicklungsländer" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="5" meaningDe="Ursprungsüberprüfung " meaningFr="Contrôle de l&apos;origine" meaningIt="Controllo dell&apos;origine" meaningEn="en_Ursprungsüberprüfung " validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="6" meaningDe="Tarifierung" meaningFr="Tarification" meaningIt="Tarifficazione" meaningEn="en_Tarifierung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="7" meaningDe="Übersiedlungsgut" meaningFr="Effets de déménagement" meaningIt="Masserizie di immigranti" meaningEn="en_Übersiedlungsgut" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="8" meaningDe="Ausstattungsgut" meaningFr="Trousseaux de mariage" meaningIt="Corredi nuziali" meaningEn="en_Ausstattungsgut" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="9" meaningDe="Erbschaftsgut" meaningFr="Effets de succession" meaningIt="Oggetti ereditati" meaningEn="en_Erbschaftsgut" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Andere Zollbefreiung, Zollbegünstigung, Zollermässigung" meaningFr="Autres franchises douanières, allègements douaniers, réductions douanières" meaningIt="Altre franchigie doganali, agevolazioni doganali, riduzioni del dazio" meaningEn="en_Andere Zollbefreiung, Zollbegünstigung, Zollermässigung" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Andere Zollermässigung oder Zollbefreiung" meaningFr="Autres réductions des droits de douane ou d&apos;exonérations des droit de douane" meaningIt="altre riduzioni dei tributi doganali o franchigia doganale" meaningEn="en_Andere Zollermässigung oder Zollbefreiung" validFrom="2007-05-01" validTo="2011-12-14" validForImport="true" validForExport="false" />
			<entry value="10" meaningDe="Andere Zollermässigung oder Zollbefreiung" meaningFr="Autres réductions des droits de douane ou d&apos;exonérations des droit de douane" meaningIt="Altre riduzioni dei tributi doganali o franchigia doganale" meaningEn="en_Andere Zollermässigung oder Zollbefreiung" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="11" meaningDe="VOC" meaningFr="COV" meaningIt="COV" meaningEn="en_VOC" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="12" meaningDe="Chemieprodukte" meaningFr="Produits chimiques" meaningIt="Prodotti chimici" meaningEn="en_Chemieprodukte" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="13" meaningDe="Tarierung" meaningFr="Tarage" meaningIt="Taratura" meaningEn="en_Tarierung" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="14" meaningDe="Tiere zum Schlachten" meaningFr="Animaux de boucherie+D122" meaningIt="Animali da macello" meaningEn="en_Tiere zum Schlachten" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="15" meaningDe="Maschinenanlagen" meaningFr="Installations de machines" meaningIt="Impianti macchine" meaningEn="en_Maschinenanlagen" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="16" meaningDe="Montage/Einbaukosten" meaningFr="Montage/frais de montage" meaningIt="Montaggio / costi di montaggio" meaningEn="en_Montage/Einbaukosten" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="17" meaningDe="OZD/KD-Bewilligung für Freipassabfertigung" meaningFr="Autorisation DGD/DA pour dédouanement sous passavant" meaningIt="Autorizzazione DGD/DC per sdoganamento con carta di passo" meaningEn="en_OZD/KD-Bewilligung für Freipassabfertigung" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="false" />
			<entry value="17" meaningDe="OZD/KD-Bewilligung für die vorübergehende Verwendung" meaningFr="Autorisation DGD/DA pour l&apos;admission temporaire" meaningIt=" Autorizzazione DGD/DC per l&apos;ammissione temporanea" meaningEn="en_OZD/KD-Bewilligung für die vorübergehende Verwendung" validFrom="2007-05-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="18" meaningDe="Unregelmässigkeiten im Transitverfahren / Verfahren der vorübergehenden Verwendung" meaningFr="Irrégularités dans le régime du transit / de l&apos;admission temporaire" meaningIt="Irregolarità nel regime di transito / dell&apos;ammissione temporanea" meaningEn="en_Unregelmässigkeiten im Transitverfahren / Verfahren der vorübergehenden Verwendung" validFrom="2007-05-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="18" meaningDe="Löschung von Zwischenabfertigungsscheinen" meaningFr="Décharge d&apos;acquits intérimaires" meaningIt="Scarico di sdoganamenti intermedi" meaningEn="en_Löschung von Zwischenabfertigungsscheinen" validFrom="2004-01-01" validTo="2007-04-30" validForImport="true" validForExport="false" />
			<entry value="19" meaningDe="Agrarprodukte" meaningFr="Produits agricoles" meaningIt="Prodotti agricoli" meaningEn="en_Agrarprodukte" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="20" meaningDe="Lagerung von Massengüter" meaningFr="Entreposage de marchandises de grande consommation" meaningIt="Deposito di merci del commercio all&apos;ingrosso" meaningEn="en_Lagerung von Massengüter" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="21" meaningDe="Fehlende Nachweisnummer für Treibstoffe aus erneuerbaren Rohstoffen" meaningFr="Manque le numéro de preuve pour carburants issus de matières premières renouvelables" meaningIt="Manca il numero della prova per carburanti provenienti da materie prime rinnovabili" meaningEn="en_Fehlende Nachweisnummer für Treibstoffe aus erneuerbaren Rohstoffen" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="21" meaningDe="Fehlende Nachweisnummer für Treibstoffe aus erneuerbaren Rohstoffen" meaningFr="Manque le numéro de preuve pour carburants issus de matières premières renouvelables" meaningIt="Mancate il numero di prova per carburanti provenienti da materie prime rinnovabili" meaningEn="en_Fehlende Nachweisnummer für Treibstoffe aus erneuerbaren Rohstoffen" validFrom="2008-06-30" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="22" meaningDe="Motoren; Einbaubestätigung fehlt" meaningFr="Moteurs; attestation de montage manquante" meaningIt="Motori; manca l&apos;attestazione di montaggio" meaningEn="Motoren; Einbaubestätigung fehlt" validFrom="2013-04-22" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="94" meaningDe="Andere; Frist 1 Jahr" meaningFr="Autres; Délai 1 an" meaningIt="Altri; termine 1 anno" meaningEn="eng_Andere; Frist 1 Jahr" validFrom="2008-04-01" validTo="2099-12-31" validForImport="false" validForExport="true" />
			<entry value="95" meaningDe="Andere; Frist 30 Tage" meaningFr="Autres; Délai 30 jours" meaningIt="Altri; termine di 30 giorni" meaningEn="en_Andere; Frist 30 Tage" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="96" meaningDe="Andere; Frist 2 Jahre" meaningFr="Autres; Délai 2 ans" meaningIt="Altri; termine di 2 anni" meaningEn="en_Andere; Frist 2 Jahre" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="97" meaningDe="Andere; Frist 2 Monate " meaningFr="Autres; Délai 2 mois" meaningIt="Altri; termine di 2 mesi" meaningEn="en_Andere; Frist 2 Monate " validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="98" meaningDe="Andere; Frist 6 Monate " meaningFr="Autres; Délai 6 mois " meaningIt="Altri; termine di 6 mesi" meaningEn="en_Andere; Frist 6 Monate " validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="99" meaningDe="Andere; Frist 3 Jahre" meaningFr="Autres; Délai 3 ans" meaningIt="Altri; termine di 3 anni" meaningEn="en_Andere; Frist 3 Jahre" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			</domain>
			<domain name="refinementType">
			<entry value="1" meaningDe="Eigenveredelungsverkehr" meaningFr="trafic de perfectionnement à façon" meaningIt="traffico di perfezionamento proprio" meaningEn="eng_Eigenveredelungsverkehr" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Eigenveredelungsverkehr" meaningFr="trafic de perfectionnement à façon" meaningIt="traffico di perfezionamento proprio" meaningEn="en_Eigenveredelungsverkehr" validFrom="2008-06-03" validTo="2009-02-10" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Eigenveredelungsverkehr" meaningFr="trafic de perfectionnement commercial" meaningIt="traffico di perfezionamento proprio" meaningEn="en_Eigenveredelungsverkehr" validFrom="2009-02-11" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Lohnveredelungsverkehr" meaningFr="trafic de perfectionnement commercial" meaningIt="traffico di perfezionamento a cottimo" meaningEn="en_Lohnveredelungsverkehr" validFrom="2008-06-03" validTo="2009-02-10" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Lohnveredelungsverkehr" meaningFr="trafic de perfectionnement à façon" meaningIt="traffico di perfezionamento a cottimo" meaningEn="en_Lohnveredelungsverkehr" validFrom="2009-02-11" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Lohnveredelungsverkehr" meaningFr="trafic de perfectionnement commercial" meaningIt="traffico di perfezionamento a cottimo" meaningEn="eng_Lohnveredelungsverkehr" validFrom="2004-01-01" validTo="2008-06-02" validForImport="true" validForExport="true" />
			</domain>
			<domain name="refundType">
			<entry value="1" meaningDe="Befreieung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="demande d&apos;exonération de la taxe d&apos;incitation sur les COV" meaningIt="esenzione della tassa d&apos;incentivazione sui COV" meaningEn="en_Befreieung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2009-05-29" validTo="2009-10-19" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="demande d&apos;exoneration de la taxe d&apos;incitation sur les COV" meaningIt="esenzione della tassa d&apos;incentivazione sui COV" meaningEn="en_Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2010-01-27" validTo="2010-02-03" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="demande d&apos;exoneration de la taxe d&apos;incitation sur les COV" meaningIt="esenzione della tassa d&apos;incentivazione sui COV" meaningEn="en_Befreieung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2009-10-20" validTo="2009-10-21" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="demande d&apos;exoneration de la taxe d&apos;incitation sur les COV" meaningIt="esenzione della tassa d&apos;incentivazione sui COV" meaningEn="en_Befreieung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2009-10-22" validTo="2010-01-26" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Rückerstattung der Lenkungsabgabe auf VOC" meaningFr="remboursement de la taxe d&apos;indication sur les COV " meaningIt="it_Rückerstattung der Lenkungsabgabe auf VOC" meaningEn="en_Rückerstattung der Lenkungsabgabe auf VOC" validFrom="2008-04-01" validTo="2009-05-28" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Rückerstattung / Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="Remboursement / demande d&apos;exoneration de la taxe d&apos;incitation sur les COV" meaningIt="Restituzione / domanda di esonero dalla tassa d&apos;incentivazione sui COV" meaningEn="en_Rückerstattung / Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2012-07-10" validTo="2012-10-09" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="demande d&apos;exoneration de la taxe d&apos;incitation sur les COV" meaningIt="Domanda di esonero dalla tassa d&apos;incentivazione sui COV" meaningEn="en_Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2011-12-15" validTo="2012-07-09" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Rückerstattung / Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="Remboursement / demande d&apos;exonération de la taxe d&apos;incitation sur les COV" meaningIt="Domanda di restituzione / esenzione dalla tassa d&apos;incentivazione sui COV" meaningEn="en_Rückerstattung / Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2012-10-10" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" meaningFr="demande d&apos;exoneration de la taxe d&apos;incitation sur les COV" meaningIt="Con domanda di restituzione della tassa sui COV" meaningEn="en_Befreiung der Lenkungsabgabe auf VOC wird geltend gemacht" validFrom="2010-02-04" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="2" meaningDe="Antrag für Ausfuhrbeiträge für LW" meaningFr="Avec demande de contributions à l&apos;exportation pour produits agricoles de base  " meaningIt="it_Antrag für Ausfuhrbeiträge für LW" meaningEn="en_Antrag für Ausfuhrbeiträge für LW" validFrom="2008-04-01" validTo="2010-02-03" validForImport="false" validForExport="true" />
			<entry value="2" meaningDe="Antrag fuer Ausfuhrbeitraege fuer LW" meaningFr="Avec demande de contributions a l&apos;exportation pour produits agricoles de base  " meaningIt="Con domanda di contributi all esportazione per prodotti agricoli di base" meaningEn="Antrag fuer Ausfuhrbeitraege fuer LW" validFrom="2010-02-04" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="2" meaningDe="Antrag fuer Ausfuhrbeitraege fuer LW" meaningFr="Avec demande de contributions a l&apos;exportation pour produits agricoles de base  " meaningIt="Domanda di contributi all&apos;esportazione per prodotti agricoli" meaningEn="Antrag fuer Ausfuhrbeitraege fuer LW" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="3" meaningDe="Antrag auf Alkohol" meaningFr="Avec demande pour l&apos;alcool" meaningIt="Domanda di restituzione dei tributi sull&apos;alcool" meaningEn="en_Antrag auf Alkohol" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="3" meaningDe="Antrag auf Alkohol" meaningFr="Avec demande pour l&apos;alcool" meaningIt="Con domanda di restituzione dei tributi sull alcool" meaningEn="en_Antrag auf Alkohol" validFrom="2010-02-04" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="3" meaningDe="Antrag auf Alkohol" meaningFr="Avec demande pour l&apos;alcool" meaningIt="it_Antrag auf Alkohol" meaningEn="en_Antrag auf Alkohol" validFrom="2008-04-01" validTo="2010-02-03" validForImport="false" validForExport="true" />
			<entry value="4" meaningDe="Antrag auf mindestens 2 der Rückerstattungstyp 1 bis 3" meaningFr="Avec demande pour aux moins 2 des codes 1 à 3" meaningIt="it_Antrag auf mindestens 2 der Rückerstattungstyp 1 bis 3" meaningEn="en_Antrag auf mindestens 2 der Rückerstattungstyp 1 bis 3" validFrom="2008-04-01" validTo="2010-02-03" validForImport="false" validForExport="true" />
			<entry value="4" meaningDe="Antrag auf mindestens 2 der Rueckerstattungstyp 1 bis 3" meaningFr="Avec demande pour aux moins 2 des codes 1 a 3" meaningIt="Domanda per almeno 2 dei tipi di restituzione da 1 a 3" meaningEn="Antrag auf mindestens 2 der Rueckerstattungstyp 1 bis 3" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="4" meaningDe="Antrag auf mindestens 2 der Rueckerstattungstyp 1 bis 3" meaningFr="Avec demande pour aux moins 2 des codes 1 a 3" meaningIt="con domanda per almeno 2 dei tipi di restituzione 1-3" meaningEn="Antrag auf mindestens 2 der Rueckerstattungstyp 1 bis 3" validFrom="2010-02-04" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="5" meaningDe="Rueckerstattung Biersteuer" meaningFr="Remboursement de l&apos;alcool sur la biere" meaningIt="Restituzione imposta sulla birra" meaningEn="Rueckerstattung Biersteuer" validFrom="2010-02-04" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="5" meaningDe="Rückerstattung Biersteuer" meaningFr="Remboursement de l&apos;alcool sur la bière" meaningIt="it_Rückerstattung Biersteuer" meaningEn="en_Rückerstattung Biersteuer" validFrom="2008-04-01" validTo="2010-02-03" validForImport="false" validForExport="true" />
			<entry value="5" meaningDe="Rueckerstattung Biersteuer" meaningFr="Remboursement de l&apos;alcool sur la biere" meaningIt="Restituzione dell&apos;imposta sulla birra" meaningEn="Rueckerstattung Biersteuer" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="6" meaningDe="Rückerstattung andere" meaningFr="autres remboursements" meaningIt="it_Rückerstattung andere" meaningEn="en_Rückerstattung andere" validFrom="2008-04-01" validTo="2010-02-03" validForImport="false" validForExport="true" />
			<entry value="6" meaningDe="Rueckerstattung andere" meaningFr="autres remboursements" meaningIt="Altre restituzioni" meaningEn="Rueckerstattung andere" validFrom="2010-02-04" validTo="9999-12-31" validForImport="false" validForExport="true" />
			</domain>
			<domain name="rmbType">
			<entry value="0" meaningDe="ohne Rechtsmittelbelehrung" meaningFr="sans indication des voies de droit" meaningIt="senza rimedi giuridici" meaningEn="Keine RMB" validFrom="2005-01-01" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="0" meaningDe="ohne Rechtsmittelbelehrung" meaningFr="sans indication des voies de droit" meaningIt="Senza indicazione dei rimedi giuridici" meaningEn="Keine RMB" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Rechtsmittelbelehrung 60" meaningFr="indication des voies de droit 60" meaningIt="rimedi giuridici 60" meaningEn="RMB60" validFrom="2005-01-01" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="Rechtsmittelbelehrung 60" meaningFr="indication des voies de droit 60" meaningIt="Indicazione di rimedi giuridici 60" meaningEn="RMB60" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="selectionResult">
			<entry value="1" meaningDe="frei ohne" meaningFr="libre sans" meaningIt="libero senza" meaningEn="en_frei ohne" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="frei mit" meaningFr="libre avec" meaningIt="libero con" meaningEn="en_frei mit" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="gesperrt" meaningFr="bloquée" meaningIt="bloccato" meaningEn="en_gesperrt" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="SensibleGoods">
			<entry value="020712" meaningDe="de_020712" meaningFr="fr_020712" meaningIt="it_020712" meaningEn="en_020712" validFrom="2009-09-13" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="020712" meaningDe="de_020712" meaningFr="fr_020712" meaningIt="it_020712" meaningEn="en_020712" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="020714" meaningDe="de_020714" meaningFr="fr_020714" meaningIt="it_020714" meaningEn="en_020714" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="020714" meaningDe="de_020714" meaningFr="fr_020714" meaningIt="it_020714" meaningEn="en_020714" validFrom="2009-09-13" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="170111" meaningDe="de_170111" meaningFr="fr_170111" meaningIt="it_170111" meaningEn="en_170111" validFrom="2009-09-13" validTo="2012-04-28" validForImport="true" validForExport="true" />
			<entry value="170112" meaningDe="de_170112" meaningFr="fr_170112" meaningIt="it_170112" meaningEn="en_170112" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="170112" meaningDe="de_170112" meaningFr="fr_170112" meaningIt="it_170112" meaningEn="en_170112" validFrom="2012-06-26" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="170112" meaningDe="de_170112" meaningFr="fr_170112" meaningIt="it_170112" meaningEn="en_170112" validFrom="2009-09-13" validTo="2012-06-26" validForImport="true" validForExport="true" />
			<entry value="170113" meaningDe="de_170113" meaningFr="fr_170113" meaningIt="it_170113" meaningEn="en_170113" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="170113" meaningDe="de_170113" meaningFr="fr_170113" meaningIt="it_170113" meaningEn="en_170113" validFrom="2012-04-28" validTo="2012-06-26" validForImport="true" validForExport="true" />
			<entry value="170113" meaningDe="de_170113" meaningFr="fr_170113" meaningIt="it_170113" meaningEn="en_170113" validFrom="2012-06-26" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="170114" meaningDe="de_170114" meaningFr="fr_170114" meaningIt="it_170114" meaningEn="en_170114" validFrom="2012-06-26" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="170114" meaningDe="de_170114" meaningFr="fr_170114" meaningIt="it_170114" meaningEn="en_170114" validFrom="2012-04-28" validTo="2012-06-26" validForImport="true" validForExport="true" />
			<entry value="170114" meaningDe="de_170114" meaningFr="fr_170114" meaningIt="it_170114" meaningEn="en_170114" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="170191" meaningDe="de_170191" meaningFr="fr_170191" meaningIt="it_170191" meaningEn="en_170191" validFrom="2012-04-28" validTo="2012-06-26" validForImport="true" validForExport="true" />
			<entry value="170191" meaningDe="de_170191" meaningFr="fr_170191" meaningIt="it_170191" meaningEn="en_170191" validFrom="2009-09-13" validTo="2012-04-28" validForImport="true" validForExport="true" />
			<entry value="170191" meaningDe="de_170191" meaningFr="fr_170191" meaningIt="it_170191" meaningEn="en_170191" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="170191" meaningDe="de_170191" meaningFr="fr_170191" meaningIt="it_170191" meaningEn="en_170191" validFrom="2012-06-26" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="170199" meaningDe="de_170199" meaningFr="fr_170199" meaningIt="it_170199" meaningEn="en_170199" validFrom="2012-06-26" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="170199" meaningDe="de_170199" meaningFr="fr_170199" meaningIt="it_170199" meaningEn="en_170199" validFrom="2010-06-12" validTo="2012-04-28" validForImport="true" validForExport="true" />
			<entry value="170199" meaningDe="de_170199" meaningFr="fr_170199" meaningIt="it_170199" meaningEn="en_170199" validFrom="2012-04-28" validTo="2012-06-26" validForImport="true" validForExport="true" />
			<entry value="170199" meaningDe="de_170199" meaningFr="fr_170199" meaningIt="it_170199" meaningEn="en_170199" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="170199" meaningDe="de_170199" meaningFr="fr_170199" meaningIt="it_170199" meaningEn="en_170199" validFrom="2009-09-13" validTo="2010-06-12" validForImport="true" validForExport="true" />
			<entry value="220820" meaningDe="de_220820" meaningFr="fr_220820" meaningIt="it_220820" meaningEn="en_220820" validFrom="2009-09-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="220830" meaningDe="de_220830" meaningFr="fr_220830" meaningIt="it_220830" meaningEn="en_220830" validFrom="2009-09-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="220840" meaningDe="de_220840" meaningFr="fr_220840" meaningIt="it_220840" meaningEn="en_220840" validFrom="2009-09-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="220850" meaningDe="de_220850" meaningFr="fr_220850" meaningIt="it_220850" meaningEn="en_220850" validFrom="2009-09-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="220860" meaningDe="de_220860" meaningFr="fr_220860" meaningIt="it_220860" meaningEn="en_220860" validFrom="2009-09-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="220870" meaningDe="de_220870" meaningFr="fr_220870" meaningIt="it_220870" meaningEn="en_220870" validFrom="2009-09-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="220890" meaningDe="de_220890" meaningFr="fr_220890" meaningIt="it_220890" meaningEn="en_220890" validFrom="2009-09-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="240220" meaningDe="de_240220" meaningFr="fr_240220" meaningIt="it_240220" meaningEn="en_240220" validFrom="2014-05-29" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="240220" meaningDe="de_240220" meaningFr="fr_240220" meaningIt="it_240220" meaningEn="en_240220" validFrom="2009-09-13" validTo="2014-05-29" validForImport="true" validForExport="true" />
			<entry value="240310" meaningDe="de_240310" meaningFr="fr_240310" meaningIt="it_240310" meaningEn="en_240310" validFrom="2009-09-13" validTo="2012-01-24" validForImport="true" validForExport="true" />
			<entry value="240311" meaningDe="de_240311" meaningFr="fr_240311" meaningIt="it_240311" meaningEn="en_240311" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="240311" meaningDe="de_240311" meaningFr="fr_240311" meaningIt="it_240311" meaningEn="en_240311" validFrom="2012-01-24" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="240319" meaningDe="de_240319" meaningFr="fr_240319" meaningIt="it_240319" meaningEn="en_240319" validFrom="2012-01-24" validTo="2014-09-03" validForImport="true" validForExport="true" />
			<entry value="240319" meaningDe="de_240319" meaningFr="fr_240319" meaningIt="it_240319" meaningEn="en_240319" validFrom="2014-09-03" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="serviceType">
			<entry value="1" meaningDe="Import" meaningFr="Import" meaningIt="Importazione" meaningEn="Import" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Export" meaningFr="Export" meaningIt="Esportazione" meaningEn="Export" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Transit" meaningFr="Transit" meaningIt="Transito" meaningEn="Transit" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="sourceAnsatz">
			<entry value="0" meaningDe="Def. zum Normalansatz" meaningFr="Def. zum Normalansatz" meaningIt="Definitivo all&apos;aliquota normale" meaningEn="Def. zum Normalansatz" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="0" meaningDe="Def. zum Normalansatz" meaningFr="Def. zum Normalansatz" meaningIt="Def. zum Normalansatz" meaningEn="Def. zum Normalansatz" validFrom="2005-01-01" validTo="2011-12-14" validForImport="true" validForExport="false" />
			<entry value="1" meaningDe="Prov. zum Normalansatz" meaningFr="Prov. zum Normalansatz" meaningIt="Prov. zum Normalansatz" meaningEn="Prov. zum Normalansatz" validFrom="2005-01-01" validTo="2011-12-14" validForImport="true" validForExport="false" />
			<entry value="1" meaningDe="Prov. zum Normalansatz" meaningFr="Prov. zum Normalansatz" meaningIt="Provv all&apos;aliquota normale" meaningEn="Prov. zum Normalansatz" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="2" meaningDe="Zum PrÌferenzansatz" meaningFr="Zum PrÌferenzansatz" meaningIt="Zum PrÌferenzansatz" meaningEn="Zum PrÌferenzansatz" validFrom="2005-01-01" validTo="2011-12-14" validForImport="true" validForExport="false" />
			<entry value="2" meaningDe="Zum Präferenzansatz" meaningFr="Zum PrÌferenzansatz" meaningIt="All&apos;aliquota preferenziale" meaningEn="Zum Präferenzansatz" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="false" />
			</domain>
			<domain name="specificCircumstanceIndicator">
			<entry value="A" meaningDe="Post- und Expressgutsendungen" meaningFr="Envois postaux et envois express" meaningIt="Invii postali ed espressi" meaningEn="en_Post- und Expressgutsendungen" validFrom="2010-10-13" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="B" meaningDe="Bevorratung von Schiffen und Flugzeugen" meaningFr="Avitaillement de bateaux et d&apos;avions" meaningIt="Approvvigionamento di navi e aerei" meaningEn="en_Bevorratung von Schiffen und Flugzeugen" validFrom="2010-10-29" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="C" meaningDe="Beförderungsart &quot;Strasse&quot;" meaningFr="Mode de transport &quot;route&quot;" meaningIt="Genere di trasporto &quot;stradale&quot;" meaningEn="en_Beförderungsart &quot;Strasse&quot;" validFrom="2010-10-29" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="D" meaningDe="Beförderungsart &quot;Schiene&quot;" meaningFr="Mode de transport &quot;rail&quot;" meaningIt="Genere di trasporto &quot;ferroviario&quot;" meaningEn="en_Beförderungsart &quot;Schiene&quot;" validFrom="2010-10-29" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="E" meaningDe="Zugelassene Wirtschaftsbeteiligte" meaningFr="Opérateurs économiques agréés" meaningIt="Operatori economici autorizzati" meaningEn="en_Zugelassene Wirtschaftsbeteiligte" validFrom="2010-10-29" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="status">
			<entry value="0" meaningDe="undefinierter Zustand" meaningFr="Etat indéfini" meaningIt="Stato indefinito" meaningEn="eng_200" validFrom="2008-07-08" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="200" meaningDe="Zollanmeldung erhalten aber noch nicht selektioniert" meaningFr="Déclaration en douane reçue mais pas encore sélectionnée" meaningIt="Dichiarazione ricevuta ma non ancora selezionata" meaningEn="eng_200" validFrom="2010-01-01" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="200" meaningDe="Zollanmeldung erhalten aber noch nicht selektioniert" meaningFr="Déclaration en douane reçue mais pas encore sélectionnée" meaningIt="Dichiarazione ricevuta ma non ancora selezionata" meaningEn="eng_200" validFrom="2008-07-08" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="201" meaningDe="Zollanmeldung wartend auf Intervention; Zollanmeldung am Domizil, gesperrt und Interventionszeit noch nicht abgelaufen" meaningFr="déclaration en douane en attente d&apos;intervention; déclaration en douane à domicile, bloquée et temps d&apos;intervention pas encore terminé." meaningIt="Dichiarazione in attesa di intervento; dichiarazione a domicilio, bloccata e termine d&apos;intervento non ancora scaduto" meaningEn="eng_200" validFrom="2008-07-08" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="202" meaningDe="Zollanmeldung in Intervention; Zollanmeldung wurde durch Zollfachperson interveniert und noch nicht freigegeben" meaningFr="Déclaration en douane en intervention; la déclaration en douane a fait l&apos;objet d&apos;une intervention par un spécialiste de douane; elle n&apos;est pas encore libérée" meaningIt="Dichiarazione con intervento in sospeso;  intervento da parte della dogana e invio non ancora liberato" meaningEn="eng_200" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="202" meaningDe="Zollanmeldung in Intervention; Zollanmeldung wurde durch Zollfachperson interveniert und noch nicht freigegeben" meaningFr="Déclaration en douane en intervention; la déclaration en douane a fait l&apos;objet d&apos;une intervention par un spécialiste de douane; elle n&apos;est pas encore libérée" meaningIt="Dichiarazione con intervento in sospeso;  è stato intervenuto sulla dichiarazione da parte dello specialista doganale e non ancora liberata" meaningEn="eng_200" validFrom="2008-07-08" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="203" meaningDe="Sendungsfreigabe; Ware kann abgeführt werden" meaningFr="Libération de l&apos;envoi; la marchandise couverte par la déclaration en douane peut être enlevée" meaningIt="Liberazione dell&apos;invio; la merce può essere asportata" meaningEn="eng_200" validFrom="2008-07-08" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="204" meaningDe="Zollanmeldung empfangen; Berichtigung oder Annullierung wartend auf Begutachtung durch Zollfachperson" meaningFr="Déclaration en douane reçue; la correction ou l&apos;annulation est en attente d&apos;acceptation par le spécialiste de douane" meaningIt="Dichiarazione ricevuta; rettifica o annullamento in attesa d&apos;accettazione da parte dello specialista doganale" meaningEn="eng_200" validFrom="2008-07-08" validTo="2012-04-19" validForImport="true" validForExport="true" />
			<entry value="204" meaningDe="Zollanmeldung empfangen; Berichtigung oder Annullierung wartend auf Begutachtung durch Zollfachperson. (Schriftlichen Antrag bei der Zollstelle einreichen)" meaningFr="Déclaration en douane reçue; la correction ou l&apos;annulation est en attente d&apos;acceptation par le spécialiste de douane. (Demande écrite à remettre au bureau de douane)" meaningIt="Dichiarazione ricevuta; rettifica o annullamento in attesa d&apos;accettazione da parte dello specialista doganale. (Inoltrare la domanda scritta all¿ ufficio doganale.)" meaningEn="eng_200" validFrom="2012-04-20" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="205" meaningDe="Ausfuhrzollanmeldung an Transitsystem übermittelt" meaningFr="Déclaration en douane d&apos;exportation transmise au système de transit" meaningIt="Dichiarazione d&apos;esportazione trasmessa al sistema di transito" meaningEn="eng_200" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="205" meaningDe="Ausfuhrzollanmeldung an Transitsystem übermittelt" meaningFr="Déclaration en douane d&apos;exportation transmise au système de transit" meaningIt="Dichiarazione d&apos;esportazione trasmessa la sistema di transito" meaningEn="eng_200" validFrom="2008-07-08" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="205" meaningDe="Ausfuhrzollanmeldung an Transitsystem übermittelt" meaningFr="Déclaration en douane d&apos;exportation transmise au système de transit" meaningIt="Dichiarazione d&apos;esportazione trasmessa la sistema di transito" meaningEn="eng_200" validFrom="2010-01-01" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="206" meaningDe="Ausfuhrzollanmeldung wird in 5 Tagen gelöscht" meaningFr="La déclaration en douane d&apos;exportation sera supprimée dans 5 jours" meaningIt="La dichiarazione d&apos;esportazione verrà eliminata in 5 giorni" meaningEn="eng_200" validFrom="2008-07-08" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="206" meaningDe="Ausfuhrzollanmeldung wird in 5 Tagen gelöscht" meaningFr="La déclaration en douane d&apos;exportation sera supprimée dans 5 jours" meaningIt="La dichiarazione d&apos;esportazione verrà eliminata in 5 giorni" meaningEn="eng_200" validFrom="2010-01-01" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="207" meaningDe="Zollanmeldung annulliert bzw. Annullierung von Zollfachperson begutachtet und angenommen" meaningFr="déclaration en douane annulée ou annulation traitée et acceptée par le personnel douanier" meaningIt="Dichiarazione annullata risp. annullamento verificato e accettato da parte della dogana" meaningEn="eng_200" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="207" meaningDe="Zollanmeldung annulliert bzw. Annullierung von Zollfachperson begutachtet und angenommen" meaningFr="déclaration en douane annulée ou annulation traitée et acceptée par le personnel douanier" meaningIt="Dichiarazione annullata risp. Annullamento da parte dello specialista doganale dopo accettazione" meaningEn="eng_200" validFrom="2008-07-08" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="208" meaningDe="Provisorische EZV umgewandelt; automatische Umwandlung einer provisorischen Einfuhrzollanmeldung zu einer definitiven nach Ablauf der Frist" meaningFr="passage automatique du statut provisoire à définitif d&apos;une déclaration d&apos;importation après échéance du délai." meaningIt="Dichiarazione provvisoria trasformata; trasformazione automatica da una dichiarazione provvisoria in una definitva dopo scadenza del termine" meaningEn="eng_200" validFrom="2008-07-08" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="208" meaningDe="Provisorische EZV umgewandelt; automatische Umwandlung einer provisorischen Einfuhrzollanmeldung zu einer definitiven nach Ablauf der Frist" meaningFr="passage automatique du statut provisoire à définitif d&apos;une déclaration d&apos;importation après échéance du délai." meaningIt="Dichiarazione provvisoria trasformata; trasformazione automatica da una dichiarazione provvisoria in una definitva dopo scadenza del termine" meaningEn="eng_200" validFrom="2010-01-01" validTo="2011-12-14" validForImport="true" validForExport="false" />
			<entry value="208" meaningDe="Provisorische EZV umgewandelt; automatische Umwandlung einer provisorischen Einfuhrzollanmeldung zu einer definitiven nach Ablauf der Frist" meaningFr="passage automatique du statut provisoire à définitif d&apos;une déclaration d&apos;importation après échéance du délai." meaningIt="Dichiarazione provvisoria trasformata; trasformazione automatica da una dichiarazione provvisoria in una definitiva dopo scadenza del termine" meaningEn="eng_200" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="209" meaningDe="Berichtigung nach Ausstellung der Veranlagungsverfügung von Zollfachperson begutachtet und angenommen" meaningFr="Correction après établissement de la décision de taxation, acceptée par le spécialiste de douane" meaningIt="Rettifica dopo la contabilizzazione, accettata dal specialita doganale" meaningEn="eng_200" validFrom="2008-07-08" validTo="2011-12-14" validForImport="true" validForExport="true" />
			<entry value="209" meaningDe="Berichtigung nach Ausstellung der Veranlagungsverfügung von Zollfachperson begutachtet und angenommen" meaningFr="Correction après établissement de la décision de taxation, acceptée par le spécialiste de douane" meaningIt="Rettifica dopo emissione della decisione d&apos;imposizione, controllata e accettata dalla dogana" meaningEn="eng_200" validFrom="2011-12-15" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="210" meaningDe="Veranlagungsverfügung wird in 30 Tagen gesperrt" meaningFr="La décision de taxation sera bloquée dans 30 jours" meaningIt="La decisione d&apos;imposizione verrà bloccata fra 30 giorni" meaningEn="eng_200" validFrom="2008-07-08" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="211" meaningDe="Ausfuhrzollanmeldung selektioniert" meaningFr="Déclaration d&apos;exportation sélectionnée" meaningIt="Dichiarazione d&apos;esportazione  selezionata" meaningEn="eng_211" validFrom="2008-07-08" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="211" meaningDe="Ausfuhrzollanmeldung selektioniert" meaningFr="Déclaration d&apos;exportation sélectionnée" meaningIt="Dichiarazione d&apos;esportazione  selezionata" meaningEn="eng_211" validFrom="2010-01-01" validTo="9999-12-31" validForImport="false" validForExport="true" />
			<entry value="212" meaningDe="Ausfuhrzollanmeldung wird in 15 Tagen gelöscht" meaningFr="La déclaration en douane d&apos;exportation sera supprimée dans 15 jours" meaningIt="La dichiarazione d&apos;esportazione verrà eliminata in 15 giorni" meaningEn="eng_212" validFrom="2011-04-16" validTo="9999-12-31" validForImport="false" validForExport="true" />
			</domain>
			<domain name="storageType">
			<entry value="1" meaningDe="LC 1 Einfuhr in freien Verkehr mit definitiver Steueranmeldung" meaningFr="LC 1 Importation pour mise à la consommation avec déclaration fiscale définitive" meaningIt="LC 1 Importazione nel libero traffico interno con dichiarazione fiscale definitiva" meaningEn="LC 1 Importation for home use with final tax declaration" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="2" meaningDe="LC 2 Einfuhr in freien Verkehr mit provisorischer Steueranmeldung" meaningFr="LC 2 Importation pour mise à la consommation avec déclaration fiscale provisoire" meaningIt="LC 2 Importazione nel libero traffico interno con dichiarazione fiscale provvisoria" meaningEn="LC 2Importation for home use with provisional tax declaration" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="3" meaningDe="LC 3 Einfuhr in zugelassenes Lager mit Begleitschein" meaningFr="LC 3 Importation dans un entrepôt agréé avec bulletin d&apos;accompagnement" meaningIt="LC 3 Importazione in un deposito autorizzato con bolletta di scorta" meaningEn="LC 3 Transport to an approved warehouse under cover of a dispatch note" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="4" meaningDe="LC 4 Einfuhr in Pflichtlager ausserhalb zugelass. Lager mit Begleitschein" meaningFr="LC 4 Imp. dans un entrepôt de réserves obligatoires hors entrepôts agréés avec bulletion d&apos;accomp." meaningIt="LC 4 Imp. in un deposito di scorte obbligatorie fuori dal deposito autorizzato con  boll. di scorta" meaningEn="LC 4Transp. to a compulsory stockholding warehouse not part of an approved wareh. with dispatch note" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="5" meaningDe="LC 5 Einfuhr mit Spezialbegleitschein" meaningFr="LC 5 Importation avec bulletin d&apos;accompagnement spécial" meaningIt="LC 5 Importazione con bolletta di sorta speciale" meaningEn="LC 5 Importation under cover of a special dispatch note" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="false" />
			<entry value="6" meaningDe="Einfuhr von Waren im Zusammenhang mit Inventar-Aufnahme per 31.12.96" meaningFr="Importation de marchandises dans le cadre de l&apos;enregistrement de l&apos;inventaire au 31.12.96" meaningIt="Importazione di merci in connessione con la registrazione inventario al 31.12.96" meaningEn="e" validFrom="1997-01-01" validTo="1997-02-28" validForImport="true" validForExport="false" />
			</domain>
			<domain name="strafverfahren">
			<entry value="0" meaningDe="Nein" meaningFr="Non" meaningIt="No" meaningEn="No" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="1" meaningDe="Ja" meaningFr="Oui" meaningIt="Si" meaningEn="Yes" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			<entry value="2" meaningDe="Vorbehalten" meaningFr="Sous réserve" meaningIt="Riservato" meaningEn="en_vorbehalten" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="false" />
			</domain>
			<domain name="tobaccoType">
			<entry value="1" meaningDe="Kentucky" meaningFr="Kentucky" meaningIt="Kentucky" meaningEn="Kentucky" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="Maryland" meaningFr="Maryland" meaningIt="Maryland" meaningEn="Maryland" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Virginia dunkel" meaningFr="Virginia dunkel" meaningIt="Virginia dunkel" meaningEn="Virginia dunkel" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Virginia hell" meaningFr="Virginia hell" meaningIt="Virginia hell" meaningEn="Virginia hell" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Burley" meaningFr="Burley" meaningIt="Burley" meaningEn="Burley" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="Seedleaf Conn." meaningFr="Seedleaf Conn." meaningIt="Seedleaf Conn." meaningEn="Seedleaf Conn." validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="Florida" meaningFr="Florida" meaningIt="Florida" meaningEn="Florida" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Périque" meaningFr="Périque" meaningIt="Périque" meaningEn="Périque" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Mexico" meaningFr="Mexico" meaningIt="Mexico" meaningEn="Mexico" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="10" meaningDe="Havanna" meaningFr="Havanna" meaningIt="Havanna" meaningEn="Havanna" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="11" meaningDe="Domingo" meaningFr="Domingo" meaningIt="Domingo" meaningEn="Domingo" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="12" meaningDe="Porto Rico" meaningFr="Porto Rico" meaningIt="Porto Rico" meaningEn="Porto Rico" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="13" meaningDe="Carmen" meaningFr="Carmen" meaningIt="Carmen" meaningEn="Carmen" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="14" meaningDe="Rio Grande" meaningFr="Rio Grande" meaningIt="Rio Grande" meaningEn="Rio Grande" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="15" meaningDe="Brasil" meaningFr="Brasil" meaningIt="Brasil" meaningEn="Brasil" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="16" meaningDe="Paraguay" meaningFr="Paraguay" meaningIt="Paraguay" meaningEn="Paraguay" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="17" meaningDe="Argentinier" meaningFr="Argentinier" meaningIt="Argentinier" meaningEn="Argentinier" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="18" meaningDe="Div. Südamerika" meaningFr="Div. Südamerika" meaningIt="Div. Südamerika" meaningEn="Div. Südamerika" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="19" meaningDe="Java" meaningFr="Java" meaningIt="Java" meaningEn="Java" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="20" meaningDe="Sumatra" meaningFr="Sumatra" meaningIt="Sumatra" meaningEn="Sumatra" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="21" meaningDe="Manila" meaningFr="Manila" meaningIt="Manila" meaningEn="Manila" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="22" meaningDe="Orient" meaningFr="Orient" meaningIt="Orient" meaningEn="Orient" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="23" meaningDe="BR. Deutschland" meaningFr="BR. Deutschland" meaningIt="BR. Deutschland" meaningEn="BR. Deutschland" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="24" meaningDe="France" meaningFr="France" meaningIt="France" meaningEn="France" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="25" meaningDe="Italiener" meaningFr="Italiener" meaningIt="Italiener" meaningEn="Italiener" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="26" meaningDe="Semois" meaningFr="Semois" meaningIt="Semois" meaningEn="Semois" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="27" meaningDe="Ungar" meaningFr="Ungar" meaningIt="Ungar" meaningEn="Ungar" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="28" meaningDe="Latakia" meaningFr="Latakia" meaningIt="Latakia" meaningEn="Latakia" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="29" meaningDe="Mischungen" meaningFr="Mischungen" meaningIt="Mischungen" meaningEn="Mischungen" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="30" meaningDe="Mattierpulver" meaningFr="Mattierpulver" meaningIt="Mattierpulver" meaningEn="Mattierpulver" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="31" meaningDe="Muster" meaningFr="Muster" meaningIt="Muster" meaningEn="Muster" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="32" meaningDe="Rippen" meaningFr="Rippen" meaningIt="Rippen" meaningEn="Rippen" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="33" meaningDe="Abfälle" meaningFr="Abfälle" meaningIt="Abfälle" meaningEn="Abfälle" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="34" meaningDe="dunkler Tabak" meaningFr="dunkler Tabak" meaningIt="dunkler Tabak" meaningEn="dunkler Tabak" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="35" meaningDe="Expandierte Rippen" meaningFr="Expandierte Rippen" meaningIt="Expandierte Rippen" meaningEn="Expandierte Rippen" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="36" meaningDe="Deckblatt-Zuschnitt" meaningFr="Deckblatt-Zuschnitt" meaningIt="Deckblatt-Zuschnitt" meaningEn="Deckblatt-Zuschnitt" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="transportationType">
			<entry value="1" meaningDe="PKW" meaningFr="Voiture" meaningIt="Autovettura" meaningEn="en_PKW" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="LKW" meaningFr="Camion" meaningIt="Camion" meaningEn="en_LKW" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="LKW mit Normalanhänger" meaningFr="Camion avec remorque normale" meaningIt="Camion con rimorchio normale" meaningEn="en_LKW mit Normalanhänger" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="LKW mit Sattelanhänger" meaningFr="Camion avec semi-remorque" meaningIt="Trattore con semi-rimorchio (bilico)" meaningEn="en_LKW mit Sattelanhänger" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="99" meaningDe="Andere" meaningFr="Autres" meaningIt="Altri" meaningEn="en_Andere" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="transportMode">
			<entry value="2" meaningDe="Bahnverkehr" meaningFr="Trafic ferroviaire" meaningIt="Traffico ferroviario" meaningEn="Rail traffic" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="Strassenverkehr" meaningFr="Trafic routier" meaningIt="Traffico stradale" meaningEn="Road traffic" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="Luftverkehr" meaningFr="Trafic aérien" meaningIt="Traffico aereo" meaningEn="Air traffic" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="Postverkehr" meaningFr="Trafic postal" meaningIt="Traffico postale" meaningEn="Postal traffic" validFrom="1995-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="Pipeline usw." meaningFr="Pipeline, etc." meaningIt="Pipeline, ecc." meaningEn="Pipeline, etc." validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="Schiffverkehr" meaningFr="Trafic par eau" meaningIt="Traffico navale" meaningEn="Inland waterways" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Eigenantrieb" meaningFr="Autopropulsion" meaningIt="Propulsione propria" meaningEn="Self-propulsion" validFrom="2006-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="Eigenantrieb" meaningFr="Autopropulsion" meaningIt="Propulsione propria" meaningEn="Self-propulsion" validFrom="2005-01-01" validTo="2005-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="VATCode">
			<entry value="1" meaningDe="6.5% - Normalsatz" meaningFr="6.5% - Normalsatz" meaningIt="6.5% - Normalsatz" meaningEn="6.5% - Normalsatz" validFrom="1988-01-01" validTo="1998-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="8% - Normalsatz" meaningFr="8% - Taux normal" meaningIt="8% - Aliquota normale" meaningEn="8% - Normalsatz" validFrom="2011-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="7.6% - Normalsatz" meaningFr="7.6% - Taux normal" meaningIt="7.6% - Aliquota normale" meaningEn="7.6% - Normalsatz" validFrom="2004-02-01" validTo="2010-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="7.6% - Normalsatz" meaningFr="7.6% - Normalsatz" meaningIt="7.6% - Normalsatz" meaningEn="7.6% - Normalsatz" validFrom="2001-01-01" validTo="2004-01-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="2.4% - Reduzierter Satz" meaningFr="2.4% - Taux réduit" meaningIt="2.4% - Aliquota ridotta" meaningEn="2.4% - Reduzierter Satz" validFrom="2004-02-01" validTo="2010-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="2.4% - Reduzierter Steuersatz" meaningFr="2.4% - Reduzierter Steuersatz" meaningIt="2.4% - Reduzierter Steuersatz" meaningEn="2.4% - Reduzierter Steuersatz" validFrom="2001-01-01" validTo="2004-01-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="2.5% - Reduzierter Satz" meaningFr="2.5% - Taux réduit" meaningIt="2.5% - Aliquota ridotta" meaningEn="2.5% - Reduzierter Satz" validFrom="2011-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="2% - Reduzierter Steuersatz" meaningFr="2% - Reduzierter Steuersatz" meaningIt="2% - Reduzierter Steuersatz" meaningEn="2% - Reduzierter Steuersatz" validFrom="1988-01-01" validTo="1998-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="0% - Frei" meaningFr="0% - Exempt" meaningIt="0% - Esente" meaningEn="0% - Frei" validFrom="2004-02-01" validTo="2006-03-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="0% - Steuerfrei" meaningFr="0% - Exempt d&apos;impôt" meaningIt="0% - Esente d&apos;imposta" meaningEn="0% - Steuerfrei" validFrom="2006-04-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="0% - Steuerfrei" meaningFr="0% - Steuerfrei" meaningIt="0% - Steuerfrei" meaningEn="0% - Steuerfrei" validFrom="1988-01-01" validTo="2004-01-31" validForImport="true" validForExport="true" />
			<entry value="90" meaningDe="0% - Verlagerungsverfahren" meaningFr="0% - Procédure de report" meaningIt="0% - Procedura di riporto" meaningEn="0% - Verlagerungsverfahren" validFrom="2004-08-01" validTo="2006-03-31" validForImport="true" validForExport="true" />
			<entry value="90" meaningDe="0% - Verlagerungsverfahren MWST" meaningFr="0% - Procédure de report de la TVA" meaningIt="0% - Procedura di riporto dell&apos;IVA" meaningEn="0% - Verlagerungsverfahren MWST" validFrom="2006-04-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="90" meaningDe="0% - Übernahme 1" meaningFr="0% - Übernahme 1" meaningIt="0% - Übernahme 1" meaningEn="0% - Übernahme 1" validFrom="1999-01-01" validTo="2004-07-31" validForImport="true" validForExport="true" />
			<entry value="91" meaningDe="0% - Übernahme 2" meaningFr="0% - Übernahme 2" meaningIt="0% - Übernahme 2" meaningEn="0% - Übernahme 2" validFrom="1999-01-01" validTo="2004-07-31" validForImport="true" validForExport="true" />
			<entry value="91" meaningDe="0% - Lohnveredelung im Nichterhebungsverfahren" meaningFr="0% - Perfectionnement à façon système suspension" meaningIt="0% - Perfezionamento a cottimo / non riscossione" meaningEn="0% - Lohnveredelung im Nichterhebungsverfahren" validFrom="2006-04-01" validTo="2007-06-01" validForImport="true" validForExport="true" />
			<entry value="91" meaningDe="0% - Lohnveredelung im Nichterhebungsverfahren MWST" meaningFr="0% - Perfectionnement à façon système suspension TVA" meaningIt="0% - Perfezionamento a cottimo / non riscossione IVA" meaningEn="0% - Lohnveredelung im Nichterhebungsverfahren MWST" validFrom="2007-06-02" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="91" meaningDe="0% - Veredlungsverkehr" meaningFr="0% - Trafic de perfectionnement" meaningIt="0% - Traffico di perfezionamento" meaningEn="0% - Veredlungsverkehr" validFrom="2004-08-01" validTo="2006-03-31" validForImport="true" validForExport="true" />
			<entry value="92" meaningDe="0% - Nachträgliche Steuerveranlagung" meaningFr="0% - Taxation fiscale ultérieure" meaningIt="0% - Imposizione fiscale posticipata" meaningEn="0% - Nachträgliche Steuerveranlagung" validFrom="2007-07-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="vehicleModelCode">
			<entry value="101" meaningDe="AC" meaningFr="AC" meaningIt="AC" meaningEn="AC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="102" meaningDe="AEBI" meaningFr="AEBI" meaningIt="AEBI" meaningEn="AEBI" validFrom="2007-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="103" meaningDe="ADRIA" meaningFr="ADRIA" meaningIt="ADRIA" meaningEn="ADRIA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="106" meaningDe="AGRATI" meaningFr="AGRATI" meaningIt="AGRATI" meaningEn="AGRATI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="108" meaningDe="AGRIA" meaningFr="AGRIA" meaningIt="AGRIA" meaningEn="AGRIA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="109" meaningDe="A J S" meaningFr="A J S" meaningIt="A J S" meaningEn="A J S" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="110" meaningDe="AIXAM" meaningFr="AIXAM" meaningIt="AIXAM" meaningEn="AIXAM" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="112" meaningDe="ALFA-ROMEO" meaningFr="ALFA-ROMEO" meaningIt="ALFA-ROMEO" meaningEn="ALFA-ROMEO" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="113" meaningDe="ALLIS" meaningFr="ALLIS" meaningIt="ALLIS" meaningEn="ALLIS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="117" meaningDe="ALPENKREUZER" meaningFr="ALPENKREUZER" meaningIt="ALPENKREUZER" meaningEn="ALPENKREUZER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="118" meaningDe="ALPINE-RENAULT" meaningFr="ALPINE-RENAULT" meaningIt="ALPINE-RENAULT" meaningEn="ALPINE-RENAULT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="123" meaningDe="AMEISE" meaningFr="AMEISE" meaningIt="AMEISE" meaningEn="AMEISE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="125" meaningDe="AMC" meaningFr="AMC" meaningIt="AMC" meaningEn="AMC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="126" meaningDe="ARCTIC CAT" meaningFr="ARCTIC CAT" meaningIt="ARCTIC CAT" meaningEn="ARCTIC CAT" validFrom="1998-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="127" meaningDe="APRILIA" meaningFr="APRILIA" meaningIt="APRILIA" meaningEn="APRILIA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="128" meaningDe="ARIENS" meaningFr="ARIENS" meaningIt="ARIENS" meaningEn="ARIENS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="129" meaningDe="ARO" meaningFr="ARO" meaningIt="ARO" meaningEn="ARO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="130" meaningDe="ASTON-MARTIN" meaningFr="ASTON-MARTIN" meaningIt="ASTON-MARTIN" meaningEn="ASTON-MARTIN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="131" meaningDe="ARMANNI" meaningFr="ARMANNI" meaningIt="ARMANNI" meaningEn="ARMANNI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="132" meaningDe="ARMSTRONG" meaningFr="ARMSTRONG" meaningIt="ARMSTRONG" meaningEn="ARMSTRONG" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="133" meaningDe="ATLET" meaningFr="ATLET" meaningIt="ATLET" meaningEn="ATLET" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="137" meaningDe="AUDI" meaningFr="AUDI" meaningIt="AUDI" meaningEn="AUDI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="138" meaningDe="AUSTIN" meaningFr="AUSTIN" meaningIt="AUSTIN" meaningEn="AUSTIN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="141" meaningDe="AUTOBIANCHI" meaningFr="AUTOBIANCHI" meaningIt="AUTOBIANCHI" meaningEn="AUTOBIANCHI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="142" meaningDe="AUWAERTER" meaningFr="AUWAERTER" meaningIt="AUWAERTER" meaningEn="AUWAERTER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="146" meaningDe="BADER" meaningFr="BADER" meaningIt="BADER" meaningEn="BADER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="147" meaningDe="BAKA" meaningFr="BAKA" meaningIt="BAKA" meaningEn="BAKA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="148" meaningDe="BALDUIN" meaningFr="BALDUIN" meaningIt="BALDUIN" meaningEn="BALDUIN" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="149" meaningDe="BALKANCARIMPEX" meaningFr="BALKANCARIMPEX" meaningIt="BALKANCARIMPEX" meaningEn="BALKANCARIMPEX" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="150" meaningDe="BAUMANN" meaningFr="BAUMANN" meaningIt="BAUMANN" meaningEn="BAUMANN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="151" meaningDe="BARBIERI" meaningFr="BARBIERI" meaningIt="BARBIERI" meaningEn="BARBIERI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="152" meaningDe="BC" meaningFr="BC" meaningIt="BC" meaningEn="BC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="153" meaningDe="BCS" meaningFr="BCS" meaningIt="BCS" meaningEn="BCS" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="157" meaningDe="BEDFORD" meaningFr="BEDFORD" meaningIt="BEDFORD" meaningEn="BEDFORD" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="160" meaningDe="BENELLI" meaningFr="BENELLI" meaningIt="BENELLI" meaningEn="BENELLI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="161" meaningDe="BELMONDO" meaningFr="BELMONDO" meaningIt="BELMONDO" meaningEn="BELMONDO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="167" meaningDe="BENTLEY" meaningFr="BENTLEY" meaningIt="BENTLEY" meaningEn="BENTLEY" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="168" meaningDe="BERTOLINI" meaningFr="BERTOLINI" meaningIt="BERTOLINI" meaningEn="BERTOLINI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="169" meaningDe="BERTONI" meaningFr="BERTONI" meaningIt="BERTONI" meaningEn="BERTONI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="170" meaningDe="BERTONE" meaningFr="BERTONE" meaningIt="BERTONE" meaningEn="BERTONE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="173" meaningDe="BETA" meaningFr="BETA" meaningIt="BETA" meaningEn="BETA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="176" meaningDe="BIMOTA" meaningFr="BIMOTA" meaningIt="BIMOTA" meaningEn="BIMOTA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="177" meaningDe="BITTER" meaningFr="BITTER" meaningIt="BITTER" meaningEn="BITTER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="185" meaningDe="BMW" meaningFr="BMW" meaningIt="BMW" meaningEn="BMW" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="186" meaningDe="BMW-ALPINA" meaningFr="BMW-ALPINA" meaningIt="BMW-ALPINA" meaningEn="BMW-ALPINA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="188" meaningDe="BOHEME, LA" meaningFr="BOHEME, LA" meaningIt="BOHEME, LA" meaningEn="BOHEME, LA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="189" meaningDe="BOLENS" meaningFr="BOLENS" meaningIt="BOLENS" meaningEn="BOLENS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="191" meaningDe="BOVA" meaningFr="BOVA" meaningIt="BOVA" meaningEn="BOVA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="193" meaningDe="BOMBARDIER" meaningFr="BOMBARDIER" meaningIt="BOMBARDIER" meaningEn="BOMBARDIER" validFrom="2004-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="200" meaningDe="BATTIONI+PAGANI (BP)" meaningFr="BATTIONI+PAGANI (BP)" meaningIt="BATTIONI+PAGANI (BP)" meaningEn="BATTIONI+PAGANI (BP)" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="203" meaningDe="BUCHER" meaningFr="BUCHER" meaningIt="BUCHER" meaningEn="BUCHER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="204" meaningDe="BUELL" meaningFr="BUELL" meaningIt="BUELL" meaningEn="BUELL" validFrom="2004-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="206" meaningDe="B.S.A" meaningFr="B.S.A" meaningIt="B.S.A" meaningEn="B.S.A" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="210" meaningDe="B.T." meaningFr="B.T." meaningIt="B.T." meaningEn="B.T." validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="215" meaningDe="BUICK" meaningFr="BUICK" meaningIt="BUICK" meaningEn="BUICK" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="221" meaningDe="BUERSTNER" meaningFr="BUERSTNER" meaningIt="BUERSTNER" meaningEn="BUERSTNER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="235" meaningDe="CADILLAC" meaningFr="CADILLAC" meaningIt="CADILLAC" meaningEn="CADILLAC" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="236" meaningDe="CANYCOM" meaningFr="CANYCOM" meaningIt="CANYCOM" meaningEn="CANYCOM" validFrom="1997-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="237" meaningDe="CAGIVA" meaningFr="CAGIVA" meaningIt="CAGIVA" meaningEn="CAGIVA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="238" meaningDe="CAMP-LET" meaningFr="CAMP-LET" meaningIt="CAMP-LET" meaningEn="CAMP-LET" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="239" meaningDe="CAMPTOUR" meaningFr="CAMPTOUR" meaningIt="CAMPTOUR" meaningEn="CAMPTOUR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="240" meaningDe="CARAVELAIR" meaningFr="CARAVELAIR" meaningIt="CARAVELAIR" meaningEn="CARAVELAIR" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="241" meaningDe="CARRARO" meaningFr="CARRARO" meaningIt="CARRARO" meaningEn="CARRARO" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="242" meaningDe="CARRARO ANTONIO" meaningFr="CARRARO ANTONIO" meaningIt="CARRARO ANTONIO" meaningEn="CARRARO ANTONIO" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="243" meaningDe="CARER" meaningFr="CARER" meaningIt="CARER" meaningEn="CARER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="244" meaningDe="CATERPILLAR" meaningFr="CATERPILLAR" meaningIt="CATERPILLAR" meaningEn="CATERPILLAR" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="245" meaningDe="CATERHAM" meaningFr="CATERHAM" meaningIt="CATERHAM" meaningEn="CATERHAM" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="246" meaningDe="CASE" meaningFr="CASE" meaningIt="CASE" meaningEn="CASE" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="247" meaningDe="CASE INTERNATIONAL" meaningFr="CASE INTERNATIONAL" meaningIt="CASE INTERNATIONAL" meaningEn="CASE INTERNATIONAL" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="248" meaningDe="CESAB" meaningFr="CESAB" meaningIt="CESAB" meaningEn="CESAB" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="249" meaningDe="CHEVROLET" meaningFr="CHEVROLET" meaningIt="CHEVROLET" meaningEn="CHEVROLET" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="250" meaningDe="CHIKUSUI" meaningFr="CHIKUSUI" meaningIt="CHIKUSUI" meaningEn="CHIKUSUI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="251" meaningDe="CHRYSLER" meaningFr="CHRYSLER" meaningIt="CHRYSLER" meaningEn="CHRYSLER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="252" meaningDe="CHATEAU" meaningFr="CHATEAU" meaningIt="CHATEAU" meaningEn="CHATEAU" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="253" meaningDe="CHANG JIANG" meaningFr="CHANG JIANG" meaningIt="CHANG JIANG" meaningEn="CHANG JIANG" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="255" meaningDe="CITROEN" meaningFr="CITROEN" meaningIt="CITROEN" meaningEn="CITROEN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="256" meaningDe="CITY-BIKE" meaningFr="CITY-BIKE" meaningIt="CITY-BIKE" meaningEn="CITY-BIKE" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="257" meaningDe="CITY-EL" meaningFr="CITY-EL" meaningIt="CITY-EL" meaningEn="CITY-EL" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="258" meaningDe="CLAAS" meaningFr="CLAAS" meaningIt="CLAAS" meaningEn="CLAAS" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="259" meaningDe="CLARK" meaningFr="CLARK" meaningIt="CLARK" meaningEn="CLARK" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="260" meaningDe="CLIMAX" meaningFr="CLIMAX" meaningIt="CLIMAX" meaningEn="CLIMAX" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="261" meaningDe="CMI" meaningFr="CMI" meaningIt="CMI" meaningEn="CMI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="262" meaningDe="COLENTA" meaningFr="COLENTA" meaningIt="COLENTA" meaningEn="COLENTA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="263" meaningDe="COLES" meaningFr="COLES" meaningIt="COLES" meaningEn="COLES" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="269" meaningDe="CONDOR" meaningFr="CONDOR" meaningIt="CONDOR" meaningEn="CONDOR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="272" meaningDe="CORSAIR" meaningFr="CORSAIR" meaningIt="CORSAIR" meaningEn="CORSAIR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="276" meaningDe="COVENTRY-CLIMAX" meaningFr="COVENTRY-CLIMAX" meaningIt="COVENTRY-CLIMAX" meaningEn="COVENTRY-CLIMAX" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="278" meaningDe="CRISTALL" meaningFr="CRISTALL" meaningIt="CRISTALL" meaningEn="CRISTALL" validFrom="1996-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="280" meaningDe="CROWN" meaningFr="CROWN" meaningIt="CROWN" meaningEn="CROWN" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="285" meaningDe="CUSHMANN" meaningFr="CUSHMANN" meaningIt="CUSHMANN" meaningEn="CUSHMANN" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="286" meaningDe="DACIA" meaningFr="DACIA" meaningIt="DACIA" meaningEn="DACIA" validFrom="2006-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="288" meaningDe="DAELIM" meaningFr="DAELIM" meaningIt="DAELIM" meaningEn="DAELIM" validFrom="2004-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="290" meaningDe="DAF" meaningFr="DAF" meaningIt="DAF" meaningEn="DAF" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="291" meaningDe="DAIHATSU" meaningFr="DAIHATSU" meaningIt="DAIHATSU" meaningEn="DAIHATSU" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="292" meaningDe="DAIMLER" meaningFr="DAIMLER" meaningIt="DAIMLER" meaningEn="DAIMLER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="293" meaningDe="DANIVA" meaningFr="DANIVA" meaningIt="DANIVA" meaningEn="DANIVA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="294" meaningDe="DE ANTONI" meaningFr="DE ANTONI" meaningIt="DE ANTONI" meaningEn="DE ANTONI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="295" meaningDe="DAEWOO" meaningFr="DAEWOO" meaningIt="DAEWOO" meaningEn="DAEWOO" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="296" meaningDe="DERBI" meaningFr="DERBI" meaningIt="DERBI" meaningEn="DERBI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="297" meaningDe="DECA" meaningFr="DECA" meaningIt="DECA" meaningEn="DECA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="298" meaningDe="DEMAG" meaningFr="DEMAG" meaningIt="DEMAG" meaningEn="DEMAG" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="299" meaningDe="DESTA" meaningFr="DESTA" meaningIt="DESTA" meaningEn="DESTA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="300" meaningDe="DETHLEFFS" meaningFr="DETHLEFFS" meaningIt="DETHLEFFS" meaningEn="DETHLEFFS" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="301" meaningDe="DETAS" meaningFr="DETAS" meaningIt="DETAS" meaningEn="DETAS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="302" meaningDe="DEUTZ" meaningFr="DEUTZ" meaningIt="DEUTZ" meaningEn="DEUTZ" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="303" meaningDe="DFM" meaningFr="DFM" meaningIt="DFM" meaningEn="DFM" validFrom="2011-09-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="304" meaningDe="DIAVOLINO" meaningFr="DIAVOLINO" meaningIt="DIAVOLINO" meaningEn="DIAVOLINO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="305" meaningDe="DIGUE" meaningFr="DIGUE" meaningIt="DIGUE" meaningEn="DIGUE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="308" meaningDe="DNEPR" meaningFr="DNEPR" meaningIt="DNEPR" meaningEn="DNEPR" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="309" meaningDe="DODGE" meaningFr="DODGE" meaningIt="DODGE" meaningEn="DODGE" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="314" meaningDe="DONKERVOORT" meaningFr="DONKERVOORT" meaningIt="DONKERVOORT" meaningEn="DONKERVOORT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="315" meaningDe="DOOSAN" meaningFr="DOOSAN" meaningIt="DOOSAN" meaningEn="DOOSAN" validFrom="2009-03-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="319" meaningDe="DROEGMOELLER" meaningFr="DROEGMOELLER" meaningIt="DROEGMOELLER" meaningEn="DROEGMOELLER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="321" meaningDe="DUCATI" meaningFr="DUCATI" meaningIt="DUCATI" meaningEn="DUCATI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="324" meaningDe="DUNTEP" meaningFr="DUNTEP" meaningIt="DUNTEP" meaningEn="DUNTEP" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="327" meaningDe="DUPORT" meaningFr="DUPORT" meaningIt="DUPORT" meaningEn="DUPORT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="332" meaningDe="EDELWEISZ" meaningFr="EDELWEISZ" meaningIt="EDELWEISZ" meaningEn="EDELWEISZ" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="334" meaningDe="ENFIELD" meaningFr="ENFIELD" meaningIt="ENFIELD" meaningEn="ENFIELD" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="335" meaningDe="EICHER" meaningFr="EICHER" meaningIt="EICHER" meaningEn="EICHER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="336" meaningDe="ELCAR" meaningFr="ELCAR" meaningIt="ELCAR" meaningEn="ELCAR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="337" meaningDe="ERA" meaningFr="ERA" meaningIt="ERA" meaningEn="ERA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="338" meaningDe="ERAD" meaningFr="ERAD" meaningIt="ERAD" meaningEn="ERAD" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="339" meaningDe="EOS" meaningFr="EOS" meaningIt="EOS" meaningEn="EOS" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="340" meaningDe="EIFELLAND" meaningFr="EIFELLAND" meaningIt="EIFELLAND" meaningEn="EIFELLAND" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="341" meaningDe="ELAIME" meaningFr="ELAIME" meaningIt="ELAIME" meaningEn="ELAIME" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="342" meaningDe="ESCALERA" meaningFr="ESCALERA" meaningIt="ESCALERA" meaningEn="ESCALERA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="343" meaningDe="ESTEREL" meaningFr="ESTEREL" meaningIt="ESTEREL" meaningEn="ESTEREL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="344" meaningDe="ERIBA" meaningFr="ERIBA" meaningIt="ERIBA" meaningEn="ERIBA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="345" meaningDe="ERKA" meaningFr="ERKA" meaningIt="ERKA" meaningEn="ERKA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="348" meaningDe="EURA" meaningFr="EURA" meaningIt="EURA" meaningEn="EURA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="350" meaningDe="EXCALIBUR" meaningFr="EXCALIBUR" meaningIt="EXCALIBUR" meaningEn="EXCALIBUR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="351" meaningDe="FAC" meaningFr="FAC" meaningIt="FAC" meaningEn="FAC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="352" meaningDe="FANTIC" meaningFr="FANTIC" meaningIt="FANTIC" meaningEn="FANTIC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="353" meaningDe="FALLER" meaningFr="FALLER" meaningIt="FALLER" meaningEn="FALLER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="354" meaningDe="FANTUZZI" meaningFr="FANTUZZI" meaningIt="FANTUZZI" meaningEn="FANTUZZI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="356" meaningDe="FAUN" meaningFr="FAUN" meaningIt="FAUN" meaningEn="FAUN" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="358" meaningDe="FENDT" meaningFr="FENDT" meaningIt="FENDT" meaningEn="FENDT" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="360" meaningDe="FENWICK" meaningFr="FENWICK" meaningIt="FENWICK" meaningEn="FENWICK" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="361" meaningDe="FENWICK-LINDE-LANSING" meaningFr="FENWICK-LINDE-LANSING" meaningIt="FENWICK-LINDE-LANSING" meaningEn="FENWICK-LINDE-LANSING" validFrom="1988-01-01" validTo="2012-02-01" validForImport="true" validForExport="true" />
			<entry value="361" meaningDe="FENWICK-LANSING" meaningFr="FENWICK-LANSING" meaningIt="FENWICK-LANSING" meaningEn="FENWICK-LANSING" validFrom="2012-02-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="362" meaningDe="FERRARI" meaningFr="FERRARI" meaningIt="FERRARI" meaningEn="FERRARI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="365" meaningDe="FFB" meaningFr="FFB" meaningIt="FFB" meaningEn="FFB" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="367" meaningDe="FIAT" meaningFr="FIAT" meaningIt="FIAT" meaningEn="FIAT" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="368" meaningDe="FISKER" meaningFr="FISKER" meaningIt="FISKER" meaningEn="FISKER" validFrom="2013-02-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="371" meaningDe="FIORI" meaningFr="FIORI" meaningIt="FIORI" meaningEn="FIORI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="373" meaningDe="FLEURETTE" meaningFr="FLEURETTE" meaningIt="FLEURETTE" meaningEn="FLEURETTE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="374" meaningDe="FODEN" meaningFr="FODEN" meaningIt="FODEN" meaningEn="FODEN" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="375" meaningDe="FORD" meaningFr="FORD" meaningIt="FORD" meaningEn="FORD" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="379" meaningDe="FRANKIA" meaningFr="FRANKIA" meaningIt="FRANKIA" meaningEn="FRANKIA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="381" meaningDe="FRESIA" meaningFr="FRESIA" meaningIt="FRESIA" meaningEn="FRESIA" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="383" meaningDe="GARBARINI" meaningFr="GARBARINI" meaningIt="GARBARINI" meaningEn="GARBARINI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="385" meaningDe="GARELLI" meaningFr="GARELLI" meaningIt="GARELLI" meaningEn="GARELLI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="386" meaningDe="GAS-GAS" meaningFr="GAS-GAS" meaningIt="GAS-GAS" meaningEn="GAS-GAS" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="387" meaningDe="GENKINGER" meaningFr="GENKINGER" meaningIt="GENKINGER" meaningEn="GENKINGER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="389" meaningDe="GILERA" meaningFr="GILERA" meaningIt="GILERA" meaningEn="GILERA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="392" meaningDe="G M C" meaningFr="G M C" meaningIt="G M C" meaningEn="G M C" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="397" meaningDe="GOLDONI" meaningFr="GOLDONI" meaningIt="GOLDONI" meaningEn="GOLDONI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="399" meaningDe="GOTTWALD" meaningFr="GOTTWALD" meaningIt="GOTTWALD" meaningEn="GOTTWALD" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="405" meaningDe="GRAVELY" meaningFr="GRAVELY" meaningIt="GRAVELY" meaningEn="GRAVELY" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="407" meaningDe="GRILLO" meaningFr="GRILLO" meaningIt="GRILLO" meaningEn="GRILLO" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="409" meaningDe="GROVE" meaningFr="GROVE" meaningIt="GROVE" meaningEn="GROVE" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="415" meaningDe="GUTBROD" meaningFr="GUTBROD" meaningIt="GUTBROD" meaningEn="GUTBROD" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="422" meaningDe="HAKO" meaningFr="HAKO" meaningIt="HAKO" meaningEn="HAKO" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="428" meaningDe="HARLEY-DAVIDSON" meaningFr="HARLEY-DAVIDSON" meaningIt="HARLEY-DAVIDSON" meaningEn="HARLEY-DAVIDSON" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="429" meaningDe="HEDEN" meaningFr="HEDEN" meaningIt="HEDEN" meaningEn="HEDEN" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="431" meaningDe="HEINEMANN" meaningFr="HEINEMANN" meaningIt="HEINEMANN" meaningEn="HEINEMANN" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="432" meaningDe="HELI" meaningFr="HELI" meaningIt="HELI" meaningEn="HELI" validFrom="2010-12-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="432" meaningDe="HELI" meaningFr="HELI" meaningIt="HELI" meaningEn="HELI" validFrom="2007-07-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="435" meaningDe="HERCHEE" meaningFr="HERCHEE" meaningIt="HERCHEE" meaningEn="HERCHEE" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="438" meaningDe="HERCULES" meaningFr="HERCULES" meaningIt="HERCULES" meaningEn="HERCULES" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="441" meaningDe="HOBBY" meaningFr="HOBBY" meaningIt="HOBBY" meaningEn="HOBBY" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="442" meaningDe="HODGEP" meaningFr="HODGEP" meaningIt="HODGEP" meaningEn="HODGEP" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="444" meaningDe="HOLDER" meaningFr="HOLDER" meaningIt="HOLDER" meaningEn="HOLDER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="445" meaningDe="HOME-CARE" meaningFr="HOME-CARE" meaningIt="HOME-CARE" meaningEn="HOME-CARE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="449" meaningDe="HONDA" meaningFr="HONDA" meaningIt="HONDA" meaningEn="HONDA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="452" meaningDe="HUBTEX" meaningFr="HUBTEX" meaningIt="HUBTEX" meaningEn="HUBTEX" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="456" meaningDe="HUERLIMANN" meaningFr="HUERLIMANN" meaningIt="HUERLIMANN" meaningEn="HUERLIMANN" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="458" meaningDe="HUSABERG" meaningFr="HUSABERG" meaningIt="HUSABERG" meaningEn="HUSABERG" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="460" meaningDe="HUSQVARNA" meaningFr="HUSQVARNA" meaningIt="HUSQVARNA" meaningEn="HUSQVARNA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="465" meaningDe="HYSTER" meaningFr="HYSTER" meaningIt="HYSTER" meaningEn="HYSTER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="466" meaningDe="HYUNDAI" meaningFr="HYUNDAI" meaningIt="HYUNDAI" meaningEn="HYUNDAI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="470" meaningDe="ICEM" meaningFr="ICEM" meaningIt="ICEM" meaningEn="ICEM" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="472" meaningDe="INCAB" meaningFr="INCAB" meaningIt="INCAB" meaningEn="INCAB" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="474" meaningDe="INDIAN" meaningFr="INDIAN" meaningIt="INDIAN" meaningEn="INDIAN" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="475" meaningDe="INFINITI" meaningFr="INFINITI" meaningIt="INFINITI" meaningEn="INFINITI" validFrom="2004-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="476" meaningDe="INNOCENTI" meaningFr="INNOCENTI" meaningIt="INNOCENTI" meaningEn="INNOCENTI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="478" meaningDe="INTERNATIONAL" meaningFr="INTERNATIONAL" meaningIt="INTERNATIONAL" meaningEn="INTERNATIONAL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="480" meaningDe="IRION" meaningFr="IRION" meaningIt="IRION" meaningEn="IRION" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="482" meaningDe="ISEKI" meaningFr="ISEKI" meaningIt="ISEKI" meaningEn="ISEKI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="488" meaningDe="ISUZU" meaningFr="ISUZU" meaningIt="ISUZU" meaningEn="ISUZU" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="489" meaningDe="ITOH" meaningFr="ITOH" meaningIt="ITOH" meaningEn="ITOH" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="490" meaningDe="IVECO" meaningFr="IVECO" meaningIt="IVECO" meaningEn="IVECO" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="491" meaningDe="ITR" meaningFr="ITR" meaningIt="ITR" meaningEn="ITR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="492" meaningDe="IWS" meaningFr="IWS" meaningIt="IWS" meaningEn="IWS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="493" meaningDe="ITALJET" meaningFr="ITALJET" meaningIt="ITALJET" meaningEn="ITALJET" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="494" meaningDe="JACOBSON" meaningFr="JACOBSON" meaningIt="JACOBSON" meaningEn="JACOBSON" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="495" meaningDe="JAGUAR" meaningFr="JAGUAR" meaningIt="JAGUAR" meaningEn="JAGUAR" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="496" meaningDe="JAMET" meaningFr="JAMET" meaningIt="JAMET" meaningEn="JAMET" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="497" meaningDe="JAWA" meaningFr="JAWA" meaningIt="JAWA" meaningEn="JAWA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="499" meaningDe="JEEP" meaningFr="JEEP" meaningIt="JEEP" meaningEn="JEEP" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="503" meaningDe="JOHN DEERE" meaningFr="JOHN DEERE" meaningIt="JOHN DEERE" meaningEn="JOHN DEERE" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="514" meaningDe="JUNGHEINRICH" meaningFr="JUNGHEINRICH" meaningIt="JUNGHEINRICH" meaningEn="JUNGHEINRICH" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="515" meaningDe="KAISER &amp; KRAFT" meaningFr="KAISER &amp; KRAFT" meaningIt="KAISER &amp; KRAFT" meaningEn="KAISER &amp; KRAFT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="516" meaningDe="KALMAR" meaningFr="KALMAR" meaningIt="KALMAR" meaningEn="KALMAR" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="517" meaningDe="KENTRUCK" meaningFr="KENTRUCK" meaningIt="KENTRUCK" meaningEn="KENTRUCK" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="518" meaningDe="KIRUNA" meaningFr="KIRUNA" meaningIt="KIRUNA" meaningEn="KIRUNA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="519" meaningDe="KOELSTRA" meaningFr="KOELSTRA" meaningIt="KOELSTRA" meaningEn="KOELSTRA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="520" meaningDe="KAESSBOHRER" meaningFr="KAESSBOHRER" meaningIt="KAESSBOHRER" meaningEn="KAESSBOHRER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="521" meaningDe="KIP" meaningFr="KIP" meaningIt="KIP" meaningEn="KIP" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="522" meaningDe="KAWASAKI" meaningFr="KAWASAKI" meaningIt="KAWASAKI" meaningEn="KAWASAKI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="523" meaningDe="KNAUS" meaningFr="KNAUS" meaningIt="KNAUS" meaningEn="KNAUS" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="524" meaningDe="KINGWAY" meaningFr="KINGWAY" meaningIt="KINGWAY" meaningEn="KINGWAY" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="525" meaningDe="KENWORTH" meaningFr="KENWORTH" meaningIt="KENWORTH" meaningEn="KENWORTH" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="526" meaningDe="KOMATSU" meaningFr="KOMATSU" meaningIt="KOMATSU" meaningEn="KOMATSU" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="527" meaningDe="KAAZ" meaningFr="KAAZ" meaningIt="KAAZ" meaningEn="KAAZ" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="528" meaningDe="KRAMER" meaningFr="KRAMER" meaningIt="KRAMER" meaningEn="KRAMER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="529" meaningDe="KEWET" meaningFr="KEWET" meaningIt="KEWET" meaningEn="KEWET" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="530" meaningDe="KREIDLER" meaningFr="KREIDLER" meaningIt="KREIDLER" meaningEn="KREIDLER" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="531" meaningDe="KIA" meaningFr="KIA" meaningIt="KIA" meaningEn="KIA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="532" meaningDe="KRISTALL" meaningFr="KRISTALL" meaningIt="KRISTALL" meaningEn="KRISTALL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="533" meaningDe="KRUPP" meaningFr="KRUPP" meaningIt="KRUPP" meaningEn="KRUPP" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="534" meaningDe="K T M" meaningFr="K T M" meaningIt="K T M" meaningEn="K T M" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="536" meaningDe="KUBOTA" meaningFr="KUBOTA" meaningIt="KUBOTA" meaningEn="KUBOTA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="538" meaningDe="KYMCO" meaningFr="KYMCO" meaningIt="KYMCO" meaningEn="KYMCO" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="539" meaningDe="LAFIS" meaningFr="LAFIS" meaningIt="LAFIS" meaningEn="LAFIS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="540" meaningDe="LADA" meaningFr="LADA" meaningIt="LADA" meaningEn="LADA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="541" meaningDe="LADOG" meaningFr="LADOG" meaningIt="LADOG" meaningEn="LADOG" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="542" meaningDe="LAMBORGHINI" meaningFr="LAMBORGHINI" meaningIt="LAMBORGHINI" meaningEn="LAMBORGHINI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="543" meaningDe="LAG" meaningFr="LAG" meaningIt="LAG" meaningEn="LAG" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="544" meaningDe="LAMBRETTA" meaningFr="LAMBRETTA" meaningIt="LAMBRETTA" meaningEn="LAMBRETTA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="546" meaningDe="LANCER-BOSS" meaningFr="LANCER-BOSS" meaningIt="LANCER-BOSS" meaningEn="LANCER-BOSS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="548" meaningDe="LANCIA" meaningFr="LANCIA" meaningIt="LANCIA" meaningEn="LANCIA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="550" meaningDe="LANDINI" meaningFr="LANDINI" meaningIt="LANDINI" meaningEn="LANDINI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="551" meaningDe="LAND ROVER" meaningFr="LAND ROVER" meaningIt="LAND ROVER" meaningEn="LAND ROVER" validFrom="2009-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="552" meaningDe="LANSING-BAGNALL" meaningFr="LANSING-BAGNALL" meaningIt="LANSING-BAGNALL" meaningEn="LANSING-BAGNALL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="554" meaningDe="LAVERDA" meaningFr="LAVERDA" meaningIt="LAVERDA" meaningEn="LAVERDA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="556" meaningDe="LEIBER" meaningFr="LEIBER" meaningIt="LEIBER" meaningEn="LEIBER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="558" meaningDe="LEITNER" meaningFr="LEITNER" meaningIt="LEITNER" meaningEn="LEITNER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="559" meaningDe="LEXUS" meaningFr="LEXUS" meaningIt="LEXUS" meaningEn="LEXUS" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="560" meaningDe="LIEBHERR" meaningFr="LIEBHERR" meaningIt="LIEBHERR" meaningEn="LIEBHERR" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="561" meaningDe="LINDE" meaningFr="LINDE" meaningIt="LINDE" meaningEn="LINDE" validFrom="1988-01-01" validTo="2012-01-05" validForImport="true" validForExport="true" />
			<entry value="561" meaningDe="LINDE" meaningFr="LINDE" meaningIt="LINDE" meaningEn="LINDE" validFrom="2012-01-05" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="562" meaningDe="LIFTER" meaningFr="LIFTER" meaningIt="LIFTER" meaningEn="LIFTER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="563" meaningDe="LINDNER" meaningFr="LINDNER" meaningIt="LINDNER" meaningEn="LINDNER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="564" meaningDe="LINCOLN" meaningFr="LINCOLN" meaningIt="LINCOLN" meaningEn="LINCOLN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="568" meaningDe="LIGIER" meaningFr="LIGIER" meaningIt="LIGIER" meaningEn="LIGIER" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="572" meaningDe="LOC" meaningFr="LOC" meaningIt="LOC" meaningEn="LOC" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="575" meaningDe="LOMBARDINI" meaningFr="LOMBARDINI" meaningIt="LOMBARDINI" meaningEn="LOMBARDINI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="581" meaningDe="LMC" meaningFr="LMC" meaningIt="LMC" meaningEn="LMC" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="584" meaningDe="LOTUS" meaningFr="LOTUS" meaningIt="LOTUS" meaningEn="LOTUS" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="586" meaningDe="LUGLI" meaningFr="LUGLI" meaningIt="LUGLI" meaningEn="LUGLI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="587" meaningDe="MAAT" meaningFr="MAAT" meaningIt="MAAT" meaningEn="MAAT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="588" meaningDe="MACK" meaningFr="MACK" meaningIt="MACK" meaningEn="MACK" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="589" meaningDe="MACMOTER" meaningFr="MACMOTER" meaningIt="MACMOTER" meaningEn="MACMOTER" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="590" meaningDe="MAGIRUS" meaningFr="MAGIRUS" meaningIt="MAGIRUS" meaningEn="MAGIRUS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="591" meaningDe="MALAGUTI" meaningFr="MALAGUTI" meaningIt="MALAGUTI" meaningEn="MALAGUTI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="592" meaningDe="MAM" meaningFr="MAM" meaningIt="MAM" meaningEn="MAM" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="593" meaningDe="MATCHLESS" meaningFr="MATCHLESS" meaningIt="MATCHLESS" meaningEn="MATCHLESS" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="594" meaningDe="MAICO" meaningFr="MAICO" meaningIt="MAICO" meaningEn="MAICO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="596" meaningDe="MALANCA" meaningFr="MALANCA" meaningIt="MALANCA" meaningEn="MALANCA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="598" meaningDe="MAN" meaningFr="MAN" meaningIt="MAN" meaningEn="MAN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="599" meaningDe="MANITOU" meaningFr="MANITOU" meaningIt="MANITOU" meaningEn="MANITOU" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="600" meaningDe="MARECHAL" meaningFr="MARECHAL" meaningIt="MARECHAL" meaningEn="MARECHAL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="601" meaningDe="MASERATI" meaningFr="MASERATI" meaningIt="MASERATI" meaningEn="MASERATI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="603" meaningDe="MASSEY-FERGUSON" meaningFr="MASSEY-FERGUSON" meaningIt="MASSEY-FERGUSON" meaningEn="MASSEY-FERGUSON" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="604" meaningDe="MERLO" meaningFr="MERLO" meaningIt="MERLO" meaningEn="MERLO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="605" meaningDe="MIG" meaningFr="MIG" meaningIt="MIG" meaningEn="MIG" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="607" meaningDe="MINI" meaningFr="MINI" meaningIt="MINI" meaningEn="MINI" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="608" meaningDe="MATRAL" meaningFr="MATRAL" meaningIt="MATRAL" meaningEn="MATRAL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="609" meaningDe="MBK" meaningFr="MBK" meaningIt="MBK" meaningEn="MBK" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="610" meaningDe="MAZDA" meaningFr="MAZDA" meaningIt="MAZDA" meaningEn="MAZDA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="612" meaningDe="MELEX" meaningFr="MELEX" meaningIt="MELEX" meaningEn="MELEX" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="613" meaningDe="MBA" meaningFr="MBA" meaningIt="MBA" meaningEn="MBA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="614" meaningDe="MB-TRAC" meaningFr="MB-TRAC" meaningIt="MB-TRAC" meaningEn="MB-TRAC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="615" meaningDe="MERCEDES-BENZ" meaningFr="MERCEDES-BENZ" meaningIt="MERCEDES-BENZ" meaningEn="MERCEDES-BENZ" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="616" meaningDe="MESSAGER" meaningFr="MESSAGER" meaningIt="MESSAGER" meaningEn="MESSAGER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="617" meaningDe="M G" meaningFr="M G" meaningIt="M G" meaningEn="M G" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="619" meaningDe="MBV" meaningFr="MBV" meaningIt="MBV" meaningEn="MBV" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="621" meaningDe="MIC" meaningFr="MIC" meaningIt="MIC" meaningEn="MIC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="622" meaningDe="MICROCAR" meaningFr="MICROCAR" meaningIt="MICROCAR" meaningEn="MICROCAR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="624" meaningDe="MITSUBISHI" meaningFr="MITSUBISHI" meaningIt="MITSUBISHI" meaningEn="MITSUBISHI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="626" meaningDe="MONDIA" meaningFr="MONDIA" meaningIt="MONDIA" meaningEn="MONDIA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="628" meaningDe="MONTESA" meaningFr="MONTESA" meaningIt="MONTESA" meaningEn="MONTESA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="629" meaningDe="MONTINI" meaningFr="MONTINI" meaningIt="MONTINI" meaningEn="MONTINI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="630" meaningDe="MORA" meaningFr="MORA" meaningIt="MORA" meaningEn="MORA" validFrom="1996-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="631" meaningDe="MORGAN" meaningFr="MORGAN" meaningIt="MORGAN" meaningEn="MORGAN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="632" meaningDe="MORINI" meaningFr="MORINI" meaningIt="MORINI" meaningEn="MORINI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="633" meaningDe="MORRIS" meaningFr="MORRIS" meaningIt="MORRIS" meaningEn="MORRIS" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="637" meaningDe="MOTOBECANE" meaningFr="MOTOBECANE" meaningIt="MOTOBECANE" meaningEn="MOTOBECANE" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="639" meaningDe="MOTO GUZZI" meaningFr="MOTO GUZZI" meaningIt="MOTO GUZZI" meaningEn="MOTO GUZZI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="642" meaningDe="MOTRON" meaningFr="MOTRON" meaningIt="MOTRON" meaningEn="MOTRON" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="643" meaningDe="MOTOSACOCHE" meaningFr="MOTOSACOCHE" meaningIt="MOTOSACOCHE" meaningEn="MOTOSACOCHE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="648" meaningDe="MULTICAR" meaningFr="MULTICAR" meaningIt="MULTICAR" meaningEn="MULTICAR" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="650" meaningDe="MULLER" meaningFr="MULLER" meaningIt="MULLER" meaningEn="MULLER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="652" meaningDe="MV-AGUSTA" meaningFr="MV-AGUSTA" meaningIt="MV-AGUSTA" meaningEn="MV-AGUSTA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="654" meaningDe="M Z" meaningFr="M Z" meaningIt="M Z" meaningEn="M Z" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="665" meaningDe="NEOPLAN" meaningFr="NEOPLAN" meaningIt="NEOPLAN" meaningEn="NEOPLAN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="666" meaningDe="WACKER-NEUSON" meaningFr="WACKER-NEUSON" meaningIt="WACKER-NEUSON" meaningEn="WACKER-NEUSON" validFrom="2001-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="667" meaningDe="NEW HOLLAND" meaningFr="NEW HOLLAND" meaningIt="NEW HOLLAND" meaningEn="NEW HOLLAND" validFrom="1999-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="668" meaningDe="NIJBO" meaningFr="NIJBO" meaningIt="NIJBO" meaningEn="NIJBO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="669" meaningDe="NISSAN" meaningFr="NISSAN" meaningIt="NISSAN" meaningEn="NISSAN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="673" meaningDe="NORTON" meaningFr="NORTON" meaningIt="NORTON" meaningEn="NORTON" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="675" meaningDe="N S U" meaningFr="N S U" meaningIt="N S U" meaningEn="N S U" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="677" meaningDe="Nichiyu-NYK" meaningFr="Nichiyu-NYK" meaningIt="Nichiyu-NYK" meaningEn="Nichiyu-NYK" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="682" meaningDe="O + K" meaningFr="O + K" meaningIt="O + K" meaningEn="O + K" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="684" meaningDe="OLDSMOBILE" meaningFr="OLDSMOBILE" meaningIt="OLDSMOBILE" meaningEn="OLDSMOBILE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="687" meaningDe="O.M." meaningFr="O.M." meaningIt="O.M." meaningEn="O.M." validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="688" meaningDe="O M G" meaningFr="O M G" meaningIt="O M G" meaningEn="O M G" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="690" meaningDe="OPEL" meaningFr="OPEL" meaningIt="OPEL" meaningEn="OPEL" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="697" meaningDe="ORMIC" meaningFr="ORMIC" meaningIt="ORMIC" meaningEn="ORMIC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="700" meaningDe="PADANE" meaningFr="PADANE" meaningIt="PADANE" meaningEn="PADANE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="701" meaningDe="PANTHER" meaningFr="PANTHER" meaningIt="PANTHER" meaningEn="PANTHER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="703" meaningDe="PARADISO" meaningFr="PARADISO" meaningIt="PARADISO" meaningEn="PARADISO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="706" meaningDe="PEFRA" meaningFr="PEFRA" meaningIt="PEFRA" meaningEn="PEFRA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="708" meaningDe="PEUGEOT" meaningFr="PEUGEOT" meaningIt="PEUGEOT" meaningEn="PEUGEOT" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="709" meaningDe="PGO" meaningFr="PGO" meaningIt="PGO" meaningEn="PGO" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="710" meaningDe="P G S" meaningFr="P G S" meaningIt="P G S" meaningEn="P G S" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="711" meaningDe="PHB-EIDECHSE" meaningFr="PHB-EIDECHSE" meaningIt="PHB-EIDECHSE" meaningEn="PHB-EIDECHSE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="712" meaningDe="PICCINI" meaningFr="PICCINI" meaningIt="PICCINI" meaningEn="PICCINI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="713" meaningDe="PIAGGIO-GILERA-VESPA" meaningFr="PIAGGIO-GILERA-VESPA" meaningIt="PIAGGIO-GILERA-VESPA" meaningEn="PIAGGIO-GILERA-VESPA" validFrom="2010-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="713" meaningDe="PIAGGIO" meaningFr="PIAGGIO" meaningIt="PIAGGIO" meaningEn="PIAGGIO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="714" meaningDe="PLYMOUTH" meaningFr="PLYMOUTH" meaningIt="PLYMOUTH" meaningEn="PLYMOUTH" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="715" meaningDe="PIMESPO" meaningFr="PIMESPO" meaningIt="PIMESPO" meaningEn="PIMESPO" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="717" meaningDe="POLARIS" meaningFr="POLARIS" meaningIt="POLARIS" meaningEn="POLARIS" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="718" meaningDe="PONTIAC" meaningFr="PONTIAC" meaningIt="PONTIAC" meaningEn="PONTIAC" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="719" meaningDe="PONY" meaningFr="PONY" meaningIt="PONY" meaningEn="PONY" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="720" meaningDe="PORSCHE" meaningFr="PORSCHE" meaningIt="PORSCHE" meaningEn="PORSCHE" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="727" meaningDe="PRAT" meaningFr="PRAT" meaningIt="PRAT" meaningEn="PRAT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="728" meaningDe="PRINOTH" meaningFr="PRINOTH" meaningIt="PRINOTH" meaningEn="PRINOTH" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="729" meaningDe="PUCH" meaningFr="PUCH" meaningIt="PUCH" meaningEn="PUCH" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="732" meaningDe="PULI" meaningFr="PULI" meaningIt="PULI" meaningEn="PULI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="733" meaningDe="RACLET" meaningFr="RACLET" meaningIt="RACLET" meaningEn="RACLET" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="735" meaningDe="RADOX" meaningFr="RADOX" meaningIt="RADOX" meaningEn="RADOX" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="736" meaningDe="RANDGER" meaningFr="RANDGER" meaningIt="RANDGER" meaningEn="RANDGER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="737" meaningDe="RAPIDO" meaningFr="RAPIDO" meaningIt="RAPIDO" meaningEn="RAPIDO" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="738" meaningDe="RASANT" meaningFr="RASANT" meaningIt="RASANT" meaningEn="RASANT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="739" meaningDe="RAYTON FISSORE" meaningFr="RAYTON FISSORE" meaningIt="RAYTON FISSORE" meaningEn="RAYTON FISSORE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="740" meaningDe="RELIANT" meaningFr="RELIANT" meaningIt="RELIANT" meaningEn="RELIANT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="745" meaningDe="REFORM" meaningFr="REFORM" meaningIt="REFORM" meaningEn="REFORM" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="748" meaningDe="RENAULT" meaningFr="RENAULT" meaningIt="RENAULT" meaningEn="RENAULT" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="751" meaningDe="RIMOR" meaningFr="RIMOR" meaningIt="RIMOR" meaningEn="RIMOR" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="755" meaningDe="RIXE" meaningFr="RIXE" meaningIt="RIXE" meaningEn="RIXE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="756" meaningDe="ROBUSTUS" meaningFr="ROBUSTUS" meaningIt="ROBUSTUS" meaningEn="ROBUSTUS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="757" meaningDe="ROCLA" meaningFr="ROCLA" meaningIt="ROCLA" meaningEn="ROCLA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="758" meaningDe="ROHLOFF" meaningFr="ROHLOFF" meaningIt="ROHLOFF" meaningEn="ROHLOFF" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="759" meaningDe="ROLATRUC" meaningFr="ROLATRUC" meaningIt="ROLATRUC" meaningEn="ROLATRUC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="760" meaningDe="ROLLER" meaningFr="ROLLER" meaningIt="ROLLER" meaningEn="ROLLER" validFrom="1988-01-01" validTo="2008-10-31" validForImport="true" validForExport="true" />
			<entry value="762" meaningDe="ROLBA" meaningFr="ROLBA" meaningIt="ROLBA" meaningEn="ROLBA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="764" meaningDe="ROLLS-ROYCE" meaningFr="ROLLS-ROYCE" meaningIt="ROLLS-ROYCE" meaningEn="ROLLS-ROYCE" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="768" meaningDe="ROVER" meaningFr="ROVER" meaningIt="ROVER" meaningEn="ROVER" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="774" meaningDe="RUBAG" meaningFr="RUBAG" meaningIt="RUBAG" meaningEn="RUBAG" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="780" meaningDe="SAAB" meaningFr="SAAB" meaningIt="SAAB" meaningEn="SAAB" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="781" meaningDe="SACHS" meaningFr="SACHS" meaningIt="SACHS" meaningEn="SACHS" validFrom="1996-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="785" meaningDe="SALEV" meaningFr="SALEV" meaningIt="SALEV" meaningEn="SALEV" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="786" meaningDe="SAMAG" meaningFr="SAMAG" meaningIt="SAMAG" meaningEn="SAMAG" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="787" meaningDe="SAMBRON" meaningFr="SAMBRON" meaningIt="SAMBRON" meaningEn="SAMBRON" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="789" meaningDe="SAME" meaningFr="SAME" meaningIt="SAME" meaningEn="SAME" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="790" meaningDe="SANKO" meaningFr="SANKO" meaningIt="SANKO" meaningEn="SANKO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="791" meaningDe="SAVIEM" meaningFr="SAVIEM" meaningIt="SAVIEM" meaningEn="SAVIEM" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="792" meaningDe="SANYANG-SYM" meaningFr="SANYANG-SYM" meaningIt="SANYANG-SYM" meaningEn="SANYANG-SYM" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="793" meaningDe="SANTANA" meaningFr="SANTANA" meaningIt="SANTANA" meaningEn="SANTANA" validFrom="2004-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="795" meaningDe="SHERCO" meaningFr="SHERCO" meaningIt="SHERCO" meaningEn="SHERCO" validFrom="2012-03-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="796" meaningDe="SCANIA" meaningFr="SCANIA" meaningIt="SCANIA" meaningEn="SCANIA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="797" meaningDe="SCHANZLIN" meaningFr="SCHANZLIN" meaningIt="SCHANZLIN" meaningEn="SCHANZLIN" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="798" meaningDe="SEAT" meaningFr="SEAT" meaningIt="SEAT" meaningEn="SEAT" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="799" meaningDe="SCHWEIKERT" meaningFr="SCHWEIKERT" meaningIt="SCHWEIKERT" meaningEn="SCHWEIKERT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="800" meaningDe="SCHULTHEISS" meaningFr="SCHULTHEISS" meaningIt="SCHULTHEISS" meaningEn="SCHULTHEISS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="801" meaningDe="SHIBAURA" meaningFr="SHIBAURA" meaningIt="SHIBAURA" meaningEn="SHIBAURA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="802" meaningDe="SIKOKU" meaningFr="SIKOKU" meaningIt="SIKOKU" meaningEn="SIKOKU" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="803" meaningDe="STILL" meaningFr="STILL" meaningIt="STILL" meaningEn="STILL" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="805" meaningDe="S.E.P." meaningFr="S.E.P." meaningIt="S.E.P." meaningEn="S.E.P." validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="806" meaningDe="SETRA" meaningFr="SETRA" meaningIt="SETRA" meaningEn="SETRA" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="808" meaningDe="SICHELSCHMIDT" meaningFr="SICHELSCHMIDT" meaningIt="SICHELSCHMIDT" meaningEn="SICHELSCHMIDT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="810" meaningDe="SIESTA" meaningFr="SIESTA" meaningIt="SIESTA" meaningEn="SIESTA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="812" meaningDe="SIMCA" meaningFr="SIMCA" meaningIt="SIMCA" meaningEn="SIMCA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="814" meaningDe="SIMPLICITY" meaningFr="SIMPLICITY" meaningIt="SIMPLICITY" meaningEn="SIMPLICITY" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="815" meaningDe="SINCLAIR" meaningFr="SINCLAIR" meaningIt="SINCLAIR" meaningEn="SINCLAIR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="818" meaningDe="SKI-DOO" meaningFr="SKI-DOO" meaningIt="SKI-DOO" meaningEn="SKI-DOO" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="821" meaningDe="SM" meaningFr="SM" meaningIt="SM" meaningEn="SM" validFrom="1998-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="822" meaningDe="SKODA" meaningFr="SKODA" meaningIt="SKODA" meaningEn="SKODA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="823" meaningDe="SMART" meaningFr="SMART" meaningIt="SMART" meaningEn="SMART" validFrom="1998-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="824" meaningDe="SPYKSTAAL" meaningFr="SPYKSTAAL" meaningIt="SPYKSTAAL" meaningEn="SPYKSTAAL" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="825" meaningDe="SPRITE" meaningFr="SPRITE" meaningIt="SPRITE" meaningEn="SPRITE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="826" meaningDe="STEINBOCK" meaningFr="STEINBOCK" meaningIt="STEINBOCK" meaningEn="STEINBOCK" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="828" meaningDe="SOLO" meaningFr="SOLO" meaningIt="SOLO" meaningEn="SOLO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="829" meaningDe="STACAR" meaningFr="STACAR" meaningIt="STACAR" meaningEn="STACAR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="831" meaningDe="STERCKEMANN" meaningFr="STERCKEMANN" meaningIt="STERCKEMANN" meaningEn="STERCKEMANN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="836" meaningDe="STEYR" meaningFr="STEYR" meaningIt="STEYR" meaningEn="STEYR" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="837" meaningDe="SSANGYONG" meaningFr="SSANGYONG" meaningIt="SSANGYONG" meaningEn="SSANGYONG" validFrom="1997-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="845" meaningDe="SYSTRA" meaningFr="SYSTRA" meaningIt="SYSTRA" meaningEn="SYSTRA" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="846" meaningDe="SUBARU" meaningFr="SUBARU" meaningIt="SUBARU" meaningEn="SUBARU" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="847" meaningDe="SULKY" meaningFr="SULKY" meaningIt="SULKY" meaningEn="SULKY" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="848" meaningDe="SUNBEAM" meaningFr="SUNBEAM" meaningIt="SUNBEAM" meaningEn="SUNBEAM" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="849" meaningDe="SUNSEEKER" meaningFr="SUNSEEKER" meaningIt="SUNSEEKER" meaningEn="SUNSEEKER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="850" meaningDe="SUZUKI" meaningFr="SUZUKI" meaningIt="SUZUKI" meaningEn="SUZUKI" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="851" meaningDe="SVETTRUCK" meaningFr="SVETTRUCK" meaningIt="SVETTRUCK" meaningEn="SVETTRUCK" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="852" meaningDe="S W M" meaningFr="S W M" meaningIt="S W M" meaningEn="S W M" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="853" meaningDe="TABBERT" meaningFr="TABBERT" meaningIt="TABBERT" meaningEn="TABBERT" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="854" meaningDe="TAGO" meaningFr="TAGO" meaningIt="TAGO" meaningEn="TAGO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="855" meaningDe="TANAKA" meaningFr="TANAKA" meaningIt="TANAKA" meaningEn="TANAKA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="856" meaningDe="TALBOT-MATRA" meaningFr="TALBOT-MATRA" meaningIt="TALBOT-MATRA" meaningEn="TALBOT-MATRA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="857" meaningDe="TALBOT" meaningFr="TALBOT" meaningIt="TALBOT" meaningEn="TALBOT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="858" meaningDe="TAM" meaningFr="TAM" meaningIt="TAM" meaningEn="TAM" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="859" meaningDe="TATA" meaningFr="TATA" meaningIt="TATA" meaningEn="TATA" validFrom="2001-05-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="860" meaningDe="TCM" meaningFr="TCM" meaningIt="TCM" meaningEn="TCM" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="861" meaningDe="TESLA" meaningFr="TESLA" meaningIt="TESLA" meaningEn="TESLA" validFrom="2013-02-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="862" meaningDe="TEC" meaningFr="TEC" meaningIt="TEC" meaningEn="TEC" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="864" meaningDe="TERBERG" meaningFr="TERBERG" meaningIt="TERBERG" meaningEn="TERBERG" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="865" meaningDe="TGB" meaningFr="TGB" meaningIt="TGB" meaningEn="TGB" validFrom="2011-09-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="866" meaningDe="THIOKOL" meaningFr="THIOKOL" meaningIt="THIOKOL" meaningEn="THIOKOL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="867" meaningDe="THINK CITY" meaningFr="THINK CITY" meaningIt="THINK CITY" meaningEn="THINK CITY" validFrom="2010-10-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="868" meaningDe="THWAITES" meaningFr="THWAITES" meaningIt="THWAITES" meaningEn="THWAITES" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="869" meaningDe="DE TOMASO" meaningFr="DE TOMASO" meaningIt="DE TOMASO" meaningEn="DE TOMASO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="870" meaningDe="TORO" meaningFr="TORO" meaningIt="TORO" meaningEn="TORO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="871" meaningDe="TOBS" meaningFr="TOBS" meaningIt="TOBS" meaningEn="TOBS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="872" meaningDe="TIMBERJACK" meaningFr="TIMBERJACK" meaningIt="TIMBERJACK" meaningEn="TIMBERJACK" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="875" meaningDe="TORPEDO" meaningFr="TORPEDO" meaningIt="TORPEDO" meaningEn="TORPEDO" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="877" meaningDe="TRIGANO" meaningFr="TRIGANO" meaningIt="TRIGANO" meaningEn="TRIGANO" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="879" meaningDe="TOYOTA" meaningFr="TOYOTA" meaningIt="TOYOTA" meaningEn="TOYOTA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="882" meaningDe="TRIUMPH" meaningFr="TRIUMPH" meaningIt="TRIUMPH" meaningEn="TRIUMPH" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="885" meaningDe="TUDOR" meaningFr="TUDOR" meaningIt="TUDOR" meaningEn="TUDOR" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="886" meaningDe="TVR" meaningFr="TVR" meaningIt="TVR" meaningEn="TVR" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="890" meaningDe="UNIC" meaningFr="UNIC" meaningIt="UNIC" meaningEn="UNIC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="892" meaningDe="UNIMOG" meaningFr="UNIMOG" meaningIt="UNIMOG" meaningEn="UNIMOG" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="894" meaningDe="UNIVERSAL" meaningFr="UNIVERSAL" meaningIt="UNIVERSAL" meaningEn="UNIVERSAL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="898" meaningDe="URSUS" meaningFr="URSUS" meaningIt="URSUS" meaningEn="URSUS" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="899" meaningDe="USAKA" meaningFr="USAKA" meaningIt="USAKA" meaningEn="USAKA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="901" meaningDe="VALMET" meaningFr="VALMET" meaningIt="VALMET" meaningEn="VALMET" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="902" meaningDe="VALPADANA" meaningFr="VALPADANA" meaningIt="VALPADANA" meaningEn="VALPADANA" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="903" meaningDe="VALTRA" meaningFr="VALTRA" meaningIt="VALTRA" meaningEn="VALTRA" validFrom="2007-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="908" meaningDe="VAN HOOL" meaningFr="VAN HOOL" meaningIt="VAN HOOL" meaningEn="VAN HOOL" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="910" meaningDe="VAUXHALL" meaningFr="VAUXHALL" meaningIt="VAUXHALL" meaningEn="VAUXHALL" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="912" meaningDe="VELOCETTE" meaningFr="VELOCETTE" meaningIt="VELOCETTE" meaningEn="VELOCETTE" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="914" meaningDe="VENTURI" meaningFr="VENTURI" meaningIt="VENTURI" meaningEn="VENTURI" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="917" meaningDe="VESTERGAARD" meaningFr="VESTERGAARD" meaningIt="VESTERGAARD" meaningEn="VESTERGAARD" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="919" meaningDe="VETTER" meaningFr="VETTER" meaningIt="VETTER" meaningEn="VETTER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="924" meaningDe="VOELKER" meaningFr="VOELKER" meaningIt="VOELKER" meaningEn="VOELKER" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="925" meaningDe="VOLKSWAGEN" meaningFr="VOLKSWAGEN" meaningIt="VOLKSWAGEN" meaningEn="VOLKSWAGEN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="929" meaningDe="VOLVO" meaningFr="VOLVO" meaningIt="VOLVO" meaningEn="VOLVO" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="939" meaningDe="WALKER" meaningFr="WALKER" meaningIt="WALKER" meaningEn="WALKER" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="942" meaningDe="WEERING" meaningFr="WEERING" meaningIt="WEERING" meaningEn="WEERING" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="945" meaningDe="WEIPPERT" meaningFr="WEIPPERT" meaningIt="WEIPPERT" meaningEn="WEIPPERT" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="946" meaningDe="WIC" meaningFr="WIC" meaningIt="WIC" meaningEn="WIC" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="951" meaningDe="WHITE FORCE" meaningFr="WHITE FORCE" meaningIt="WHITE FORCE" meaningEn="WHITE FORCE" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="952" meaningDe="WHITE" meaningFr="WHITE" meaningIt="WHITE" meaningEn="WHITE" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="954" meaningDe="WILK" meaningFr="WILK" meaningIt="WILK" meaningEn="WILK" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="955" meaningDe="WILLERBY" meaningFr="WILLERBY" meaningIt="WILLERBY" meaningEn="WILLERBY" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="961" meaningDe="WINKING" meaningFr="WINKING" meaningIt="WINKING" meaningEn="WINKING" validFrom="1997-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="965" meaningDe="YALE" meaningFr="YALE" meaningIt="YALE" meaningEn="YALE" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="966" meaningDe="YAMAGUCHI" meaningFr="YAMAGUCHI" meaningIt="YAMAGUCHI" meaningEn="YAMAGUCHI" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="967" meaningDe="YAMAHA" meaningFr="YAMAHA" meaningIt="YAMAHA" meaningEn="YAMAHA" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="968" meaningDe="YANMAR" meaningFr="YANMAR" meaningIt="YANMAR" meaningEn="YANMAR" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="970" meaningDe="ZASTAVA" meaningFr="ZASTAVA" meaningIt="ZASTAVA" meaningEn="ZASTAVA" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="973" meaningDe="ZAZ" meaningFr="ZAZ" meaningIt="ZAZ" meaningEn="ZAZ" validFrom="1988-01-01" validTo="2009-12-31" validForImport="true" validForExport="true" />
			<entry value="975" meaningDe="ZETOR" meaningFr="ZETOR" meaningIt="ZETOR" meaningEn="ZETOR" validFrom="1988-01-01" validTo="2012-01-31" validForImport="true" validForExport="true" />
			<entry value="980" meaningDe="ZUENDAPP" meaningFr="ZUENDAPP" meaningIt="ZUENDAPP" meaningEn="ZUENDAPP" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="998" meaningDe="UEBRIGE MARKEN" meaningFr="UEBRIGE MARKEN" meaningIt="UEBRIGE MARKEN" meaningEn="UEBRIGE MARKEN" validFrom="1988-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="warehouseCoded">
			<entry value="1" meaningDe="Zolllager" meaningFr="entrepôt douanier" meaningIt="deposito doganale" meaningEn="en_Zolllager" validFrom="2009-05-29" validTo="2999-12-31" validForImport="false" validForExport="true" />
			<entry value="1" meaningDe="OZL" meaningFr="EDO" meaningIt="it_OZL" meaningEn="en_OZL" validFrom="2008-04-01" validTo="2009-05-28" validForImport="false" validForExport="true" />
			<entry value="2" meaningDe="ZWILA" meaningFr="entrepôt provisoire" meaningIt="it_ZWILA" meaningEn="en_ZWILA" validFrom="2008-04-01" validTo="2011-12-14" validForImport="false" validForExport="true" />
			<entry value="2" meaningDe="ZWILA" meaningFr="entrepôt provisoire" meaningIt="Deposito intermedio" meaningEn="en_ZWILA" validFrom="2011-12-15" validTo="9999-12-31" validForImport="false" validForExport="true" />
			</domain>
			<domain name="webDecGueltigkeitsDatum">
			<entry value="1" meaningDe="30" meaningFr="30" meaningIt="30" meaningEn="30" validFrom="2011-06-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="yesNoCode">
			<entry value="0" meaningDe="nein" meaningFr="Non" meaningIt="No" meaningEn="No" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="1" meaningDe="ja" meaningFr="Oui" meaningIt="Si" meaningEn="Yes" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="Zollbefund.Referenztyp">
			<entry value="1" meaningDe="EZA" meaningFr="LI" meaningIt="DI" meaningEn="eng_EZA" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="2" meaningDe="EZA-Postverkehr" meaningFr="LI - trafic postal" meaningIt="DI traffico postale" meaningEn="eng_EZA-Postverkehr" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="3" meaningDe="No ZIL" meaningFr="No SDI" meaningIt="n. SDI" meaningEn="eng_No ZIL" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="4" meaningDe="No VEV" meaningFr="No PSI" meaningIt="n. PSI" meaningEn="eng_No VEV" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="e-dec Web" meaningFr="e-dec Web" meaningIt="e-dec Web" meaningEn="e-dec Web" validFrom="2013-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="5" meaningDe="konv. Ausfuhrdekl." meaningFr="Déclaration d&apos;export conv." meaningIt="dich. d&apos;esportazione conv." meaningEn="eng_konv. Ausfuhrdekl." validFrom="2006-01-01" validTo="2012-12-31" validForImport="true" validForExport="true" />
			<entry value="6" meaningDe="Bew. VAR + Laufnr." meaningFr="Permis RSE + No d&apos;ordre" meaningIt="Aut. PSE + n. progressivo" meaningEn="eng_Bew. VAR + Laufnr." validFrom="2006-01-01" validTo="2010-03-31" validForImport="true" validForExport="true" />
			<entry value="7" meaningDe="MRN" meaningFr="MRN" meaningIt="MRN" meaningEn="eng_MRN" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="8" meaningDe="11.71/72" meaningFr="11.71/72" meaningIt="11.71/72" meaningEn="eng_11.71/72" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="9" meaningDe="11.86" meaningFr="11.86" meaningIt="11.86" meaningEn="eng_11.86" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="10" meaningDe="11.51/52" meaningFr="11.51/52" meaningIt="11.51/52" meaningEn="eng_11.51/52" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="11" meaningDe="ATA" meaningFr="ATA" meaningIt="ATA" meaningEn="eng_ATA" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="12" meaningDe="ATA Transit" meaningFr="ATA Transit" meaningIt="ATA Transito" meaningEn="eng_ATA Transit" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="13" meaningDe="Zonenverkehr" meaningFr="Trafic de zone" meaningIt="Traffico nelle zone" meaningEn="eng_Trafic de zone" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="14" meaningDe="Zollfrei (ohne Statistik)" meaningFr="Franchises G" meaningIt="Esenzioni" meaningEn="eng_Zollfrei (ohne Statistik)" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="15" meaningDe="TIR" meaningFr="TIR" meaningIt="TIR" meaningEn="eng_TIR" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="16" meaningDe="Andere Einfuhr" meaningFr="Autres Import" meaningIt="Altri Importazione" meaningEn="eng_Andere Einfuhr" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="17" meaningDe="Andere Ausfuhr" meaningFr="Autres Export" meaningIt="Altri Esportazione" meaningEn="eng_Andere Ausfuhr" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="18" meaningDe="11.44" meaningFr="11.44" meaningIt="11.44" meaningEn="eng_11.44" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="19" meaningDe="WA Einfahrt" meaningFr="DM entrée" meaningIt="Scheda entrata" meaningEn="eng_WA Einfahrt" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="20" meaningDe="WA Ausfahrt" meaningFr="DM sortie" meaningIt="Scheda uscita" meaningEn="eng_WA Ausfahrt" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="21" meaningDe="11.73 / 11.74" meaningFr="11.73 / 11.74" meaningIt="11.73 / 11.74" meaningEn="en_11.73 / 11.74" validFrom="2006-01-01" validTo="2999-12-31" validForImport="true" validForExport="true" />
			<entry value="22" meaningDe="AZA" meaningFr="DE" meaningIt="DE" meaningEn="eng_AZA" validFrom="2006-01-01" validTo="2099-12-31" validForImport="true" validForExport="true" />
			<entry value="23" meaningDe="ENS" meaningFr="ENS" meaningIt="ENS" meaningEn="ENS" validFrom="2004-01-01" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
			<domain name="ZollkundenBerechtigung">
			<entry value="100" meaningDe="Rolle ServiceAnbieter" meaningFr="Rôle de fournisseur de services" meaningIt="Ruolo fornitore del servizio" meaningEn="Rolle ServiceAnbieter" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="110" meaningDe="Rolle Postverkehr" meaningFr="Rôle de trafic postale" meaningIt="Ruolo traffico postale" meaningEn="Rolle Postverkehr" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="120" meaningDe="Rolle Basisrolle Fracht" meaningFr="Rôle de base dans le trafic des marchandises" meaningIt="Ruolo di base per il carico" meaningEn="Rolle Basisrolle Fracht" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="130" meaningDe="Rolle Bezüger elektronischer Dokumente" meaningFr="Rôle de bénéficiaire de documents électroniques" meaningIt="Ruolo della persona che ritira i documenti elettronici" meaningEn="Rolle Bezüger elektronischer Dokumente" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="140" meaningDe="Rolle RailControl" meaningFr="Rôle RailControl" meaningIt="Ruolo RailControl" meaningEn="Rolle RailControl" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="200" meaningDe="Rolle Zugelassener Empfänger" meaningFr="Rôle de destinataire agréé" meaningIt="Ruolo destinatario autorizzato" meaningEn="Rolle Zugelassener Empfänger" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="201" meaningDe="Rolle Zugelassener Versender" meaningFr="Rôle d&apos;expéditeur agréé" meaningIt="Ruolo speditore autorizzato" meaningEn="Rolle Zugelassener Versender" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			<entry value="202" meaningDe="Rolle Ermächtigter Wirtschaftsbeteiligter" meaningFr="Rôle d&apos;opérateur économique agréé" meaningIt="Ruolo operatore economico autorizzato" meaningEn="Rolle Ermächtigter Wirtschaftsbeteiligter" validFrom="2012-09-06" validTo="9999-12-31" validForImport="true" validForExport="true" />
			</domain>
		</domains>
	</xsl:variable>    
</xsl:stylesheet>